/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.security.user.service.imp;

import com.newtouch.context.pojo.User;
import com.newtouch.dao.DBHandleCreator;
import com.newtouch.dao.IDao;
import com.newtouch.dao.QuerySqlable;
import com.newtouch.dao.UpdateSqlable;
import com.newtouch.dao.callback.FieldCallback;
import com.newtouch.dao.util.DBFunction;
import com.newtouch.msg.Return;
import com.newtouch.msg.ReturnMsg;
import com.newtouch.msg.pojo.Message;
import com.newtouch.security.user.service.IUserService;
import com.newtouch.security.user.util.ReplaceIsAllotField;
import com.newtouch.util.date.DateUtil;
import com.newtouch.util.md5.Md5;
import com.newtouch.util.string.StrUtil;
import com.newtouch.util.uuid.UniqueSeq;
import com.newtouch.web.BaseService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class UserServiceImp
extends BaseService
implements IUserService {
    @Autowired
    @Qualifier(value="Rms_UserDao")
    private IDao userDao;
    @Autowired
    @Qualifier(value="Rms_User_RolesDao")
    private IDao userRoleDao;
    @Autowired
    @Qualifier(value="Rms_Resources_AuthDao")
    private IDao resAuthDao;
    @Autowired
    @Qualifier(value="Rms_User_NaturalDao")
    private IDao userNaturalDao;
    @Autowired
    @Qualifier(value="Rms_ResourcesDao")
    private IDao rmsResourcesDao;
    @Autowired
    @Qualifier(value="Rms_Grant_RolesDao")
    private IDao rmsGrantRolesDao;
    @Autowired
    @Qualifier(value="Rms_Password_HistDao")
    private IDao rmsPwdHistDao;

    @Override
    public ReturnMsg queryUser(Map<String, Object> map) {
        Return returnMsg = new Return();
        String sql = "SELECT oper.pk_uuid,\t oper.dept_no, \t oper.user_no, \t run.employee_no, \t oper.user_name,   CASE oper.state WHEN '1' THEN '\u6709\u6548' ELSE '\u65e0\u6548' END state,   (SELECT COUNT(*)   FROM rms_resources_auth operauth \t WHERE oper.pk_uuid = operauth.relate_fk   AND operauth.resource_type = ?   AND operauth.relate_tab = ? " + DBFunction.getInstance().limit(1) + ") oper_auth,   (SELECT COUNT(*)   FROM rms_user_roles operrole \t WHERE oper.pk_uuid = operrole.pk_uuid " + DBFunction.getInstance().limit(1) + ") oper_role   FROM rms_user oper \t LEFT JOIN rms_user_natural run ON oper.pk_uuid = run.pk_uuid   WHERE  oper.data_flag=?  AND oper.user_no !=?  AND oper.user_no !=?";
        QuerySqlable query = DBHandleCreator.getInstance().getQuerySql();
        query.add((Object)"DEPT");
        query.add((Object)"rms_user");
        query.add((Object)"1");
        query.add((Object)this.user().getOptID());
        query.add((Object)"admin");
        ReplaceIsAllotField isAllotCallback = new ReplaceIsAllotField();
        query.addFieldCallback("oper_auth", (FieldCallback)isAllotCallback);
        query.addFieldCallback("oper_role", (FieldCallback)isAllotCallback);
        if (!StrUtil.isNull((Object)map.get("user_name"))) {
            sql = sql + " AND oper.user_name like '%" + map.get("user_name") + "%'";
        }
        if (!StrUtil.isNull((Object)map.get("user_no"))) {
            sql = sql + " AND oper.user_no like '%" + map.get("user_no") + "%'";
        }
        if (!StrUtil.isNull((Object)map.get("state"))) {
            sql = sql + " AND oper.state = ?";
            query.add(map.get("state"));
        }
        query.setSql(sql);
        query.setOrderBy("oper.crt_date DESC");
        returnMsg.setDataList(this.dbHandle().queryList(query));
        return returnMsg.msg();
    }

    @Override
    public ReturnMsg addUser(Map<String, Object> param) {
        Return msg = new Return();
        this.isNull(msg, param);
        if (param.get("user_pwd") != null && !param.get("user_pwd").equals(param.get("user_pwd_confirm"))) {
            msg.setFailMsg(new Message("", "\u786e\u8ba4\u5bc6\u7801\u5fc5\u987b\u4e0e\u5bc6\u7801\u76f8\u540c"));
        }
        this.userDao.addEq("user_no", param.get("user_no"));
        if (!this.userDao.query().isEmpty()) {
            msg.setFailMsg(new Message("", "\u7528\u6237\u5e10\u53f7\u5df2\u5b58\u5728"));
        }
        this.userNaturalDao.addEq("employee_no", param.get("employee_no"));
        if (!this.userNaturalDao.query().isEmpty()) {
            msg.setFailMsg(new Message("", "\u5de5\u53f7\u5df2\u5b58\u5728"));
        }
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        param.put("pk_uuid", UniqueSeq.shortUUID());
        param.put("user_pwd", Md5.md5((String)StrUtil.trimStr((Object)param.get("user_pwd"))));
        param.put("start_date", DateUtil.sysDate());
        param.put("end_date", DateUtil.maxDate());
        param.put("state", "1");
        this.userDao.insert(param);
        param.remove("user_no");
        this.userNaturalDao.insert(param);
        return msg.msg();
    }

    private void isNull(Return msg, Map<String, Object> param) {
        if (StrUtil.isNull((Object)param.get("user_no"))) {
            msg.setFailMsg(new Message("", "\u7528\u6237\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (StrUtil.isNull((Object)param.get("user_name"))) {
            msg.setFailMsg(new Message("", "\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (StrUtil.isNull((Object)param.get("employee_no"))) {
            msg.setFailMsg(new Message("", "\u5de5\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (StrUtil.isNull((Object)param.get("user_pwd"))) {
            msg.setFailMsg(new Message("", "\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (StrUtil.isNull((Object)param.get("user_pwd_confirm"))) {
            msg.setFailMsg(new Message("", "\u786e\u8ba4\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
        }
    }

    @Override
    public ReturnMsg delUser(Map<String, Object> param) {
        Return msg = new Return();
        List userList = (List)param.get("checkbox");
        for (Map aUser : userList) {
            if (aUser.get("pk_uuid") == null) continue;
            HashMap where = new HashMap();
            where.put("relate_fk", aUser.get("pk_uuid"));
            where.put("pk_uuid", aUser.get("pk_uuid"));
            where.put("pk_uuid", aUser.get("pk_uuid"));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("data_flag", "0");
            map.put("mdf_date", "SYSDATE()");
            map.put("mdf_user", (String)aUser.get("mdf_user"));
            this.resAuthDao.addEq(where);
            this.userRoleDao.addEq(where);
            this.userDao.addEq(where);
            this.resAuthDao.update(map);
            this.userRoleDao.update(map);
            this.userDao.update(map);
        }
        return msg.msg();
    }

    @Override
    public ReturnMsg queryUserByOptno(Map<String, Object> map) {
        Return msg = new Return();
        QuerySqlable query = DBHandleCreator.getInstance().getQuerySql4Calc();
        String sql = "SELECT ? user_type,t.user_no,t.dept_no,  td.dept_name,  t.pk_uuid,  t.user_name,  rl.employee_no,  t.data_flag FROM  rms_user t LEFT JOIN rms_dept td ON t.dept_no = td.dept_no LEFT JOIN rms_user_natural rl ON t.pk_uuid = rl.pk_uuid WHERE 1 = 1";
        query.add((Object)1);
        if (map.get("pk_uuid") != null && !"".equals(map.get("pk_uuid"))) {
            sql = sql + " and t.pk_uuid = ?";
            query.add(map.get("pk_uuid"));
        }
        query.setSql(sql);
        Map result = this.dbHandle().query(query);
        msg.setDataTable(result);
        return msg.msg();
    }

    @Override
    public ReturnMsg mdfUser(Map<String, Object> param) {
        Return msg = new Return();
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("user_no", param.get("user_no"));
        param.put("employee_no", param.get("employee_no"));
        param.put("user_pwd", Md5.md5((String)param.get("user_pwd").toString()));
        param.put("user_pwd_confirm", Md5.md5((String)param.get("user_pwd_confirm").toString()));
        this.userDao.addEq("pk_uuid", param.get("pk_uuid"));
        this.userDao.addEq("user_pwd", param.get("user_pwd"));
        Map rmsUser = this.userDao.query();
        if (!param.get("user_pwd").equals(rmsUser.get("user_pwd"))) {
            HashMap<String, Object> rmspwd = new HashMap<String, Object>();
            rmspwd.put("pk_uuid", param.get("pk_uuid"));
            rmspwd.put("user_pwd", param.get("user_pwd"));
            this.userDao.addEq(where);
            this.userDao.update(param);
            this.rmsPwdHistDao.insert(rmspwd);
        } else {
            this.userDao.addEq(where);
            this.userDao.update(param);
        }
        return msg.msg();
    }

    @Override
    public ReturnMsg queryUserRoleListById(Map<String, Object> map) {
        String sql = "SELECT  DISTINCT  tor.pk_uuid,  tr.role_no,  tr.role_name,  CASE  WHEN tr.role_type = 1 THEN  '\u7cfb\u7edf\u7ba1\u7406\u5458'  ELSE  '\u666e\u901a\u7528\u6237'  END role_type  FROM  rms_user_roles tor,  rms_roles tr  WHERE  tor.pk_uuid = ?  AND tor.role_no = tr.role_no  AND tor.data_flag=?";
        QuerySqlable query = DBHandleCreator.getInstance().getQuerySql();
        query.add(map.get("pk_uuid"));
        query.add((Object)"1");
        sql = sql + " ORDER BY role_no DESC";
        query.setSql(sql);
        Return msg = new Return();
        msg.setDataList(this.dbHandle().queryList(query));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryUserNotAssignedRole(Map<String, Object> param) {
        Return msg = new Return();
        if (this.user().getOptID().equals("admin")) {
            String sql = "SELECT\n rrs.role_no, \n rrs.role_name, \n CASE\n WHEN rrs.role_type = 1 THEN \n '\u7cfb\u7edf\u7ba1\u7406\u5458'\n ELSE\n '\u666e\u901a\u7528\u6237'\n END role_type \n FROM\n rms_roles rrs  \n WHERE\n rrs.role_no NOT IN (\n\tSELECT\n\tur.role_no \n\t FROM\n\trms_user_roles ur  \n\tWHERE\n\tur.pk_uuid = ?\n\tAND ur.data_flag = ?\n\t)\n AND rrs.data_flag = ?\n";
            QuerySqlable query = DBHandleCreator.getInstance().getQuerySql();
            query.add(param.get("pk_uuid"));
            query.add((Object)"1");
            query.add((Object)"1");
            if (!StrUtil.isNull((Object)param.get("role_no"))) {
                sql = sql + " AND rrs.role_no = ? ";
                query.add((Object)StrUtil.trimStr((Object)param.get("role_no")));
            }
            if (!StrUtil.isNull((Object)param.get("role_name"))) {
                sql = sql + " AND rrs.role_name LIKE ? ";
                query.add((Object)("%" + StrUtil.trimStr((Object)param.get("role_name")) + "%"));
            }
            sql = sql + " ORDER BY role_no DESC";
            query.setPaginate(true);
            query.setSql(sql);
            msg.setDataList(this.dbHandle().queryList(query));
        } else {
            QuerySqlable query = DBHandleCreator.getInstance().getQuerySql4Calc();
            String sql = "SELECT DISTINCT rgr.role_no , rr.role_name , CASE WHEN rr.role_type = 1 THEN '\u7cfb\u7edf\u7ba1\u7406\u5458' ELSE '\u666e\u901a\u7528\u6237' END role_type , rr.start_date , rr.end_date FROM rms_grant_roles rgr LEFT JOIN rms_roles rr ON rr.role_no = rgr.role_no WHERE 1 = 1 AND rgr.role_no NOT IN( SELECT ur.role_no FROM rms_user_roles ur WHERE ur.pk_uuid = ? AND ur.data_flag = ?) AND rgr.pk_uuid = ? AND rgr.data_flag = ?";
            query.add(param.get("pk_uuid"));
            query.add((Object)"1");
            query.add((Object)((User)param.get("user")).getId());
            query.add((Object)"1");
            if (!StrUtil.isNull((Object)param.get("role_no"))) {
                sql = sql + " AND rr.role_no = ? ";
                query.add((Object)StrUtil.trimStr((Object)param.get("role_no")));
            }
            if (!StrUtil.isNull((Object)param.get("role_name"))) {
                sql = sql + " AND rr.role_name LIKE ? ";
                query.add((Object)("%" + StrUtil.trimStr((Object)param.get("role_name")) + "%"));
            }
            query.setPaginate(true);
            query.setSql(sql);
            msg.setDataList(this.dbHandle().queryList(query));
        }
        return msg.msg();
    }

    @Override
    public ReturnMsg addRole4User(Map<String, Object> param) {
        Return msg = new Return();
        List roleList = (List)param.get("checkbox");
        for (Map aRole : roleList) {
            aRole.put("pk_uuid", param.get("pk_uuid"));
            aRole.put("start_date", DateUtil.sysDate());
            aRole.put("end_date", DateUtil.maxDate());
            this.userRoleDao.insert(aRole);
        }
        return msg.msg();
    }

    @Override
    public ReturnMsg delRoleUserList(Map<String, Object> map) {
        Return reutn = new Return();
        List mapList = (List)map.get("checkbox");
        String sql = "DELETE FROM rms_user_roles WHERE pk_uuid=? and role_no=?";
        for (Map tpRole : mapList) {
            UpdateSqlable update = DBHandleCreator.getInstance().getUpdateSql();
            update.setSql(sql);
            update.add(tpRole.get("pk_uuid"));
            update.add(tpRole.get("role_no"));
            this.dbHandle().update(update);
        }
        return reutn.msg();
    }

    @Override
    public ReturnMsg queryUserAuthList(Map<String, Object> map) {
        this.rmsResourcesDao.addEq("resource_type", map.get("resource_type"));
        Map authTypeMap = this.rmsResourcesDao.query();
        String no = (String)authTypeMap.get("mapping_no");
        String name = (String)authTypeMap.get("mapping_name");
        String parent = (String)authTypeMap.get("mapping_parent");
        String mapping_rule = (String)authTypeMap.get("mapping_rule");
        String table_name = (String)authTypeMap.get("mapping_tab");
        String sql = "SELECT \ttm.dept_no data_auth_no, \ttm." + name + " name, \ttm." + parent + " parent_data_auth, \tCASE  WHEN tr.relate_fk is NOT NULL then \t?  ELSE \t?  END checked,  tr.data_auth_child,   tr.is_half_check halfcheck  FROM " + table_name + " tm LEFT JOIN \trms_resources_auth tr  ON \ttm.dept_no = tr.res_data_no  AND tr.relate_fk  = ?   AND tr.resource_type  = ?  AND tr.relate_field  = ? ";
        String[] rule = mapping_rule.split("##");
        QuerySqlable query = DBHandleCreator.getInstance().getQuerySql4Calc();
        query.add((Object)"true");
        query.add((Object)"false");
        query.add(map.get("pk_uuid"));
        query.add(map.get("resource_type"));
        query.add((Object)"pk_uuid");
        for (int i = 0; i < rule.length; ++i) {
            String[] sub_rule = rule[i].replaceAll("'", "").split("=");
            sql = sql + " AND tm." + sub_rule[0] + " = ? ";
            query.add((Object)sub_rule[1]);
        }
        query.setSql(sql);
        Return msg = new Return();
        msg.setDataList(this.dbHandle().queryList(query));
        return msg.msg();
    }

    @Override
    public ReturnMsg addUserDeptList(Map<String, Object> map) {
        Return reutn = new Return();
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("relate_fk", map.get("pk_uuid"));
        where.put("resource_type", "DEPT");
        this.resAuthDao.addEq(where);
        this.resAuthDao.delete();
        List treeList = (List)map.get("authTree");
        if (treeList != null) {
            for (Map aRoleAuth : treeList) {
                aRoleAuth.put("relate_fk", map.get("pk_uuid"));
                aRoleAuth.put("relate_field", "pk_uuid");
                aRoleAuth.put("relate_tab", "rms_user");
                aRoleAuth.put("res_data_no", aRoleAuth.get("data_auth_no"));
                aRoleAuth.put("resource_type", "DEPT");
                aRoleAuth.put("start_date", DateUtil.sysDate());
                aRoleAuth.put("end_date", DateUtil.maxDate());
                this.resAuthDao.insert(aRoleAuth);
            }
        }
        return reutn.msg();
    }

    @Override
    public ReturnMsg queryUserGrantRoleListById(Map<String, Object> map) {
        String sql = "SELECT\n  tor.pk_uuid,\n  tr.role_no,\n  tr.role_name,\n  CASE\nWHEN tr.role_type = 1 THEN\n  '\u7cfb\u7edf\u7ba1\u7406\u5458'\nELSE\n  '\u666e\u901a\u7528\u6237'\nEND role_type\nFROM\n  rms_grant_roles tor,\n  rms_roles tr\nWHERE\n  tor.pk_uuid = ?\nAND tor.role_no = tr.role_no\n";
        QuerySqlable query = DBHandleCreator.getInstance().getQuerySql();
        query.add(map.get("pk_uuid"));
        sql = sql + " ORDER BY role_no DESC";
        query.setSql(sql);
        Return msg = new Return();
        msg.setDataList(this.dbHandle().queryList(query));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryUserNotAssignedRoleGrant(Map<String, Object> param) {
        Return msg = new Return();
        if (this.user().getOptID().equals("admin")) {
            String sql = " SELECT\n rrs.role_no, \n rrs.role_name, \n CASE\n WHEN rrs.role_type = 1 THEN\n '\u7cfb\u7edf\u7ba1\u7406\u5458'\n ELSE\n '\u666e\u901a\u7528\u6237'\n END role_type \n FROM\n rms_roles rrs \n WHERE\n rrs.role_no NOT IN (\n\tSELECT\n\t rgr.role_no \n\t FROM\n\t rms_grant_roles rgr \n\t WHERE\n\t rgr.data_flag = ?\n\t AND rgr.pk_uuid = ?\n\t )\n AND rrs.data_flag = ?\n";
            QuerySqlable query = DBHandleCreator.getInstance().getQuerySql();
            query.add((Object)"1");
            query.add(param.get("pk_uuid"));
            query.add((Object)"1");
            if (!StrUtil.isNull((Object)param.get("role_no"))) {
                sql = sql + " AND rrs.role_no = ? ";
                query.add((Object)StrUtil.trimStr((Object)param.get("role_no")));
            }
            if (!StrUtil.isNull((Object)param.get("role_name"))) {
                sql = sql + " AND rrs.role_name LIKE ? ";
                query.add((Object)("%" + StrUtil.trimStr((Object)param.get("role_name")) + "%"));
            }
            sql = sql + " ORDER BY role_no DESC";
            query.setPaginate(true);
            query.setSql(sql);
            msg.setDataList(this.dbHandle().queryList(query));
        } else {
            QuerySqlable query = DBHandleCreator.getInstance().getQuerySql4Calc();
            String sql = "SELECT DISTINCT\n rgr.role_no, \n rrs.role_name, \n CASE\n WHEN rrs.role_type = 1 THEN\n '\u7cfb\u7edf\u7ba1\u7406\u5458'\n ELSE\n '\u666e\u901a\u7528\u6237'\n END role_type \n FROM\n rms_grant_roles rgr \n LEFT JOIN rms_roles rrs ON rrs.role_no = rgr.role_no\n WHERE\n rgr.role_no NOT IN (\n\tSELECT\n\t  rgr.role_no\n\t  FROM\n\t  rms_grant_roles rgr \n\t  WHERE\n\t  rgr.data_flag = ?\n\t  AND rgr.pk_uuid = ?\n\t  )\n AND rgr.role_no  IN (\n\tSELECT\n\t  rgr.role_no\n\t  FROM\n\t  rms_grant_roles rgr \n\t  WHERE\n\t  rgr.data_flag = ?\n\t  AND rgr.pk_uuid = ?\n\t  ) AND rgr.data_flag = ? ";
            query.add((Object)"1");
            query.add(param.get("pk_uuid"));
            query.add((Object)"1");
            query.add((Object)((User)param.get("user")).getId());
            query.add((Object)"1");
            if (!StrUtil.isNull((Object)param.get("role_no"))) {
                sql = sql + " AND rr.role_no = ? ";
                query.add((Object)StrUtil.trimStr((Object)param.get("role_no")));
            }
            if (!StrUtil.isNull((Object)param.get("role_name"))) {
                sql = sql + " AND rr.role_name LIKE ? ";
                query.add((Object)("%" + StrUtil.trimStr((Object)param.get("role_name")) + "%"));
            }
            query.setPaginate(true);
            query.setSql(sql);
            msg.setDataList(this.dbHandle().queryList(query));
        }
        return msg.msg();
    }

    @Override
    public ReturnMsg addRoleGrant4User(Map<String, Object> param) {
        Return msg = new Return();
        List roleList = (List)param.get("checkbox");
        for (Map aRole : roleList) {
            aRole.put("pk_uuid", param.get("pk_uuid"));
            aRole.put("start_date", DateUtil.sysDate());
            aRole.put("end_date", DateUtil.maxDate());
            this.rmsGrantRolesDao.insert(aRole);
        }
        return msg.msg();
    }

    @Override
    public ReturnMsg delRoleUserGrantList(Map<String, Object> map) {
        Return reutn = new Return();
        List mapList = (List)map.get("checkbox");
        String sql = "DELETE FROM rms_grant_roles WHERE pk_uuid=? and role_no=?";
        for (Map tpRole : mapList) {
            UpdateSqlable update = DBHandleCreator.getInstance().getUpdateSql();
            update.setSql(sql);
            update.add(tpRole.get("pk_uuid"));
            update.add(tpRole.get("role_no"));
            this.dbHandle().update(update);
        }
        return reutn.msg();
    }

    @Override
    public ReturnMsg validUserState(Map<String, Object> param) {
        Return msg = new Return();
        List checkboxList = (List)param.get("checkbox");
        for (Map validMap : checkboxList) {
            this.userDao.addEq("state", (Object)"1");
            this.userDao.addEq("pk_uuid", validMap.get("pk_uuid"));
            Map validUser = this.userDao.query();
            if (validUser != null && validUser.size() > 0) {
                msg.setFailMsg(new Message("\u60a8\u6240\u9009\u7684\u8bb0\u5f55\u5df2\u7ecf\u5305\u542b\u6709\u6548\u72b6\u6001,\u8bf7\u60a8\u91cd\u65b0\u9009\u62e9\u8bb0\u5f55!"));
                return msg.msg();
            }
            if (validMap.get("pk_uuid") == null) continue;
            HashMap where = new HashMap();
            where.put("pk_uuid", validMap.get("pk_uuid"));
            HashMap<String, String> map1 = new HashMap<String, String>();
            map1.put("state", "1");
            this.userDao.addEq(where);
            this.userDao.update(map1);
        }
        return msg.msg();
    }

    @Override
    public ReturnMsg invalidUserState(Map<String, Object> param) {
        Return msg = new Return();
        List checkboxList = (List)param.get("checkbox");
        for (Map isValidMap : checkboxList) {
            this.userDao.addEq("state", (Object)"0");
            this.userDao.addEq("pk_uuid", isValidMap.get("pk_uuid"));
            Map isValidUser = this.userDao.query();
            if (isValidUser != null && isValidUser.size() > 0) {
                msg.setFailMsg(new Message("\u60a8\u6240\u9009\u7684\u8bb0\u5f55\u5df2\u7ecf\u5305\u542b\u65e0\u6548\u72b6\u6001,\u8bf7\u60a8\u91cd\u65b0\u9009\u62e9\u8bb0\u5f55!"));
                return msg.msg();
            }
            if (isValidMap.get("pk_uuid") == null) continue;
            HashMap where = new HashMap();
            where.put("pk_uuid", isValidMap.get("pk_uuid"));
            HashMap<String, String> map1 = new HashMap<String, String>();
            map1.put("state", "0");
            this.userDao.addEq(where);
            this.userDao.update(map1);
        }
        return msg.msg();
    }

    @Override
    public ReturnMsg mdfUserInit(Map<String, Object> param) {
        Return msg = new Return();
        this.userDao.addEq("pk_uuid", param.get("pk_uuid"));
        this.userNaturalDao.addEq("pk_uuid", param.get("pk_uuid"));
        msg.getDataTable().putAll(this.userDao.query());
        msg.getDataTable().putAll(this.userNaturalDao.query());
        return msg.msg();
    }

    @Override
    public ReturnMsg queryUserHasAssignedRole(Map<String, Object> param) {
        Return msg = new Return();
        QuerySqlable query = DBHandleCreator.getInstance().getQuerySql4Calc();
        String sql = "SELECT rr.role_no, rr.role_name, rr.role_type, rr.start_date, rr.end_date      FROM rms_roles rr, rms_user_roles ur, rms_user usr     WHERE rr.role_no = ur.role_no       AND ur.pk_uuid = usr.pk_uuid       AND ? BETWEEN ur.start_date AND ur.end_date       AND ur.pk_uuid = ? ";
        query.add((Object)DateUtil.sysDate());
        query.add(param.get("pk_uuid"));
        if (!StrUtil.isNull((Object)param.get("user_name"))) {
            sql = sql + " AND usr.user_name LIKE ? ";
            query.add((Object)("%" + StrUtil.trimStr((Object)param.get("user_name")) + "%"));
        }
        query.setSql(sql);
        msg.setDataList(this.dbHandle().queryList(query));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryUserGrantByOptno(Map<String, Object> map) {
        return null;
    }
}

