/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.security.role.service.imp;

import com.newtouch.dao.DBHandleCreator;
import com.newtouch.dao.IDao;
import com.newtouch.dao.QuerySqlable;
import com.newtouch.msg.Return;
import com.newtouch.msg.ReturnMsg;
import com.newtouch.msg.pojo.Message;
import com.newtouch.security.role.service.IRoleService;
import com.newtouch.util.date.DateUtil;
import com.newtouch.util.string.StrUtil;
import com.newtouch.util.uuid.UniqueSeq;
import com.newtouch.web.BaseService;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class RoleServiceImp
extends BaseService
implements IRoleService {
    @Autowired
    @Qualifier(value="Rms_RolesDao")
    private IDao rolesDao;
    @Autowired
    @Qualifier(value="Rms_User_RolesDao")
    private IDao rolesUserDao;
    @Autowired
    @Qualifier(value="Rms_Resources_AuthDao")
    private IDao rmsResourcesAuthdao;
    @Autowired
    @Qualifier(value="Rms_ResourcesDao")
    private IDao rmsResources;
    @Autowired
    @Qualifier(value="Rms_Grant_RolesDao")
    private IDao rmsGrantRole;

    @Override
    public ReturnMsg queryRoleList(Map<String, Object> map) {
        Return returnMsg = new Return();
        String sql = "SELECT     rmr.role_no,     rmr.role_name,\trmr.role_no  role_noNow, rmr.role_name role_nameNow, rmr.role_type role_typeNow,      rmr.role_type,     rmr.start_date,     CASE   WHEN rmr.role_type = 1 THEN     '\u7cfb\u7edf\u7ba1\u7406\u5458'   ELSE     '\u666e\u901a\u7528\u6237'   END role_types,    CASE   WHEN COUNT(rra.serno) = 0 THEN     '\u672a\u6dfb\u52a0'   ELSE     '\u5df2\u6dfb\u52a0'   END menu_info,   CASE   WHEN COUNT(rur.serno) = 0 THEN     '\u672a\u6dfb\u52a0'   ELSE     '\u5df2\u6dfb\u52a0'   END user_info      FROM     rms_roles rmr   LEFT JOIN rms_user_roles rur on rur.role_no=rmr.role_no   LEFT JOIN rms_resources_auth rra ON rra.relate_fk = rmr.role_no   AND rra.relate_tab =?   AND rra.relate_field =?   WHERE     rmr.data_flag = 1  ";
        QuerySqlable query = DBHandleCreator.getInstance().getQuerySql();
        query.add((Object)"rms_roles");
        query.add((Object)"role_no");
        if (map.get("role_no") != null && !"".equals(map.get("role_no"))) {
            sql = sql + " AND rmr.role_no = ?";
            query.add(map.get("role_no"));
        }
        if (map.get("role_name") != null && !"".equals(map.get("role_name"))) {
            sql = sql + " AND rmr.role_name like ?";
            query.add((Object)("%" + map.get("role_name") + "%"));
        }
        if (map.get("role_type") != null && !"".equals(map.get("role_type"))) {
            sql = sql + " AND rmr.role_type=?";
            query.add(map.get("role_type"));
        }
        sql = sql + " GROUP BY rmr.role_no,rmr.role_name,rmr.role_type,rmr.start_date";
        sql = sql + " ORDER BY rmr.start_date desc , rmr.role_no";
        query.setSql(sql);
        returnMsg.setDataList(this.dbHandle().queryList(query));
        return returnMsg.msg();
    }

    @Override
    public ReturnMsg queryRole(Map<String, Object> map) {
        Return returnMsg = new Return();
        String sql = "SELECT  \trm.role_no,  \trm.role_name,  \trm.role_type  FROM  \trms_roles rm  WHERE  \trm.data_flag =? and  rm.role_no = ?";
        QuerySqlable query = DBHandleCreator.getInstance().getQuerySql();
        query.add((Object)"1");
        query.add(map.get("role_no"));
        query.setSql(sql);
        Map result = this.dbHandle().query(query);
        returnMsg.setDataTable(result);
        return returnMsg.msg();
    }

    @Override
    public Return addRole(Map<String, Object> map) {
        Return reutn = this.checkRole(map, "add");
        if (!reutn.isSuccessflag()) {
            return reutn;
        }
        map.put("SERNO", UniqueSeq.UUID());
        map.put("start_date", DateUtil.sysDate());
        map.put("end_date", DateUtil.maxDate());
        this.rolesDao.insert(map);
        return reutn;
    }

    private Return checkRole(Map<String, Object> map, String type) {
        Return reutn = new Return();
        if (StrUtil.isNull((Object)map.get("role_no"))) {
            reutn.setFailMsg(new Message("", "\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (StrUtil.isNull((Object)map.get("role_name"))) {
            reutn.setFailMsg(new Message("", "\u89d2\u8272\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (StrUtil.isNull((Object)map.get("role_type"))) {
            reutn.setFailMsg(new Message("", "\u89d2\u8272\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (type.equals("add")) {
            HashMap<String, Object> isNameExistMap = new HashMap<String, Object>();
            isNameExistMap.put("role_no", map.get("role_no"));
            this.rolesDao.addEq(isNameExistMap);
            Map nameExistMap = this.rolesDao.query();
            if (nameExistMap.size() > 0) {
                reutn.setFailMsg(new Message("", "\u8be5\u89d2\u8272\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\uff01"));
                return reutn;
            }
            HashMap<String, Object> isExistMap = new HashMap<String, Object>();
            isExistMap.put("role_name", map.get("role_name"));
            isExistMap.put("data_flag", "1");
            this.rolesDao.addEq(isExistMap);
            Map existObj = this.rolesDao.query();
            if (existObj.size() > 0) {
                reutn.setFailMsg(new Message("", "\u8be5\u89d2\u8272\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\uff01"));
                return reutn;
            }
        } else {
            String sql = "SELECT * FROM rms_roles where role_no !=? and role_name = ? ";
            QuerySqlable query = DBHandleCreator.getInstance().getQuerySql();
            query.setSql(sql);
            query.add(map.get("role_no"));
            query.add(map.get("role_name"));
            List list = this.dbHandle().queryList(query);
            if (list.size() > 0) {
                reutn.setFailMsg(new Message("\u8be5\u89d2\u8272\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\uff01"));
                return reutn;
            }
        }
        return reutn;
    }

    @Override
    public ReturnMsg deleteRoleList(Map<String, Object> map) {
        Calendar c = Calendar.getInstance();
        c.add(5, -1);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String mDateTime = formatter.format(c.getTime());
        String strend = mDateTime.substring(0, 10);
        Return reutn = new Return();
        List checkboxList = (List)map.get("checkbox");
        for (Map isvableMap : checkboxList) {
            HashMap where = new HashMap();
            HashMap<String, String> mapcheck = new HashMap<String, String>();
            where.put("role_no", isvableMap.get("role_no"));
            where.put("data_flag", "1");
            this.rolesUserDao.addEq(where);
            List opt = this.rolesUserDao.queryList();
            if (opt != null && opt.size() > 0) {
                reutn.setFailMsg(new Message("", "\u8be5\u89d2\u8272\u6b63\u5728\u4f7f\u7528\u4e0d\u80fd\u5220\u9664\uff01"));
                return reutn.msg();
            }
            this.rmsGrantRole.addEq(where);
            List optgrant = this.rmsGrantRole.queryList();
            if (optgrant != null && optgrant.size() > 0) {
                reutn.setFailMsg(new Message("", "\u8be5\u89d2\u8272\u6b63\u5728\u4f7f\u7528\u4e0d\u80fd\u5220\u9664\uff01"));
                return reutn.msg();
            }
            this.rolesDao.addEq(where);
            mapcheck.put("data_flag", "0");
            mapcheck.put("end_date", strend);
            this.rolesDao.update(mapcheck);
        }
        return reutn.msg();
    }

    @Override
    public ReturnMsg mdfRoleBaseInfo(Map<String, Object> map) {
        Return reutn = this.checkRole(map, "mdf");
        if (!reutn.isSuccessflag()) {
            return reutn.msg();
        }
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("role_no", map.get("role_no"));
        this.rolesDao.addEq(where);
        this.rolesDao.update(map);
        return reutn.msg();
    }

    @Override
    public ReturnMsg queryRoleUserListById(Map<String, Object> map) {
        String sql = "SELECT    rur.role_no, ru.user_no,rur.pk_uuid ,    ru.user_name,     td.dept_name   FROM     rms_user ru   LEFT JOIN rms_user_roles rur ON rur.pk_uuid = ru.pk_uuid   LEFT JOIN rms_dept td ON td.dept_no = ru.dept_no   WHERE ru.data_flag=? AND rur.data_flag=? and rur.role_no=?  ";
        QuerySqlable query = DBHandleCreator.getInstance().getQuerySql();
        query.add((Object)"1");
        query.add((Object)"1");
        query.add(map.get("role_no"));
        sql = sql + " ORDER BY  ru.user_no DESC";
        query.setSql(sql);
        Return msg = new Return();
        msg.setDataList(this.dbHandle().queryList(query));
        return msg.msg();
    }

    @Override
    public ReturnMsg deleteRoleUserList(Map<String, Object> map) {
        Return msg = new Return();
        List checkbox = (List)map.get("checkbox");
        for (Map roleMap : checkbox) {
            this.rolesUserDao.addEq("pk_uuid", roleMap.get("pk_uuid"));
            this.rolesUserDao.addEq("role_no", roleMap.get("role_no"));
            this.rolesUserDao.delete();
        }
        return msg.msg();
    }

    @Override
    public ReturnMsg queryRoleUserList(Map<String, Object> map) {
        String sql = "SELECT     ru.user_no,     ru.user_name, ru.pk_uuid,    td.dept_name   FROM     rms_user ru   LEFT JOIN rms_dept td ON ru.dept_no = td.dept_no   WHERE     ru.pk_uuid NOT IN (       SELECT         rur.pk_uuid       FROM         rms_user_roles rur       WHERE         rur.data_flag = ?       AND rur.role_no = ?     )   and ru.data_flag=? and ru.user_no!=?  and ru.user_no!= ?  ";
        QuerySqlable query = DBHandleCreator.getInstance().getQuerySql();
        query.add((Object)"1");
        query.add(map.get("role_no"));
        query.add((Object)"1");
        query.add((Object)"admin");
        query.add(map.get("usernoCur"));
        if (!StrUtil.isNull((Object)map.get("user_no"))) {
            sql = sql + "   AND ru.user_no = ? ";
            query.add(map.get("user_no"));
        }
        if (!StrUtil.isNull((Object)map.get("user_name"))) {
            sql = sql + "   AND  ru.user_name like ? ";
            query.add((Object)("%" + map.get("user_name") + "%"));
        }
        query.setSql(sql);
        Return msg = new Return();
        msg.setDataList(this.dbHandle().queryList(query));
        return msg.msg();
    }

    @Override
    public ReturnMsg addRoleUserList(Map<String, Object> map) {
        Return reutn = new Return();
        List checkboxList = (List)map.get("checkbox");
        for (Map isvableMap : checkboxList) {
            HashMap<String, Object> mapcheck = new HashMap<String, Object>();
            mapcheck.put("start_date", DateUtil.sysDate());
            mapcheck.put("end_date", DateUtil.maxDate());
            mapcheck.put("role_no", map.get("role_no"));
            mapcheck.put("pk_uuid", isvableMap.get("pk_uuid"));
            this.rolesUserDao.insert(mapcheck);
        }
        return reutn.msg();
    }

    @Override
    public ReturnMsg queryRoleAuthList(Map<String, Object> map) {
        this.rmsResources.addEq("resource_type", map.get("data_auth_type"));
        Map authTypeMap = this.rmsResources.query();
        String no = (String)authTypeMap.get("mapping_no");
        String name = (String)authTypeMap.get("mapping_name");
        String parent = (String)authTypeMap.get("mapping_parent");
        String mapping_rule = (String)authTypeMap.get("mapping_rule");
        Object order_rule = authTypeMap.get("order_rule");
        String table_name = (String)authTypeMap.get("mapping_tab");
        String sql = "select    \ttm." + no + " data_auth_no,    \ttm." + name + " name,    \ttm." + parent + " parent_data_auth,    \tcase    when (tr.relate_fk is not null and tr.relate_fk!= ?) then ?   else  ? end checked,     tr.data_auth_child,     tr.is_half_check halfcheck    from    \t" + table_name + " tm left join     \trms_resources_auth tr    on    \ttm." + no + " = tr.res_data_no     and tr.relate_fk = ? where 1=1 ";
        QuerySqlable query = DBHandleCreator.getInstance().getQuerySql4Calc();
        query.add((Object)"");
        query.add((Object)"true");
        query.add((Object)"false");
        query.add(map.get("role_no"));
        String[] rule = mapping_rule.split("##");
        for (int i = 0; i < rule.length; ++i) {
            String[] sub_rule = rule[i].replaceAll("'", "").split("=");
            sql = sql + " AND tm." + sub_rule[0] + " = ? ";
            query.add((Object)sub_rule[1]);
        }
        if (!StrUtil.isNull(order_rule)) {
            sql = sql + " order by " + order_rule;
        }
        query.setSql(sql);
        Return msg = new Return();
        msg.setDataList(this.dbHandle().queryList(query));
        return msg.msg();
    }

    @Override
    public ReturnMsg mdfRoleAuthInfo(Map<String, Object> map) {
        Return reutn = new Return();
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("relate_fk", map.get("role_no"));
        where.put("resource_type", map.get("resource_type"));
        this.rmsResourcesAuthdao.addEq(where);
        this.rmsResourcesAuthdao.delete();
        List treeList = null;
        if ("MENU".equals(map.get("resource_type"))) {
            treeList = (List)map.get("memuAuthTree");
        } else if ("SYSTEM".equals(map.get("resource_type"))) {
            treeList = (List)map.get("resourceAuthTree");
        }
        if (treeList == null) {
            return reutn.msg();
        }
        for (Map aRoleAuth : treeList) {
            aRoleAuth.put("relate_tab", "rms_roles");
            aRoleAuth.put("relate_field", "role_no");
            aRoleAuth.put("res_data_no", aRoleAuth.get("data_auth_no"));
            aRoleAuth.put("relate_fk", map.get("role_no"));
            aRoleAuth.put("resource_type", map.get("resource_type"));
            aRoleAuth.put("start_date", DateUtil.sysDate());
            aRoleAuth.put("end_date", DateUtil.maxDate());
            this.rmsResourcesAuthdao.insert(aRoleAuth);
        }
        return reutn.msg();
    }
}

