/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.security.resource.service.imp;

import com.newtouch.dao.DBHandleCreator;
import com.newtouch.dao.IDao;
import com.newtouch.dao.QuerySqlable;
import com.newtouch.msg.Return;
import com.newtouch.msg.ReturnMsg;
import com.newtouch.security.resource.service.IResourceService;
import com.newtouch.util.string.StrUtil;
import com.newtouch.util.uuid.UniqueSeq;
import com.newtouch.web.BaseService;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ResourceServiceImp
extends BaseService
implements IResourceService {
    @Autowired
    @Qualifier(value="Rms_MenuDao")
    public IDao menuDao;
    @Autowired
    @Qualifier(value="Rms_Resources_DataDao")
    public IDao ResourcesDao;

    @Override
    public Return queryTree() {
        String sql = "SELECT t.res_data_no as id ,\nt.res_data_name as name,\nt.parent_res_data as pid\nFROM rms_resources_data t \nwhere t.data_flag = ? \nORDER BY t.crt_date";
        QuerySqlable query = DBHandleCreator.getInstance().getQuerySql();
        query.setPaginate(false);
        query.setSql(sql);
        query.add((Object)"1");
        Return msg = new Return();
        msg.setDataList(this.dbHandle().queryList(query));
        return msg;
    }

    @Override
    public Return query(Map<String, Object> map) {
        Return msg = new Return();
        String sql = "SELECT t.res_data_no,\nt.res_data_name,\nt.parent_res_data,\nt.resource_type,\nt.data_flag,\ntm.res_data_name as up_resource_name FROM rms_resources_data t \nleft join rms_resources_data tm on tm.res_data_no=t.parent_res_data WHERE t.data_flag = ? and t.res_data_no=?";
        QuerySqlable query = DBHandleCreator.getInstance().getQuerySql();
        query.setPaginate(false);
        query.add((Object)"1");
        query.add(map.get("res_data_no"));
        query.setSql(sql);
        Map menuMap = this.dbHandle().query(query);
        msg.setDataTable(menuMap);
        return msg;
    }

    @Override
    public Return insert(Map<String, Object> map) {
        Return msg = new Return();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("res_data_name", map.get("res_data_name"));
        param.put("resource_type", map.get("resource_type"));
        param.put("parent_res_data", map.get("parent_res_data"));
        this.ResourcesDao.addEq(param);
        Map ResourceNo = this.ResourcesDao.query();
        if (!ResourceNo.isEmpty()) {
            msg.setFailMsg("\u8be5\u8d44\u6e90\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165!");
            return msg;
        }
        Date dd = new Date();
        HashMap<String, Object> ResourceMap = new HashMap<String, Object>();
        ResourceMap.put("name", map.get("res_data_name"));
        ResourceMap.put("id", UniqueSeq.shortUUID());
        param.put("start_date", dd);
        param.put("res_data_no", map.get("parent_res_data") + "." + ResourceMap.get("id"));
        msg.setDataTable(ResourceMap);
        if ("1".equals(map.get("data_flag"))) {
            this.ResourcesDao.insert(param);
        } else {
            HashMap<String, Object> updateParam = new HashMap<String, Object>();
            updateParam.put("data_flag", map.get("data_flag"));
            this.ResourcesDao.update(this.ResourcesDao.insert(param), updateParam);
        }
        return msg;
    }

    @Override
    public ReturnMsg delete(Map<String, Object> map) {
        Return msg = new Return();
        this.ResourcesDao.addEq("res_data_no", map.get("res_data_no"));
        String res_data_no = StrUtil.trimStr(this.ResourcesDao.query().get("res_data_no"));
        if (StrUtil.isNull((Object)res_data_no)) {
            msg.setFailMsg("\u672a\u67e5\u627e\u5230\u5bf9\u5e94\u83dc\u5355");
            return msg.msg();
        }
        this.ResourcesDao.addLikeR("res_data_no", (Object)res_data_no);
        this.ResourcesDao.delete();
        return msg.msg();
    }

    @Override
    public ReturnMsg update(Map<String, Object> map) {
        HashMap<String, Object> whereMap = new HashMap<String, Object>();
        whereMap.put("res_data_no", map.get("res_data_no"));
        Return msg = new Return();
        this.ResourcesDao.addEq(whereMap);
        this.ResourcesDao.update(map);
        return msg.msg();
    }
}

