/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.security.menu.service.imp;

import com.newtouch.dao.DBHandleCreator;
import com.newtouch.dao.IDao;
import com.newtouch.dao.QuerySqlable;
import com.newtouch.dao.UpdateSqlable;
import com.newtouch.msg.Return;
import com.newtouch.msg.ReturnMsg;
import com.newtouch.msg.pojo.Message;
import com.newtouch.security.menu.service.IMenuService;
import com.newtouch.util.string.StrUtil;
import com.newtouch.util.uuid.UniqueSeq;
import com.newtouch.web.BaseService;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class MenuServiceImp
extends BaseService
implements IMenuService {
    @Autowired
    @Qualifier(value="Rms_MenuDao")
    public IDao menuDao;

    @Override
    public Return insert(Map<String, Object> map) {
        Return msg = new Return();
        this.menuDao.addEq("menu_name", map.get("menu_name"));
        Map menuNo = this.menuDao.query();
        if (!menuNo.isEmpty()) {
            msg.setFailMsg("\u83dc\u5355\u540d\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165!");
            return msg;
        }
        if (map.get("menu_url") != null && !"".equals(map.get("menu_url"))) {
            this.menuDao.addEq("menu_url", map.get("menu_url"));
            Map menuUrl = this.menuDao.query();
            if (!menuUrl.isEmpty()) {
                msg.setFailMsg("\u83dc\u5355\u4e8b\u4ef6\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165!");
                return msg;
            }
        }
        HashMap<String, Object> menuMap = new HashMap<String, Object>();
        menuMap.put("name", map.get("menu_name"));
        menuMap.put("id", UniqueSeq.shortUUID());
        map.remove("menu_no");
        map.put("menu_no", menuMap.get("id"));
        map.put("menu_seq", map.get("up_seq").toString() + "." + map.get("menu_no").toString());
        msg.setDataTable(menuMap);
        this.menuDao.insert(map);
        return msg;
    }

    @Override
    public ReturnMsg delete(Map<String, Object> map) {
        Return msg = new Return();
        this.menuDao.addEq("menu_no", map.get("menu_no"));
        String menu_seq = StrUtil.trimStr(this.menuDao.query().get("menu_seq"));
        if (StrUtil.isNull((Object)menu_seq)) {
            msg.setFailMsg("\u672a\u67e5\u627e\u5230\u5bf9\u5e94\u83dc\u5355");
            return msg.msg();
        }
        String sql_isUse = "select serno from  rms_resources_auth where res_data_no = ?  and resource_type=?";
        QuerySqlable query_isUse = DBHandleCreator.getInstance().getQuerySql();
        query_isUse.add(map.get("menu_no"));
        query_isUse.add((Object)"ROLE");
        query_isUse.setSql(sql_isUse);
        if (this.dbHandle().queryList(query_isUse).size() > 0) {
            msg.setFailMsg("\u8be5\u83dc\u5355\u5df2\u4f7f\u7528\uff0c\u4e0d\u80fd\u5220\u9664");
            return msg.msg();
        }
        this.menuDao.addLikeR("menu_seq", (Object)menu_seq);
        this.menuDao.delete();
        UpdateSqlable query = DBHandleCreator.getInstance().getUpdateSql();
        String sql = "delete from rms_resources_auth  \nwhere res_data_no in ( \nselect menu_no from rms_menu where menu_seq like ?) ";
        query.add((Object)(map.get("menu_seq") + "%"));
        query.setSql(sql);
        this.dbHandle().update(query);
        return msg.msg();
    }

    @Override
    public Return query(Map<String, Object> map) {
        Return msg = new Return();
        String sql = "SELECT t.menu_no,\nt.menu_name,\nt.menu_url,\nt.menu_order,t.menu_type,\nt.menu_status,\nt.up_menu,\ntm.menu_name as parent_name FROM rms_menu t \nleft join rms_menu tm on tm.menu_no=t.up_menu WHERE t.menu_no=? ORDER BY t.up_menu, t.menu_order ";
        QuerySqlable query = DBHandleCreator.getInstance().getQuerySql();
        query.setPaginate(false);
        query.add(map.get("menu_no"));
        query.setSql(sql);
        Map menuMap = this.dbHandle().query(query);
        msg.setDataTable(menuMap);
        return msg;
    }

    @Override
    public Return queryTree() {
        String sql = "SELECT t.menu_no as id ,\nt.menu_name as name,\nt.up_menu as pid,\nt.menu_seq FROM rms_menu t \nORDER BY  menu_order asc , menu_no desc ";
        QuerySqlable query = DBHandleCreator.getInstance().getQuerySql();
        query.setPaginate(false);
        query.setSql(sql);
        Return msg = new Return();
        msg.setDataList(this.dbHandle().queryList(query));
        return msg;
    }

    @Override
    public ReturnMsg update(Map<String, Object> map) {
        HashMap<String, Object> whereMap = new HashMap<String, Object>();
        whereMap.put("menu_no", map.get("menu_no"));
        Return msg = new Return();
        if ("0".equals(map.get("menu_status"))) {
            QuerySqlable query = DBHandleCreator.getInstance().getQuerySql();
            String sql = "SELECT t.relate_tab FROM rms_resources_auth t WHERE t.res_data_no= ? ";
            query.add(map.get("menu_no"));
            query.setSql(sql);
            Map dataMap = this.dbHandle().query(query);
            if (!dataMap.isEmpty()) {
                msg.setFailMsg(new Message("", "\u83dc\u5355\u5df2\u88ab\u4f7f\u7528\uff0c\u4e0d\u80fd\u5931\u6548\uff01"));
                return msg.msg();
            }
        }
        if (map.get("menu_name") != null && !"".equals(map.get("menu_name"))) {
            this.menuDao.addEq("menu_name", map.get("menu_name"));
            Map menuName = this.menuDao.query();
            if (!menuName.isEmpty() && !menuName.get("menu_no").toString().equals(map.get("menu_no").toString())) {
                msg.setFailMsg("\u83dc\u5355\u540d\u79f0\u4e0e\u5e93\u4e2d\u540d\u79f0\u51b2\u7a81\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165!");
                return msg.msg();
            }
        }
        if (map.get("menu_url") != null && !"".equals(map.get("menu_url"))) {
            this.menuDao.addEq("menu_url", map.get("menu_url"));
            Map menuUrl = this.menuDao.query();
            if (!menuUrl.isEmpty() && !menuUrl.get("menu_no").equals(map.get("menu_no"))) {
                msg.setFailMsg("\u83dc\u5355\u4e8b\u4ef6\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165!");
                return msg.msg();
            }
        }
        map.put("data_flag", map.get("menu_status"));
        this.menuDao.addEq(whereMap);
        this.menuDao.update(map);
        return msg.msg();
    }

    @Override
    public ReturnMsg queryUserMenuList(Map<String, Object> map) {
        Return msg = new Return();
        String sql = "select distinct \n roleauth.res_data_no as id,\n menu.menu_name as name,\n menu.up_menu pid,\n menu.menu_url aurl,\n menu.menu_no menu_no,\n menu.menu_order \nfrom rms_user operator,\nrms_user_roles operrole,\nrms_resources_auth roleauth,\nrms_menu menu\nwhere operator.pk_uuid = operrole.pk_uuid\nand operrole.role_no=roleauth.relate_fk\nand roleauth.res_data_no=menu.menu_no\nand menu.menu_status=? and operator.user_no=?  and roleauth.resource_type=? and roleauth.is_display = ? ";
        QuerySqlable query = DBHandleCreator.getInstance().getQuerySql();
        query.add((Object)"1");
        query.add(map.get("user_no"));
        query.add((Object)"MENU");
        query.add((Object)"true");
        if (null == map.get("menu_type")) {
            sql = sql + " ORDER BY  menu.menu_order ";
        } else {
            sql = sql + " and menu.menu_type = ? ORDER BY  menu.menu_order asc , menu.menu_no desc ";
            query.add(map.get("menu_type"));
        }
        query.setPaginate(false);
        query.setSql(sql);
        msg.setDataList(this.dbHandle().queryList(query));
        return msg.msg();
    }
}

