/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.repository.where;

import com.newtouch.dao.DBHandleCreator;
import com.newtouch.dao.pojo.DBTypes;
import com.newtouch.dao.util.DBFunction;
import com.newtouch.repository.ModelField;
import com.newtouch.repository.ModelOperator;
import com.newtouch.repository.util.SqlMapper;
import com.newtouch.repository.where.ModelWhere;
import com.newtouch.util.string.StrUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Function;

public class ModelWhereImp
extends ModelWhere {
    private DBTypes dbType = null;
    private ModelField field;
    private ModelOperator conFlag;
    private Object value = "";
    private Object value2 = "";
    private String sql = "";
    private String printSql = "";
    private List<Object> allValue = new ArrayList<Object>();

    public ModelField getField() {
        return this.field;
    }

    public void setField(ModelField field) {
        this.field = field;
    }

    public ModelOperator getConFlag() {
        return this.conFlag;
    }

    public void setConFlag(ModelOperator conFlag) {
        this.conFlag = conFlag;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue2() {
        return this.value2;
    }

    public void setValue2(Object value2) {
        this.value2 = value2;
    }

    public DBTypes getDbType() {
        return this.dbType;
    }

    public void setDbType(DBTypes dbType) {
        this.dbType = dbType;
    }

    public SqlMapper getSqlMapper() {
        if (StrUtil.isNull((Object)this.sql)) {
            this.getSql();
        }
        SqlMapper mapper = new SqlMapper();
        mapper.setSql(this.sql);
        mapper.setPrintSql(this.printSql);
        mapper.setValue(this.allValue);
        return mapper;
    }

    private String getSql() {
        if (this.dbType == null) {
            this.dbType = DBHandleCreator.getInstance().getDbType();
        }
        if (StrUtil.isNull((Object)this.sql)) {
            if (this.conFlag == ModelOperator.IN || this.conFlag == ModelOperator.NOTIN) {
                this.sqlIn((List)this.getValue());
            } else {
                this.sql();
            }
        }
        return this.sql;
    }

    private void sql() {
        this.sql = String.format(this.getConFlag().sql(), this.field.column(), "?", "?");
        switch (this.conFlag) {
            case ISNOTNULL: 
            case ISNULL: {
                this.sql = String.format(this.getConFlag().sql(), this.field.column(), this.field.column());
                this.printSql = String.format(this.getConFlag().sql(), this.field.column(), this.field.column());
                break;
            }
            case BETWEEN: {
                this.allValue.add(this.getValue());
                this.allValue.add(this.getValue2());
                this.printSql = String.format(this.getConFlag().sql(), this.field.column(), this.getValue(), this.getValue2());
                break;
            }
            case LIKE: 
            case NOTLIKE: {
                this.allValue.add("%" + this.getValue() + "%");
                this.printSql = String.format(this.getConFlag().sql(), this.field.column(), "'%" + this.getValue().toString() + "%'");
                break;
            }
            case LIKEL: 
            case NOTLIKEL: {
                this.printSql = String.format(this.getConFlag().sql(), this.field.column(), "'%" + this.getValue().toString() + "'");
                this.allValue.add("%" + this.getValue());
                break;
            }
            case LIKER: 
            case NOTLIKER: {
                this.printSql = String.format(this.getConFlag().sql(), this.field.column(), "'" + this.getValue().toString() + "%'");
                this.allValue.add(this.getValue() + "%");
                break;
            }
            default: {
                this.allValue.add(this.getValue());
                this.printSql = String.format(this.getConFlag().sql(), this.field.column(), this.getValue(), this.getValue2());
            }
        }
        this.sqlCheck();
        if (this.getValue() instanceof String && this.getConFlag().toString().indexOf("LIKE") < 0 && this.getConFlag().toString().indexOf("NULL") < 0) {
            this.printSql = String.format(this.getConFlag().sql(), this.field.column(), "'" + this.getValue().toString() + "'", "'" + this.getValue2().toString() + "'");
            return;
        }
        if (this.getValue() instanceof Timestamp) {
            this.printSql = String.format(this.getConFlag().sql(), this.field.column(), StrUtil.trimStr((Object)DBFunction.getInstance().timestamp(this.getValue(), this.dbType)), DBFunction.getInstance().timestamp(this.getValue2(), this.dbType));
            return;
        }
        if (this.getValue() instanceof Date) {
            this.printSql = String.format(this.getConFlag().sql(), this.field.column(), DBFunction.getInstance().date(this.getValue(), this.dbType), StrUtil.trimStr((Object)DBFunction.getInstance().date(this.getValue2(), this.dbType)));
            return;
        }
    }

    private void sqlCheck() {
    }

    private void sqlIn(List<?> inList) {
        if (inList.isEmpty()) {
            return;
        }
        this.allValue.addAll(inList);
        Function<Object, String> value = str -> str.toString();
        String prefix = "'";
        String suffix = "', '";
        Object o = inList.get(0);
        if (o instanceof Timestamp) {
            value = timestamp -> StrUtil.trimStr((Object)DBFunction.getInstance().timestamp(timestamp, this.dbType));
            prefix = "";
            suffix = ", ";
        }
        if (o instanceof Date) {
            value = date -> StrUtil.trimStr((Object)DBFunction.getInstance().date(date, this.dbType));
            prefix = "";
            suffix = ", ";
        }
        this.sqlIn(inList, value, prefix, suffix);
    }

    private void sqlIn(List<?> inList, Function<Object, String> value, String prefix, String suffix) {
        String sqlArgsStr;
        Object o = inList.get(0);
        StringBuilder printArgs = new StringBuilder(prefix);
        StringBuilder sqlArgs = new StringBuilder();
        for (Object obj : inList) {
            printArgs.append(value.apply(obj) + suffix);
            sqlArgs.append("?, ");
        }
        String printArgsStr = printArgs.toString();
        if (printArgsStr.length() > prefix.length()) {
            printArgsStr = printArgsStr.substring(0, printArgsStr.length() - suffix.length() + prefix.length());
        }
        if (!StrUtil.isNull((Object)(sqlArgsStr = sqlArgs.toString()))) {
            sqlArgsStr = sqlArgsStr.substring(0, sqlArgsStr.length() - 2);
        }
        this.printSql = String.format(this.getConFlag().sql(), this.field.column(), printArgsStr);
        this.sql = String.format(this.getConFlag().sql(), this.field.column(), sqlArgsStr);
    }
}

