/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.product.transfer.utils;

import cn.com.chinalife.model.Dsn_Attribute_Option;
import cn.com.chinalife.model.Dsn_Biz_Attribute;
import cn.com.chinalife.model.Dsn_Biz_Attribute_Option;
import cn.com.chinalife.model.Dsn_Rules;
import cn.com.chinalife.model.Dsn_Structure;
import cn.com.chinalife.model.Sip_Product_Risks;
import cn.com.chinalife.model.Sip_Products;
import cn.com.chinalife.model.Sip_Risk_Relation;
import cn.com.chinalife.model.Sip_Risks;
import com.newtouch.repository.AbsModel;
import com.newtouch.repository.AbsModelRepository;
import com.newtouch.repository.ModelField;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProductUpdateUtils {
    @Autowired
    AbsModelRepository dao;

    public void update(AbsModel model) {
        if (model == null) {
            return;
        }
        String name = model.getClass().getName();
        UpdateFlag updateFlag = (UpdateFlag)((Object)model.getOtherProperty("update_flag", UpdateFlag.class));
        if (updateFlag == null) {
            return;
        }
        switch (updateFlag) {
            case I: {
                int delete = 0;
                if (!(model instanceof Dsn_Rules)) {
                    delete = this.dao.delete(model.getSerno(), model.getClass());
                }
                if (model instanceof Dsn_Rules) {
                    Dsn_Rules rules = (Dsn_Rules)model;
                    rules.where().addEq((ModelField)Dsn_Rules.Field.rule_no, (Object)rules.getRuleNo());
                    this.dao.delete((AbsModel)rules);
                }
                this.deleteOtherdata(model);
                this.dao.save(model);
                break;
            }
            case U: {
                this.dao.update(model.getSerno(), model);
                break;
            }
            case D: {
                if (!(model instanceof Dsn_Rules)) {
                    this.dao.delete(model.getSerno(), model.getClass());
                }
                if (!(model instanceof Dsn_Rules)) break;
                Dsn_Rules rules = (Dsn_Rules)model;
                rules.where().addEq((ModelField)Dsn_Rules.Field.rule_no, (Object)rules.getRuleNo());
                this.dao.delete((AbsModel)rules);
                break;
            }
        }
    }

    private void deleteOtherdata(AbsModel model) {
        if (model instanceof Dsn_Attribute_Option) {
            Dsn_Attribute_Option opt = (Dsn_Attribute_Option)model;
            opt.where().addEq((ModelField)Dsn_Attribute_Option.Field.attr_uuid, (Object)opt.getAttrUuid());
            opt.where().addEq((ModelField)Dsn_Attribute_Option.Field.option_no, (Object)opt.getOptionNo());
            opt.where().addEq((ModelField)Dsn_Attribute_Option.Field.option_name, (Object)opt.getOptionName());
            this.dao.delete((AbsModel)opt);
        }
        if (model instanceof Dsn_Biz_Attribute) {
            Dsn_Biz_Attribute biz = (Dsn_Biz_Attribute)model;
            biz.where().addEq((ModelField)Dsn_Biz_Attribute.Field.biz_uuid, (Object)biz.getBizUuid());
            this.dao.delete((AbsModel)biz);
        }
        if (model instanceof Dsn_Biz_Attribute_Option) {
            Dsn_Biz_Attribute_Option bizOption = (Dsn_Biz_Attribute_Option)model;
            bizOption.where().addEq((ModelField)Dsn_Biz_Attribute_Option.Field.biz_uuid, (Object)bizOption.getBizUuid());
            bizOption.where().addEq((ModelField)Dsn_Biz_Attribute_Option.Field.option_no, (Object)bizOption.getOptionNo());
            bizOption.where().addEq((ModelField)Dsn_Biz_Attribute_Option.Field.option_value, (Object)bizOption.getOptionValue());
            int delete = this.dao.delete((AbsModel)bizOption);
            if (delete == 0) {
                bizOption.where().addEq((ModelField)Dsn_Biz_Attribute_Option.Field.biz_uuid, (Object)bizOption.getBizUuid());
                bizOption.where().addEq((ModelField)Dsn_Biz_Attribute_Option.Field.option_name, (Object)bizOption.getOptionName());
                int delNum = this.dao.delete((AbsModel)bizOption);
                if (delNum == 0) {
                    bizOption.where().addEq((ModelField)Dsn_Biz_Attribute_Option.Field.biz_uuid, (Object)bizOption.getBizUuid());
                    bizOption.where().addEq((ModelField)Dsn_Biz_Attribute_Option.Field.option_value, (Object)bizOption.getOptionValue());
                    this.dao.delete((AbsModel)bizOption);
                }
            }
        }
        if (model instanceof Sip_Risks) {
            Sip_Risks sipRisks = (Sip_Risks)model;
            sipRisks.where().addEq((ModelField)Sip_Risks.Field.risk_uuid, (Object)sipRisks.getRiskUuid());
            this.dao.delete((AbsModel)sipRisks);
        }
        if (model instanceof Dsn_Rules) {
            Dsn_Rules rules = (Dsn_Rules)model;
            rules.where().addEq((ModelField)Dsn_Rules.Field.rule_no, (Object)rules.getRuleNo());
            this.dao.delete((AbsModel)rules);
        }
        if (model instanceof Sip_Risk_Relation) {
            Sip_Risk_Relation riskRelation = (Sip_Risk_Relation)model;
            riskRelation.where().addEq((ModelField)Sip_Risk_Relation.Field.main_risk, (Object)riskRelation.getMainRisk());
            riskRelation.where().addEq((ModelField)Sip_Risk_Relation.Field.risk_uuid, (Object)riskRelation.getRiskUuid());
            this.dao.delete((AbsModel)riskRelation);
        }
        if (model instanceof Dsn_Structure) {
            Dsn_Structure dsnStructure = (Dsn_Structure)model;
            dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)dsnStructure.getNodeNo());
            dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)dsnStructure.getUpNode());
            this.dao.delete((AbsModel)dsnStructure);
        }
        if (model instanceof Sip_Product_Risks) {
            Sip_Product_Risks sipProductRisks = (Sip_Product_Risks)model;
            sipProductRisks.where().addEq((ModelField)Sip_Product_Risks.Field.product_uuid, (Object)sipProductRisks.getProductUuid());
            sipProductRisks.where().addEq((ModelField)Sip_Product_Risks.Field.risk_uuid, (Object)sipProductRisks.getRiskUuid());
            this.dao.delete((AbsModel)sipProductRisks);
        }
    }

    public String getProductImage(String productNo) {
        Sip_Products product = new Sip_Products();
        product.where().addEq((ModelField)Sip_Products.Field.product_no, (Object)productNo);
        return ((Sip_Products)this.dao.findOne((AbsModel)product)).getProductImage();
    }

    public static enum UpdateFlag {
        I,
        U,
        D;

    }
}

