/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.product.transfer.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Md5 {
    public static final String[] HEX_DIGITS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

    public static String md5(String plainText) {
        return Md5.md5(plainText.getBytes());
    }

    public static String md5(InputStream file) {
        byte[] byteFile = null;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream(1024);){
            byte[] temp = new byte[1024];
            int size = 0;
            while ((size = file.read(temp)) != -1) {
                out.write(temp, 0, size);
            }
            byteFile = out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Md5.md5(byteFile);
    }

    public static String md5(byte[] byteFile) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(byteFile);
            return Md5.byteArrayToHexString(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String md5(File file) {
        try (FileInputStream fs = new FileInputStream(file);){
            String string = Md5.md5(fs);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String byteArrayToHexString(byte[] digest) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < digest.length; ++i) {
            buffer.append(Md5.byteToHexString(digest[i]));
        }
        return buffer.toString();
    }

    private static String byteToHexString(byte b) {
        int d1 = (b & 0xF0) >> 4;
        int d2 = b & 0xF;
        return HEX_DIGITS[d1] + HEX_DIGITS[d2];
    }

    public static void main(String[] args) throws Exception {
        System.out.println("-----\u6d4b\u8bd5\u521b\u5efa\u6587\u4ef6\u7684md5\u540e\u7f00----------");
        File file = new File("/Users/mac/Desktop/a.doc");
        if (!file.exists()) {
            file.createNewFile();
        }
        String parent = file.getParent();
        System.out.println(parent);
        String fileName = file.getName();
        System.out.println(fileName);
        String md5 = Md5.md5(file);
        System.out.println("-----\u83b7\u53d6\u7684md5\uff1a" + md5);
        File md5File = new File(parent + fileName + ".md5");
        if (md5File.exists()) {
            md5File.delete();
            md5File.createNewFile();
        }
        FileOutputStream fos = new FileOutputStream(md5File);
        fos.write(md5.getBytes());
        fos.flush();
        fos.close();
        System.out.println("--------\u5b8c\u6210---------");
    }
}

