/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.product.transfer.services.impl;

import cn.com.chinalife.model.Sip_Products;
import com.newtouch.context.ThreadLocalContext;
import com.newtouch.log.Ulog;
import com.newtouch.msg.Return;
import com.newtouch.msg.ReturnMsg;
import com.newtouch.msg.exception.BusinessException;
import com.newtouch.msg.pojo.Message;
import com.newtouch.product.transfer.domain.product.Product;
import com.newtouch.product.transfer.services.IProductTransferService;
import com.newtouch.product.transfer.utils.Md5;
import com.newtouch.product.transfer.utils.Zip;
import com.newtouch.repository.AbsModel;
import com.newtouch.repository.AbsModelRepository;
import com.newtouch.repository.ModelField;
import com.newtouch.util.date.DateUtil;
import com.newtouch.util.file.WriterFile;
import com.newtouch.util.json.JsonUtil;
import com.newtouch.util.json.JsonUtilOld;
import com.newtouch.util.path.PathFactory;
import com.newtouch.util.string.StrUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ProductTransferServiceImpl
implements IProductTransferService {
    @Autowired
    private AbsModelRepository dao;
    private static final String ALLOW_SUFFIX = ".zip";

    @Override
    public ReturnMsg exportProduct(List<Map<String, Object>> products) {
        Return msg = new Return();
        String currentTimeMillis = String.valueOf(System.currentTimeMillis());
        String basePath = PathFactory.getProperty() + "/product/export/" + DateUtil.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + currentTimeMillis + "/";
        for (Map<String, Object> prdMap : products) {
            Product p = new Product();
            String prdUuid = (String)prdMap.get("product_uuid");
            p.load(prdUuid);
            ArrayList<String> list = new ArrayList<String>();
            list.add(JsonUtilOld.formatObject(p));
            WriterFile.write((String)(basePath + "/" + prdUuid + ".json"), list);
        }
        String target = PathFactory.getProperty() + "/product/export/" + DateUtil.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + currentTimeMillis + ALLOW_SUFFIX;
        Ulog.info((String)("basePath----" + basePath));
        Ulog.info((String)("target----" + target));
        Zip.zip(basePath, target, new String[]{".json"});
        msg.getDataTable().put("zipPath", target);
        return msg.msg();
    }

    @Override
    public ReturnMsg importProduct(MultipartFile file, String md5) {
        ThreadLocalContext.get().setRqstSource("insure");
        String basePath = PathFactory.getProperty() + "/product/import/" + DateUtil.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + System.currentTimeMillis() + "/";
        Return msg = this.unzipFile(file, md5, basePath);
        if (!msg.isSuccessflag()) {
            msg.setFailMsg("\u4e0a\u4f20\u5931\u8d25");
            return msg.msg();
        }
        File importDir = new File(basePath);
        ArrayList<File> fileList = new ArrayList<File>();
        this.getAllFiles(importDir, fileList);
        for (File aProduct : fileList) {
            String pdrUuid = aProduct.getName().substring(0, aProduct.getName().lastIndexOf("."));
            StringBuffer buffer = new StringBuffer();
            try (FileInputStream inputStream = new FileInputStream(aProduct);
                 BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                String line = reader.readLine();
                while (line != null) {
                    buffer.append(line);
                    line = reader.readLine();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            String result = "";
            try {
                result = new String(buffer.toString().getBytes(), "UTf-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            Product importProduct = JsonUtilOld.json2Object(result, Product.class);
            String imports = JsonUtil.toJson((Object)importProduct);
            System.out.println("\u5bfc\u5165\u7684\u4ea7\u54c1\u4fe1\u606f\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\uff1a" + imports);
            Product dbProduct = new Product();
            dbProduct.load(pdrUuid);
            String dbPrd = JsonUtil.toJson((Object)dbProduct);
            System.out.println("\u67e5\u8be2\u51fa\u7684\u4ea7\u54c1\u4fe1\u606f\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\uff1a" + dbPrd);
            dbProduct.merge(importProduct);
            dbPrd = JsonUtil.toJson((Object)dbProduct);
            System.out.println("merger\u540e\u7684\u7684\u4ea7\u54c1\u4fe1\u606f\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\uff1a" + dbPrd);
            dbProduct.save();
        }
        msg.setSuccessMsg("\u4e0a\u4f20\u6210\u529f");
        return msg.msg();
    }

    @Override
    public ReturnMsg importPropose(MultipartFile file, String md5) throws Exception {
        ThreadLocalContext.get().setRqstSource("propose");
        String basePath = PathFactory.getProperty() + "/product/import/" + DateUtil.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + System.currentTimeMillis() + "/";
        Return msg = this.unzipFile(file, md5, basePath);
        if (!msg.isSuccessflag()) {
            msg.setFailMsg("\u4e0a\u4f20\u5931\u8d25");
            return msg.msg();
        }
        File importDir = new File(basePath);
        ArrayList<File> fileList = new ArrayList<File>();
        this.getAllFiles(importDir, fileList);
        for (File aProduct : fileList) {
            String pdrUuid = aProduct.getName().substring(0, aProduct.getName().lastIndexOf("."));
            Sip_Products prd = new Sip_Products();
            prd.where().addEq((ModelField)Sip_Products.Field.product_uuid, (Object)pdrUuid);
            if (StrUtil.isNull((Object)((Sip_Products)this.dao.findOne((AbsModel)prd)).getSerno())) {
                throw new BusinessException(new Message("2016027", "\u6b64\u4ea7\u54c1\u4e0d\u5b58\u5728,\u8be5\u8d26\u6237\u65e0\u6743\u9650\u5bfc\u5165"));
            }
            StringBuffer buffer = new StringBuffer();
            try (FileInputStream inputStream = new FileInputStream(aProduct);
                 BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                String line = reader.readLine();
                while (line != null) {
                    buffer.append(line);
                    line = reader.readLine();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            String result = "";
            try {
                result = new String(buffer.toString().getBytes(), "UTf-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            Product importProduct = JsonUtilOld.json2Object(result, Product.class);
            String imports = JsonUtil.toJson((Object)importProduct);
            System.out.println("\u5bfc\u5165\u7684\u4ea7\u54c1\u4fe1\u606f\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\uff1a" + imports);
            Product dbProduct = new Product();
            dbProduct.load(pdrUuid);
            String dbPrd = JsonUtil.toJson((Object)dbProduct);
            System.out.println("\u67e5\u8be2\u51fa\u7684\u4ea7\u54c1\u4fe1\u606f\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\uff1a" + dbPrd);
            dbProduct.merge(importProduct);
            dbPrd = JsonUtil.toJson((Object)dbProduct);
            System.out.println("merger\u540e\u7684\u7684\u4ea7\u54c1\u4fe1\u606f\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\uff1a" + dbPrd);
            dbProduct.save();
        }
        msg.setSuccessMsg("\u4e0a\u4f20\u6210\u529f");
        return msg.msg();
    }

    private Return unzipFile(MultipartFile file, String md5, String path) {
        String fileName = file.getOriginalFilename();
        long fileSize = file.getSize();
        Return msg = this.checkFile(fileName, fileSize);
        try {
            if (!StrUtil.isNull((Object)md5) && !md5.equals(Md5.md5(file.getInputStream()))) {
                msg.setFailMsg("\u4e0a\u4f20\u6587\u4ef6\u4e0d\u5b8c\u6574\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
                return msg;
            }
            File destFile = new File(path);
            if (!destFile.exists()) {
                destFile.mkdirs();
            }
            Zip.unzip(file.getInputStream(), path);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return msg;
    }

    private Return checkFile(String fileName, long fileSize) {
        String suffix;
        Return msg = new Return();
        if (fileName.indexOf(".") < 0) {
            msg.setFailMsg("\u53ea\u80fd\u4e0a\u4f20\u6269\u5c55\u540d\u4e3a[.zip]\u7684\u6587\u4ef6");
        }
        if (ALLOW_SUFFIX.indexOf(suffix = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase()) == -1) {
            msg.setFailMsg("\u53ea\u80fd\u4e0a\u4f20\u6269\u5c55\u540d\u4e3a[.zip]\u7684\u6587\u4ef6");
        }
        if (fileSize <= 0L) {
            msg.setFailMsg("\u6587\u4ef6\u5fc5\u987b\u5927\u4e8e0KB");
        }
        return msg;
    }

    public void getAllFiles(File dir, List<File> file) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.getAllFiles(files[i], file);
                continue;
            }
            if (files[i].getName().endsWith(".json")) {
                File file1 = files[i];
                file.add(file1);
            }
            Ulog.info((Object)files[i]);
        }
    }
}

