/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.product.transfer.domain.rule;

import cn.com.chinalife.model.Dsn_Rules;
import cn.com.chinalife.model.Dsn_Structure;
import com.newtouch.context.ThreadLocalContext;
import com.newtouch.product.transfer.domain.rule.RuleInfo;
import com.newtouch.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.product.transfer.utils.ProductQueryUtils;
import com.newtouch.product.transfer.utils.ProductUpdateUtils;
import com.newtouch.spring.SpringContext;
import java.util.ArrayList;
import java.util.List;

public class RuleNode
implements Comparable {
    private Dsn_Structure ruleStructure;
    private List<RuleInfo> rules = new ArrayList<RuleInfo>();

    public RuleNode load(Dsn_Structure ruleStructure) {
        this.ruleStructure = ruleStructure;
        ProductQueryUtils utils = SpringContext.getBean(ProductQueryUtils.class);
        utils.queryRules(this.ruleStructure.getNodeNo()).forEach(rule -> {
            RuleInfo info = new RuleInfo();
            info.load((Dsn_Rules)((Object)rule));
            this.rules.add(info);
        });
        return this;
    }

    public void merge(RuleNode ruleNode) {
        this.ruleStructure = ProductEqualsUtils.merge(this.ruleStructure, ruleNode.getRuleStructure());
        this.rules = ProductEqualsUtils.merge(this.rules, ruleNode.getRules(), RuleInfo.class);
    }

    public void save() {
        ProductUpdateUtils update = SpringContext.getBean(ProductUpdateUtils.class);
        String rqstSource = ThreadLocalContext.get().getRqstSource();
        if ("propose".equals(rqstSource) && this.ruleStructure.getNodeName().indexOf("\u5229\u76ca\u6f14\u793a") < 0) {
            return;
        }
        if ("insure".equals(rqstSource) && this.ruleStructure.getNodeName().indexOf("\u5229\u76ca\u6f14\u793a") > -1) {
            return;
        }
        update.update(this.ruleStructure);
        this.rules.forEach(ruleInfo -> ruleInfo.save());
    }

    public Dsn_Structure getRuleStructure() {
        return this.ruleStructure;
    }

    public void setRuleStructure(Dsn_Structure ruleStructure) {
        this.ruleStructure = ruleStructure;
    }

    public List<RuleInfo> getRules() {
        return this.rules;
    }

    public void setRules(List<RuleInfo> rules) {
        this.rules = rules;
    }

    public int hashCode() {
        return this.ruleStructure.getOtherProperty("md5").hashCode();
    }

    public int compareTo(Object o) {
        ProductUpdateUtils.UpdateFlag flag = (ProductUpdateUtils.UpdateFlag)((Object)this.ruleStructure.getOtherProperty("update_flag", ProductUpdateUtils.UpdateFlag.class));
        if (flag == ProductUpdateUtils.UpdateFlag.D) {
            return -1;
        }
        if (flag == ProductUpdateUtils.UpdateFlag.U) {
            return 0;
        }
        if (flag == ProductUpdateUtils.UpdateFlag.I) {
            return 1;
        }
        return 0;
    }
}

