/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.product.transfer.domain.rule;

import cn.com.chinalife.model.Dsn_Rules;
import cn.com.chinalife.model.Dsn_Rules_Const;
import com.newtouch.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.product.transfer.utils.ProductQueryUtils;
import com.newtouch.product.transfer.utils.ProductUpdateUtils;
import com.newtouch.repository.AbsModel;
import com.newtouch.spring.SpringContext;
import java.util.List;

public class RuleInfo
implements Comparable {
    private Dsn_Rules rule;
    private List<Dsn_Rules_Const> ruleConstList;

    public RuleInfo load(Dsn_Rules rule) {
        this.rule = rule;
        ProductQueryUtils utils = SpringContext.getBean(ProductQueryUtils.class);
        this.ruleConstList = utils.queryRuleConst(this.rule.getRuleNo());
        return this;
    }

    public void merge(RuleInfo ruleInfo) {
        this.rule = ProductEqualsUtils.merge(this.rule, ruleInfo.getRule());
        this.ruleConstList = ProductEqualsUtils.merge(this.ruleConstList, ruleInfo.getRuleConstList());
    }

    public void save() {
        ProductUpdateUtils update = SpringContext.getBean(ProductUpdateUtils.class);
        update.update(this.rule);
        this.ruleConstList.forEach(rulesConst -> update.update((AbsModel)rulesConst));
    }

    public Dsn_Rules getRule() {
        return this.rule;
    }

    public void setRule(Dsn_Rules rule) {
        this.rule = rule;
    }

    public List<Dsn_Rules_Const> getRuleConstList() {
        return this.ruleConstList;
    }

    public void setRuleConstList(List<Dsn_Rules_Const> ruleConstList) {
        this.ruleConstList = ruleConstList;
    }

    public int hashCode() {
        return this.rule.getOtherProperty("md5").hashCode();
    }

    public int compareTo(Object o) {
        ProductUpdateUtils.UpdateFlag flag = (ProductUpdateUtils.UpdateFlag)((Object)this.rule.getOtherProperty("update_flag", ProductUpdateUtils.UpdateFlag.class));
        if (flag == ProductUpdateUtils.UpdateFlag.D) {
            return -1;
        }
        if (flag == ProductUpdateUtils.UpdateFlag.U) {
            return 0;
        }
        if (flag == ProductUpdateUtils.UpdateFlag.I) {
            return 1;
        }
        return 0;
    }
}

