/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.product.transfer.domain.rule;

import cn.com.chinalife.model.Dsn_Structure;
import com.newtouch.context.ThreadLocalContext;
import com.newtouch.product.transfer.domain.rule.FeeRule;
import com.newtouch.product.transfer.domain.rule.InitRule;
import com.newtouch.product.transfer.domain.rule.InsureRule;
import com.newtouch.product.transfer.domain.rule.LinkageRule;
import com.newtouch.product.transfer.domain.rule.UnderwriteRule;
import com.newtouch.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.product.transfer.utils.ProductQueryUtils;
import com.newtouch.product.transfer.utils.ProductUpdateUtils;
import com.newtouch.spring.SpringContext;

public class Rule {
    private Dsn_Structure rule;
    private InitRule initRule;
    private InsureRule insureRule;
    private UnderwriteRule underwriteRule;
    private FeeRule feeRule;
    private LinkageRule linkageRule;

    public Rule load(String upNode, String nodeType) {
        ProductQueryUtils utils = SpringContext.getBean(ProductQueryUtils.class);
        this.rule = utils.queryStructure(upNode, nodeType);
        if (this.rule == null) {
            return this;
        }
        this.initRule = new InitRule();
        this.initRule.load(this.rule.getNodeNo());
        this.insureRule = new InsureRule();
        this.insureRule.load(this.rule.getNodeNo());
        this.underwriteRule = new UnderwriteRule();
        this.underwriteRule.load(this.rule.getNodeNo());
        this.feeRule = new FeeRule();
        this.feeRule.load(this.rule.getNodeNo());
        this.linkageRule = new LinkageRule();
        this.linkageRule.load(this.rule.getNodeNo());
        return this;
    }

    public void merge(Rule rule) {
        this.rule = ProductEqualsUtils.merge(this.rule, rule.getRule());
        this.initRule = ProductEqualsUtils.merge(this.initRule, rule.getInitRule(), InitRule.class);
        this.insureRule = ProductEqualsUtils.merge(this.insureRule, rule.getInsureRule(), InsureRule.class);
        this.underwriteRule = ProductEqualsUtils.merge(this.underwriteRule, rule.getUnderwriteRule(), UnderwriteRule.class);
        this.feeRule = ProductEqualsUtils.merge(this.feeRule, rule.getFeeRule(), FeeRule.class);
        this.linkageRule = ProductEqualsUtils.merge(this.linkageRule, rule.getLinkageRule(), LinkageRule.class);
    }

    public void save() {
        ProductUpdateUtils update = SpringContext.getBean(ProductUpdateUtils.class);
        String source = ThreadLocalContext.get().getRqstSource();
        if (!ProductEqualsUtils.isPropose(source)) {
            update.update(this.rule);
        }
        if (this.initRule != null) {
            this.initRule.save();
        }
        if (this.insureRule != null) {
            this.insureRule.save();
        }
        if (this.underwriteRule != null) {
            this.underwriteRule.save();
        }
        if (this.feeRule != null) {
            this.feeRule.save();
        }
        if (this.linkageRule != null) {
            this.linkageRule.save();
        }
    }

    public Dsn_Structure getRule() {
        return this.rule;
    }

    public void setRule(Dsn_Structure rule) {
        this.rule = rule;
    }

    public InitRule getInitRule() {
        return this.initRule;
    }

    public void setInitRule(InitRule initRule) {
        this.initRule = initRule;
    }

    public InsureRule getInsureRule() {
        return this.insureRule;
    }

    public void setInsureRule(InsureRule insureRule) {
        this.insureRule = insureRule;
    }

    public UnderwriteRule getUnderwriteRule() {
        return this.underwriteRule;
    }

    public void setUnderwriteRule(UnderwriteRule underwriteRule) {
        this.underwriteRule = underwriteRule;
    }

    public FeeRule getFeeRule() {
        return this.feeRule;
    }

    public void setFeeRule(FeeRule feeRule) {
        this.feeRule = feeRule;
    }

    public LinkageRule getLinkageRule() {
        return this.linkageRule;
    }

    public void setLinkageRule(LinkageRule linkageRule) {
        this.linkageRule = linkageRule;
    }
}

