/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.product.transfer.domain.rule;

import cn.com.chinalife.model.Dsn_Structure;
import com.newtouch.context.ThreadLocalContext;
import com.newtouch.product.transfer.domain.rule.RuleNode;
import com.newtouch.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.product.transfer.utils.ProductQueryUtils;
import com.newtouch.product.transfer.utils.ProductUpdateUtils;
import com.newtouch.spring.SpringContext;
import java.util.ArrayList;
import java.util.List;

public class InitRule {
    private Dsn_Structure initRule;
    private List<RuleNode> ruleList;

    String getRuleType() {
        return "init_rule";
    }

    public InitRule load(String upNode) {
        ProductQueryUtils utils = SpringContext.getBean(ProductQueryUtils.class);
        this.initRule = utils.queryStructure(upNode, this.getRuleType());
        if (this.initRule == null) {
            return this;
        }
        List<Dsn_Structure> ruleStructureList = utils.queryStructures(this.initRule.getNodeNo());
        this.ruleList = new ArrayList<RuleNode>();
        for (Dsn_Structure ruleStructure : ruleStructureList) {
            RuleNode ruleNode = new RuleNode();
            ruleNode.load(ruleStructure);
            this.ruleList.add(ruleNode);
        }
        return this;
    }

    public void merge(InitRule rule) {
        this.initRule = ProductEqualsUtils.merge(this.initRule, rule.getInitRule());
        this.ruleList = ProductEqualsUtils.merge(this.ruleList, rule.getRuleList(), RuleNode.class);
    }

    public void save() {
        ProductUpdateUtils update = SpringContext.getBean(ProductUpdateUtils.class);
        String source = ThreadLocalContext.get().getRqstSource();
        if (!ProductEqualsUtils.isPropose(source)) {
            update.update(this.initRule);
        }
        if (this.ruleList != null) {
            this.ruleList.forEach(ruleNode -> ruleNode.save());
        }
    }

    public Dsn_Structure getInitRule() {
        return this.initRule;
    }

    public void setInitRule(Dsn_Structure initRule) {
        this.initRule = initRule;
    }

    public List<RuleNode> getRuleList() {
        return this.ruleList;
    }

    public void setRuleList(List<RuleNode> ruleList) {
        this.ruleList = ruleList;
    }
}

