/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.product.transfer.domain.risk;

import cn.com.chinalife.model.Dsn_Structure;
import cn.com.chinalife.model.Sip_Risks;
import com.newtouch.context.ThreadLocalContext;
import com.newtouch.product.transfer.domain.attribute.Attribute;
import com.newtouch.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.product.transfer.utils.ProductQueryUtils;
import com.newtouch.product.transfer.utils.ProductUpdateUtils;
import com.newtouch.spring.SpringContext;
import java.util.ArrayList;
import java.util.List;

public class RiskDetail {
    private Dsn_Structure riskDetail;
    private List<Attribute> attributeList = new ArrayList<Attribute>();
    private Sip_Risks risk;

    public RiskDetail load(String upNode) {
        return this.load(upNode, "n_risk_detail");
    }

    public RiskDetail load(String upNode, String detailType) {
        ProductQueryUtils utils = SpringContext.getBean(ProductQueryUtils.class);
        this.riskDetail = utils.queryStructure(upNode, detailType);
        if (this.riskDetail == null) {
            return this;
        }
        utils.queryStructures(this.riskDetail.getNodeNo()).forEach(dsnAttr -> {
            Attribute attr = new Attribute();
            attr.load((Dsn_Structure)((Object)dsnAttr));
            this.attributeList.add(attr);
        });
        this.risk = utils.queryRisk(this.riskDetail.getNodeNo());
        return this;
    }

    public void merge(RiskDetail detail) {
        this.riskDetail = ProductEqualsUtils.merge(this.riskDetail, detail.getRiskDetail());
        this.attributeList = ProductEqualsUtils.merge(this.attributeList, detail.getAttributeList(), Attribute.class);
        this.risk = ProductEqualsUtils.merge(this.risk, detail.getRisk());
    }

    public void save() {
        ProductUpdateUtils update = SpringContext.getBean(ProductUpdateUtils.class);
        String source = ThreadLocalContext.get().getRqstSource();
        if (this.riskDetail != null && !ProductEqualsUtils.isPropose(source)) {
            update.update(this.riskDetail);
        }
        if (this.attributeList != null && !ProductEqualsUtils.isPropose(source)) {
            this.attributeList.forEach(attr -> attr.save());
        }
        if (this.risk != null && !ProductEqualsUtils.isPropose(source)) {
            update.update(this.risk);
        }
    }

    public Dsn_Structure getRiskDetail() {
        return this.riskDetail;
    }

    public void setRiskDetail(Dsn_Structure riskDetail) {
        this.riskDetail = riskDetail;
    }

    public List<Attribute> getAttributeList() {
        return this.attributeList;
    }

    public void setAttributeList(List<Attribute> attributeList) {
        this.attributeList = attributeList;
    }

    public Sip_Risks getRisk() {
        return this.risk;
    }

    public void setRisk(Sip_Risks risk) {
        this.risk = risk;
    }
}

