/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.product.transfer.domain.risk;

import cn.com.chinalife.model.Dsn_Structure;
import com.newtouch.context.ThreadLocalContext;
import com.newtouch.product.transfer.domain.attribute.Attribute;
import com.newtouch.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.product.transfer.utils.ProductQueryUtils;
import com.newtouch.product.transfer.utils.ProductUpdateUtils;
import com.newtouch.spring.SpringContext;
import java.util.ArrayList;
import java.util.List;

public class RiskAttribute {
    private Dsn_Structure riskAttr;
    private List<Attribute> attributeList = new ArrayList<Attribute>();

    public RiskAttribute load(String upNode) {
        ProductQueryUtils utils = SpringContext.getBean(ProductQueryUtils.class);
        this.riskAttr = utils.queryStructure(upNode, "n_risk_attr");
        utils.queryStructures(this.riskAttr.getNodeNo()).forEach(dsnAttr -> {
            Attribute attribute = new Attribute();
            attribute.load((Dsn_Structure)((Object)dsnAttr));
            this.attributeList.add(attribute);
        });
        return this;
    }

    public void merge(RiskAttribute attribute) {
        this.riskAttr = ProductEqualsUtils.merge(this.riskAttr, attribute.getRiskAttr());
        this.attributeList = ProductEqualsUtils.merge(this.attributeList, attribute.getAttributeList(), Attribute.class);
    }

    public void save() {
        ProductUpdateUtils update = SpringContext.getBean(ProductUpdateUtils.class);
        if (this.riskAttr != null) {
            update.update(this.riskAttr);
        }
        String source = ThreadLocalContext.get().getRqstSource();
        if (this.attributeList != null) {
            this.attributeList.forEach(attr -> attr.save());
        }
    }

    public Dsn_Structure getRiskAttr() {
        return this.riskAttr;
    }

    public void setRiskAttr(Dsn_Structure riskAttr) {
        this.riskAttr = riskAttr;
    }

    public List<Attribute> getAttributeList() {
        return this.attributeList;
    }
}

