/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.product.transfer.domain.risk;

import cn.com.chinalife.model.Dsn_Structure;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.newtouch.context.ThreadLocalContext;
import com.newtouch.product.transfer.domain.risk.RiskAttribute;
import com.newtouch.product.transfer.domain.risk.RiskDetail;
import com.newtouch.product.transfer.domain.rule.Rule;
import com.newtouch.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.product.transfer.utils.ProductQueryUtils;
import com.newtouch.product.transfer.utils.ProductUpdateUtils;
import com.newtouch.spring.SpringContext;

public class Risk
implements Comparable {
    private Dsn_Structure riskNode;
    private RiskDetail detail;
    private RiskAttribute attribute;
    private Rule rule;
    private boolean onlyReslation;

    public Risk load(Dsn_Structure riskNode) {
        ProductQueryUtils utils = SpringContext.getBean(ProductQueryUtils.class);
        this.riskNode = riskNode;
        this.detail = new RiskDetail();
        this.detail.load(this.riskNode.getNodeNo(), this.detailNodeType());
        this.attribute = new RiskAttribute();
        this.attribute.load(this.riskNode.getNodeNo());
        this.rule = new Rule();
        this.rule.load(riskNode.getNodeNo(), "n_rule");
        return this;
    }

    public void merge(Risk risk) {
        this.riskNode = ProductEqualsUtils.merge(this.riskNode, risk.getRiskNode());
        this.detail = ProductEqualsUtils.merge(this.detail, risk.getDetail(), RiskDetail.class);
        this.attribute = ProductEqualsUtils.merge(this.attribute, risk.getAttribute(), RiskAttribute.class);
        this.rule = ProductEqualsUtils.merge(this.rule, risk.getRule(), Rule.class);
    }

    public void save() {
        ProductUpdateUtils update = SpringContext.getBean(ProductUpdateUtils.class);
        String source = ThreadLocalContext.get().getRqstSource();
        if (this.riskNode != null && !ProductEqualsUtils.isPropose(source)) {
            update.update(this.riskNode);
        }
        if (this.detail != null && !this.isOnlyReslation()) {
            this.detail.save();
        }
        if (this.attribute != null && !this.isOnlyReslation()) {
            this.attribute.save();
        }
        if (this.rule != null && !this.isOnlyReslation()) {
            this.rule.save();
        }
    }

    public String detailNodeType() {
        return "n_risk_detail";
    }

    @JsonIgnore
    public Risk getBaseRisk() {
        Risk risk = new Risk();
        risk.setRiskNode(this.getRiskNode());
        risk.setDetail(this.getDetail());
        risk.setAttribute(this.getAttribute());
        this.setRule(this.getRule());
        return risk;
    }

    @JsonIgnore
    public Dsn_Structure detailNode() {
        return this.getDetail().getRiskDetail();
    }

    public Dsn_Structure getRiskNode() {
        return this.riskNode;
    }

    public void setRiskNode(Dsn_Structure riskNode) {
        this.riskNode = riskNode;
    }

    public RiskDetail getDetail() {
        return this.detail;
    }

    public void setDetail(RiskDetail detail) {
        this.detail = detail;
    }

    public RiskAttribute getAttribute() {
        return this.attribute;
    }

    public void setAttribute(RiskAttribute attribute) {
        this.attribute = attribute;
    }

    public Rule getRule() {
        return this.rule;
    }

    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public boolean isOnlyReslation() {
        return this.onlyReslation;
    }

    public void setOnlyReslation(boolean onlyReslation) {
        this.onlyReslation = onlyReslation;
    }

    public int hashCode() {
        return this.riskNode.getOtherProperty("md5").hashCode();
    }

    public int compareTo(Object o) {
        ProductUpdateUtils.UpdateFlag flag = (ProductUpdateUtils.UpdateFlag)((Object)this.riskNode.getOtherProperty("update_flag", ProductUpdateUtils.UpdateFlag.class));
        if (flag == ProductUpdateUtils.UpdateFlag.D) {
            return -1;
        }
        if (flag == ProductUpdateUtils.UpdateFlag.U) {
            return 0;
        }
        if (flag == ProductUpdateUtils.UpdateFlag.I) {
            return 1;
        }
        return 0;
    }
}

