/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.product.transfer.domain.risk;

import cn.com.chinalife.model.Dsn_Structure;
import com.newtouch.context.ThreadLocalContext;
import com.newtouch.product.transfer.domain.risk.MainRisk;
import com.newtouch.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.product.transfer.utils.ProductQueryUtils;
import com.newtouch.product.transfer.utils.ProductUpdateUtils;
import com.newtouch.spring.SpringContext;
import java.util.ArrayList;
import java.util.List;

public class MainRiskNode {
    private Dsn_Structure mainRiskNode;
    private List<MainRisk> mainRiskList;

    public MainRiskNode load(String prdUuid) {
        ProductQueryUtils utils = SpringContext.getBean(ProductQueryUtils.class);
        this.mainRiskNode = utils.queryStructure(prdUuid, "n_risk");
        if (this.mainRiskNode != null) {
            List<Dsn_Structure> dsnMainRiskList = utils.queryStructures(this.mainRiskNode.getNodeNo());
            this.mainRiskList = new ArrayList<MainRisk>();
            for (Dsn_Structure mainRisk : dsnMainRiskList) {
                MainRisk risk = new MainRisk();
                risk.setProductUuid(prdUuid);
                risk.load(mainRisk);
                this.mainRiskList.add(risk);
            }
        }
        return this;
    }

    public void merge(MainRiskNode mainRiskNode) {
        this.mainRiskNode = ProductEqualsUtils.merge(this.mainRiskNode, mainRiskNode.getMainRiskNode());
        this.mainRiskList = ProductEqualsUtils.merge(this.mainRiskList, mainRiskNode.getMainRiskList(), MainRisk.class);
    }

    public void save() {
        ProductUpdateUtils update = SpringContext.getBean(ProductUpdateUtils.class);
        String source = ThreadLocalContext.get().getRqstSource();
        if (!ProductEqualsUtils.isPropose(source)) {
            update.update(this.mainRiskNode);
        }
        if (this.mainRiskList != null) {
            this.mainRiskList.forEach(m -> m.save());
        }
    }

    public Dsn_Structure getMainRiskNode() {
        return this.mainRiskNode;
    }

    public void setMainRiskNode(Dsn_Structure mainRiskNode) {
        this.mainRiskNode = mainRiskNode;
    }

    public List<MainRisk> getMainRiskList() {
        return this.mainRiskList;
    }

    public void setMainRiskList(List<MainRisk> mainRiskList) {
        this.mainRiskList = mainRiskList;
    }
}

