/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.product.transfer.domain.risk;

import cn.com.chinalife.model.Dsn_Structure;
import cn.com.chinalife.model.Sip_Product_Risks;
import com.newtouch.context.ThreadLocalContext;
import com.newtouch.product.transfer.domain.propose.BenefitDemo;
import com.newtouch.product.transfer.domain.propose.RateGroup;
import com.newtouch.product.transfer.domain.risk.AccyRisk;
import com.newtouch.product.transfer.domain.risk.AccyRiskNode;
import com.newtouch.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.product.transfer.utils.ProductQueryUtils;
import com.newtouch.product.transfer.utils.ProductUpdateUtils;
import com.newtouch.spring.SpringContext;

public class MainRisk
extends AccyRisk {
    private AccyRiskNode accyRiskNode;
    private RateGroup rateGroup;
    private BenefitDemo benefitDemo;
    private Sip_Product_Risks sipProductRisks;
    private String productUuid;

    @Override
    public MainRisk load(Dsn_Structure riskNode) {
        super.load(riskNode);
        ProductQueryUtils utils = SpringContext.getBean(ProductQueryUtils.class);
        this.accyRiskNode = new AccyRiskNode();
        this.accyRiskNode.setRisk(this.getBaseRisk());
        this.accyRiskNode.load(this.getRiskNode().getNodeNo());
        this.rateGroup = new RateGroup();
        this.rateGroup.load(this.getRiskNode().getNodeNo());
        this.benefitDemo = new BenefitDemo();
        this.benefitDemo.load(this.getRiskNode().getNodeNo());
        String riskUuid = this.detailNode().getNodeNo();
        this.sipProductRisks = utils.queryProductRelation(this.productUuid, riskUuid);
        return this;
    }

    public void merge(MainRisk mainRisk) {
        super.merge(mainRisk);
        this.accyRiskNode = ProductEqualsUtils.merge(this.accyRiskNode, mainRisk.getAccyRiskNode(), AccyRiskNode.class);
        this.sipProductRisks = ProductEqualsUtils.merge(this.sipProductRisks, mainRisk.getSipProductRisks());
        this.benefitDemo = ProductEqualsUtils.merge(this.benefitDemo, mainRisk.getBenefitDemo(), BenefitDemo.class);
        this.rateGroup = ProductEqualsUtils.merge(null, mainRisk.getRateGroup(), RateGroup.class);
        this.productUuid = mainRisk.getProductUuid();
    }

    @Override
    public void save() {
        super.save();
        ProductUpdateUtils update = SpringContext.getBean(ProductUpdateUtils.class);
        String source = ThreadLocalContext.get().getRqstSource();
        if (this.accyRiskNode != null) {
            this.accyRiskNode.save();
        }
        if (this.sipProductRisks != null && "insure".equals(source)) {
            update.update(this.sipProductRisks);
        }
        if (this.benefitDemo != null && "propose".equals(source)) {
            this.benefitDemo.save();
        }
        if (this.rateGroup != null && "propose".equals(source)) {
            this.rateGroup.save();
        }
    }

    @Override
    public String detailNodeType() {
        return "n_risk_detail";
    }

    public AccyRiskNode getAccyRiskNode() {
        return this.accyRiskNode;
    }

    public void setAccyRiskNode(AccyRiskNode accyRiskNode) {
        this.accyRiskNode = accyRiskNode;
    }

    public Sip_Product_Risks getSipProductRisks() {
        return this.sipProductRisks;
    }

    public void setSipProductRisks(Sip_Product_Risks sipProductRisks) {
        this.sipProductRisks = sipProductRisks;
    }

    public String getProductUuid() {
        return this.productUuid;
    }

    public void setProductUuid(String productUuid) {
        this.productUuid = productUuid;
    }

    @Override
    public RateGroup getRateGroup() {
        return this.rateGroup;
    }

    @Override
    public void setRateGroup(RateGroup rateGroup) {
        this.rateGroup = rateGroup;
    }

    @Override
    public BenefitDemo getBenefitDemo() {
        return this.benefitDemo;
    }

    @Override
    public void setBenefitDemo(BenefitDemo benefitDemo) {
        this.benefitDemo = benefitDemo;
    }
}

