/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.product.transfer.domain.risk;

import cn.com.chinalife.model.Dsn_Structure;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.newtouch.context.ThreadLocalContext;
import com.newtouch.product.transfer.domain.risk.LiabilityRisk;
import com.newtouch.product.transfer.domain.risk.Risk;
import com.newtouch.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.product.transfer.utils.ProductQueryUtils;
import com.newtouch.product.transfer.utils.ProductUpdateUtils;
import com.newtouch.spring.SpringContext;
import java.util.ArrayList;
import java.util.List;

public class LiabilityRiskNode {
    private Dsn_Structure liabilityRisk;
    private List<LiabilityRisk> liabilityRiskList = new ArrayList<LiabilityRisk>();
    @JsonIgnore
    private Risk risk;

    public LiabilityRiskNode load(String upNode) {
        ProductQueryUtils utils = SpringContext.getBean(ProductQueryUtils.class);
        this.liabilityRisk = utils.queryStructure(upNode, "n_sub_risks");
        if (this.liabilityRisk != null) {
            utils.queryStructures(this.liabilityRisk.getNodeNo()).forEach(liabilityRisk -> {
                LiabilityRisk risk = new LiabilityRisk();
                risk.setMainRisk(this.risk);
                risk.load((Dsn_Structure)((Object)liabilityRisk));
                this.liabilityRiskList.add(risk);
            });
        }
        return this;
    }

    public void merge(LiabilityRiskNode liabilityRiskNode) {
        this.liabilityRisk = ProductEqualsUtils.merge(this.liabilityRisk, liabilityRiskNode.getLiabilityRisk());
        this.liabilityRiskList = ProductEqualsUtils.merge(this.liabilityRiskList, liabilityRiskNode.getLiabilityRiskList(), LiabilityRisk.class);
    }

    public void save() {
        ProductUpdateUtils update = SpringContext.getBean(ProductUpdateUtils.class);
        String source = ThreadLocalContext.get().getRqstSource();
        if (!ProductEqualsUtils.isPropose(source)) {
            update.update(this.liabilityRisk);
        }
        if (this.liabilityRiskList != null) {
            this.liabilityRiskList.forEach(risk -> risk.save());
        }
    }

    public void setRisk(Risk risk) {
        this.risk = risk;
    }

    public Dsn_Structure getLiabilityRisk() {
        return this.liabilityRisk;
    }

    public void setLiabilityRisk(Dsn_Structure liabilityRisk) {
        this.liabilityRisk = liabilityRisk;
    }

    public List<LiabilityRisk> getLiabilityRiskList() {
        return this.liabilityRiskList;
    }

    public void setLiabilityRiskList(List<LiabilityRisk> liabilityRiskList) {
        this.liabilityRiskList = liabilityRiskList;
    }

    public Risk getRisk() {
        return this.risk;
    }
}

