/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.product.transfer.domain.risk;

import cn.com.chinalife.model.Dsn_Structure;
import cn.com.chinalife.model.Sip_Risk_Relation;
import com.newtouch.context.ThreadLocalContext;
import com.newtouch.product.transfer.domain.risk.Risk;
import com.newtouch.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.product.transfer.utils.ProductQueryUtils;
import com.newtouch.product.transfer.utils.ProductUpdateUtils;
import com.newtouch.spring.SpringContext;

public class LiabilityRisk
extends Risk {
    private Risk mainRisk;
    private Sip_Risk_Relation relation;

    @Override
    public LiabilityRisk load(Dsn_Structure riskNode) {
        super.load(riskNode);
        if (this.mainRisk == null) {
            return this;
        }
        String mainRisk = this.mainRisk.detailNode().getNodeNo();
        String riskUuid = this.detailNode().getNodeNo();
        ProductQueryUtils utils = SpringContext.getBean(ProductQueryUtils.class);
        this.relation = utils.queryRiskRelation(mainRisk, riskUuid);
        return this;
    }

    public void merge(LiabilityRisk liabilityRisk) {
        super.merge(liabilityRisk);
        this.relation = ProductEqualsUtils.merge(this.relation, liabilityRisk.getRelation());
    }

    @Override
    public void save() {
        super.save();
        String source = ThreadLocalContext.get().getRqstSource();
        if (this.relation != null && !ProductEqualsUtils.isPropose(source)) {
            ProductUpdateUtils update = SpringContext.getBean(ProductUpdateUtils.class);
            update.update(this.relation);
        }
    }

    @Override
    public String detailNodeType() {
        return "n_sub_risks_detail";
    }

    public Risk getMainRisk() {
        return this.mainRisk;
    }

    public void setMainRisk(Risk mainRisk) {
        this.mainRisk = mainRisk;
    }

    public Sip_Risk_Relation getRelation() {
        return this.relation;
    }

    public void setRelation(Sip_Risk_Relation relation) {
        this.relation = relation;
    }
}

