/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.product.transfer.domain.risk;

import cn.com.chinalife.model.Dsn_Structure;
import com.newtouch.product.transfer.domain.risk.LiabilityRisk;
import com.newtouch.product.transfer.domain.risk.LiabilityRiskNode;
import com.newtouch.product.transfer.utils.ProductEqualsUtils;

public class ExemptRisk
extends LiabilityRisk {
    private LiabilityRiskNode liabilityNode;

    @Override
    public ExemptRisk load(Dsn_Structure riskNode) {
        super.load(riskNode);
        this.liabilityNode = new LiabilityRiskNode();
        this.liabilityNode.setRisk(this.getBaseRisk());
        this.liabilityNode.load(this.getRiskNode().getNodeNo());
        return this;
    }

    public void merge(ExemptRisk exemptRisk) {
        super.merge(exemptRisk);
        this.liabilityNode = ProductEqualsUtils.merge(this.liabilityNode, exemptRisk.getLiabilityNode(), LiabilityRiskNode.class);
    }

    @Override
    public void save() {
        super.save();
        if (this.liabilityNode != null && !this.isOnlyReslation()) {
            this.liabilityNode.save();
        }
    }

    @Override
    public String detailNodeType() {
        return "n_exempt_detail";
    }

    public LiabilityRiskNode getLiabilityNode() {
        return this.liabilityNode;
    }

    public void setLiabilityNode(LiabilityRiskNode liabilityNode) {
        this.liabilityNode = liabilityNode;
    }
}

