/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.product.transfer.domain.risk;

import cn.com.chinalife.model.Dsn_Structure;
import com.newtouch.context.ThreadLocalContext;
import com.newtouch.product.transfer.domain.risk.AccyRisk;
import com.newtouch.product.transfer.domain.risk.Risk;
import com.newtouch.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.product.transfer.utils.ProductQueryUtils;
import com.newtouch.product.transfer.utils.ProductUpdateUtils;
import com.newtouch.spring.SpringContext;
import java.util.ArrayList;
import java.util.List;

public class AccyRiskNode {
    private Risk risk;
    private Dsn_Structure accyRiskNode;
    private List<AccyRisk> accyRiskList;

    public AccyRiskNode load(String upNode) {
        ProductQueryUtils utils = SpringContext.getBean(ProductQueryUtils.class);
        this.accyRiskNode = utils.queryStructure(upNode, "n_accy_risks");
        if (this.accyRiskNode != null) {
            List<Dsn_Structure> dsnAccyRiskList = utils.queryStructures(this.accyRiskNode.getNodeNo());
            this.accyRiskList = new ArrayList<AccyRisk>();
            for (Dsn_Structure accyRisk : dsnAccyRiskList) {
                AccyRisk risk = new AccyRisk();
                risk.setMainRisk(this.risk);
                risk.load(accyRisk);
                this.accyRiskList.add(risk);
            }
        }
        return this;
    }

    public void merge(AccyRiskNode accyRiskNode) {
        this.accyRiskNode = ProductEqualsUtils.merge(this.accyRiskNode, accyRiskNode.getAccyRiskNode());
        this.accyRiskList = ProductEqualsUtils.merge(this.accyRiskList, accyRiskNode.getAccyRiskList(), AccyRisk.class);
    }

    public void save() {
        ProductUpdateUtils update = SpringContext.getBean(ProductUpdateUtils.class);
        String source = ThreadLocalContext.get().getRqstSource();
        if (!ProductEqualsUtils.isPropose(source)) {
            update.update(this.accyRiskNode);
        }
        if (this.accyRiskList != null) {
            this.accyRiskList.forEach(risk -> risk.save());
        }
    }

    public void setRisk(Risk risk) {
        this.risk = risk;
    }

    public Risk getRisk() {
        return this.risk;
    }

    public Dsn_Structure getAccyRiskNode() {
        return this.accyRiskNode;
    }

    public void setAccyRiskNode(Dsn_Structure accyRiskNode) {
        this.accyRiskNode = accyRiskNode;
    }

    public List<AccyRisk> getAccyRiskList() {
        return this.accyRiskList;
    }

    public void setAccyRiskList(List<AccyRisk> accyRiskList) {
        this.accyRiskList = accyRiskList;
    }
}

