/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.product.transfer.domain.risk;

import cn.com.chinalife.model.Dsn_Structure;
import com.newtouch.context.ThreadLocalContext;
import com.newtouch.product.transfer.domain.propose.BenefitDemo;
import com.newtouch.product.transfer.domain.propose.RateGroup;
import com.newtouch.product.transfer.domain.risk.ExemptRisk;
import com.newtouch.product.transfer.domain.risk.ExemptRiskNode;
import com.newtouch.product.transfer.utils.ProductEqualsUtils;

public class AccyRisk
extends ExemptRisk {
    private ExemptRiskNode exemptRiskNode;
    private RateGroup rateGroup;
    private BenefitDemo benefitDemo;

    @Override
    public AccyRisk load(Dsn_Structure riskNode) {
        super.load(riskNode);
        this.exemptRiskNode = new ExemptRiskNode();
        this.exemptRiskNode.setRisk(this.getBaseRisk());
        this.exemptRiskNode.load(this.getRiskNode().getNodeNo());
        this.rateGroup = new RateGroup();
        this.rateGroup.load(this.getRiskNode().getNodeNo());
        this.benefitDemo = new BenefitDemo();
        this.benefitDemo.load(this.getRiskNode().getNodeNo());
        return this;
    }

    public void merge(AccyRisk accyRisk) {
        super.merge(accyRisk);
        this.exemptRiskNode = ProductEqualsUtils.merge(this.exemptRiskNode, accyRisk.getExemptRiskNode(), ExemptRiskNode.class);
        this.benefitDemo = ProductEqualsUtils.merge(this.benefitDemo, accyRisk.getBenefitDemo(), BenefitDemo.class);
        this.rateGroup = ProductEqualsUtils.merge(null, accyRisk.getRateGroup(), RateGroup.class);
    }

    @Override
    public void save() {
        String source = ThreadLocalContext.get().getRqstSource();
        super.save();
        if (this.exemptRiskNode != null && this.isOnlyReslation()) {
            this.exemptRiskNode.save();
        }
        if (this.benefitDemo != null && "propose".equals(source)) {
            this.benefitDemo.save();
        }
        if (this.rateGroup != null && "propose".equals(source)) {
            this.rateGroup.save();
        }
    }

    @Override
    public String detailNodeType() {
        return "n_accy_detail";
    }

    public ExemptRiskNode getExemptRiskNode() {
        return this.exemptRiskNode;
    }

    public void setExemptRiskNode(ExemptRiskNode exemptRiskNode) {
        this.exemptRiskNode = exemptRiskNode;
    }

    public RateGroup getRateGroup() {
        return this.rateGroup;
    }

    public void setRateGroup(RateGroup rateGroup) {
        this.rateGroup = rateGroup;
    }

    public BenefitDemo getBenefitDemo() {
        return this.benefitDemo;
    }

    public void setBenefitDemo(BenefitDemo benefitDemo) {
        this.benefitDemo = benefitDemo;
    }
}

