/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.product.transfer.domain.propose;

import cn.com.chinalife.model.Dsn_Dynamic_Data;
import cn.com.chinalife.model.Dsn_Structure;
import com.newtouch.product.transfer.domain.propose.RateDetail;
import com.newtouch.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.product.transfer.utils.ProductQueryUtils;
import com.newtouch.product.transfer.utils.ProductUpdateUtils;
import com.newtouch.spring.SpringContext;

public class RateInfo
implements Comparable {
    private Dsn_Structure rateInfoDsnStru;
    private Dsn_Dynamic_Data rateDynamicData;
    private RateDetail inputRate;
    private RateDetail ouputRate;

    public RateInfo load(Dsn_Structure riskNode) {
        ProductQueryUtils utils = SpringContext.getBean(ProductQueryUtils.class);
        this.rateInfoDsnStru = utils.queryStructure(riskNode.getNodeNo());
        this.inputRate = new RateDetail();
        this.inputRate.load(riskNode, "input");
        this.ouputRate = new RateDetail();
        this.ouputRate.load(riskNode, "output");
        this.rateDynamicData = utils.queryDynamic(riskNode.getNodeNo());
        return this;
    }

    public void merge(RateInfo rateInfo) {
        this.rateDynamicData = ProductEqualsUtils.merge(this.rateDynamicData, rateInfo.getRateDynamicData());
        this.ouputRate = ProductEqualsUtils.merge(this.ouputRate, rateInfo.getOuputRate(), RateDetail.class);
        this.inputRate = ProductEqualsUtils.merge(this.inputRate, rateInfo.getInputRate(), RateDetail.class);
        this.rateInfoDsnStru = ProductEqualsUtils.merge(this.rateInfoDsnStru, rateInfo.getRateInfoDsnStru());
    }

    public void save() {
        ProductUpdateUtils update = SpringContext.getBean(ProductUpdateUtils.class);
        if (this.ouputRate != null) {
            this.ouputRate.save();
        }
        if (this.inputRate != null) {
            this.inputRate.save();
        }
        if (this.rateDynamicData != null) {
            update.update(this.rateDynamicData);
        }
        if (this.rateInfoDsnStru != null) {
            update.update(this.rateInfoDsnStru);
        }
    }

    public int compareTo(Object o) {
        return 0;
    }

    public Dsn_Structure getRateInfoDsnStru() {
        return this.rateInfoDsnStru;
    }

    public void setRateInfoDsnStru(Dsn_Structure rateInfoDsnStru) {
        this.rateInfoDsnStru = rateInfoDsnStru;
    }

    public RateDetail getInputRate() {
        return this.inputRate;
    }

    public void setInputRate(RateDetail inputRate) {
        this.inputRate = inputRate;
    }

    public RateDetail getOuputRate() {
        return this.ouputRate;
    }

    public void setOuputRate(RateDetail ouputRate) {
        this.ouputRate = ouputRate;
    }

    public Dsn_Dynamic_Data getRateDynamicData() {
        return this.rateDynamicData;
    }

    public void setRateDynamicData(Dsn_Dynamic_Data rateDynamicData) {
        this.rateDynamicData = rateDynamicData;
    }
}

