/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.product.transfer.domain.propose;

import cn.com.chinalife.model.Dsn_Structure;
import com.newtouch.product.transfer.domain.propose.RateInfo;
import com.newtouch.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.product.transfer.utils.ProductQueryUtils;
import com.newtouch.product.transfer.utils.ProductUpdateUtils;
import com.newtouch.spring.SpringContext;
import java.util.ArrayList;
import java.util.List;

public class RateGroup {
    private Dsn_Structure rateNode;
    private List<RateInfo> rateInfoList;

    public RateGroup load(String upNode) {
        ProductQueryUtils utils = SpringContext.getBean(ProductQueryUtils.class);
        this.rateNode = utils.queryStructure(upNode, "n_rate");
        if (this.rateNode != null) {
            List<Dsn_Structure> dsnRateList = utils.queryStructures(this.rateNode.getNodeNo());
            this.rateInfoList = new ArrayList<RateInfo>();
            for (Dsn_Structure accyRisk : dsnRateList) {
                RateInfo rate = new RateInfo();
                rate.load(accyRisk);
                this.rateInfoList.add(rate);
            }
        }
        return this;
    }

    public void merge(RateGroup rateGroup) {
        this.rateNode = ProductEqualsUtils.merge(this.rateNode, rateGroup.getRateNode());
        this.rateInfoList = ProductEqualsUtils.merge(this.rateInfoList, rateGroup.getRateInfoList(), RateInfo.class);
    }

    public void save() {
        ProductUpdateUtils update = SpringContext.getBean(ProductUpdateUtils.class);
        if (this.rateInfoList != null) {
            this.rateInfoList.forEach(m -> m.save());
        }
        if (this.rateNode != null) {
            update.update(this.rateNode);
        }
    }

    public Dsn_Structure getRateNode() {
        return this.rateNode;
    }

    public void setRateNode(Dsn_Structure rateNode) {
        this.rateNode = rateNode;
    }

    public List<RateInfo> getRateInfoList() {
        return this.rateInfoList;
    }

    public void setRateInfoList(List<RateInfo> rateInfoList) {
        this.rateInfoList = rateInfoList;
    }
}

