/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.product.transfer.domain.propose;

import cn.com.chinalife.model.Dsn_Biz_Attribute;
import cn.com.chinalife.model.Dsn_Structure;
import com.newtouch.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.product.transfer.utils.ProductQueryUtils;
import com.newtouch.product.transfer.utils.ProductUpdateUtils;
import com.newtouch.repository.AbsModel;
import com.newtouch.spring.SpringContext;
import com.newtouch.util.string.StrUtil;
import java.util.ArrayList;
import java.util.List;

public class RateDetail {
    private Dsn_Structure rateNode;
    private List<Dsn_Structure> rateDsnStructures;
    private List<Dsn_Biz_Attribute> rateBizAttributes;

    public RateDetail load(Dsn_Structure riskNode, String type) {
        ProductQueryUtils utils = SpringContext.getBean(ProductQueryUtils.class);
        this.rateNode = utils.queryStructure(riskNode.getNodeNo(), type);
        this.rateBizAttributes = new ArrayList<Dsn_Biz_Attribute>();
        if (!StrUtil.isNull((Object)((Object)this.rateNode))) {
            this.rateDsnStructures = utils.queryStructures(this.rateNode.getNodeNo());
            for (Dsn_Structure dsn : this.rateDsnStructures) {
                this.rateBizAttributes.add(utils.queryBizAttribute(dsn.getRelateFk()));
            }
        }
        return this;
    }

    public void merge(RateDetail rateDetail) {
        this.rateBizAttributes = ProductEqualsUtils.merge(this.rateBizAttributes, rateDetail.getRateBizAttributes());
        this.rateNode = ProductEqualsUtils.merge(this.rateNode, rateDetail.getRateNode());
        this.rateDsnStructures = ProductEqualsUtils.merge(this.rateDsnStructures, rateDetail.getRateDsnStructures());
    }

    public void save() {
        ProductUpdateUtils update = SpringContext.getBean(ProductUpdateUtils.class);
        if (this.rateBizAttributes != null) {
            this.rateBizAttributes.forEach(m -> update.update((AbsModel)m));
        }
        if (this.rateNode != null) {
            update.update(this.rateNode);
        }
        if (this.rateDsnStructures != null) {
            this.rateDsnStructures.forEach(n -> update.update((AbsModel)n));
        }
    }

    public Dsn_Structure getRateNode() {
        return this.rateNode;
    }

    public void setRateNode(Dsn_Structure rateNode) {
        this.rateNode = rateNode;
    }

    public List<Dsn_Structure> getRateDsnStructures() {
        return this.rateDsnStructures;
    }

    public void setRateDsnStructures(List<Dsn_Structure> rateDsnStructures) {
        this.rateDsnStructures = rateDsnStructures;
    }

    public List<Dsn_Biz_Attribute> getRateBizAttributes() {
        return this.rateBizAttributes;
    }

    public void setRateBizAttributes(List<Dsn_Biz_Attribute> rateBizAttributes) {
        this.rateBizAttributes = rateBizAttributes;
    }
}

