/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.product.transfer.domain.propose;

import cn.com.chinalife.model.Dsn_Rules;
import cn.com.chinalife.model.Dsn_Structure;
import com.newtouch.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.product.transfer.utils.ProductQueryUtils;
import com.newtouch.product.transfer.utils.ProductUpdateUtils;
import com.newtouch.repository.AbsModel;
import com.newtouch.spring.SpringContext;
import com.newtouch.util.string.StrUtil;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class BenefitRules {
    private List<Dsn_Structure> benefitRuleNode;
    private List<Dsn_Rules> benefitRules;

    public BenefitRules load(List<Dsn_Structure> dsnStructures) {
        ProductQueryUtils utils = SpringContext.getBean(ProductQueryUtils.class);
        this.benefitRules = new ArrayList<Dsn_Rules>();
        this.benefitRuleNode = new ArrayList<Dsn_Structure>();
        for (Dsn_Structure structure : dsnStructures) {
            Dsn_Structure dsnStructure = utils.queryStructure(structure.getNodeNo(), "rule");
            if (StrUtil.isNull((Object)((Object)dsnStructure))) continue;
            this.benefitRuleNode.add(dsnStructure);
        }
        for (Dsn_Structure rule : this.benefitRuleNode) {
            List<Dsn_Rules> rules = utils.queryRules(rule.getNodeNo());
            if (CollectionUtils.isEmpty(rules)) continue;
            this.benefitRules.addAll(rules);
        }
        return this;
    }

    public void merge(BenefitRules benefitRules) {
        this.benefitRuleNode = ProductEqualsUtils.merge(this.benefitRuleNode, benefitRules.getBenefitRuleNode());
        this.benefitRules = ProductEqualsUtils.merge(this.benefitRules, benefitRules.getBenefitRules());
    }

    public void save() {
        ProductUpdateUtils update = SpringContext.getBean(ProductUpdateUtils.class);
        if (this.benefitRuleNode != null) {
            this.benefitRuleNode.forEach(n -> update.update((AbsModel)n));
        }
        if (this.benefitRules != null) {
            this.benefitRules.forEach(m -> update.update((AbsModel)m));
        }
    }

    public List<Dsn_Structure> getBenefitRuleNode() {
        return this.benefitRuleNode;
    }

    public void setBenefitRuleNode(List<Dsn_Structure> benefitRuleNode) {
        this.benefitRuleNode = benefitRuleNode;
    }

    public List<Dsn_Rules> getBenefitRules() {
        return this.benefitRules;
    }

    public void setBenefitRules(List<Dsn_Rules> benefitRules) {
        this.benefitRules = benefitRules;
    }
}

