/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.product.transfer.domain.propose;

import cn.com.chinalife.model.Dsn_Dynamic_Data;
import cn.com.chinalife.model.Dsn_Structure;
import com.newtouch.product.transfer.domain.propose.BenefitRules;
import com.newtouch.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.product.transfer.utils.ProductQueryUtils;
import com.newtouch.product.transfer.utils.ProductUpdateUtils;
import com.newtouch.repository.AbsModel;
import com.newtouch.spring.SpringContext;
import com.newtouch.util.string.StrUtil;
import java.util.ArrayList;
import java.util.List;

public class BenefitDetail
implements Comparable {
    private List<Dsn_Structure> benefitNode;
    private List<Dsn_Dynamic_Data> benefitDynamicData;
    private BenefitRules benefitRules;

    public BenefitDetail load(String riskNode, String nodeType) {
        ProductQueryUtils utils = SpringContext.getBean(ProductQueryUtils.class);
        this.benefitDynamicData = new ArrayList<Dsn_Dynamic_Data>();
        this.benefitRules = new BenefitRules();
        ArrayList<Dsn_Structure> tables = new ArrayList<Dsn_Structure>();
        this.benefitNode = utils.queryStructures(riskNode);
        if ("n_liability_table".equals(nodeType)) {
            for (Dsn_Structure dsnStructure : this.benefitNode) {
                tables.addAll(utils.queryStructures(dsnStructure.getNodeNo()));
            }
        }
        this.benefitNode.addAll(tables);
        this.benefitRules.load(this.benefitNode);
        for (Dsn_Structure dsnStructure : this.benefitNode) {
            Dsn_Dynamic_Data dynamicData = utils.queryDynamic(dsnStructure.getNodeNo());
            if (StrUtil.isNull((Object)dynamicData.getSerno())) continue;
            this.benefitDynamicData.add(dynamicData);
        }
        return this;
    }

    public void merge(BenefitDetail benefitDetail) {
        this.benefitNode = ProductEqualsUtils.merge(this.benefitNode, benefitDetail.getBenefitNode());
        this.benefitDynamicData = ProductEqualsUtils.merge(this.benefitDynamicData, benefitDetail.getBenefitDynamicData());
        this.benefitRules = ProductEqualsUtils.merge(this.benefitRules, benefitDetail.getBenefitRules(), BenefitRules.class);
    }

    public void save() {
        ProductUpdateUtils update = SpringContext.getBean(ProductUpdateUtils.class);
        if (this.benefitNode != null) {
            this.benefitNode.forEach(n -> update.update((AbsModel)n));
        }
        if (this.benefitDynamicData != null) {
            this.benefitDynamicData.forEach(m -> update.update((AbsModel)m));
        }
        if (this.benefitRules != null) {
            this.benefitRules.save();
        }
    }

    public List<Dsn_Structure> getBenefitNode() {
        return this.benefitNode;
    }

    public void setBenefitNode(List<Dsn_Structure> benefitNode) {
        this.benefitNode = benefitNode;
    }

    public List<Dsn_Dynamic_Data> getBenefitDynamicData() {
        return this.benefitDynamicData;
    }

    public void setBenefitDynamicData(List<Dsn_Dynamic_Data> benefitDynamicData) {
        this.benefitDynamicData = benefitDynamicData;
    }

    public BenefitRules getBenefitRules() {
        return this.benefitRules;
    }

    public void setBenefitRules(BenefitRules benefitRules) {
        this.benefitRules = benefitRules;
    }

    public int compareTo(Object o) {
        return 0;
    }
}

