/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.product.transfer.domain.propose;

import cn.com.chinalife.model.Dsn_Structure;
import com.newtouch.product.transfer.domain.propose.BenefitTarget;
import com.newtouch.product.transfer.domain.propose.LiabilityTable;
import com.newtouch.product.transfer.domain.propose.SecurityTarget;
import com.newtouch.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.product.transfer.utils.ProductQueryUtils;
import com.newtouch.product.transfer.utils.ProductUpdateUtils;
import com.newtouch.spring.SpringContext;

public class BenefitDemo {
    private Dsn_Structure benefitNode;
    private BenefitTarget benefitTarget;
    private LiabilityTable liabilityTable;
    private SecurityTarget securityTarget;

    public BenefitDemo load(String upNode) {
        ProductQueryUtils utils = SpringContext.getBean(ProductQueryUtils.class);
        this.benefitNode = utils.queryStructure(upNode, "n_liability");
        if (this.benefitNode != null) {
            this.benefitTarget = new BenefitTarget();
            this.benefitTarget.load(this.benefitNode.getNodeNo());
            this.liabilityTable = new LiabilityTable();
            this.liabilityTable.load(this.benefitNode.getNodeNo());
            this.securityTarget = new SecurityTarget();
            this.securityTarget.load(this.benefitNode.getNodeNo());
        }
        return this;
    }

    public void merge(BenefitDemo benefitDemo) {
        this.benefitNode = ProductEqualsUtils.merge(this.benefitNode, benefitDemo.getBenefitNode());
        this.benefitTarget = ProductEqualsUtils.merge(this.benefitTarget, benefitDemo.getBenefitTarget(), BenefitTarget.class);
        this.liabilityTable = ProductEqualsUtils.merge(null, benefitDemo.getLiabilityTable(), LiabilityTable.class);
        this.securityTarget = ProductEqualsUtils.merge(this.securityTarget, benefitDemo.getSecurityTarget(), SecurityTarget.class);
    }

    public void save() {
        ProductUpdateUtils update = SpringContext.getBean(ProductUpdateUtils.class);
        if (this.benefitTarget != null) {
            this.benefitTarget.save();
        }
        if (this.liabilityTable != null) {
            this.liabilityTable.save();
        }
        if (this.securityTarget != null) {
            this.securityTarget.save();
        }
        if (this.benefitNode != null) {
            update.update(this.benefitNode);
        }
    }

    public Dsn_Structure getBenefitNode() {
        return this.benefitNode;
    }

    public void setBenefitNode(Dsn_Structure benefitNode) {
        this.benefitNode = benefitNode;
    }

    public BenefitTarget getBenefitTarget() {
        return this.benefitTarget;
    }

    public void setBenefitTarget(BenefitTarget benefitTarget) {
        this.benefitTarget = benefitTarget;
    }

    public LiabilityTable getLiabilityTable() {
        return this.liabilityTable;
    }

    public void setLiabilityTable(LiabilityTable liabilityTable) {
        this.liabilityTable = liabilityTable;
    }

    public SecurityTarget getSecurityTarget() {
        return this.securityTarget;
    }

    public void setSecurityTarget(SecurityTarget securityTarget) {
        this.securityTarget = securityTarget;
    }
}

