/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.product.transfer.domain.product;

import cn.com.chinalife.model.Dsn_Structure;
import cn.com.chinalife.model.Sip_Products;
import com.newtouch.context.ThreadLocalContext;
import com.newtouch.product.transfer.domain.attribute.Attribute;
import com.newtouch.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.product.transfer.utils.ProductQueryUtils;
import com.newtouch.product.transfer.utils.ProductUpdateUtils;
import com.newtouch.spring.SpringContext;
import java.util.ArrayList;
import java.util.List;

public class ProductDetail {
    private Dsn_Structure prdDetail;
    private List<Attribute> attributeList;
    private Sip_Products products;

    public ProductDetail load(String prdUuid) {
        ProductQueryUtils utils = SpringContext.getBean(ProductQueryUtils.class);
        this.prdDetail = utils.queryStructure(prdUuid, "prd_detail");
        if (this.prdDetail == null) {
            return this;
        }
        this.attributeList = new ArrayList<Attribute>();
        List<Dsn_Structure> dsnAttrList = null;
        dsnAttrList = utils.queryStructures(this.prdDetail.getNodeNo());
        for (Dsn_Structure dsnAttr : dsnAttrList) {
            Attribute attr = new Attribute();
            attr.load(dsnAttr);
            this.attributeList.add(attr);
        }
        this.products = utils.queryProduct(prdUuid);
        return this;
    }

    public void save() {
        ProductUpdateUtils update = SpringContext.getBean(ProductUpdateUtils.class);
        String source = ThreadLocalContext.get().getRqstSource();
        if (!ProductEqualsUtils.isPropose(source)) {
            update.update(this.prdDetail);
        }
        this.attributeList.forEach(attr -> {
            if (("prp_start_date".equals(attr.getBizAttribute().getAttrNo()) || "prp_end_date".equals(attr.getBizAttribute().getAttrNo()) || "product_image".equals(attr.getBizAttribute().getAttrNo())) && ProductEqualsUtils.isPropose(source)) {
                attr.save();
            }
            if (!("prp_start_date".equals(attr.getBizAttribute().getAttrNo()) || "prp_end_date".equals(attr.getBizAttribute().getAttrNo()) || "product_image".equals(attr.getBizAttribute().getAttrNo()) || ProductEqualsUtils.isPropose(source))) {
                attr.save();
            }
        });
        if (!ProductEqualsUtils.isPropose(source)) {
            String productImage = update.getProductImage(this.products.getProductNo());
            this.products.setProductImage(productImage);
            update.update(this.products);
        } else {
            Sip_Products newSip = new Sip_Products();
            newSip.setPrpEndDate(this.products.getPrpEndDate());
            newSip.setPrpStartDate(this.products.getPrpStartDate());
            newSip.setProductImage(this.products.getProductImage());
            newSip.setSerno(this.products.getSerno());
            newSip.putOtherProperty("update_flag", this.products.getOtherProperty("update_flag", ProductUpdateUtils.UpdateFlag.class));
            update.update(newSip);
        }
    }

    public void merge(ProductDetail detail) {
        this.prdDetail = ProductEqualsUtils.merge(this.prdDetail, detail.getPrdDetail());
        this.products = ProductEqualsUtils.merge(this.products, detail.getProducts());
        this.attributeList = ProductEqualsUtils.merge(this.attributeList, detail.getAttributeList(), Attribute.class);
    }

    public Dsn_Structure getPrdDetail() {
        return this.prdDetail;
    }

    public void setPrdDetail(Dsn_Structure prdDetail) {
        this.prdDetail = prdDetail;
    }

    public List<Attribute> getAttributeList() {
        return this.attributeList;
    }

    public void setAttributeList(List<Attribute> attributeList) {
        this.attributeList = attributeList;
    }

    public Sip_Products getProducts() {
        return this.products;
    }

    public void setProducts(Sip_Products products) {
        this.products = products;
    }
}

