/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.product.transfer.domain.product;

import cn.com.chinalife.model.Dsn_Structure;
import com.newtouch.context.ThreadLocalContext;
import com.newtouch.product.transfer.domain.product.ProductDetail;
import com.newtouch.product.transfer.domain.risk.MainRiskNode;
import com.newtouch.product.transfer.domain.rule.Rule;
import com.newtouch.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.product.transfer.utils.ProductQueryUtils;
import com.newtouch.product.transfer.utils.ProductUpdateUtils;
import com.newtouch.spring.SpringContext;

public class Product {
    private Dsn_Structure productStructure;
    private ProductDetail productDetail;
    private MainRiskNode mainRisk;
    private Rule rule;

    public void load(String prdUuid) {
        ProductQueryUtils query = SpringContext.getBean(ProductQueryUtils.class);
        this.productStructure = query.queryStructure(prdUuid);
        if (this.productStructure == null) {
            return;
        }
        this.productDetail = new ProductDetail();
        this.productDetail.load(prdUuid);
        this.mainRisk = new MainRiskNode();
        this.mainRisk.load(prdUuid);
        this.rule = new Rule();
        this.rule.load(prdUuid, "n_prd_rule");
    }

    public void loadPropose(String prdUuid) {
        ProductQueryUtils query = SpringContext.getBean(ProductQueryUtils.class);
        this.productStructure = query.queryStructure(prdUuid);
        if (this.productStructure == null) {
            return;
        }
        this.productDetail = new ProductDetail();
        this.mainRisk = new MainRiskNode();
        this.mainRisk.load(prdUuid);
        this.rule = new Rule();
        this.rule.load(prdUuid, "n_prd_rule");
    }

    public void merge(Product prd) {
        this.productStructure = ProductEqualsUtils.merge(this.productStructure, prd.getProductStructure());
        this.productDetail = ProductEqualsUtils.merge(this.productDetail, prd.getProductDetail(), ProductDetail.class);
        this.mainRisk = ProductEqualsUtils.merge(this.mainRisk, prd.getMainRisk(), MainRiskNode.class);
        this.rule = ProductEqualsUtils.merge(this.rule, prd.getRule(), Rule.class);
    }

    public void save() {
        ProductUpdateUtils update = SpringContext.getBean(ProductUpdateUtils.class);
        String source = ThreadLocalContext.get().getRqstSource();
        if (this.productStructure != null && !ProductEqualsUtils.isPropose(source)) {
            update.update(this.productStructure);
        }
        if (this.productDetail != null) {
            this.productDetail.save();
        }
        if (this.mainRisk != null) {
            this.mainRisk.save();
        }
        if (this.rule != null) {
            this.rule.save();
        }
    }

    public ProductDetail getProductDetail() {
        return this.productDetail;
    }

    public void setProductDetail(ProductDetail productDetail) {
        this.productDetail = productDetail;
    }

    public MainRiskNode getMainRisk() {
        return this.mainRisk;
    }

    public void setMainRisk(MainRiskNode mainRisk) {
        this.mainRisk = mainRisk;
    }

    public Rule getRule() {
        return this.rule;
    }

    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public Dsn_Structure getProductStructure() {
        return this.productStructure;
    }

    public void setProductStructure(Dsn_Structure productStructure) {
        this.productStructure = productStructure;
    }
}

