/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.product.transfer.domain.attribute;

import cn.com.chinalife.model.Dsn_Attribute;
import cn.com.chinalife.model.Dsn_Attribute_Option;
import cn.com.chinalife.model.Dsn_Biz_Attribute;
import cn.com.chinalife.model.Dsn_Biz_Attribute_Option;
import cn.com.chinalife.model.Dsn_Structure;
import com.newtouch.context.ThreadLocalContext;
import com.newtouch.product.transfer.domain.rule.Rule;
import com.newtouch.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.product.transfer.utils.ProductQueryUtils;
import com.newtouch.product.transfer.utils.ProductUpdateUtils;
import com.newtouch.repository.AbsModel;
import com.newtouch.spring.SpringContext;
import com.newtouch.util.string.StrUtil;
import java.util.List;

public class Attribute
implements Comparable {
    private Dsn_Structure attrStructure;
    private Dsn_Biz_Attribute bizAttribute;
    private List<Dsn_Biz_Attribute_Option> bizAttributeOptions;
    private Dsn_Attribute attribute;
    private List<Dsn_Attribute_Option> attributeOptions;
    private Rule rule;

    public Attribute load(String nodeNo) {
        ProductQueryUtils utils = SpringContext.getBean(ProductQueryUtils.class);
        this.load(utils.queryStructure(nodeNo));
        return this;
    }

    public Attribute load(Dsn_Structure attrStructure) {
        ProductQueryUtils utils = SpringContext.getBean(ProductQueryUtils.class);
        if (attrStructure == null || StrUtil.isNull((Object)attrStructure.getNodeNo())) {
            return this;
        }
        this.attrStructure = attrStructure;
        this.bizAttribute = utils.queryBizAttribute(this.attrStructure.getNodeNo());
        if (this.bizAttribute != null) {
            this.bizAttributeOptions = utils.queryBizAttributeOption(this.bizAttribute.getBizUuid());
            this.attribute = utils.queryAttribute(this.bizAttribute.getAttrUuid());
        }
        if (this.attribute != null) {
            this.attributeOptions = utils.queryAttributeOption(this.attribute.getAttrUuid());
        }
        this.rule = new Rule();
        this.rule.load(attrStructure.getNodeNo(), "n_rule");
        return this;
    }

    public void merge(Attribute attr) {
        this.attrStructure = ProductEqualsUtils.merge(this.attrStructure, attr.getAttrStructure());
        this.bizAttribute = ProductEqualsUtils.merge(this.bizAttribute, attr.getBizAttribute());
        this.bizAttributeOptions = ProductEqualsUtils.merge(this.bizAttributeOptions, attr.getBizAttributeOptions());
        this.attribute = ProductEqualsUtils.merge(this.attribute, attr.getAttribute());
        this.attributeOptions = ProductEqualsUtils.merge(this.attributeOptions, attr.getAttributeOptions());
        this.rule = ProductEqualsUtils.merge(this.rule, attr.getRule(), Rule.class);
    }

    public void save() {
        ProductUpdateUtils update = SpringContext.getBean(ProductUpdateUtils.class);
        String source = ThreadLocalContext.get().getRqstSource();
        if (!ProductEqualsUtils.isPropose(source)) {
            update.update(this.attrStructure);
            update.update(this.bizAttribute);
            if (this.bizAttributeOptions != null) {
                this.bizAttributeOptions.forEach(a -> update.update((AbsModel)a));
            }
            update.update(this.attribute);
            if (this.attributeOptions != null) {
                this.attributeOptions.forEach(a -> update.update((AbsModel)a));
            }
        }
        if (this.rule != null) {
            this.rule.save();
        }
    }

    public Dsn_Structure getAttrStructure() {
        return this.attrStructure;
    }

    public void setAttrStructure(Dsn_Structure attrStructure) {
        this.attrStructure = attrStructure;
    }

    public Dsn_Biz_Attribute getBizAttribute() {
        return this.bizAttribute;
    }

    public void setBizAttribute(Dsn_Biz_Attribute bizAttribute) {
        this.bizAttribute = bizAttribute;
    }

    public List<Dsn_Biz_Attribute_Option> getBizAttributeOptions() {
        return this.bizAttributeOptions;
    }

    public void setBizAttributeOptions(List<Dsn_Biz_Attribute_Option> bizAttributeOptions) {
        this.bizAttributeOptions = bizAttributeOptions;
    }

    public Dsn_Attribute getAttribute() {
        return this.attribute;
    }

    public void setAttribute(Dsn_Attribute attribute) {
        this.attribute = attribute;
    }

    public List<Dsn_Attribute_Option> getAttributeOptions() {
        return this.attributeOptions;
    }

    public void setAttributeOptions(List<Dsn_Attribute_Option> attributeOptions) {
        this.attributeOptions = attributeOptions;
    }

    public Rule getRule() {
        return this.rule;
    }

    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public int hashCode() {
        return this.attrStructure.getOtherProperty("md5").hashCode();
    }

    public int compareTo(Object o) {
        if (!(o instanceof Attribute)) {
            return 1;
        }
        Attribute attr = (Attribute)o;
        ProductUpdateUtils.UpdateFlag thisFlag = (ProductUpdateUtils.UpdateFlag)((Object)this.getAttrStructure().getOtherProperty("update_flag", ProductUpdateUtils.UpdateFlag.class));
        ProductUpdateUtils.UpdateFlag oFlag = (ProductUpdateUtils.UpdateFlag)((Object)attr.getAttrStructure().getOtherProperty("update_flag", ProductUpdateUtils.UpdateFlag.class));
        System.out.println("====" + this.attrStructure.getNodeName() + "  " + (Object)((Object)thisFlag) + "   " + this.attrStructure.getOtherProperty("md5"));
        if (thisFlag == ProductUpdateUtils.UpdateFlag.D && oFlag != ProductUpdateUtils.UpdateFlag.D) {
            return -1;
        }
        if (thisFlag == ProductUpdateUtils.UpdateFlag.U && oFlag == ProductUpdateUtils.UpdateFlag.I) {
            return -1;
        }
        if (thisFlag == ProductUpdateUtils.UpdateFlag.I) {
            return 1;
        }
        return 0;
    }
}

