/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.product.main.service.imp;

import com.newtouch.dao.IDao;
import com.newtouch.msg.Return;
import com.newtouch.msg.ReturnMsg;
import com.newtouch.product.main.service.IProductMainService;
import com.newtouch.util.string.StrUtil;
import com.newtouch.util.uuid.UniqueSeq;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ProductMainServiceImp
implements IProductMainService {
    @Autowired
    @Qualifier(value="Sys_Tree_MenuDao")
    private IDao menuConfig;
    @Autowired
    @Qualifier(value="Sip_Product_StructureDao")
    private IDao productStruct;

    @Override
    public ReturnMsg queryTree(Map<String, Object> param) {
        String node_no = StrUtil.trimStr((Object)param.get("node_no"));
        if (!StrUtil.isNull((Object)node_no)) {
            this.productStruct.addLikeR("node_seq", (Object)node_no);
        }
        this.productStruct.setOrder("display_order");
        Return msg = new Return();
        msg.setDataList(this.productStruct.queryList(false));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryRootNode(Map<String, Object> param) {
        Map menu_info = (Map)param.get("menu_info");
        if (menu_info == null || StrUtil.isNull(menu_info.get("node_type"))) {
            return new Return().msg();
        }
        this.menuConfig.addEq("menu_no", menu_info.get("node_type"));
        Map menu = this.menuConfig.query();
        Return ret = new Return();
        ret.getDataTable().put("node_name", menu.get("menu_name") + "\u540d\u79f0");
        ret.getDataTable().put("node_type", menu_info.get("node_type"));
        ret.getDataTable().put("node_no", param.get("node_no"));
        ret.getDataTable().put("node_seq", param.get("node_seq"));
        return ret.msg();
    }

    @Override
    public ReturnMsg queryTreeMenu(Map<String, Object> param) {
        if (StrUtil.isNull((Object)param.get("node_type"))) {
            return new Return().msg();
        }
        this.menuConfig.addEq("up_menu", param.get("node_type"));
        this.menuConfig.addEq("menu_type", (Object)"menu");
        this.menuConfig.setOrder("display_order");
        Return ret = new Return();
        ret.setDataList(this.menuConfig.queryList(false));
        return ret.msg();
    }

    @Override
    public ReturnMsg addDefNode(Map<String, Object> param) {
        String node_no = UniqueSeq.shortUUID();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("node_no", node_no);
        map.put("node_name", StrUtil.trimStr((Object)param.get("node_name")));
        map.put("node_type", StrUtil.trimStr((Object)param.get("node_type")));
        map.put("up_node", StrUtil.trimStr((Object)param.get("node_no")));
        String node_seq = StrUtil.trimStr((Object)param.get("node_seq")) + node_no + ".";
        map.put("node_seq", node_seq);
        this.productStruct.addEq("up_node", map.get("up_node"));
        this.productStruct.addGroupBy("max(display_order)");
        String display_order = StrUtil.trimStr(this.productStruct.query().get("max_display_order"));
        map.put("display_order", StrUtil.isNull((Object)display_order) ? "1" : Integer.valueOf(Integer.parseInt(display_order) + 1));
        this.productStruct.insert(map);
        this.menuConfig.addEq("up_menu", param.get("node_type"));
        this.menuConfig.addEq("menu_type", (Object)"node");
        this.menuConfig.setOrder("display_order");
        List nodeList = this.menuConfig.queryList(false);
        for (Map aNode : nodeList) {
            map.put("node_no", UniqueSeq.shortUUID());
            map.put("node_name", aNode.get("menu_name"));
            map.put("node_type", StrUtil.trimStr(aNode.get("node_type")));
            map.put("up_node", node_no);
            map.put("display_order", aNode.get("display_order"));
            map.put("node_seq", node_seq + map.get("node_no") + ".");
            this.productStruct.insert(map);
        }
        return new Return().msg();
    }
}

