/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.file.upload.service.imp;

import com.newtouch.dao.IDao;
import com.newtouch.file.upload.service.IFileUploader;
import com.newtouch.log.Ulog;
import com.newtouch.msg.Return;
import com.newtouch.msg.ReturnMsg;
import com.newtouch.util.date.DateUtil;
import com.newtouch.util.md5.Md5;
import com.newtouch.util.path.PathFactory;
import com.newtouch.util.string.StrUtil;
import com.newtouch.util.uuid.UniqueSeq;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FileUploaderImp
implements IFileUploader {
    @Autowired
    @Qualifier(value="Sys_File_RepostryDao")
    private IDao fileDao;
    private String allowSuffix = "png,gif,jpg,jpeg,bmp,tiff,txt,xml,pdf,zip,rar,doc,ppt,xls,docx,pptx,xlsx,html,htm,webp";
    private long allowSize = 0x200000L;
    private String rootDir = "fileRepostry/";

    @Override
    public ReturnMsg saveFile(String file, String fileName, String fileNo, String md5) {
        Return msg = this.check(fileName, file.length(), null);
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        if (!StrUtil.isNull((Object)md5) && !md5.equals(Md5.md5((String)file))) {
            msg.setFailMsg("\u4e0a\u4f20\u6587\u4ef6\u4e0d\u5b8c\u6574\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
            return msg.msg();
        }
        byte[] byteFile = Base64.getMimeDecoder().decode(file.substring(file.indexOf(",") + 1));
        ByteArrayInputStream sbs = new ByteArrayInputStream(byteFile);
        msg = this.saveFile(fileNo, fileName, byteFile.length, sbs);
        return msg.msg();
    }

    @Override
    public ReturnMsg saveFile(MultipartFile file, String fileNo, String md5, String localFileSize) {
        long fileSize;
        String fileName = file.getOriginalFilename();
        Return msg = this.check(fileName, fileSize = file.getSize(), localFileSize);
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        try {
            if (!StrUtil.isNull((Object)md5) && !md5.equals(Md5.getFileMD5((InputStream)file.getInputStream()))) {
                msg.setFailMsg("\u4e0a\u4f20\u6587\u4ef6\u4e0d\u5b8c\u6574\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
                return msg.msg();
            }
            msg = this.saveFile(fileNo, fileName, fileSize, file.getInputStream());
            return msg.msg();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ReturnMsg saveFile(File file) {
        return this.saveFile(file, "");
    }

    @Override
    public ReturnMsg saveFile(File file, String file_no) {
        long fileSize;
        String fileName = file.getName();
        Return msg = this.check(fileName, fileSize = file.length(), null);
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            msg = this.saveFile(file_no, fileName, fileSize, in);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return msg.msg();
    }

    private Return check(String fileName, long fileSize, String localFileSize) {
        String suffix;
        Return msg = new Return();
        if (StrUtil.isNull((Object)fileName)) {
            msg.setFailMsg("\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StrUtil.isNull((Object)localFileSize) && fileSize != Long.parseLong(localFileSize)) {
            msg.setFailMsg("\u4e0a\u4f20\u6587\u4ef6\u4e3a[" + Long.parseLong(localFileSize) / 1024L + "]KB\uff0c\u5b9e\u9645\u63a5\u6536[" + fileSize / 1024L + "]KB\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
        }
        if (fileName.indexOf(".") < 0) {
            msg.setFailMsg("\u53ea\u80fd\u4e0a\u4f20\u6269\u5c55\u540d\u4e3a[" + this.allowSuffix + "]\u7684\u6587\u4ef6");
        }
        if (this.allowSuffix.indexOf(suffix = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase()) == -1) {
            msg.setFailMsg("\u53ea\u80fd\u4e0a\u4f20\u6269\u5c55\u540d\u4e3a[" + this.allowSuffix + "]\u7684\u6587\u4ef6");
        }
        if (fileSize <= 0L) {
            msg.setFailMsg("\u6587\u4ef6\u5fc5\u987b\u5927\u4e8e0KB");
        }
        if (fileSize > this.allowSize) {
            msg.setFailMsg("\u6587\u4ef6\u6700\u5927\u4e0d\u80fd\u8d85\u8fc7[2M]");
        }
        return msg;
    }

    private Return saveFile(String file_no, String fileName, long fileSize, InputStream in) {
        if (StrUtil.isNull((Object)file_no)) {
            file_no = UniqueSeq.shortUUID();
        }
        String relativePath = this.rootDir + DateUtil.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/";
        String absolutePath = PathFactory.getProperty() + relativePath;
        File destFile = new File(absolutePath);
        if (!destFile.exists()) {
            destFile.mkdirs();
        }
        String suffix = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
        String newFileName = "file_" + file_no + "_" + DateUtil.date2String((Date)DateUtil.sysTimestamp(), (String)"yyyyMMddHHmmssSSS") + "." + suffix;
        File f = new File(absolutePath + newFileName);
        int byteread = 0;
        OutputStream out = null;
        try {
            if (!f.exists()) {
                f.createNewFile();
            }
            out = new FileOutputStream(f);
            byte[] buffer = new byte[1024];
            while ((byteread = in.read(buffer)) != -1) {
                out.write(buffer, 0, byteread);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                Ulog.error((Throwable)e);
                throw new RuntimeException(e);
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                Ulog.error((Throwable)e);
                throw new RuntimeException(e);
            }
        }
        Return msg = new Return();
        if (f.length() != fileSize) {
            msg.setFailMsg("\u4e0a\u4f20\u6587\u4ef6\u4e3a[" + fileSize / 1024L + "]KB\uff0c\u5b9e\u9645\u63a5\u6536[" + f.length() / 1024L + "]KB\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
            return msg;
        }
        this.fileDao.addEq("file_no", (Object)file_no);
        this.fileDao.delete();
        HashMap<String, Object> afile = new HashMap<String, Object>();
        afile.put("file_no", file_no);
        afile.put("file_name", fileName);
        afile.put("new_file_name", newFileName);
        afile.put("file_suffix", suffix);
        afile.put("file_type", suffix);
        afile.put("file_path", relativePath + newFileName);
        afile.put("file_size", fileSize);
        afile.put("upload_date", DateUtil.sysDate());
        this.fileDao.insert(afile);
        msg.getDataTable().put("file_no", file_no);
        return msg;
    }
}

