/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.file.download.service.imp;

import com.newtouch.dao.IDao;
import com.newtouch.file.download.service.IFileDownload;
import com.newtouch.msg.Return;
import com.newtouch.msg.ReturnMsg;
import com.newtouch.util.path.PathFactory;
import com.newtouch.util.string.StrUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class FileDownloadImp
implements IFileDownload {
    @Autowired
    @Qualifier(value="Sys_File_RepostryDao")
    private IDao fileDao;

    @Override
    public ReturnMsg downloadFile(Map<String, Object> map) {
        String file_no = StrUtil.trimStr((Object)map.get("file_no"));
        Return msg = new Return();
        msg.setAutoRollback(false);
        if (StrUtil.isNull((Object)file_no)) {
            msg.setFailMsg("\u6587\u4ef6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        this.fileDao.addEq("file_no", (Object)file_no);
        Map file_path = this.fileDao.query();
        if (file_path.isEmpty()) {
            msg.setFailMsg("\u672a\u67e5\u627e\u5230[" + file_no + "]\u5bf9\u5e94\u6587\u4ef6");
            return msg.msg();
        }
        File aFile = new File(PathFactory.getProperty() + StrUtil.trimStr(file_path.get("file_path")));
        file_path.put("file", aFile);
        if (!aFile.exists()) {
            msg.setFailMsg("\u672a\u5728[" + PathFactory.getProperty() + "]\u8def\u5f84\u4e0b\u67e5\u627e\u5230[" + StrUtil.trimStr(file_path.get("file_path")) + "]\u6587\u4ef6");
            return msg.msg();
        }
        msg.getDataTable().putAll(file_path);
        return msg.msg();
    }

    @Override
    public ReturnMsg getFileInfo(Map<String, Object> map) {
        String file_no = StrUtil.trimStr((Object)map.get("file_no"));
        Return msg = new Return();
        msg.setAutoRollback(false);
        if (StrUtil.isNull((Object)file_no)) {
            msg.setFailMsg("\u6587\u4ef6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        this.fileDao.addEq("file_no", (Object)file_no);
        Map file = this.fileDao.query();
        if (file.isEmpty()) {
            msg.setFailMsg("\u672a\u67e5\u627e\u5230[" + file_no + "]\u5bf9\u5e94\u6587\u4ef6");
            return msg.msg();
        }
        msg.setDataTable(file);
        return msg.msg();
    }

    @Override
    public ReturnMsg imageToBase64(Map<String, Object> map) {
        ReturnMsg msg1 = this.downloadFile(map);
        if (!msg1.isSuccessflag()) {
            throw msg1.getException();
        }
        Return msg = new Return();
        String imgPath = PathFactory.getProperty() + StrUtil.trimStr(msg1.getDataTable().get("file_path"));
        File file = new File(imgPath);
        if (!file.exists()) {
            msg.setFailMsg("\u672a\u5728[" + PathFactory.getProperty() + "]\u8def\u5f84\u4e0b\u67e5\u627e\u5230[" + StrUtil.trimStr(msg1.getDataTable().get("file_path")) + "]\u6587\u4ef6");
            return msg.msg();
        }
        byte[] data = null;
        try {
            FileInputStream input = new FileInputStream(file);
            data = new byte[(int)file.length()];
            input.read(data);
            input.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String baseCode = new String(Base64.getEncoder().encode(data));
        msg.getDataTable().put("baseCode", baseCode);
        return msg.msg();
    }
}

