/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.disclose.question.service.imp;

import com.newtouch.dao.DBHandleCreator;
import com.newtouch.dao.IDao;
import com.newtouch.dao.QuerySqlable;
import com.newtouch.dao.callback.FieldCallback;
import com.newtouch.dao.callback.RowCallback;
import com.newtouch.dao.util.callback.RepEnum;
import com.newtouch.disclose.question.service.IQuestionService;
import com.newtouch.msg.Return;
import com.newtouch.msg.ReturnMsg;
import com.newtouch.util.json.JsonUtilOld;
import com.newtouch.util.string.StrUtil;
import com.newtouch.util.uuid.UniqueSeq;
import com.newtouch.web.BaseService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class QuestionServiceImp
extends BaseService
implements IQuestionService {
    @Autowired
    @Qualifier(value="Tr_QuestionsDao")
    private IDao tr_questionsdao;
    @Autowired
    @Qualifier(value="Tr_Question_OptionDao")
    private IDao tr_question_optiondao;
    @Autowired
    @Qualifier(value="Tr_Question_BlanksDao")
    private IDao tr_question_blanksdao;
    @Autowired
    @Qualifier(value="Tr_Question_Blank_OptionDao")
    private IDao tr_question_blank_optionDao;
    @Autowired
    @Qualifier(value="Tr_Exam_Paper_QuestionDao")
    private IDao tr_Exam_Paper_QuestionDao;
    @Autowired
    @Qualifier(value="Sys_EnumDao")
    private IDao sys_enum;

    @Override
    public ReturnMsg queryQuestion(Map<String, Object> param) {
        this.tr_questionsdao.addRowCallback((RowCallback)new RepEnum("question_type", "question_type"));
        this.tr_questionsdao.addRowCallback((RowCallback)new RepEnum("question_class", "question_class"));
        this.tr_questionsdao.addRowCallback((RowCallback)new RepEnum("applicable_scope", "applicable_scope"));
        this.tr_questionsdao.addFieldCallback("up_question", (FieldCallback)new FieldCallback<Map<String, Object>>(){

            public void callback(String field, Object value, Map<String, Object> row) {
                row.put(field + "_name", "");
                if (StrUtil.isNull((Object)value)) {
                    return;
                }
                QuestionServiceImp.this.tr_questionsdao.addEq("question_no", value);
                row.put(field + "_name", QuestionServiceImp.this.tr_questionsdao.query().get("question_title"));
            }
        });
        if (!StrUtil.isNull((Object)param.get("question_title"))) {
            this.tr_questionsdao.addLike("question_title", param.get("question_title"));
        }
        if (!StrUtil.isNull((Object)param.get("question_type"))) {
            this.tr_questionsdao.addEq("question_type", param.get("question_type"));
        }
        if (!StrUtil.isNull((Object)param.get("question_class"))) {
            this.tr_questionsdao.addEq("question_class", param.get("question_class"));
        }
        if (!StrUtil.isNull((Object)param.get("question_code"))) {
            this.tr_questionsdao.addEq("question_code", param.get("question_code"));
        }
        Return msg = new Return();
        msg.setDataList(this.tr_questionsdao.queryList());
        return msg.msg();
    }

    @Override
    public ReturnMsg addQuestion(Map<String, Object> param) {
        Return msg = this.problemCheck(param, "add");
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        String question_no = UniqueSeq.shortUUID();
        String question_seq = question_no + ".";
        param.put("question_no", question_no);
        param.put("question_seq", question_seq);
        if (!StrUtil.isNull((Object)param.get("up_question"))) {
            this.tr_questionsdao.addEq("question_no", param.get("up_question"));
            String up_seq = StrUtil.trimStr(this.tr_questionsdao.query().get("question_seq"));
            param.put("question_seq", up_seq + question_seq);
        }
        this.tr_questionsdao.insert(param);
        if ("blanks".equals(param.get("question_type"))) {
            this.insertBlanks(param, question_no);
            return msg.msg();
        }
        if ("checkbox".equals(param.get("question_type")) || "radio".equals(param.get("question_type"))) {
            msg = this.insertChoice(param, question_no);
            return msg.msg();
        }
        return msg.msg();
    }

    private void insertBlanks(Map<String, Object> param, String question_no) {
        List tr_q_blanks = (List)param.get("tr_question_blanks");
        if (tr_q_blanks == null || tr_q_blanks.isEmpty()) {
            return;
        }
        for (Map aOption : tr_q_blanks) {
            String enum_list;
            aOption.put("question_no", question_no);
            aOption.put("blank_no", UniqueSeq.shortUUID());
            this.tr_question_blanksdao.insert(aOption);
            if (!"checkbox".equals(aOption.get("blank_class")) && !"radio".equals(aOption.get("blank_class")) || StrUtil.isNull((Object)(enum_list = StrUtil.trimStr(aOption.get("enum_list"))))) continue;
            List<Map<String, Object>> tr_q_b_option = JsonUtilOld.json2List(enum_list);
            for (Map<String, Object> b_option : tr_q_b_option) {
                if (StrUtil.isNull((Object)b_option.get("up_enum"))) continue;
                b_option.put("blank_no", aOption.get("blank_no"));
                this.tr_question_blank_optionDao.insert(b_option);
            }
        }
    }

    private Return insertChoice(Map<String, Object> param, String question_no) {
        List tr_q_option = (List)param.get("tr_question_option");
        Return msg = new Return();
        if (tr_q_option == null || tr_q_option.isEmpty()) {
            return msg;
        }
        ArrayList<String> optionValue = new ArrayList<String>();
        for (Map aOption : tr_q_option) {
            if (optionValue.contains(aOption.get("option_value"))) {
                msg.setFailMsg("\u9009\u9879\u503c[" + StrUtil.trimStr(aOption.get("option_value")) + "]\u5df2\u5b58\u5728");
                continue;
            }
            optionValue.add(StrUtil.trimStr(aOption.get("option_value")));
            aOption.put("question_no", question_no);
            aOption.put("option_no", UniqueSeq.shortUUID());
            this.tr_question_optiondao.insert(aOption);
        }
        return msg;
    }

    private Return problemCheck(Map<String, Object> param, String type) {
        Return msg = new Return();
        String question_code = StrUtil.trimStr((Object)param.get("question_code"));
        String question_title = StrUtil.trimStr((Object)param.get("question_title"));
        String question_class = StrUtil.trimStr((Object)param.get("question_class"));
        String applicable_scope = StrUtil.trimStr((Object)param.get("applicable_scope"));
        if (StrUtil.isNull((Object)question_code)) {
            msg.setFailMsg("\u95ee\u9898\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StrUtil.isNull((Object)question_title)) {
            msg.setFailMsg("\u95ee\u9898\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StrUtil.isNull((Object)question_class)) {
            msg.setFailMsg("\u95ee\u9898\u6240\u5c5e\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StrUtil.isNull((Object)applicable_scope)) {
            msg.setFailMsg("\u9002\u7528\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (type.equals("add")) {
            this.tr_questionsdao.addEq("question_code", (Object)question_code);
            if (this.tr_questionsdao.queryList().size() != 0) {
                msg.setFailMsg("\u95ee\u9898\u7f16\u53f7\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165");
            }
        }
        return msg;
    }

    @Override
    public ReturnMsg mdfQuestionInit(Map<String, Object> param) {
        this.tr_questionsdao.addFieldCallback("up_question", (FieldCallback)new FieldCallback<Map<String, Object>>(){

            public void callback(String field, Object value, Map<String, Object> row) {
                row.put(field + "_name", "");
                if (StrUtil.isNull((Object)value)) {
                    return;
                }
                QuestionServiceImp.this.tr_questionsdao.addEq("question_no", value);
                row.put(field + "_name", QuestionServiceImp.this.tr_questionsdao.query().get("question_title"));
            }
        });
        String question_no = StrUtil.trimStr((Object)param.get("question_no"));
        this.tr_questionsdao.addEq("question_no", (Object)question_no);
        Map map = this.tr_questionsdao.query();
        this.tr_question_optiondao.addEq("question_no", (Object)question_no);
        List showlist = this.tr_question_optiondao.queryList();
        if (!showlist.isEmpty()) {
            map.put("tr_question_option", showlist);
        }
        this.tr_question_blanksdao.addFieldCallback("blank_type", (FieldCallback)new FieldCallback<Map<String, Object>>(){

            public void callback(String field, Object value, Map<String, Object> row) {
                if ("BLANK".equals(value)) {
                    row.put(field + "_name", "\u7a7a\u4f4d");
                    return;
                }
                if ("DESC".equals(value)) {
                    row.put(field + "_name", "\u63cf\u8ff0");
                    return;
                }
                row.put(field + "_name", value);
            }
        });
        this.tr_question_blanksdao.addEq("question_no", (Object)question_no);
        this.tr_question_blanksdao.setOrder("display_order");
        showlist = this.tr_question_blanksdao.queryList(false);
        String sql = "SELECT se.enum_no, se.enum_name, se.up_enum FROM tr_question_blank_option tqbo, sys_enum se  WHERE tqbo.enum_no = se.enum_no and tqbo.blank_no = ?";
        QuerySqlable query = DBHandleCreator.getInstance().getQuerySql4Calc();
        for (Map aBlank : showlist) {
            if (!"radio".equals(aBlank.get("blank_class")) && !"checkbox".equals(aBlank.get("blank_class"))) continue;
            aBlank.put("enum_list", "");
            query.setSql(sql);
            query.add(aBlank.get("blank_no"));
            String enum_list = JsonUtilOld.formatJSONArray(this.dbHandle().queryList(query));
            if (StrUtil.isNull((Object)enum_list)) continue;
            aBlank.put("enum_list", enum_list);
        }
        if (!showlist.isEmpty()) {
            map.put("tr_question_blanks", showlist);
        }
        Return msg = new Return();
        msg.setDataTable(map);
        return msg.msg();
    }

    @Override
    public ReturnMsg mdfQuestion(Map<String, Object> param) {
        Return msg = this.problemCheck(param, "modify");
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        this.tr_questionsdao.addEq("question_no", param.get("question_no"));
        this.tr_questionsdao.update(param);
        if ("blanks".equals(param.get("question_type"))) {
            this.mdfBlanks(param);
        }
        if (("checkbox".equals(param.get("question_type")) || "radio".equals(param.get("question_type"))) && !(msg = this.mdfChoice(param)).isSuccessflag()) {
            return msg.msg();
        }
        this.mdfQuestionTree(param);
        return msg.msg();
    }

    private void mdfQuestionTree(Map<String, Object> param) {
        this.tr_Exam_Paper_QuestionDao.addEq("relate_fk", param.get("question_no"));
        List treeList = this.tr_Exam_Paper_QuestionDao.queryList(false);
        if (treeList.size() > 0) {
            HashMap<String, Object> titleMap = new HashMap<String, Object>();
            titleMap.put("node_name", param.get("question_title"));
            this.tr_Exam_Paper_QuestionDao.addEq("relate_fk", param.get("question_no"));
            this.tr_Exam_Paper_QuestionDao.update(titleMap);
        }
    }

    private void mdfBlanks(Map<String, Object> param) {
        this.tr_question_blanksdao.addEq("question_no", param.get("question_no"));
        List blankList = this.tr_question_blanksdao.queryList();
        for (Map aBlank : blankList) {
            this.tr_question_blank_optionDao.addEq("blank_no", aBlank.get("blank_no"));
            this.tr_question_blank_optionDao.delete();
        }
        this.tr_question_blanksdao.addEq("question_no", param.get("question_no"));
        this.tr_question_blanksdao.delete();
        List tr_q_blanks = (List)param.get("tr_question_blanks");
        if (tr_q_blanks == null || tr_q_blanks.isEmpty()) {
            return;
        }
        this.insertBlanks(param, StrUtil.trimStr((Object)param.get("question_no")));
    }

    private Return mdfChoice(Map<String, Object> param) {
        this.tr_question_optiondao.addEq("question_no", param.get("question_no"));
        this.tr_question_optiondao.delete();
        Return msg = new Return();
        List tr_q_option = (List)param.get("tr_question_option");
        if (tr_q_option == null || tr_q_option.isEmpty()) {
            return msg;
        }
        return this.insertChoice(param, StrUtil.trimStr((Object)param.get("question_no")));
    }

    @Override
    public ReturnMsg delQuestion(Map<String, Object> param) {
        List questionListMap = (List)param.get("checkbox");
        Return msg = new Return();
        msg.setAutoRollback(false);
        Map question = null;
        for (Map map : questionListMap) {
            if (StrUtil.isNull(map.get("question_no"))) continue;
            this.tr_questionsdao.addEq("question_no", map.get("question_no"));
            question = this.tr_questionsdao.query();
            String question_seq = StrUtil.trimStr(question.get("question_seq"));
            this.tr_questionsdao.addLikeR("question_seq", (Object)question_seq);
            this.tr_questionsdao.addNotEq("question_no", map.get("question_no"));
            if (!this.tr_questionsdao.queryList().isEmpty()) {
                msg.setWarnMsg(question.get("question_title") + "[" + question.get("question_code") + "]\u5b58\u5728\u4e0b\u7ea7\uff0c\u672a\u8fdb\u884c\u5220\u9664");
                continue;
            }
            this.tr_questionsdao.addEq("question_no", map.get("question_no"));
            this.tr_questionsdao.delete();
        }
        return msg.msg();
    }

    @Override
    public ReturnMsg queryQuestion4Ajax(Map<String, Object> param) {
        this.tr_questionsdao.addAs("question_title", "name");
        this.tr_questionsdao.addAs("question_no", "code");
        if (!StrUtil.isNull((Object)param.get("question_code"))) {
            this.tr_questionsdao.addEq("question_code", param.get("question_code"));
        }
        if (!StrUtil.isNull((Object)param.get("question_title"))) {
            this.tr_questionsdao.addLike("question_title", param.get("question_title"));
        }
        if (!StrUtil.isNull((Object)param.get("question_class"))) {
            this.tr_questionsdao.addEq("question_class", param.get("question_class"));
        }
        if (!StrUtil.isNull((Object)param.get("question_type"))) {
            this.tr_questionsdao.addEq("question_type", param.get("question_type"));
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.tr_questionsdao.setOrder("name");
        map.put("leftSelect", this.tr_questionsdao.queryList(false));
        map.put("ajaxtype", "select");
        map.put("blankline", false);
        Return msg = new Return();
        msg.getDataList().add(map);
        return msg.msg();
    }
}

