/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.disclose.paper.service.imp;

import com.newtouch.dao.IDao;
import com.newtouch.dao.callback.RowCallback;
import com.newtouch.dao.util.callback.RepEnum;
import com.newtouch.disclose.paper.service.IPaperService;
import com.newtouch.msg.Return;
import com.newtouch.msg.ReturnMsg;
import com.newtouch.util.string.StrUtil;
import com.newtouch.util.uuid.UniqueSeq;
import com.newtouch.web.BaseService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class PaperServiceImp
extends BaseService
implements IPaperService {
    @Autowired
    @Qualifier(value="Tr_QuestionsDao")
    private IDao questionDao;
    @Autowired
    @Qualifier(value="Tr_Exam_PaperDao")
    private IDao examPaperDao;
    @Autowired
    @Qualifier(value="Tr_Exam_Paper_QuestionDao")
    private IDao paperQuestionDao;
    @Autowired
    @Qualifier(value="Tr_Exam_Paper_Qu_SettingDao")
    private IDao paperSetting;
    @Autowired
    @Qualifier(value="Tr_Exam_Paper_Qu_ShowDao")
    private IDao paperShow;
    @Autowired
    @Qualifier(value="Tr_Exam_Paper_GroupDao")
    private IDao paperGrouDao;

    @Override
    public ReturnMsg queryPaper(Map<String, Object> param) {
        if (!StrUtil.isNull((Object)param.get("exam_paper_name"))) {
            this.examPaperDao.addLike("exam_paper_name", param.get("exam_paper_name"));
        }
        if (!StrUtil.isNull((Object)param.get("exam_class"))) {
            this.examPaperDao.addEq("exam_class", param.get("exam_class"));
        }
        if (!StrUtil.isNull((Object)param.get("applicable_scope"))) {
            this.examPaperDao.addEq("applicable_scope", param.get("applicable_scope"));
        }
        this.examPaperDao.setOrder("mdf_date desc");
        this.examPaperDao.addRowCallback((RowCallback)new RepEnum("exam_class", "exam_class"));
        this.examPaperDao.addRowCallback((RowCallback)new RepEnum("applicable_scope", "applicable_scope"));
        Return msg = new Return();
        msg.setDataList(this.examPaperDao.queryList());
        return msg.msg();
    }

    @Override
    public ReturnMsg queryPaper4Ajax(Map<String, Object> param) {
        this.examPaperDao.addAs("exam_paper_no", "code");
        this.examPaperDao.addAs("exam_paper_name", "name");
        this.examPaperDao.addNotEq("exam_paper_no", param.get("exam_paper_no"));
        if (!StrUtil.isNull((Object)param.get("exam_paper_name"))) {
            this.examPaperDao.addLike("exam_paper_name", param.get("exam_paper_name"));
        }
        if (!StrUtil.isNull((Object)param.get("exam_class"))) {
            this.examPaperDao.addEq("exam_class", param.get("exam_class"));
        }
        if (!StrUtil.isNull((Object)param.get("applicable_scope"))) {
            this.examPaperDao.addEq("applicable_scope", param.get("applicable_scope"));
        }
        this.examPaperDao.setOrder("mdf_date desc");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("leftSelect", this.examPaperDao.queryList(false));
        map.put("ajaxtype", "select");
        map.put("blankline", false);
        Return msg = new Return();
        msg.getDataList().add(map);
        return msg.msg();
    }

    @Override
    public ReturnMsg addPaper(Map<String, Object> param) {
        Return msg = new Return();
        String exam_paper_no = UniqueSeq.shortUUID();
        Return check = this.examCheck(param, "add");
        if (!check.isSuccessflag()) {
            return check.msg();
        }
        param.put("exam_paper_no", exam_paper_no);
        this.examPaperDao.insert(param);
        param.put("node_no", exam_paper_no);
        param.put("node_name", param.get("exam_paper_name"));
        param.put("relate_tab", "tr_exam_paper");
        param.put("relate_field", "exam_paper_no");
        param.put("relate_fk", exam_paper_no);
        param.put("up_node", 0);
        param.put("node_level", 0);
        param.put("display_order", "0");
        param.put("node_seq", exam_paper_no + ".");
        this.paperQuestionDao.insert(param);
        msg.setSuccessMsg("\u8bd5\u5377\u65b0\u589e\u6210\u529f!");
        return msg.msg();
    }

    private Return examCheck(Map<String, Object> param, String type) {
        Return msg = new Return();
        String exam_paper_name = StrUtil.trimStr((Object)param.get("exam_paper_name"));
        String exam_paper_code = StrUtil.trimStr((Object)param.get("exam_paper_code"));
        String applicable_scope = StrUtil.trimStr((Object)param.get("applicable_scope"));
        String exam_class = StrUtil.trimStr((Object)param.get("exam_class"));
        String st_order1 = StrUtil.trimStr((Object)param.get("order_1st"));
        if (type.equals("add")) {
            this.examPaperDao.addEq("exam_paper_name", (Object)exam_paper_name);
            if (!this.examPaperDao.queryList().isEmpty()) {
                msg.setFailMsg("\u95ee\u5377\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165");
                return msg;
            }
        }
        if (StrUtil.isNull((Object)exam_paper_name)) {
            msg.setFailMsg("\u95ee\u5377\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (exam_paper_name.length() > 256) {
            msg.setFailMsg("\u95ee\u5377\u540d\u79f0\u4e0d\u80fd\u5927\u4e8e128\u4e2a\u5b57\u7b26\uff01");
        }
        if (StrUtil.isNull((Object)exam_paper_code)) {
            msg.setFailMsg("\u95ee\u5377\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (exam_paper_code.length() > 32) {
            msg.setFailMsg("\u95ee\u5377\u7f16\u53f7\u4e0d\u80fd\u5927\u4e8e32\u4f4d\uff01");
        }
        if (StrUtil.isNull((Object)applicable_scope)) {
            msg.setFailMsg("\u9002\u7528\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StrUtil.isNull((Object)exam_class)) {
            msg.setFailMsg("\u95ee\u5377\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StrUtil.isNull((Object)st_order1)) {
            msg.setFailMsg("\u7b2c\u4e00\u7ea7\u7f16\u7801\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String st_order2 = StrUtil.trimStr((Object)param.get("order_2st"));
        String st_order3 = StrUtil.trimStr((Object)param.get("order_3st"));
        String st_order4 = StrUtil.trimStr((Object)param.get("order_4st"));
        if (!StrUtil.isNull((Object)st_order4) && StrUtil.isNull((Object)st_order3)) {
            msg.setFailMsg("\u7b2c\u4e09\u7ea7\u7f16\u7801\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!StrUtil.isNull((Object)st_order3) && StrUtil.isNull((Object)st_order2)) {
            msg.setFailMsg("\u7b2c\u4e8c\u7ea7\u7f16\u7801\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return msg;
    }

    @Override
    public ReturnMsg mdfPaperInit(Map<String, Object> param) {
        return null;
    }

    @Override
    public ReturnMsg mdfPaper(Map<String, Object> param) {
        return null;
    }

    @Override
    public ReturnMsg delPaper(Map<String, Object> param) {
        List questionListMap = (List)param.get("checkbox");
        Return msg = new Return();
        for (Map map : questionListMap) {
            if (StrUtil.isNull(map.get("exam_paper_no"))) continue;
            this.paperQuestionDao.addEq("exam_paper_no", map.get("exam_paper_no"));
            List questionList = this.paperQuestionDao.queryList(false);
            for (Map aQuestion : questionList) {
                this.paperSetting.addIn("node_no", aQuestion.get("node_no"));
                this.paperShow.addIn("node_no", aQuestion.get("node_no"));
                if (!"tr_exam_paper_group".equals(aQuestion.get("relate_tab"))) continue;
                this.paperGrouDao.addIn("group_no", aQuestion.get("relate_fk"));
            }
            if (this.paperSetting.hasWhere()) {
                this.paperSetting.delete();
            }
            if (this.paperShow.hasWhere()) {
                this.paperShow.delete();
            }
            if (this.paperGrouDao.hasWhere()) {
                this.paperGrouDao.delete();
            }
            this.paperQuestionDao.addEq("exam_paper_no", map.get("exam_paper_no"));
            this.paperQuestionDao.delete();
            this.examPaperDao.addEq("exam_paper_no", map.get("exam_paper_no"));
            this.examPaperDao.delete();
        }
        return msg.msg();
    }
}

