/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.disclose.paper.service.imp;

import com.newtouch.dao.IDao;
import com.newtouch.dao.callback.FieldCallback;
import com.newtouch.dao.callback.RowCallback;
import com.newtouch.dao.util.callback.RepEnum;
import com.newtouch.disclose.paper.service.IPaperQuestionShowService;
import com.newtouch.msg.Return;
import com.newtouch.msg.ReturnMsg;
import com.newtouch.util.string.StrUtil;
import com.newtouch.util.uuid.UniqueSeq;
import com.newtouch.web.BaseService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class PaperQuestionShowServiceImp
extends BaseService
implements IPaperQuestionShowService {
    @Autowired
    @Qualifier(value="Tr_Exam_Paper_Qu_ShowDao")
    private IDao paperQuShowDao;
    @Autowired
    @Qualifier(value="Tr_Exam_Paper_QuestionDao")
    private IDao paperQuestionDao;

    @Override
    public ReturnMsg queryShowSetting(Map<String, Object> param) {
        Return msg = this.checkAndSetEq(param);
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        this.paperQuShowDao.addRowCallback((RowCallback)new RepEnum("policy_person_type", "answer_object"));
        this.paperQuShowDao.addFieldCallback("compare_object", (FieldCallback)new FieldCallback<Map<String, Object>>(){

            public void callback(String field, Object value, Map<String, Object> row) {
                row.put(field + "_name", value);
                if ("SEX".equals(value)) {
                    row.put(field + "_name", "\u6027\u522b");
                    return;
                }
                if ("AGE".equals(value)) {
                    row.put(field + "_name", "\u5e74\u9f84");
                    return;
                }
            }
        });
        this.paperQuShowDao.addRowCallback((RowCallback)new RepEnum("con_flag", "compare_type"));
        this.paperQuShowDao.addRowCallback((RowCallback)new RepEnum("SHOWHIDE", "show_hide"));
        this.paperQuShowDao.addRowCallback((RowCallback)new RepEnum("sex", "start_value"));
        msg.setDataList(this.paperQuShowDao.queryList(false));
        return msg.msg();
    }

    private Return checkAndSetEq(Map<String, Object> param) {
        Return msg = new Return();
        if (StrUtil.isNull((Object)param.get("node_no")) && StrUtil.isNull((Object)param.get("show_no"))) {
            msg.setFailMsg("\u8282\u70b9\u7f16\u7801\u6216\u663e\u793a\u8bbe\u7f6e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return msg;
        }
        if (!StrUtil.isNull((Object)param.get("node_no"))) {
            this.paperQuShowDao.addEq("node_no", param.get("node_no"));
        }
        if (!StrUtil.isNull((Object)param.get("show_no"))) {
            this.paperQuShowDao.addEq("show_no", param.get("show_no"));
        }
        return msg;
    }

    @Override
    public ReturnMsg addShowSetting(Map<String, Object> param) {
        Return msg = new Return();
        this.paperQuShowDao.addEq("node_no", param.get("node_no"));
        this.paperQuShowDao.addEq("answer_object", param.get("answer_object"));
        this.paperQuShowDao.addEq("compare_object", param.get("compare_object"));
        if (!this.paperQuShowDao.query().isEmpty()) {
            msg.setFailMsg("\u5b58\u5728\u76f8\u540c\u663e\u793a\u6761\u4ef6");
        }
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        param.put("show_no", UniqueSeq.shortUUID());
        this.paperQuShowDao.insert(param);
        this.paperQuestionDao.addEq("node_no", param.get("node_no"));
        String nodeSeq = StrUtil.trimStr(this.paperQuestionDao.query().get("node_seq"));
        this.paperQuestionDao.addLikeR("node_seq", (Object)nodeSeq);
        this.paperQuestionDao.addNotEq("node_no", param.get("node_no"));
        List nextQuestionList = this.paperQuestionDao.queryList(false);
        HashMap<String, Object> nextParam = new HashMap<String, Object>();
        for (Map aQuestion : nextQuestionList) {
            this.paperQuShowDao.addEq("node_no", aQuestion.get("node_no"));
            if (!this.paperQuShowDao.queryList().isEmpty()) continue;
            nextParam.clear();
            nextParam.putAll(param);
            nextParam.put("show_no", UniqueSeq.shortUUID());
            nextParam.put("node_no", aQuestion.get("node_no"));
            this.paperQuShowDao.insert(nextParam);
        }
        return msg.msg();
    }

    @Override
    public ReturnMsg mdfShowSettingInit(Map<String, Object> param) {
        return null;
    }

    @Override
    public ReturnMsg mdfShowSetting(Map<String, Object> param) {
        return null;
    }

    @Override
    public ReturnMsg delShowSetting(Map<String, Object> param) {
        Return msg = this.checkAndSetEq(param);
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        if (!StrUtil.isNull((Object)param.get("answer_object"))) {
            this.paperQuShowDao.addNotEq("answer_object", param.get("answer_object"));
        }
        this.paperQuShowDao.delete();
        return msg.msg();
    }
}

