/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.disclose.paper.service.imp;

import com.newtouch.dao.IDao;
import com.newtouch.dao.callback.FieldCallback;
import com.newtouch.dao.callback.RowCallback;
import com.newtouch.disclose.paper.service.IPaperQuestionSettingService;
import com.newtouch.msg.Return;
import com.newtouch.msg.ReturnMsg;
import com.newtouch.util.string.StrUtil;
import com.newtouch.util.uuid.UniqueSeq;
import com.newtouch.web.BaseService;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class PaperQuestionSettingServiceImp
extends BaseService
implements IPaperQuestionSettingService {
    @Autowired
    @Qualifier(value="Tr_Exam_Paper_Qu_SettingDao")
    private IDao paperQuSettingDao;
    @Autowired
    @Qualifier(value="Tr_Exam_Paper_QuestionDao")
    private IDao paperQuestionDao;
    @Autowired
    @Qualifier(value="Tr_Exam_PaperDao")
    private IDao examPaperDao;

    @Override
    public ReturnMsg queryQuestionSetting(Map<String, Object> param) {
        Return msg = this.checkAndSetEq(param);
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        this.paperQuSettingDao.addFieldCallback("relate_tab", (FieldCallback)new FieldCallback<Map<String, Object>>(){

            public void callback(String field, Object value, Map<String, Object> row) {
                row.put(field + "_name", value);
                if ("tr_exam_paper_question".equals(value)) {
                    row.put(field + "_name", "\u95ee\u9898");
                    return;
                }
                if ("tr_exam_paper".equals(value)) {
                    row.put(field + "_name", "\u95ee\u5377");
                    return;
                }
            }
        });
        this.paperQuSettingDao.addRowCallback((RowCallback)new RowCallback<Map<String, Object>>(){

            public void callback(Map<String, Object> row, List<? extends Map<String, Object>> data, int index) {
                String relate_tab = StrUtil.trimStr((Object)row.get("relate_tab"));
                if ("tr_exam_paper_question".equals(relate_tab)) {
                    PaperQuestionSettingServiceImp.this.paperQuestionDao.addEq(StrUtil.trimStr((Object)row.get("relate_field")), row.get("relate_fk"));
                    row.put("question_title", PaperQuestionSettingServiceImp.this.paperQuestionDao.query().get("node_name"));
                    return;
                }
                if ("tr_exam_paper".equals(relate_tab)) {
                    PaperQuestionSettingServiceImp.this.examPaperDao.addEq(StrUtil.trimStr((Object)row.get("relate_field")), row.get("relate_fk"));
                    row.put("question_title", PaperQuestionSettingServiceImp.this.examPaperDao.query().get("exam_paper_name"));
                    return;
                }
            }
        });
        msg.setDataList(this.paperQuSettingDao.queryList(false));
        return msg.msg();
    }

    private Return checkAndSetEq(Map<String, Object> param) {
        Return msg = new Return();
        if (StrUtil.isNull((Object)param.get("node_no")) || StrUtil.isNull((Object)param.get("option_no"))) {
            msg.setFailMsg("\u8282\u70b9\u7f16\u7801\u548c\u9009\u9879\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return msg;
        }
        if (!StrUtil.isNull((Object)param.get("node_no"))) {
            this.paperQuSettingDao.addEq("node_no", param.get("node_no"));
        }
        if (!StrUtil.isNull((Object)param.get("option_no"))) {
            this.paperQuSettingDao.addEq("option_no", param.get("option_no"));
        }
        return msg;
    }

    @Override
    public ReturnMsg addQuestionSetting(Map<String, Object> param) {
        Object grid = param.get("paper_question_setting_question_grid");
        Return msg = new Return();
        if (grid == null) {
            return msg.msg();
        }
        List gridList = (List)grid;
        for (Map aData : gridList) {
            if (StrUtil.isNull(aData.get("setting_no"))) {
                this.paperQuSettingDao.addEq("node_no", aData.get("node_no"));
                this.paperQuSettingDao.addEq("option_no", aData.get("option_no"));
                this.paperQuSettingDao.addEq("relate_tab", aData.get("relate_tab"));
                this.paperQuSettingDao.addEq("relate_fk", aData.get("relate_fk"));
                if (!this.paperQuSettingDao.queryList().isEmpty()) {
                    msg.setWarnMsg(aData.get("question_title") + "\u5df2\u5b58\u5728\uff0c\u672a\u518d\u6b21\u4fdd\u5b58");
                    continue;
                }
                aData.put("setting_no", UniqueSeq.shortUUID());
                this.paperQuSettingDao.insert(aData);
                continue;
            }
            this.paperQuSettingDao.addEq("setting_no", aData.get("setting_no"));
            this.paperQuSettingDao.update(aData);
        }
        return msg.msg();
    }

    @Override
    public ReturnMsg mdfQuestionSettingInit(Map<String, Object> param) {
        return null;
    }

    @Override
    public ReturnMsg mdfQuestionSetting(Map<String, Object> param) {
        return null;
    }

    @Override
    public ReturnMsg delQuestionSetting(Map<String, Object> param) {
        Return msg = new Return();
        if (StrUtil.isNull((Object)param.get("node_no")) && StrUtil.isNull((Object)param.get("setting_no"))) {
            msg.setFailMsg("\u7b54\u9898\u8bbe\u7f6e\u7f16\u7801\u6216\u8282\u70b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        if (!StrUtil.isNull((Object)param.get("setting_no"))) {
            this.paperQuSettingDao.addEq("setting_no", param.get("setting_no"));
        }
        if (!StrUtil.isNull((Object)param.get("node_no"))) {
            this.paperQuSettingDao.addEq("node_no", param.get("node_no"));
        }
        this.paperQuSettingDao.delete();
        return msg.msg();
    }
}

