/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.disclose.paper.service.imp;

import com.newtouch.dao.IDao;
import com.newtouch.disclose.paper.service.IPaperQuestionService;
import com.newtouch.disclose.paper.service.IPaperQuestionSettingService;
import com.newtouch.disclose.paper.service.IPaperQuestionShowService;
import com.newtouch.msg.Return;
import com.newtouch.msg.ReturnMsg;
import com.newtouch.util.string.StrUtil;
import com.newtouch.util.uuid.UniqueSeq;
import com.newtouch.web.BaseService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class PaperQuestionServiceImp
extends BaseService
implements IPaperQuestionService {
    @Autowired
    @Qualifier(value="Tr_QuestionsDao")
    private IDao questionDao;
    @Autowired
    @Qualifier(value="Tr_Question_OptionDao")
    private IDao questionOptionDao;
    @Autowired
    @Qualifier(value="Tr_Exam_Paper_QuestionDao")
    private IDao paperQuestionDao;
    @Autowired
    @Qualifier(value="Tr_Exam_Paper_GroupDao")
    private IDao paperGroupDao;
    @Autowired
    private IPaperQuestionShowService paperQuShow;
    @Autowired
    private IPaperQuestionSettingService paperQuSetting;

    @Override
    public ReturnMsg queryPaperQuestion(Map<String, Object> param) {
        if (!StrUtil.isNull((Object)param.get("exam_paper_no"))) {
            this.paperQuestionDao.addEq("exam_paper_no", param.get("exam_paper_no"));
        }
        if (!StrUtil.isNull((Object)param.get("node_no"))) {
            this.paperQuestionDao.addEq("node_no", param.get("node_no"));
        }
        if (!StrUtil.isNull((Object)param.get("node_name"))) {
            this.paperQuestionDao.addLike("node_name", param.get("node_name"));
        }
        if (!StrUtil.isNull((Object)param.get("up_node"))) {
            this.paperQuestionDao.addEq("up_node", param.get("up_node"));
        }
        Return msg = new Return();
        msg.setDataList(this.paperQuestionDao.queryList());
        return msg.msg();
    }

    @Override
    public ReturnMsg queryPaperQuestion4Ajax(Map<String, Object> param) {
        Return msg = new Return();
        if (StrUtil.isNull((Object)param.get("exam_paper_no"))) {
            msg.setFailMsg("\u95ee\u5377\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        this.paperQuestionDao.addAs("node_name", "name");
        this.paperQuestionDao.addAs("node_no", "code");
        this.paperQuestionDao.addEq("relate_tab", (Object)"tr_questions");
        this.paperQuestionDao.addEq("exam_paper_no", param.get("exam_paper_no"));
        this.paperQuestionDao.addNotEq("node_no", param.get("node_no"));
        if (!StrUtil.isNull((Object)param.get("node_name"))) {
            this.paperQuestionDao.addLike("node_name", param.get("node_name"));
        }
        if ("Y".equals(param.get("only_next"))) {
            this.paperQuestionDao.addEq("up_node", param.get("node_no"));
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("leftSelect", this.paperQuestionDao.queryList(false));
        map.put("ajaxtype", "select");
        map.put("blankline", false);
        msg.getDataList().add(map);
        return msg.msg();
    }

    @Override
    public ReturnMsg addPaperQuestion(Map<String, Object> param) {
        Return msg = new Return();
        List rigthSelect = (List)param.get("rigthSelect");
        if (StrUtil.isNull((Object)rigthSelect)) {
            msg.setFailMsg("\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01");
            return msg.msg();
        }
        for (Map map : rigthSelect) {
            if (StrUtil.isNull(map.get("rigthSelect")) || StrUtil.isNull(map.get("rigthSelect_name"))) continue;
            this.paperQuestionDao.addEq("relate_fk", map.get("rigthSelect"));
            this.paperQuestionDao.addEq("exam_paper_no", param.get("exam_paper_no"));
            this.paperQuestionDao.addEq("up_node", param.get("node_no"));
            List list = this.paperQuestionDao.queryList();
            if (list.size() <= 0) continue;
            msg.setFailMsg(map.get("rigthSelect_name") + "\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
        }
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        this.paperQuestionDao.addEq("up_node", param.get("node_no"));
        this.paperQuestionDao.addGroupBy("max(display_order)");
        String display_order = StrUtil.trimStr(this.paperQuestionDao.query().get("max_display_order"));
        if (StrUtil.isNull((Object)display_order)) {
            display_order = "0";
        }
        this.paperQuestionDao.addEq("node_no", param.get("node_no"));
        String node_seq = StrUtil.trimStr(this.paperQuestionDao.query().get("node_seq"));
        int i = 1;
        HashMap<String, Object> questionMap = new HashMap<String, Object>();
        int node_level = Integer.parseInt(param.get("node_level").toString()) + 1;
        for (Map map : rigthSelect) {
            if (StrUtil.isNull(map.get("rigthSelect")) || StrUtil.isNull(map.get("rigthSelect_name"))) continue;
            questionMap.clear();
            String node_no = UniqueSeq.shortUUID();
            questionMap.put("exam_paper_no", param.get("exam_paper_no"));
            questionMap.put("node_no", node_no);
            questionMap.put("node_name", map.get("rigthSelect_name"));
            questionMap.put("relate_tab", "tr_questions");
            questionMap.put("relate_field", "question_no");
            questionMap.put("relate_fk", map.get("rigthSelect"));
            questionMap.put("up_node", param.get("node_no"));
            questionMap.put("node_level", node_level);
            questionMap.put("display_order", Integer.parseInt(display_order) + i);
            questionMap.put("node_seq", node_seq + StrUtil.alignLeft(questionMap.get("display_order"), (int)2) + "." + node_no + ".");
            ++i;
            this.paperQuestionDao.insert(questionMap);
        }
        return msg.msg();
    }

    @Override
    public ReturnMsg mdfPaperQuestionInit(Map<String, Object> param) {
        Return msg = new Return();
        if ("tr_questions".equals(param.get("relate_tab"))) {
            this.questionDao.addEq("question_no", param.get("relate_fk"));
            Map questionMap = this.questionDao.query();
            msg.getDataTable().put("question_depict", questionMap.get("question_depict"));
            msg.getDataTable().put("question_code", questionMap.get("question_code"));
            msg.getDataTable().put("node_name", questionMap.get("question_title"));
            msg.getDataTable().put("question_type", questionMap.get("question_type"));
        }
        if ("tr_exam_paper_group".equals(param.get("relate_tab"))) {
            this.paperGroupDao.addEq("group_no", param.get("relate_fk"));
            Map groupMap = this.paperGroupDao.query();
            msg.getDataTable().put("question_depict", groupMap.get("group_depict"));
            msg.getDataTable().put("question_code", groupMap.get("group_no"));
            msg.getDataTable().put("node_name", groupMap.get("group_title"));
            msg.getDataTable().put("question_type", groupMap.get("group_type"));
        }
        this.paperQuestionDao.addEq("node_no", param.get("node_no"));
        msg.getDataTable().putAll(this.paperQuestionDao.query());
        msg.getDataTable().put("xianshi_grid", this.paperQuShow.queryShowSetting(param).getDataList());
        this.questionOptionDao.addEq("question_no", param.get("relate_fk"));
        this.questionOptionDao.setOrder("display_order");
        msg.getDataTable().put("dati_grid", this.questionOptionDao.queryList(false));
        return msg.msg();
    }

    @Override
    public ReturnMsg mdfPaperQuestion(Map<String, Object> param) {
        Return msg = new Return();
        String node_seq = StrUtil.trimStr((Object)param.get("node_seq"));
        String display_order = StrUtil.trimStr((Object)param.get("display_order"));
        String up_node_seq = node_seq.substring(0, node_seq.length() - 12);
        String new_seq = up_node_seq + StrUtil.alignLeft((Object)display_order, (int)2) + "." + param.get("node_no") + ".";
        if (!new_seq.equals(node_seq)) {
            param.put("node_seq", new_seq);
        }
        this.paperQuestionDao.addEq("node_no", param.get("node_no"));
        this.paperQuestionDao.update(param);
        if (!"TBR_BBR".equals(param.get("answer_object"))) {
            this.paperQuShow.delShowSetting(param);
        }
        this.paperQuestionDao.addEq("up_node", param.get("node_no"));
        this.paperQuestionDao.addNotEq("node_no", param.get("node_no"));
        this.paperQuestionDao.setOrder("display_order");
        List nextQuestionList = this.paperQuestionDao.queryList(false);
        HashMap<String, Object> nextParam = new HashMap<String, Object>();
        HashMap<String, String> upNodeType = new HashMap<String, String>();
        for (Map aQuestion : nextQuestionList) {
            upNodeType.put(StrUtil.trimStr(aQuestion.get("node_no")), StrUtil.trimStr(aQuestion.get("relate_tab")));
            nextParam.clear();
            String nextNewSeq = new_seq + StrUtil.alignLeft(aQuestion.get("display_order"), (int)2) + "." + aQuestion.get("node_no") + ".";
            if (!new_seq.equals(aQuestion.get("node_seq"))) {
                nextParam.put("node_seq", nextNewSeq);
            }
            if (StrUtil.isNull(aQuestion.get("is_required"))) {
                nextParam.put("is_required", param.get("is_required"));
            }
            if (StrUtil.isNull(aQuestion.get("initial_state"))) {
                if ("tr_questions".equals(upNodeType.get(aQuestion.get("up_node")))) {
                    nextParam.put("initial_state", "HIDE");
                } else {
                    nextParam.put("initial_state", param.get("initial_state"));
                }
            }
            if (StrUtil.isNull(aQuestion.get("answer_object"))) {
                nextParam.put("answer_object", param.get("answer_object"));
            }
            if (nextParam.isEmpty()) continue;
            this.paperQuestionDao.addEq("node_no", aQuestion.get("node_no"));
            this.paperQuestionDao.update(nextParam);
        }
        msg.getDataTable().put("xianshi_grid", this.paperQuShow.queryShowSetting(param).getDataList());
        return msg.msg();
    }

    @Override
    public ReturnMsg delPaperQuestion(Map<String, Object> param) {
        Return msg = new Return();
        this.paperQuestionDao.addEq("up_node", param.get("node_no"));
        if (!this.paperQuestionDao.queryList().isEmpty()) {
            msg.setFailMsg("\u8bf7\u5148\u5220\u9664\u4e0b\u7ea7\u95ee\u9898");
            return msg.msg();
        }
        this.paperQuestionDao.addEq("node_no", param.get("node_no"));
        this.paperQuestionDao.delete();
        HashMap<String, Object> delMap = new HashMap<String, Object>();
        delMap.put("node_no", param.get("node_no"));
        this.paperQuShow.delShowSetting(delMap);
        this.paperQuSetting.delQuestionSetting(delMap);
        return msg.msg();
    }
}

