/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.disclose.answer.util;

import com.newtouch.disclose.answer.pojo.Question;
import com.newtouch.util.CollectionUtil;
import com.newtouch.util.string.StrUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PaperMerge {
    private Map<String, Integer> titleMaxIndex = new LinkedHashMap<String, Integer>();
    private String title = "";
    private List<Question<String, Object>> paper = new ArrayList<Question<String, Object>>();
    private List<Question<String, Object>> subList = new ArrayList<Question<String, Object>>();
    private List<String> showNode = new ArrayList<String>();
    private String allQuestionSeq = "";
    private Map<String, String> nodeConvert = new HashMap<String, String>();
    private List<Map<String, Object>> allAnswerMan = new ArrayList<Map<String, Object>>();
    private List<String> answerManList = new ArrayList<String>();
    private int maxIndex = 0;

    public List<Question<String, Object>> getPaper() {
        return this.paper;
    }

    public List<Map<String, Object>> getAllAnswerMan() {
        return this.allAnswerMan;
    }

    public void mergePaper(Map<String, Object> aNode, Map<String, Object> person, String personType) {
        if ("0".equals(aNode.get("node_level"))) {
            return;
        }
        Question<String, Object> paperNode = new Question<String, Object>(aNode);
        paperNode.addAnswer(StrUtil.trimStr((Object)person.get("person_no")));
        if (this.nodeConvert.keySet().contains(aNode.get("up_node")) && !Boolean.TRUE.equals(paperNode.get("setting_flag"))) {
            paperNode.put("up_node", this.nodeConvert.get(aNode.get("up_node")));
        }
        if (!"1".equals(paperNode.get("node_level")) && !this.showNode.contains(paperNode.get("up_node"))) {
            return;
        }
        if (StrUtil.trimStr((Object)aNode.get("answer_object")).indexOf(personType) < 0) {
            return;
        }
        List showList = (List)paperNode.get("node_show");
        if (showList != null && !showList.isEmpty()) {
            if (!PaperMerge.isShow(paperNode, person, personType)) {
                return;
            }
            paperNode.put("initial_state", "SHOW");
        }
        if (this.showNode.contains(paperNode.get("node_no")) || this.paper.contains(paperNode) && !Boolean.TRUE.equals(paperNode.get("setting_flag"))) {
            Question<String, Object> existsNode = this.findPaperNode(paperNode);
            if (existsNode == null) {
                return;
            }
            existsNode.put("answer_object", StrUtil.trimStr(existsNode.get("answer_object")) + "," + personType);
            existsNode.addAnswer(paperNode.getAnswer());
            if ("HIDE".equals(existsNode.get("initial_state"))) {
                existsNode.put("initial_state", paperNode.get("initial_state"));
            }
            if ("TITLE".equals(paperNode.get("type")) || "GROUP".equals(paperNode.get("type"))) {
                this.showNode.add(StrUtil.trimStr(paperNode.get("node_no")));
                this.initTitle(paperNode);
                return;
            }
            return;
        }
        if (!StrUtil.isNull(paperNode.get("question_seq")) && !Boolean.TRUE.equals(paperNode.get("setting_flag"))) {
            this.mergeQuestion(paperNode);
        }
        if ("TITLE".equals(paperNode.get("type")) || "GROUP".equals(paperNode.get("type"))) {
            this.initTitle(paperNode);
        }
        this.showNode.add(StrUtil.trimStr(paperNode.get("node_no")));
        this.addQuestionToPaper(paperNode);
        if (!StrUtil.isNull(paperNode.get("question_seq"))) {
            this.allQuestionSeq = this.allQuestionSeq + paperNode.get("question_seq") + "|" + paperNode.get("serno_key") + "#";
        }
    }

    private void initTitle(Question<String, Object> paperNode) {
        if (this.title.endsWith(StrUtil.trimStr(paperNode.get("depict")))) {
            return;
        }
        String[] titleArr = this.title.split("#");
        int titleIndex = Integer.parseInt(StrUtil.trimStr(paperNode.get("node_level")));
        this.title = titleIndex < 2 ? StrUtil.trimStr(paperNode.get("depict")) : titleArr[titleIndex - 2] + "#" + StrUtil.trimStr(paperNode.get("depict"));
    }

    private void mergeQuestion(Question<String, Object> paperNode) {
        if (this.allQuestionSeq.indexOf(StrUtil.trimStr(paperNode.get("question_seq"))) > 0) {
            String serno_key = this.parseAllQuestionSeq(StrUtil.trimStr(paperNode.get("question_seq")));
            HashMap<String, Object> up_question = new HashMap<String, Object>();
            up_question.put("serno_key", serno_key);
            Question<String, Object> findQuestion = this.findPaperNode(up_question);
            if (findQuestion == null) {
                return;
            }
            paperNode.put("answer_object", StrUtil.trimStr(paperNode.get("answer_object")) + "," + StrUtil.trimStr(findQuestion.get("answer_object")));
            paperNode.addAnswer(findQuestion.getAnswer());
            this.removeQuestionFromPaper(findQuestion);
            List settingList = (List)findQuestion.get("node_setting");
            for (Map aSetting : settingList) {
                up_question.clear();
                up_question.put("node_no", aSetting.get("relate_fk"));
                this.removeQuestionFromPaper(this.findPaperNode(up_question));
            }
            return;
        }
        String question_seq = StrUtil.trimStr(paperNode.get("question_seq"));
        int seqLength = question_seq.split("\\.").length;
        if (seqLength < 2) {
            return;
        }
        int index = -1;
        question_seq = question_seq.substring(0, question_seq.lastIndexOf("."));
        for (int i = 0; i < seqLength; ++i) {
            index = this.allQuestionSeq.indexOf(question_seq + ".|");
            if (index > 0) {
                String serno_key = this.parseAllQuestionSeq(question_seq + ".|");
                HashMap<String, Object> up_question = new HashMap<String, Object>();
                up_question.put("serno_key", serno_key);
                Question<String, Object> upQuestion = this.findPaperNode(up_question);
                upQuestion.put("answer_object", StrUtil.trimStr(upQuestion.get("answer_object")) + "," + StrUtil.trimStr(paperNode.get("answer_object")));
                upQuestion.addAnswer(paperNode.getAnswer());
                this.nodeConvert.put(StrUtil.trimStr(paperNode.get("node_no")), StrUtil.trimStr(upQuestion.get("node_no")));
                return;
            }
            index = question_seq.lastIndexOf(".");
            if (index <= 0) continue;
            question_seq = question_seq.substring(0, index);
        }
    }

    private void addQuestionToPaper(Question<String, Object> paperNode) {
        if (this.titleMaxIndex.get(this.title) == null) {
            this.titleMaxIndex.put(this.title, this.maxIndex);
            if (this.title.indexOf("#") > 0) {
                this.titleMaxIndex.put(this.title, this.titleMaxIndex.get(this.title.substring(0, this.title.lastIndexOf("#"))) + 1);
            }
        } else {
            this.titleMaxIndex.put(this.title, this.titleMaxIndex.get(this.title) + 1);
        }
        String[] titleArray = this.title.split("#");
        for (int i = 0; i < titleArray.length - 1; ++i) {
            this.titleMaxIndex.put(titleArray[i], this.titleMaxIndex.get(titleArray[i]) + 1);
        }
        this.paper.add(this.titleMaxIndex.get(this.title), paperNode);
        ++this.maxIndex;
    }

    private void removeQuestionFromPaper(Question<String, Object> paperNode) {
        if (paperNode == null) {
            return;
        }
        Question removeQ = new Question();
        removeQ.put("node_no", paperNode.get("node_no"));
        this.paper.remove(removeQ);
        this.showNode.remove(paperNode.get("node_no"));
        --this.maxIndex;
        boolean before = false;
        for (String key : this.titleMaxIndex.keySet()) {
            if (key.equals(this.title)) {
                before = true;
            }
            if (!before) continue;
            this.titleMaxIndex.put(key, this.titleMaxIndex.get(key) - 1);
        }
    }

    private String parseAllQuestionSeq(String question_seq) {
        int index = this.allQuestionSeq.indexOf(question_seq);
        String serno_key = this.allQuestionSeq.substring(index, this.allQuestionSeq.length());
        return serno_key.substring(serno_key.indexOf("|") + 1, serno_key.indexOf("#"));
    }

    private Question<String, Object> findPaperNode(Map<String, Object> paperNode) {
        this.subList.clear();
        this.subList.add(new Question<String, Object>(paperNode));
        int existsNodeIndex = Collections.indexOfSubList(this.paper, this.subList);
        if (existsNodeIndex == -1) {
            return null;
        }
        Question<String, Object> existsNode = this.paper.get(existsNodeIndex);
        return existsNode;
    }

    public static boolean isShow(Map<String, Object> aQuestion, Map<String, Object> person, String answerType) {
        List showList = (List)aQuestion.get("node_show");
        if (showList == null || showList.isEmpty()) {
            return false;
        }
        boolean showFlag = true;
        for (Map aShowSetting : showList) {
            if (!answerType.equals(aShowSetting.get("answer_object")) || (showFlag = showFlag && PaperMerge.comparePerson(aShowSetting, person))) continue;
            return showFlag;
        }
        return showFlag;
    }

    private static boolean comparePerson(Map<String, Object> showSetting, Map<String, Object> person) {
        if ("SEX".equals(showSetting.get("compare_object"))) {
            if (showSetting.get("start_value").equals(person.get("person_sex"))) {
                return "SHOW".equals(showSetting.get("show_hide"));
            }
            return "HIDE".equals(showSetting.get("show_hide"));
        }
        if ("AGE".equals(showSetting.get("compare_object"))) {
            int age = Integer.parseInt(StrUtil.trimStr((Object)person.get("person_age")));
            int startAge = Integer.parseInt(StrUtil.trimStr((Object)showSetting.get("start_value")));
            int endAge = Integer.parseInt(StrUtil.trimStr((Object)showSetting.get("end_value")));
            if (startAge <= age && age <= endAge) {
                return "SHOW".equals(showSetting.get("show_hide"));
            }
            return "HIDE".equals(showSetting.get("show_hide"));
        }
        return false;
    }

    public void initAnswerResult(Question<String, Object> aNode, Map<String, String> answerResult) {
        if ("TITLE".equals(aNode.get("type")) || "GROUP".equals(aNode.get("type"))) {
            return;
        }
        Map answer = (Map)aNode.get("answer");
        if (answer == null || answer.isEmpty()) {
            return;
        }
        String key = "";
        int gridIndex = -1;
        for (String answer_person : answer.keySet()) {
            Map aPerson = (Map)answer.get(answer_person);
            List questionList = (List)aPerson.get(aNode.get("type"));
            ArrayList<Map<String, Object>> grid = new ArrayList<Map<String, Object>>();
            for (Map ablank : questionList) {
                if ("DESC".equals(ablank.get("blank_type"))) continue;
                key = answer_person + "_" + aNode.get("exam_paper_no") + "_" + aNode.get("node_no") + "_" + aNode.get("relate_fk") + "_" + ablank.get("answer_code");
                if (!"Y".equals(aNode.get("is_repeat"))) {
                    key = key + "_0";
                    ablank.put("value", StrUtil.trimStr((Object)answerResult.get(key)));
                    answerResult.remove(key);
                    continue;
                }
                aPerson.put("grid", grid);
                String[] displayOrder = null;
                for (String answerResultkey : answerResult.keySet()) {
                    if (!answerResultkey.startsWith(key)) continue;
                    displayOrder = answerResultkey.split("_");
                    gridIndex = Integer.parseInt(displayOrder[displayOrder.length - 1]);
                    this.initListMap(grid, gridIndex);
                    ((Map)grid.get(gridIndex)).put(StrUtil.trimStr(ablank.get("answer_code")), StrUtil.trimStr((Object)answerResult.get(answerResultkey)));
                    answerResult.remove(answerResultkey);
                }
            }
        }
    }

    private void initListMap(List<Map<String, Object>> list, int index) {
        if (index < list.size()) {
            return;
        }
        while (list.size() <= index) {
            list.add(new HashMap());
        }
    }

    public void initAnswer(Question<String, Object> aNode, Map<String, Object> person, String personType) {
        HashMap<String, Object> aResult;
        if ("TITLE".equals(aNode.get("type")) || "GROUP".equals(aNode.get("type"))) {
            return;
        }
        if (Boolean.TRUE.equals(aNode.get("setting_flag"))) {
            HashMap<String, Object> up_node = new HashMap<String, Object>();
            up_node.put("node_no", aNode.get("up_node"));
            Question<String, Object> up_question = this.findPaperNode(up_node);
            aNode.put("answer_object", StrUtil.trimStr(aNode.get("answer_object")) + "," + StrUtil.trimStr(up_question.get("answer_object")));
            aNode.addAnswer(up_question.getAnswer());
        }
        if (StrUtil.trimStr(aNode.get("answer_object")).indexOf(personType) < 0) {
            return;
        }
        List showList = (List)aNode.get("node_show");
        if (showList != null && !showList.isEmpty() && !PaperMerge.isShow(aNode, person, personType)) {
            return;
        }
        if (!aNode.getAnswer().contains(person.get("person_no"))) {
            return;
        }
        LinkedHashMap answer = (LinkedHashMap)aNode.get("answer");
        if (answer == null) {
            answer = new LinkedHashMap();
            aNode.put("answer", answer);
        }
        if ((aResult = (HashMap<String, Object>)answer.get(person.get("person_no"))) != null) {
            return;
        }
        aResult = new HashMap<String, Object>();
        answer.put(StrUtil.trimStr((Object)person.get("person_no")), aResult);
        aResult.put("person_name", person.get("person_name"));
        aResult.put("person_no", person.get("person_no"));
        String allAnswerMan_type = "TBR".equals(personType) ? "(\u6295)" : "(\u88ab)";
        switch (StrUtil.trimStr(aNode.get("type"))) {
            case "blanks": {
                String person_type;
                List baseList = (List)aNode.get("blank_list");
                List blank_list = CollectionUtil.cloneList((List)baseList);
                String string = person_type = "TBR".equals(personType) ? "\u6295\u4fdd\u4eba" : "\u88ab\u4fdd\u4eba";
                if ("Y".equals(aNode.get("is_repeat"))) {
                    HashMap<String, String> person_name = new HashMap<String, String>();
                    person_name.put("blank_type", "DESC");
                    person_name.put("blank_depict", person_type);
                    blank_list.add(0, person_name);
                    HashMap<String, Object> person_name_value = new HashMap<String, Object>();
                    person_name_value.put("blank_type", "disabled");
                    person_name_value.put("blank_depict", "person_name");
                    person_name_value.put("value", person.get("person_name"));
                    blank_list.add(1, person_name_value);
                    HashMap<String, String> person_no = new HashMap<String, String>();
                    person_no.put("blank_type", "DESC");
                    person_no.put("blank_depict", "person_no");
                    blank_list.add(2, person_no);
                    HashMap<String, Object> person_value = new HashMap<String, Object>();
                    person_value.put("blank_type", "hidden");
                    person_value.put("blank_depict", "person_no");
                    person_value.put("value", person.get("person_no"));
                    blank_list.add(3, person_name);
                } else {
                    HashMap<String, String> person_name = new HashMap<String, String>();
                    person_name.put("blank_type", "DESC");
                    person_name.put("blank_depict", person_type + ":" + person.get("person_name"));
                    blank_list.add(0, person_name);
                }
                aResult.put(StrUtil.trimStr(aNode.get("type")), blank_list);
                break;
            }
            case "radio": 
            case "checkbox": {
                if (!this.answerManList.contains(person.get("person_no"))) {
                    Map answerMan = CollectionUtil.cloneMap(person);
                    answerMan.put("person_name", allAnswerMan_type + StrUtil.trimStr((Object)person.get("person_name")));
                    this.allAnswerMan.add(answerMan);
                    this.answerManList.add(StrUtil.trimStr((Object)person.get("person_no")));
                }
                List baseQuestionOption = (List)aNode.get("question_option");
                List question_option = CollectionUtil.cloneList((List)baseQuestionOption);
                List node_setting = (List)aNode.get("node_setting");
                for (Map aOption : question_option) {
                    for (Map aSetting : node_setting) {
                        ArrayList<String> node_no_list;
                        if (!aSetting.get("option_no").equals(aOption.get("option_no"))) continue;
                        HashMap<String, ArrayList<String>> chuFaJiHe = (HashMap<String, ArrayList<String>>)aOption.get(aSetting.get("relate_tab"));
                        if (chuFaJiHe == null) {
                            chuFaJiHe = new HashMap<String, ArrayList<String>>();
                            aOption.put(StrUtil.trimStr(aSetting.get("relate_tab")), chuFaJiHe);
                        }
                        if ((node_no_list = (ArrayList<String>)chuFaJiHe.get(aSetting.get("show_hide"))) == null) {
                            node_no_list = new ArrayList<String>();
                            chuFaJiHe.put(StrUtil.trimStr(aSetting.get("show_hide")), node_no_list);
                        }
                        node_no_list.add(StrUtil.trimStr(aSetting.get("relate_fk")));
                    }
                }
                aResult.put(StrUtil.trimStr(aNode.get("type")), question_option);
                break;
            }
            case "answer": {
                aResult.put(StrUtil.trimStr(aNode.get("type")), aNode.get("depict"));
                break;
            }
        }
    }
}

