/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.disclose.answer.service.imp;

import com.newtouch.cache.CacheManager;
import com.newtouch.dao.DBHandleCreator;
import com.newtouch.dao.DBHandleable;
import com.newtouch.dao.IDao;
import com.newtouch.dao.QuerySqlable;
import com.newtouch.dao.callback.FieldCallback;
import com.newtouch.dao.callback.RowCallback;
import com.newtouch.dao.util.callback.RmBaseClm;
import com.newtouch.disclose.answer.service.IPaper;
import com.newtouch.util.string.StrUtil;
import com.newtouch.web.BaseService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class PaperImp
extends BaseService
implements IPaper {
    @Autowired
    @Qualifier(value="Tr_Exam_PaperDao")
    private IDao paperDao;
    @Autowired
    @Qualifier(value="Tr_Exam_Paper_QuestionDao")
    private IDao paperQuestionDao;
    @Autowired
    @Qualifier(value="Tr_Exam_Paper_GroupDao")
    private IDao paperGroupDao;
    @Autowired
    @Qualifier(value="Tr_Exam_Paper_Qu_ShowDao")
    private IDao paperShowDao;
    @Autowired
    @Qualifier(value="Tr_Exam_Paper_Qu_SettingDao")
    private IDao paperSettingDao;
    @Autowired
    @Qualifier(value="Tr_QuestionsDao")
    private IDao questionDao;
    @Autowired
    @Qualifier(value="Tr_Question_OptionDao")
    private IDao questionOptDao;
    @Autowired
    @Qualifier(value="Tr_Question_BlanksDao")
    private IDao questionBlankDao;
    @Autowired
    @Qualifier(value="Tr_Question_Blank_OptionDao")
    private IDao questionBlankOptDao;

    @Override
    public List<Map<String, Object>> initPaper(String exam_paper_no) {
        List paperTree = (List)CacheManager.get((String)("PaperImp." + exam_paper_no));
        if (paperTree != null && !paperTree.isEmpty()) {
            return paperTree;
        }
        this.paperQuestionDao.addEq("exam_paper_no", (Object)exam_paper_no);
        this.paperQuestionDao.setOrder("node_seq, display_order");
        this.paperQuestionDao.addRowCallback((RowCallback)new RmBaseClm());
        List paperQuestionList = this.paperQuestionDao.queryList(false);
        HashMap<String, Integer> nodeIndex = new HashMap<String, Integer>();
        final HashMap settingNodeList = new HashMap();
        int i = 0;
        for (Map aNode : paperQuestionList) {
            nodeIndex.put(StrUtil.trimStr(aNode.get("node_no")), i);
            this.initGroup(aNode);
            this.initQuestion(aNode);
            this.paperSettingDao.addEq("node_no", aNode.get("node_no"));
            this.paperSettingDao.addRowCallback((RowCallback)new RowCallback<Map<String, Object>>(){

                public void callback(Map<String, Object> row, List<? extends Map<String, Object>> data, int index) {
                    if (!"tr_exam_paper_question".equals(row.get("relate_tab")) || settingNodeList.keySet().contains(row.get("relate_fk"))) {
                        return;
                    }
                    settingNodeList.put(StrUtil.trimStr((Object)row.get("relate_fk")), StrUtil.trimStr((Object)row.get("is_repeat")));
                }
            });
            this.paperSettingDao.addRowCallback((RowCallback)new RmBaseClm());
            aNode.put("node_setting", this.paperSettingDao.queryList(false));
            this.paperShowDao.addEq("node_no", aNode.get("node_no"));
            this.paperShowDao.addRowCallback((RowCallback)new RmBaseClm());
            aNode.put("node_show", this.paperShowDao.queryList(false));
            ++i;
        }
        for (String node_no : settingNodeList.keySet()) {
            Map aNode = (Map)paperQuestionList.get((Integer)nodeIndex.get(node_no));
            if (aNode == null) continue;
            aNode.put("is_repeat", settingNodeList.get(node_no));
            aNode.put("setting_flag", true);
        }
        CacheManager.put((String)("PaperImp." + exam_paper_no), (Object)paperQuestionList);
        return paperQuestionList;
    }

    private void initGroup(Map<String, Object> aNode) {
        if (!"tr_exam_paper_group".equals(aNode.get("relate_tab"))) {
            return;
        }
        this.paperGroupDao.addEq("group_no", aNode.get("relate_fk"));
        this.paperGroupDao.addRowCallback((RowCallback)new RmBaseClm());
        Map group = this.paperGroupDao.query();
        aNode.put("depict", group.get("group_depict"));
        aNode.put("type", group.get("group_type"));
        aNode.put("serno_key", aNode.get("relate_tab") + "." + aNode.get("relate_field") + "." + aNode.get("depict"));
    }

    private void initQuestion(Map<String, Object> aNode) {
        if (!"tr_questions".equals(aNode.get("relate_tab"))) {
            return;
        }
        aNode.put("serno_key", aNode.get("relate_tab") + "." + aNode.get("relate_field") + "." + aNode.get("relate_fk"));
        this.questionDao.addEq("question_no", aNode.get("relate_fk"));
        this.questionDao.addRowCallback((RowCallback)new RmBaseClm());
        Map question = this.questionDao.query();
        aNode.put("depict", question.get("question_depict"));
        aNode.put("type", question.get("question_type"));
        aNode.put("question_no", question.get("question_no"));
        aNode.put("show_type", question.get("show_type"));
        aNode.put("up_question", question.get("up_question"));
        aNode.put("question_seq", question.get("question_seq"));
        this.questionOptDao.addEq("question_no", aNode.get("relate_fk"));
        this.questionOptDao.setOrder("display_order");
        this.questionOptDao.addRowCallback((RowCallback)new RmBaseClm());
        this.questionOptDao.addFieldCallback("option_no", (FieldCallback)new FieldCallback<Map<String, Object>>(){

            public void callback(String field, Object value, Map<String, Object> row) {
                row.put("answer_code", value);
            }
        });
        List optionList = this.questionOptDao.queryList(false);
        aNode.put("question_option", optionList);
        this.questionBlankDao.addEq("question_no", aNode.get("relate_fk"));
        this.questionBlankDao.setOrder("display_order");
        this.questionBlankDao.addRowCallback((RowCallback)new RmBaseClm());
        this.questionBlankDao.addFieldCallback("blank_no", (FieldCallback)new FieldCallback<Map<String, Object>>(){

            public void callback(String field, Object value, Map<String, Object> row) {
                row.put("answer_code", value);
            }
        });
        final DBHandleable db = this.dbHandle();
        this.questionBlankDao.addRowCallback((RowCallback)new RowCallback<Map<String, Object>>(){

            public void callback(Map<String, Object> row, List<? extends Map<String, Object>> data, int index) {
                Object blank_class = row.get("blank_class");
                if (!"radio".equals(blank_class) && !"checkbox".equals(blank_class)) {
                    return;
                }
                String sql = "SELECT se.* FROM tr_question_blank_option tqbo, sys_enum se WHERE tqbo.enum_no = se.enum_no      AND tqbo.blank_no = ? ";
                QuerySqlable query = DBHandleCreator.getInstance().getQuerySql4Calc();
                query.setSql(sql);
                query.add(row.get("blank_no"));
                query.setOrderBy("se.enum_order");
                query.addRowCallback((RowCallback)new RmBaseClm());
                row.put("blank_option", db.queryList(query));
            }
        });
        List blank_list = this.questionBlankDao.queryList(false);
        aNode.put("blank_list", blank_list);
    }
}

