/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.disclose.answer.service.imp;

import com.newtouch.cache.CacheManager;
import com.newtouch.dao.DBHandleCreator;
import com.newtouch.dao.IDao;
import com.newtouch.dao.QuerySqlable;
import com.newtouch.dao.UpdateSqlable;
import com.newtouch.dao.callback.RowCallback;
import com.newtouch.disclose.answer.pojo.Question;
import com.newtouch.disclose.answer.service.IPaper;
import com.newtouch.disclose.answer.service.IPaperGenerateService;
import com.newtouch.disclose.answer.util.PaperMerge;
import com.newtouch.log.Ulog;
import com.newtouch.msg.Return;
import com.newtouch.msg.ReturnMsg;
import com.newtouch.util.date.DateUtil;
import com.newtouch.util.json.JsonUtilOld;
import com.newtouch.util.string.StrUtil;
import com.newtouch.util.uuid.UniqueSeq;
import com.newtouch.web.BaseService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class PaperGenerateServiceImp
extends BaseService
implements IPaperGenerateService {
    @Autowired
    @Qualifier(value="Tr_Exam_PaperDao")
    private IDao paperDao;
    @Autowired
    @Qualifier(value="Tr_Exam_Paper_AnswerDao")
    private IDao answerDao;
    @Autowired
    @Qualifier(value="Tr_Exam_Paper_Ans_ResultDao")
    private IDao ansResultDao;
    @Autowired
    @Qualifier(value="Tr_Insure_ExampaperDao")
    private IDao riskPaperDao;
    @Autowired
    private IPaper paper;

    @Override
    public ReturnMsg generatePaper(Map<String, Object> param) {
        CacheManager.put((String)("people_" + param.get("policy_uuid")), param);
        Map tbr = (Map)param.get("tbr");
        List bbrList = (List)param.get("bbr");
        PaperMerge paperMerge = new PaperMerge();
        List riskList = null;
        ArrayList<String> riskPaper = new ArrayList<String>();
        for (Map bbr : bbrList) {
            riskList = (List)bbr.get("risk");
            riskPaper.clear();
            riskPaper.add("rOnGjaWm");
            this.initRiskPaper(riskList, riskPaper);
            for (String exam_paper_no : riskPaper) {
                List<Map<String, Object>> paperRst = this.paper.initPaper(exam_paper_no);
                for (Map<String, Object> map : paperRst) {
                    paperMerge.mergePaper(map, tbr, "TBR");
                    paperMerge.mergePaper(map, bbr, "BBR");
                }
            }
        }
        String sql = "SELECT tepa.answer_person,tepar.*     FROM tr_exam_paper_answer tepa, tr_exam_paper_ans_result tepar    WHERE tepa.answer_no = tepar.answer_no AND tepa.policy_uuid = ?";
        final ConcurrentSkipListMap<String, String> paperAnswerResult = new ConcurrentSkipListMap<String, String>();
        QuerySqlable query = DBHandleCreator.getInstance().getQuerySql4Calc();
        query.setSql(sql);
        query.add(param.get("policy_uuid"));
        query.addRowCallback((RowCallback)new RowCallback<Map<String, Object>>(){

            public void callback(Map<String, Object> row, List<? extends Map<String, Object>> data, int index) {
                String key = row.get("answer_person") + "_" + row.get("exam_paper_no") + "_" + row.get("node_no") + "_" + row.get("question_no") + "_" + row.get("answer_code") + "_" + row.get("display_order");
                if (paperAnswerResult.keySet().contains(key)) {
                    Ulog.debug((String)("[" + key + "]\u91cd\u590d\u4e86"));
                }
                paperAnswerResult.put(key, StrUtil.trimStr((Object)row.get("answer_content")));
            }
        });
        this.dbHandle().queryList(query);
        Return msg = new Return();
        List<Question<String, Object>> paper = paperMerge.getPaper();
        for (Question question : paper) {
            paperMerge.initAnswer(question, tbr, "TBR");
            for (Map bbr : bbrList) {
                paperMerge.initAnswer(question, bbr, "BBR");
                bbr.remove("risk");
            }
            question.remove("node_setting");
            question.remove("node_show");
            question.remove("blank_list");
            question.remove("question_option");
            if (paperAnswerResult.isEmpty()) continue;
            paperMerge.initAnswerResult(question, paperAnswerResult);
        }
        msg.getDataTable().put("paper", paper);
        msg.getDataTable().put("answer", paperMerge.getAllAnswerMan());
        Ulog.debug((String)JsonUtilOld.formatJSONObject(msg.getDataTable()));
        return msg.msg();
    }

    private void initRiskPaper(List<Map<String, Object>> riskList, List<String> riskPaper) {
        if (riskList == null || riskList.isEmpty()) {
            return;
        }
        for (Map<String, Object> aRisk : riskList) {
            this.riskPaperDao.addIn("policy_id", (Object)StrUtil.trimStr((Object)aRisk.get("insurence_code")));
        }
        this.riskPaperDao.addBetween((Object)DateUtil.sysDate(), "start_date", "end_date");
        for (Map<String, Object> aPaper : this.riskPaperDao.queryList(false)) {
            if (riskPaper.contains(aPaper.get("exam_paper_no"))) continue;
            riskPaper.add(StrUtil.trimStr((Object)aPaper.get("exam_paper_no")));
        }
    }

    @Override
    public ReturnMsg savePaper(Map<String, Object> param) {
        this.answerDao.addEq("policy_uuid", param.get("policy_uuid"));
        List li = this.answerDao.queryList();
        if (li.size() > 0) {
            String delsql = " delete result from tr_exam_paper_ans_result result , tr_exam_paper_answer answer where result.answer_no = answer.answer_no  and answer.policy_uuid=? ";
            UpdateSqlable update = DBHandleCreator.getInstance().getUpdateSql();
            update.add(param.get("policy_uuid"));
            update.setSql(delsql);
            this.dbHandle().update(update);
            this.answerDao.addEq("policy_uuid", param.get("policy_uuid"));
            this.answerDao.delete();
        }
        HashMap<String, String> answer_person = new HashMap<String, String>();
        List answer_result = (List)param.get("answer_result");
        for (Map aResult : answer_result) {
            if (StrUtil.isNull(answer_person.get(aResult.get("answer_person")))) {
                answer_person.put(StrUtil.trimStr(aResult.get("answer_person")), UniqueSeq.shortUUID());
            }
            aResult.put("answer_no", answer_person.get(aResult.get("answer_person")));
            if (StrUtil.isNull(aResult.get("is_repeat"))) {
                aResult.put("is_repeat", "N");
            }
            this.ansResultDao.insert(aResult);
        }
        HashMap<String, Object> answer = new HashMap<String, Object>();
        for (String key : answer_person.keySet()) {
            answer.put("answer_person", key);
            for (Map polMap : li) {
                if (!polMap.get("answer_person").equals(key)) continue;
                answer.put("policy_uuid_1", polMap.get("policy_uuid_1"));
                answer.put("party_uuid", polMap.get("party_uuid"));
            }
            answer.put("answer_no", answer_person.get(key));
            answer.put("policy_uuid", param.get("policy_uuid"));
            answer.put("answer_date", DateUtil.sysDate());
            this.answerDao.insert(answer);
        }
        return new Return().msg();
    }
}

