/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.design.util;

import com.newtouch.context.ThreadLocalContext;
import com.newtouch.dao.DBHandleCreator;
import com.newtouch.dao.DBHandleable;
import com.newtouch.dao.QuerySqlable;
import com.newtouch.log.Ulog;
import com.newtouch.msg.Return;
import com.newtouch.msg.pojo.Message;
import com.newtouch.util.date.DateUtil;
import com.newtouch.util.string.StrUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelRead {
    private Workbook workBook = null;
    private Map<String, List<Object>> excelMap = new LinkedHashMap<String, List<Object>>();
    private boolean ignoreBlankRow = false;
    private Sheet sheet = null;
    private Row oneRow = null;
    private int headNum = 1;
    private Return returnmsg = new Return();

    public void initExcel(String filePath) {
        try {
            if (filePath.endsWith(".xls")) {
                POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(filePath));
                this.workBook = new HSSFWorkbook(fs);
            } else {
                this.workBook = new XSSFWorkbook(filePath);
            }
        }
        catch (IOException e) {
            Ulog.error((Throwable)e);
        }
    }

    public void initExcel(InputStream in, String fileName) {
        try {
            if (fileName.endsWith(".xls")) {
                POIFSFileSystem fs = new POIFSFileSystem(in);
                this.workBook = new HSSFWorkbook(fs);
            } else {
                this.workBook = new XSSFWorkbook(in);
            }
        }
        catch (IOException e) {
            Ulog.error((Throwable)e);
        }
    }

    public Map<String, List<Object>> initSheet(Object[] objects, List<String[]> titles) {
        System.out.println("\u5171[" + this.workBook.getNumberOfSheets() + "]\u4e2aSheet");
        for (int i = 0; i < this.workBook.getNumberOfSheets(); ++i) {
            System.out.println("\u7b2c[" + (i + 1) + "]\u4e2aSheet");
            this.excelMap.put(this.workBook.getSheetName(i), this.initSheetData(i, titles.get(i), objects[i]));
        }
        return this.excelMap;
    }

    public Map<String, List<Object>> initSheet(Object object, String[] titles, String[] chTitle) {
        System.out.println("\u5171[" + this.workBook.getNumberOfSheets() + "]\u4e2aSheet");
        for (int i = 0; i < this.workBook.getNumberOfSheets(); ++i) {
            System.out.println("\u7b2c[" + (i + 1) + "]\u4e2aSheet");
            this.excelMap.put(this.workBook.getSheetName(i), this.initSheetData(i, titles, chTitle));
        }
        return this.excelMap;
    }

    public Map<String, List<Object>> initSheet(int sheetNum, String[] titles, String[] chTitle) {
        System.out.println("\u5171[" + this.workBook.getNumberOfSheets() + "]\u4e2aSheet");
        if (sheetNum - 1 < this.workBook.getNumberOfSheets()) {
            System.out.println("\u7b2c[" + sheetNum + "]\u4e2aSheet");
            this.excelMap.put(this.workBook.getSheetName(sheetNum - 1), this.initSheetData(sheetNum - 1, titles, chTitle));
        }
        return this.excelMap;
    }

    private List<Object> initSheetData(int sheetNum, String[] titles, Object obj) {
        ArrayList<Object> list = new ArrayList<Object>();
        this.sheet = this.workBook.getSheetAt(sheetNum);
        if (this.sheet == null) {
            return list;
        }
        int rows = this.sheet.getPhysicalNumberOfRows();
        if (rows <= 0) {
            return list;
        }
        int i = 0;
        int j = 0;
        while (i < rows) {
            if (i < this.headNum) {
                ++i;
                ++j;
                continue;
            }
            System.out.println("\u7b2c[" + (i + 1) + "]\u884c");
            this.oneRow = this.sheet.getRow(i == j ? i : j);
            while ((this.oneRow == null || StrUtil.isNull((Object)this.oneRow.getCell(0))) && this.ignoreBlankRow && j <= rows) {
                this.oneRow = this.sheet.getRow(++j);
            }
            ++i;
            ++j;
            if (this.oneRow == null) continue;
            try {
                Object aObject = Class.forName(obj.getClass().getName()).newInstance();
                if (!this.initRowData(this.oneRow, aObject, titles)) continue;
                list.add(aObject);
            }
            catch (Exception e) {
                Ulog.error((Throwable)e);
            }
        }
        return list;
    }

    private List<Object> initSheetData(int sheetNum, String[] titles, String[] chTitle) {
        ArrayList<Object> list = new ArrayList<Object>();
        this.sheet = this.workBook.getSheetAt(sheetNum);
        if (this.sheet == null) {
            return list;
        }
        int rows = this.sheet.getPhysicalNumberOfRows();
        if (rows <= 0) {
            return list;
        }
        int i = 0;
        int j = 0;
        while (i < rows) {
            if (i < this.headNum) {
                this.oneRow = this.sheet.getRow(i);
                for (int y = 0; y < chTitle.length; ++y) {
                    System.out.println("||" + chTitle[y] + "||" + this.oneRow.getCell(y) + "||" + chTitle[y].equals(this.oneRow.getCell(y).getStringCellValue()));
                    if (chTitle[y].equals(this.oneRow.getCell(y).getStringCellValue())) continue;
                    this.returnmsg.setFailMsg(new Message("\u5bfc\u5165\u6a21\u677f\u4e0d\u6b63\u786e\uff01"));
                    return list;
                }
                ++i;
                ++j;
                continue;
            }
            System.out.println("\u7b2c[" + (i + 1) + "]\u884c");
            this.oneRow = this.sheet.getRow(i == j ? i : j);
            while ((this.oneRow == null || StrUtil.isNull((Object)this.oneRow.getCell(0))) && this.ignoreBlankRow && j <= rows) {
                this.oneRow = this.sheet.getRow(++j);
            }
            ++i;
            ++j;
            if (this.oneRow == null) continue;
            try {
                HashMap<String, Object> aObject = new HashMap<String, Object>();
                if (!this.initRowData(this.oneRow, aObject, titles, i + 1)) continue;
                list.add(aObject);
            }
            catch (Exception e) {
                Ulog.error((Throwable)e);
            }
        }
        if (list.size() == 0) {
            this.returnmsg.setFailMsg(new Message("\u8bf7\u6dfb\u52a0\u5b8c\u6570\u636e\u518d\u8fdb\u884c\u5bfc\u5165\uff01"));
        }
        return list;
    }

    private boolean initRowData(Row aRow, Object aObject, String[] titles) {
        Cell cell = null;
        int cells = titles.length;
        Object obj = null;
        for (int i = 0; i < cells; ++i) {
            System.out.println("\u7b2c[" + (i + 1) + "]\u4e2a\u5355\u5143\u683c");
            cell = aRow.getCell(i);
            if (cell == null) continue;
            obj = this.initCellData(cell);
            if (!this.ignoreBlankRow || i != 0 || !"".equals(obj)) continue;
            return false;
        }
        return true;
    }

    private boolean initRowData(Row aRow, Map<String, Object> aObject, String[] titles, int rownum) {
        Cell cell = null;
        int cells = titles.length;
        Object obj = null;
        for (int i = 0; i < cells; ++i) {
            System.out.println("\u7b2c[" + (i + 1) + "]\u4e2a\u5355\u5143\u683c");
            cell = aRow.getCell(i);
            if (cell == null || (obj = this.initCellData(cell)) == "") continue;
            if (this.ignoreBlankRow && i == 0 && "".equals(obj)) {
                return false;
            }
            if (titles[i].endsWith("date")) {
                if (!DateUtil.isValidDate((String)obj.toString())) {
                    this.returnmsg.setFailMsg(new Message("\u5bfc\u5165\u5931\u8d25\uff01\u7b2c[" + (rownum - 1) + "]\u884c\u7b2c[" + (i + 1) + "]\u4e2a\u5355\u5143\u683c\u65e5\u671f\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01"));
                    continue;
                }
                aObject.put(titles[i], DateUtil.string2Date((Object)StrUtil.trimStr((Object)obj)));
                continue;
            }
            if (titles[i].indexOf("#") != -1) {
                String[] arr = titles[i].split("#");
                if (arr.length != 2) continue;
                String enumCode = this.getEnumCodeByName(arr[1], (String)obj);
                aObject.put(arr[0], enumCode);
                continue;
            }
            aObject.put(titles[i], obj);
        }
        return true;
    }

    private String getEnumCodeByName(String enumParent, String enumName) {
        String deptType = ThreadLocalContext.get().getUser().getDept_type();
        QuerySqlable query = DBHandleCreator.getInstance().getQuerySql();
        String s = "select t.enum_code as code from T_ENUM t where t.enum_parentid=? and t.enum_name=? and t.dept_type=? order by t.enum_id";
        query.setSql(s);
        query.setPaginate(false);
        query.add((Object)enumParent);
        query.add((Object)enumName);
        query.add((Object)deptType);
        DBHandleable dbHandle = DBHandleCreator.getInstance().getDBHandle();
        List result = dbHandle.queryList(query);
        if (result.size() > 0) {
            return (String)((Map)result.get(0)).get("code");
        }
        query = DBHandleCreator.getInstance().getQuerySql();
        query.setSql(s);
        query.setPaginate(false);
        query.add((Object)enumParent);
        query.add((Object)enumName);
        query.add((Object)"00");
        result = dbHandle.queryList(query);
        if (result.isEmpty()) {
            return "";
        }
        return (String)((Map)result.get(0)).get("code");
    }

    private Object initCellData(Cell cell) {
        Object value = "";
        String formula = "";
        block0 : switch (cell.getCellType()) {
            case 1: {
                value = StrUtil.trimStr((Object)cell.getRichStringCellValue());
                System.out.println("\u6570\u636e\u7c7b\u578b\u4e3aString,\u503c\u4e3a[" + value + "]");
                break;
            }
            case 0: {
                double d = 0.0;
                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    value = new Date(HSSFDateUtil.getJavaDate((double)cell.getNumericCellValue()).getTime());
                    System.out.println("\u6570\u636e\u7c7b\u578b\u4e3aDate,\u503c\u4e3a[" + value + "]");
                    break;
                }
                d = cell.getNumericCellValue();
                value = d - (double)((int)d) < Double.MIN_VALUE ? Integer.toString((int)d) : Double.toString(d);
                System.out.println("\u6570\u636e\u7c7b\u578b\u4e3aDouble,\u503c\u4e3a[" + value + "]");
                break;
            }
            case 2: {
                formula = cell.getCellFormula();
                switch (cell.getCachedFormulaResultType()) {
                    case 4: {
                        value = cell.getBooleanCellValue();
                        System.out.println("\u6570\u636e\u7c7b\u578b\u4e3a\u516c\u5f0f,\u516c\u5f0f\u4e3a[" + formula + "],\u53d6\u503c\u4e3aBoolean,\u503c\u4e3a[" + value + "]");
                        break block0;
                    }
                    case 0: {
                        if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                            value = HSSFDateUtil.getJavaDate((double)cell.getNumericCellValue());
                            System.out.println("\u6570\u636e\u7c7b\u578b\u4e3a\u516c\u5f0f,\u516c\u5f0f\u4e3a[" + formula + "],\u53d6\u503c\u4e3aDate,\u503c\u4e3a[" + value + "]");
                            break block0;
                        }
                        value = cell.getNumericCellValue();
                        System.out.println("\u6570\u636e\u7c7b\u578b\u4e3a\u516c\u5f0f,\u516c\u5f0f\u4e3a[" + formula + "],\u53d6\u503c\u4e3aDouble,\u503c\u4e3a[" + value + "]");
                        break block0;
                    }
                    case 1: {
                        value = StrUtil.trimStr((Object)cell.getRichStringCellValue());
                        System.out.println("\u6570\u636e\u7c7b\u578b\u4e3a\u516c\u5f0f,\u516c\u5f0f\u4e3a[" + formula + "],\u53d6\u503c\u4e3aString,\u503c\u4e3a[" + value + "]");
                        break block0;
                    }
                }
                value = StrUtil.trimStr((Object)cell.getRichStringCellValue());
                System.out.println("\u6570\u636e\u7c7b\u578b\u4e3a\u516c\u5f0f,\u516c\u5f0f\u4e3a[" + formula + "],\u8f6c\u4e3a\u53d6\u503c\u4e3aString,\u503c\u4e3a[" + value + "]");
                break;
            }
            case 4: {
                value = cell.getBooleanCellValue();
                System.out.println("\u6570\u636e\u7c7b\u578b\u4e3aBoolean,\u503c\u4e3a[" + value + "]");
                break;
            }
            case 3: {
                value = "";
                System.out.println("\u5355\u5143\u683c\u503c\u4e3a\u7a7a");
                break;
            }
            case 5: {
                value = "";
                System.out.println("\u5355\u5143\u683c\u53d6\u503c\u51fa\u73b0\u9519\u8bef");
                break;
            }
            default: {
                value = StrUtil.trimStr((Object)cell.getRichStringCellValue());
                System.out.println("\u9ed8\u8ba4\u6309String\u7c7b\u578b\u5904\u7406,\u503c\u4e3a[" + value + "]");
            }
        }
        return value;
    }

    public Map<String, List<Object>> getExcelData() {
        return this.excelMap;
    }

    public List<Object> getExcelData(String sheetName) {
        return this.excelMap.get(sheetName);
    }

    public boolean isIgnoreBlankRow() {
        return this.ignoreBlankRow;
    }

    public void setIgnoreBlankRow(boolean ignoreBlankRow) {
        this.ignoreBlankRow = ignoreBlankRow;
    }

    public static void main(String[] args) throws Exception {
        ExcelRead excel = new ExcelRead();
        excel.setIgnoreBlankRow(true);
        excel.initExcel("C:/Users/lenovo/Desktop/test.xls");
        String[] titles = new String[]{"a", "b", "c", "d", "e"};
    }

    public int getHeadNum() {
        return this.headNum;
    }

    public void setHeadNum(int headNum) {
        this.headNum = headNum;
    }

    public Return getReturnmsg() {
        return this.returnmsg;
    }

    public void setReturnmsg(Return returnmsg) {
        this.returnmsg = returnmsg;
    }
}

