/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.design.tree.service.imp;

import cn.com.chinalife.model.Dsn_Attribute;
import cn.com.chinalife.model.Dsn_Attribute_Option;
import cn.com.chinalife.model.Dsn_Biz_Attribute;
import cn.com.chinalife.model.Dsn_Biz_Attribute_Option;
import cn.com.chinalife.model.Dsn_Structure;
import cn.com.chinalife.model.Sip_Product_Risks;
import cn.com.chinalife.model.Sip_Risk_Relation;
import cn.com.chinalife.model.Sys_Enum;
import cn.com.chinalife.model.Sys_Tree_Menu;
import com.newtouch.dao.DBHandleCreator;
import com.newtouch.dao.IDao;
import com.newtouch.dao.QuerySqlable;
import com.newtouch.dao.UpdateSqlable;
import com.newtouch.design.data.service.StructureService;
import com.newtouch.design.product.service.IProductConfigService;
import com.newtouch.design.tree.service.IPublicTreeService;
import com.newtouch.design.util.StructureConstant;
import com.newtouch.log.Ulog;
import com.newtouch.msg.Return;
import com.newtouch.msg.ReturnMsg;
import com.newtouch.repository.AbsModel;
import com.newtouch.repository.AbsModelRepository;
import com.newtouch.repository.ModelField;
import com.newtouch.util.json.JsonUtilOld;
import com.newtouch.util.string.StrUtil;
import com.newtouch.util.uuid.UniqueSeq;
import com.newtouch.web.BaseService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class PublicTreeServiceImp
extends BaseService
implements IPublicTreeService {
    @Autowired
    @Qualifier(value="Sys_Tree_MenuDao")
    private IDao menuConfig;
    @Autowired
    @Qualifier(value="Dsn_StructureDao")
    private IDao structDao;
    @Autowired
    private AbsModelRepository dao;
    @Autowired
    private IProductConfigService productConfigService;
    @Autowired
    private StructureService nodeService;
    @Autowired
    private StructureService structureService;
    private List<String> FOLDER_NODETYPE_LIST = new ArrayList<String>();

    PublicTreeServiceImp() {
        this.FOLDER_NODETYPE_LIST.add("main_risks");
        this.FOLDER_NODETYPE_LIST.add("prd_detail");
        this.FOLDER_NODETYPE_LIST.add("n_risk");
        this.FOLDER_NODETYPE_LIST.add("accy_risks");
        this.FOLDER_NODETYPE_LIST.add("n_main_exempt");
        this.FOLDER_NODETYPE_LIST.add("sub_risks");
        this.FOLDER_NODETYPE_LIST.add("n_prd_group");
    }

    @Override
    public ReturnMsg queryTree(String node_no) {
        Dsn_Structure dsn = new Dsn_Structure();
        dsn.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)node_no);
        dsn.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"prd");
        dsn.setOrderBy(new Sort.Order[]{Dsn_Structure.Field.display_order.asc()});
        List dsnList = this.dao.findAll((AbsModel)dsn);
        this.iterationTree(node_no, dsnList);
        Return msg = new Return();
        msg.setDataList(dsnList, Dsn_Structure.class);
        msg.getDataTable().put("prdUUID4NodeNo", node_no);
        return msg.msg();
    }

    @Override
    public List<Dsn_Structure> iterationTree(String node_no, List<Dsn_Structure> dsnList) {
        Dsn_Structure dsn = new Dsn_Structure();
        dsn.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)node_no);
        dsn.setOrderBy(new Sort.Order[]{Dsn_Structure.Field.display_order.asc()});
        List structureList = this.dao.findAll((AbsModel)dsn);
        if (structureList.isEmpty()) {
            return dsnList;
        }
        for (Dsn_Structure structure : structureList) {
            String nodeType = structure.getNodeType();
            if (this.FOLDER_NODETYPE_LIST.contains(nodeType)) {
                structure.putOtherProperty("isParent", "true");
            }
            if (!StructureConstant.RISK_ROOT_LIST.contains(nodeType)) {
                this.iterationTree(structure.getNodeNo(), dsnList);
            }
            dsnList.add(structure);
        }
        return dsnList;
    }

    @Override
    public ReturnMsg queryRootMenu(Dsn_Structure node, Sys_Tree_Menu menuInfo) {
        if (menuInfo == null || StrUtil.isNull((Object)menuInfo.getNodeType())) {
            return new Return().msg();
        }
        Sys_Tree_Menu menu = new Sys_Tree_Menu(true);
        menu.setMenuNo(menuInfo.getNodeType());
        menu = (Sys_Tree_Menu)this.dao.findOne((AbsModel)menu);
        Return ret = new Return();
        ret.getDataTable().put("node_name", menuInfo.getMenuName() + "\u540d\u79f0");
        ret.getDataTable().put("node_no", node.getNodeNo());
        ret.getDataTable().put("node_type", menuInfo.getNodeType());
        ret.getDataTable().put("up_node", node.getNodeNo());
        ret.getDataTable().put("node_seq", node.getNodeSeq());
        return ret.msg();
    }

    @Override
    public ReturnMsg queryTreeMenu(String node_type, String userNo) {
        if (StrUtil.isNull((Object)node_type)) {
            return new Return().msg();
        }
        Sys_Tree_Menu menu = new Sys_Tree_Menu(true);
        menu.setUpMenu(node_type);
        menu.setMenuType("menu");
        menu.setOrderBy(new Sort.Order[]{Sys_Tree_Menu.Field.display_order.asc()});
        Return ret = new Return();
        List<Sys_Tree_Menu> all = this.dao.findAll((AbsModel)menu, false);
        if ("admin".equals(userNo)) {
            all = this.dealTreeMenu(node_type, all);
        }
        if ("propose".equals(userNo)) {
            all = this.dealTreePrpMenu(node_type, all);
        }
        ret.setDataList(all, Sys_Tree_Menu.class);
        return ret.msg();
    }

    private List<Sys_Tree_Menu> dealTreeMenu(String node_type, List<Sys_Tree_Menu> all) {
        Iterator<Sys_Tree_Menu> iterator;
        if ("main_risks".equals(node_type) || "accy_risks".equals(node_type)) {
            iterator = all.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().getMenuNo().equals("add_main_rate")) continue;
                iterator.remove();
            }
        }
        if ("accy_risks".equals(node_type)) {
            iterator = all.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().getMenuNo().equals("add_accy_rate")) continue;
                iterator.remove();
            }
        }
        if (StructureConstant.PROPOSE_MENU.contains(node_type)) {
            return null;
        }
        return all;
    }

    private List<Sys_Tree_Menu> dealTreePrpMenu(String node_type, List<Sys_Tree_Menu> all) {
        ArrayList<Sys_Tree_Menu> newSys = new ArrayList<Sys_Tree_Menu>();
        if ("main_risks".equals(node_type) || "accy_risks".equals(node_type)) {
            for (Sys_Tree_Menu sys : all) {
                if (!sys.getMenuNo().equals("add_main_rate")) continue;
                newSys.add(sys);
                return newSys;
            }
        }
        if ("accy_risks".equals(node_type)) {
            for (Sys_Tree_Menu sys : all) {
                if (!sys.getMenuNo().equals("add_accy_rate")) continue;
                newSys.add(sys);
                return newSys;
            }
        }
        if (!StructureConstant.PROPOSE_MENU.contains(node_type) && !StructureConstant.PROPOSE_RULE.contains(node_type)) {
            return null;
        }
        return all;
    }

    @Override
    public ReturnMsg addTreeNode(Map<String, Object> param) {
        Return r = new Return();
        Dsn_Structure structure = new Dsn_Structure();
        String node_no = UniqueSeq.shortUUID();
        structure.setNodeNo(node_no);
        structure.setUpNode(StrUtil.trimStr((Object)param.get("node_no")));
        structure.setNodeType(StrUtil.trimStr((Object)param.get("node_type")));
        structure.setNodeSeq(StrUtil.trimStr((Object)param.get("node_seq")) + node_no + ".");
        structure.setNodeName(StrUtil.trimStr((Object)param.get("node_name")));
        int maxDisplayorder = this.nodeService.getMaxDisplayorder(structure.getUpNode());
        structure.setDisplayOrder(maxDisplayorder + 1);
        this.dao.save((AbsModel)structure);
        this.saveChildNode(structure);
        r.setDataTable(JsonUtilOld.objToMap((Object)structure));
        return r.msg();
    }

    private boolean judgeIsBenefit(String nodeNO) {
        Dsn_Structure dsn_structure4Query = new Dsn_Structure();
        dsn_structure4Query.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)nodeNO);
        Dsn_Structure dsn_structure4Result = (Dsn_Structure)this.dao.findOne((AbsModel)dsn_structure4Query);
        if (StrUtil.isNull((Object)dsn_structure4Result.getSerno())) {
            return false;
        }
        boolean flag = dsn_structure4Result.getNodeName().equals("\u5229\u76ca\u6f14\u793a");
        return flag;
    }

    private void saveChildNode(Dsn_Structure ds) {
        Return r = new Return();
        List<Dsn_Structure> nextNodeList = this.queryChildNode(ds.getNodeType(), ds.getNodeNo(), ds.getNodeSeq());
        if (!nextNodeList.isEmpty()) {
            this.dao.save(nextNodeList);
            for (Dsn_Structure dsNew : nextNodeList) {
                this.saveChildNode(dsNew);
            }
        }
    }

    private List<Dsn_Structure> queryChildNode(String node_type, String parentNodeNo, String parentNodeSeq) {
        if (StrUtil.isNull((Object)node_type)) {
            return new ArrayList<Dsn_Structure>();
        }
        Sys_Tree_Menu queryNode = new Sys_Tree_Menu();
        queryNode.where().addEq((ModelField)Sys_Tree_Menu.Field.up_menu, (Object)node_type);
        queryNode.where().addEq((ModelField)Sys_Tree_Menu.Field.menu_type, (Object)"node");
        queryNode.setOrderBy(new Sort.Order[]{Sys_Tree_Menu.Field.display_order.asc()});
        List<Dsn_Structure> nextNodeList = this.dao.findAll((AbsModel)queryNode, false).stream().map(node -> {
            Dsn_Structure nextNode = new Dsn_Structure();
            String nodeNo = UniqueSeq.shortUUID();
            nextNode.setNodeNo(nodeNo);
            nextNode.setNodeName(node.getMenuName());
            nextNode.setNodeType(node.getNodeType());
            nextNode.setUpNode(parentNodeNo);
            nextNode.setDisplayOrder(node.getDisplayOrder());
            nextNode.setNodeSeq(parentNodeSeq + nodeNo + ".");
            return nextNode;
        }).collect(Collectors.toList());
        return nextNodeList;
    }

    @Override
    public ReturnMsg queryNotIncludeNode(Map<String, Object> param) {
        return null;
    }

    @Override
    public ReturnMsg cancelRisks(Map<String, Object> param) {
        Return r = new Return();
        String node_seq = StrUtil.trimStr((Object)param.get("node_seq"));
        String serno = StrUtil.trimStr((Object)param.get("serno"));
        Dsn_Structure ds = new Dsn_Structure();
        ds.where().addLikeR((ModelField)Dsn_Structure.Field.node_seq, (Object)node_seq);
        ds.where().addNotEq((ModelField)Dsn_Structure.Field.serno, (Object)serno);
        List dsList = this.dao.findAll((AbsModel)ds);
        if (dsList.isEmpty()) {
            Dsn_Structure ds1 = new Dsn_Structure();
            ds1.where().addEq((ModelField)Dsn_Structure.Field.serno, (Object)serno);
            this.dao.delete((AbsModel)ds1);
            r = this.maintainRelation(param);
            if (!r.isSuccessflag()) {
                return r.msg();
            }
        } else {
            r.setFailMsg("\u8be5\u9669\u79cd\u662f\u65b0\u589e\u9669\u79cd,\u4e0d\u53ef\u53d6\u6d88\u9669\u79cd\u5173\u7cfb!");
        }
        return r.msg();
    }

    private Return maintainRelation(Map<String, Object> param) {
        Return msg = new Return();
        String nodeNo = StrUtil.trimStr((Object)param.get("node_no"));
        String parentNodeNo = StrUtil.trimStr((Object)param.get("up_node"));
        String nodeType = StrUtil.trimStr((Object)param.get("node_type"));
        Map<String, Object> nodeTypeMap = this.judgeHandleClass(nodeType, parentNodeNo, nodeNo);
        if (null == nodeTypeMap || nodeTypeMap.isEmpty()) {
            msg.setFailMsg("\u672a\u67e5\u8be2\u5230\u5f53\u524d\u8282\u70b9\u7c7b\u578b\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u67e5\u627e\u95ee\u9898\uff01");
            return msg;
        }
        String parentNodeType = StrUtil.trimStr((Object)nodeTypeMap.get("parent"));
        String currentNodeType = StrUtil.trimStr((Object)nodeTypeMap.get("current"));
        String mainRiskFlag = "main_risks";
        if (mainRiskFlag.equals(nodeType)) {
            int deleteFlag = this.maintainProductAndMainRisks(parentNodeType, currentNodeType);
            if (deleteFlag != 1) {
                msg.setFailMsg("\u7ef4\u62a4\u4ea7\u54c1\u548c\u9669\u79cd\u5173\u7cfb\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u6dfb\u52a0\u4e86\u5df2\u6709\u9669\u79cd\u540e\u662f\u5426\u70b9\u51fb\u4e86\"\u9669\u79cd\u8be6\u60c5\"\u4e2d\u7684\u4fdd\u5b58\u6309\u94ae\uff01");
            }
            return msg;
        }
        Map<String, Object> parentInfoMap = this.getParentInfo(parentNodeNo, parentNodeType);
        if (null != parentInfoMap && !parentInfoMap.isEmpty()) {
            String mainRisk = StrUtil.trimStr((Object)parentInfoMap.get("mainRisk"));
            String currentRiskUUID = this.getCurrentInfo(nodeNo, currentNodeType);
            if (!StrUtil.isNull((Object)currentRiskUUID)) {
                Sip_Risk_Relation sipRiskRelation4Delete = new Sip_Risk_Relation();
                sipRiskRelation4Delete.where().addEq((ModelField)Sip_Risk_Relation.Field.main_risk, (Object)mainRisk);
                sipRiskRelation4Delete.where().addEq((ModelField)Sip_Risk_Relation.Field.risk_uuid, (Object)currentRiskUUID);
                int deleteFlag = this.dao.delete((AbsModel)sipRiskRelation4Delete);
                if (deleteFlag != 1) {
                    msg.setFailMsg("\u7ef4\u62a4\u9669\u79cd\u5173\u7cfb\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u6dfb\u52a0\u4e86\u5df2\u6709\u9669\u79cd\u540e\u662f\u5426\u70b9\u51fb\u4e86\"\u9669\u79cd\u8be6\u60c5\"\u4e2d\u7684\u4fdd\u5b58\u6309\u94ae\uff01");
                    return msg;
                }
            }
        }
        return msg;
    }

    private int maintainProductAndMainRisks(String productUUID, String riskUUID) {
        Sip_Product_Risks sipProductRisks4Delete = new Sip_Product_Risks();
        sipProductRisks4Delete.where().addEq((ModelField)Sip_Product_Risks.Field.product_uuid, (Object)productUUID);
        sipProductRisks4Delete.where().addEq((ModelField)Sip_Product_Risks.Field.risk_uuid, (Object)riskUUID);
        return this.dao.delete((AbsModel)sipProductRisks4Delete);
    }

    private String getCurrentInfo(String nodeNo, String nodeType) {
        Dsn_Structure dsnStructure4Query = new Dsn_Structure();
        dsnStructure4Query.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)nodeNo);
        dsnStructure4Query.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)nodeType);
        Dsn_Structure dsnStructure4Result = (Dsn_Structure)this.dao.findOne((AbsModel)dsnStructure4Query);
        return null == dsnStructure4Result ? null : dsnStructure4Result.getNodeNo();
    }

    private Map<String, Object> getParentInfo(String parentNodeNo, String nodeType) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        Dsn_Structure dsnStructure = this.getNodeInfo(parentNodeNo);
        if (null != dsnStructure) {
            String[] nodeSeqArray = dsnStructure.getNodeSeq().split("\\.");
            String rootNodeNo = nodeSeqArray[0];
            String upNode = dsnStructure.getUpNode();
            Dsn_Structure dsnStructure4Query = new Dsn_Structure();
            dsnStructure4Query.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)upNode);
            dsnStructure4Query.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)nodeType);
            Dsn_Structure dsnStructure4Result = (Dsn_Structure)this.dao.findOne((AbsModel)dsnStructure4Query);
            if (null != dsnStructure4Result && !StrUtil.isNull((Object)dsnStructure4Result.getSerno())) {
                resultMap.put("mainRisk", dsnStructure4Result.getNodeNo());
                resultMap.put("rootNodeNo", rootNodeNo);
            }
        }
        return resultMap;
    }

    private Dsn_Structure getNodeInfo(String nodeNo) {
        Dsn_Structure dsnStructure4Query = new Dsn_Structure();
        dsnStructure4Query.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)nodeNo);
        Dsn_Structure dsnStructure4Result = (Dsn_Structure)this.dao.findOne((AbsModel)dsnStructure4Query);
        return null == dsnStructure4Result ? null : dsnStructure4Result;
    }

    private Map<String, Object> judgeHandleClass(String nodeType, String upNode, String nodeNo) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        switch (nodeType) {
            case "main_risks": {
                Dsn_Structure dsnStructure4Query = this.getNodeInfo(upNode);
                if (null == dsnStructure4Query || StrUtil.isNull((Object)dsnStructure4Query.getSerno())) break;
                String[] nodeSeqArray = dsnStructure4Query.getNodeSeq().split("\\.");
                resultMap.put("parent", nodeSeqArray[0]);
                String risk_uuid = this.getCurrentInfo(nodeNo, "n_risk_detail");
                resultMap.put("current", risk_uuid);
                break;
            }
            case "accy_risks": {
                resultMap.put("parent", "n_risk_detail");
                resultMap.put("current", "n_accy_detail");
                break;
            }
            case "n_main_exempt": 
            case "n_accy_exempt": {
                int mainRiskExemptLength;
                Dsn_Structure dsnStructure = this.getNodeInfo(upNode);
                if (null == dsnStructure || StrUtil.isNull((Object)dsnStructure.getSerno())) break;
                String[] nodeSeqArray = dsnStructure.getNodeSeq().split("\\.");
                if (nodeSeqArray.length == (mainRiskExemptLength = 4)) {
                    resultMap.put("parent", "n_risk_detail");
                    resultMap.put("current", "n_exempt_detail");
                    break;
                }
                resultMap.put("parent", "n_accy_detail");
                resultMap.put("current", "n_exempt_detail");
                break;
            }
            default: {
                Ulog.info((String)"\u6839\u636e\u8282\u70b9\u7684nodeType\u672a\u627e\u5230\u5339\u914d\u7684\u64cd\u4f5c\u7c7b\u578b\uff01");
            }
        }
        return resultMap;
    }

    @Override
    public ReturnMsg isAddRisks(Map<String, Object> param) {
        Return r = new Return();
        String node_no = StrUtil.trimStr((Object)param.get("node_no"));
        Dsn_Structure ds = new Dsn_Structure();
        ds.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)node_no);
        List<Dsn_Structure> dsList = this.dao.findAll((AbsModel)ds);
        if (dsList != null && dsList.size() > 1) {
            dsList = this.deleteCopyRisk(dsList);
        }
        if (dsList.size() == 1) {
            r.setSuccessMsg("\u8be5\u64cd\u4f5c\u5c06\u4f1a\u5220\u9664\u8be5\u9669\u79cd\u7684\u6240\u6709\u4fe1\u606f<br />\u786e\u8ba4\u5220\u9664\u5417?");
        } else {
            r.setSuccessMsg("\u8be5\u9669\u79cd\u5df2\u5728\u5176\u4ed6\u5730\u65b9\u88ab\u5f15\u7528,\u6267\u884c\u9669\u79cd\u5220\u9664\u53ea\u4f1a\u5220\u9664\u8be5\u9669\u79cd\u8282\u70b9,\u5e76\u4e0d\u5f71\u54cd\u5176\u4ed6\u4ea7\u54c1\u6216\u9669\u79cd,\u786e\u8ba4\u5220\u9664\u5417?");
        }
        r.setDataTable(param);
        return r.msg();
    }

    private List<Dsn_Structure> deleteCopyRisk(List<Dsn_Structure> dsnStructures) {
        ArrayList<Dsn_Structure> result = new ArrayList<Dsn_Structure>();
        dsnStructures.parallelStream().forEach(x -> {
            if (!StrUtil.isNull((Object)x.getUpNode())) {
                result.add((Dsn_Structure)((Object)x));
            } else {
                this.deleteFirstCopyData(x.getNodeNo(), x.getNodeType());
            }
        });
        return result;
    }

    private void deleteFirstCopyData(String node_no, String node_type) {
        if (!(StrUtil.isNull((Object)node_no) || StrUtil.isNull((Object)node_type) || node_type.equals("prd"))) {
            String sql = "DELETE from dsn_structure where node_no = ? \nand up_node= ? ";
            UpdateSqlable delete = DBHandleCreator.getInstance().getUpdateSql();
            delete.add((Object)node_no);
            delete.add((Object)"");
            delete.setSql(sql);
            this.dbHandle().update(delete);
        }
    }

    @Override
    public ReturnMsg delRisks(Map<String, Object> param) {
        Return r = new Return();
        String nodeSeq = this.getNewSeq(param);
        String nodeNo = StrUtil.trimStr((Object)param.get("node_no"));
        Dsn_Structure ds = new Dsn_Structure();
        ds.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)nodeNo);
        ds.where().addNotEq((ModelField)Dsn_Structure.Field.up_node, (Object)"root");
        List riskList = this.dao.findAll((AbsModel)ds);
        this.delFromRiskRelation(nodeSeq, StrUtil.trimStr((Object)param.get("node_type")));
        if (riskList.size() == 1) {
            ds.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)nodeNo);
            ds.where().addEq((ModelField)Dsn_Structure.Field.up_node, param.get("up_node"));
            List dsList = this.dao.findAll((AbsModel)ds);
            this.getRiskTree((Dsn_Structure)((Object)dsList.get(0)));
        } else {
            Dsn_Structure structure = new Dsn_Structure();
            structure.where().addEq((ModelField)Dsn_Structure.Field.up_node, param.get("up_node"));
            structure.where().addEq((ModelField)Dsn_Structure.Field.node_no, param.get("node_no"));
            this.dao.delete((AbsModel)structure);
        }
        return r.msg();
    }

    @Override
    public void delFromRiskRelation(String riskNodeSeq, String nodeType) {
        String[] nodeSeqs;
        if ("accy_risks".equals(nodeType) || "n_main_exempt".equals(nodeType)) {
            nodeSeqs = riskNodeSeq.split("\\.");
            String riskNodeNo = nodeSeqs[nodeSeqs.length - 1];
            Dsn_Structure mainNode = this.structureService.getOneDsnByNodeNo(nodeSeqs[2]);
            String mainUuid = this.structureService.getRiskuuidByNode(mainNode);
            String subUuid = this.structureService.getRiskuuidByNodeNo(riskNodeNo);
            Sip_Risk_Relation riskRelation = new Sip_Risk_Relation();
            riskRelation.where().addEq((ModelField)Sip_Risk_Relation.Field.main_risk, (Object)mainUuid);
            riskRelation.where().addEq((ModelField)Sip_Risk_Relation.Field.risk_uuid, (Object)subUuid);
            this.dao.delete((AbsModel)riskRelation);
        }
        if ("main_risks".equals(nodeType)) {
            nodeSeqs = riskNodeSeq.split("\\.");
            Dsn_Structure mainNode = this.structureService.getOneDsnByNodeNo(nodeSeqs[2]);
            String mainUuid = this.structureService.getRiskuuidByNode(mainNode);
            Sip_Product_Risks product2RiskRelation = new Sip_Product_Risks();
            product2RiskRelation.where().addEq((ModelField)Sip_Product_Risks.Field.product_uuid, (Object)nodeSeqs[0]);
            product2RiskRelation.where().addEq((ModelField)Sip_Product_Risks.Field.risk_uuid, (Object)mainUuid);
            this.dao.delete((AbsModel)product2RiskRelation);
        }
    }

    private String getRegex(String seqTag) {
        if (".".equals(seqTag)) {
            return "\\\\.";
        }
        return seqTag;
    }

    @Override
    public ReturnMsg doChooseChannel(Map<String, Object> param) {
        Return r = new Return();
        String node_no = StrUtil.trimStr((Object)param.get("node_no"));
        Dsn_Structure risk = new Dsn_Structure();
        risk.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)node_no);
        if ("accy_risks".equals(param.get("node_type"))) {
            risk.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"n_accy_detail");
        } else if ("n_main_exempt".equals(param.get("node_type"))) {
            risk.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"n_exempt_detail");
        } else {
            r.setFailMsg("\u8282\u70b9\u6709\u8bef,\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458!");
            return r.msg();
        }
        risk = (Dsn_Structure)this.dao.findOne((AbsModel)risk);
        String up_node = StrUtil.trimStr((Object)param.get("up_node"));
        String sql = "select node_no from dsn_structure where up_node = (select up_node from dsn_structure where node_no = ?) and node_type in (?,?)";
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        querySql.add((Object)up_node);
        querySql.add((Object)"n_risk_detail");
        querySql.add((Object)"n_accy_detail");
        querySql.setSql(sql);
        List dsn = this.dao.findAll(querySql);
        if (dsn == null || dsn.isEmpty()) {
            r.setFailMsg("\u8be5\u9669\u79cd\u65e0\u4e0a\u7ea7\u9669\u79cd,\u8bf7\u786e\u8ba4!");
            return r.msg();
        }
        String mainUuid = StrUtil.trimStr(((Map)dsn.get(0)).get("node_no"));
        Sys_Enum sysEnum = new Sys_Enum();
        sysEnum.where().addEq((ModelField)Sys_Enum.Field.up_enum, (Object)"channel_type");
        List enumList = this.dao.findAll((AbsModel)sysEnum);
        boolean flag = false;
        for (Sys_Enum e : enumList) {
            if (StrUtil.isNull((Object)param.get(e.getEnumNo()))) continue;
            flag = true;
            r.setSuccessMsg("\u6e20\u9053:" + e.getEnumName() + " \u5173\u8054\u6210\u529f!");
        }
        if (!flag) {
            r.setFailMsg("\u8bf7\u9009\u62e9\u6e20\u9053!");
        }
        return r.msg();
    }

    @Override
    public ReturnMsg doChooseRequired(Map<String, Object> param) {
        String isRequired = StrUtil.trimStr((Object)param.get("is_required"));
        String node_no = StrUtil.trimStr((Object)param.get("node_no"));
        String up_node = StrUtil.trimStr((Object)param.get("up_node"));
        Dsn_Structure risk = new Dsn_Structure();
        risk.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)node_no);
        risk.where().addIn((ModelField)Dsn_Structure.Field.node_type, new String[]{"n_accy_detail", "n_exempt_detail"});
        risk = (Dsn_Structure)this.dao.findOne((AbsModel)risk);
        String sql = "select node_no from dsn_structure where up_node = (select up_node from dsn_structure where node_no = ?) and node_type in (?,?)";
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        querySql.add((Object)up_node);
        querySql.add((Object)"n_risk_detail");
        querySql.add((Object)"n_accy_detail");
        querySql.setSql(sql);
        Map main = (Map)this.dao.findAll(querySql).get(0);
        Sip_Risk_Relation relation = new Sip_Risk_Relation();
        relation.setMainRisk(StrUtil.trimStr(main.get("node_no")));
        relation.setRiskUuid(risk.getNodeNo());
        relation.setIsRequired(isRequired);
        relation.setRelationType("n_accy_detail".equals(risk.getNodeType()) ? "ADDED" : "EXEMPT");
        this.dao.save((AbsModel)relation);
        return new Return().msg();
    }

    private String getNewSeq(Map<String, Object> param) {
        String nodeSeq = StrUtil.trimStr((Object)param.get("node_seq"));
        String nodeNo = StrUtil.trimStr((Object)param.get("node_no"));
        String upNode = StrUtil.trimStr((Object)param.get("up_node"));
        String nodeType = StrUtil.trimStr((Object)param.get("node_type"));
        Dsn_Structure parrent = this.getDsnSacture(upNode);
        String[] split = nodeSeq.split("\\.");
        if ("accy_risks".equalsIgnoreCase(nodeType)) {
            split[2] = parrent.getNodeNo();
            split[split.length - 1] = nodeNo;
        } else {
            split[0] = parrent.getNodeNo();
        }
        split[split.length - 1] = nodeNo;
        StringBuilder nddeSeq = new StringBuilder();
        for (int i = 0; i < split.length; ++i) {
            nddeSeq.append(split[i] + ".");
        }
        return nddeSeq.toString();
    }

    private Dsn_Structure getDsnSacture(String upNode) {
        Dsn_Structure structure = new Dsn_Structure();
        structure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)upNode);
        Dsn_Structure daoOne = (Dsn_Structure)this.dao.findOne((AbsModel)structure);
        structure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)daoOne.getUpNode());
        return (Dsn_Structure)this.dao.findOne((AbsModel)structure);
    }

    private void getRiskTree(Dsn_Structure dsnStructure) {
        String riskType = "";
        riskType = "main_risks".equalsIgnoreCase(dsnStructure.getNodeType()) ? "M" : "A";
        List<Dsn_Structure> structuresList = this.getQuerySqlable(dsnStructure, riskType);
        structuresList.forEach(dsn -> this.deleteBizAttribute(dsn.getNodeNo()));
        List<Dsn_Structure> list = structuresList.stream().filter(e -> !"".equalsIgnoreCase(e.getRelateTab())).collect(Collectors.toList());
        list.forEach(dsn -> this.deleteBizAttribute(dsn.getRelateFk()));
        Dsn_Structure structure = new Dsn_Structure();
        structuresList.forEach(dsn -> structure.where().addIn((ModelField)Dsn_Structure.Field.serno, dsn.getSerno()));
        this.dao.delete((AbsModel)structure);
    }

    private void deleteBizAttribute(String bizUuid) {
        Dsn_Biz_Attribute biz = new Dsn_Biz_Attribute();
        biz.where().addEq((ModelField)Dsn_Biz_Attribute.Field.biz_uuid, (Object)bizUuid);
        Dsn_Biz_Attribute bizAttribute = (Dsn_Biz_Attribute)this.dao.findOne((AbsModel)biz);
        if (!StrUtil.isNull((Object)bizAttribute.getSerno())) {
            this.deleteBizOption(bizAttribute);
            this.deleteAttrbute(bizAttribute);
            this.deleteAttrbute(bizAttribute);
            this.deleteAttrbuteOption(bizAttribute);
            biz.where().addEq((ModelField)Dsn_Biz_Attribute.Field.biz_uuid, (Object)bizAttribute.getBizUuid());
            this.dao.delete((AbsModel)biz);
        }
    }

    private void deleteBizOption(Dsn_Biz_Attribute bizAttribute) {
        Dsn_Biz_Attribute_Option biz = new Dsn_Biz_Attribute_Option();
        biz.where().addEq((ModelField)Dsn_Biz_Attribute_Option.Field.biz_uuid, (Object)bizAttribute.getBizUuid());
        this.dao.delete((AbsModel)biz);
    }

    private void deleteAttrbute(Dsn_Biz_Attribute bizAttribute) {
        Dsn_Attribute attribute = new Dsn_Attribute();
        attribute.where().addEq((ModelField)Dsn_Attribute.Field.attr_uuid, (Object)bizAttribute.getAttrUuid());
        this.dao.delete((AbsModel)attribute);
    }

    private void deleteAttrbuteOption(Dsn_Biz_Attribute bizAttribute) {
        Dsn_Attribute_Option option = new Dsn_Attribute_Option();
        option.where().addEq((ModelField)Dsn_Attribute_Option.Field.attr_uuid, (Object)bizAttribute.getAttrUuid());
        this.dao.delete((AbsModel)option);
    }

    public List<Dsn_Structure> getQuerySqlable(Dsn_Structure dsnStructure, String riskType) {
        ArrayList<Dsn_Structure> dsnList = new ArrayList<Dsn_Structure>();
        dsnList.add(dsnStructure);
        this.getTree(dsnList, dsnStructure.getNodeNo(), riskType);
        return dsnList;
    }

    private void getTree(List<Dsn_Structure> dsnList, String upNode, String riskType) {
        Dsn_Structure structure = new Dsn_Structure();
        structure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)upNode);
        if ("M".equalsIgnoreCase(riskType)) {
            structure.where().addNotEq((ModelField)Dsn_Structure.Field.node_type, (Object)"accy_risks");
        }
        List parentList = this.dao.findAll((AbsModel)structure);
        dsnList.addAll(parentList);
        parentList.forEach(dsn -> this.getTree(dsnList, dsn.getNodeNo(), riskType));
    }
}

