/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.design.rule.service.imp;

import cn.com.chinalife.model.Dsn_Biz_Attribute_Rules;
import cn.com.chinalife.model.Dsn_Dynamic_Data;
import cn.com.chinalife.model.Dsn_Rules;
import cn.com.chinalife.model.Dsn_Structure;
import cn.com.chinalife.model.Reg_Rules;
import cn.com.chinalife.model.Reg_Rules_Param;
import cn.com.chinalife.model.Reg_Rules_Param_Group;
import cn.com.chinalife.model.Reg_Rules_Sub;
import cn.com.chinalife.model.Sip_Risk_Rules;
import cn.com.chinalife.model.Sys_Enum;
import com.newtouch.dao.DBHandleCreator;
import com.newtouch.dao.QuerySqlable;
import com.newtouch.dao.UpdateSqlable;
import com.newtouch.dao.callback.RowCallback;
import com.newtouch.design.rule.service.IPublicRuleService;
import com.newtouch.msg.Return;
import com.newtouch.msg.ReturnMsg;
import com.newtouch.msg.exception.BusinessException;
import com.newtouch.msg.pojo.Message;
import com.newtouch.repository.AbsModel;
import com.newtouch.repository.AbsModelRepository;
import com.newtouch.repository.ModelField;
import com.newtouch.repository.util.RepEnum;
import com.newtouch.util.date.DateUtil;
import com.newtouch.util.json.JsonUtilOld;
import com.newtouch.util.string.StrUtil;
import com.newtouch.util.uuid.UniqueSeq;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PublicRuleServiceImp
implements IPublicRuleService {
    @Autowired
    private AbsModelRepository dao;

    @Override
    public ReturnMsg delRule(Map<String, Object> param) {
        String serno = StrUtil.trimStr((Object)param.get("serno"));
        String node_no = StrUtil.trimStr((Object)param.get("node_no"));
        String userNo = StrUtil.trimStr((Object)param.get("user_no"));
        Dsn_Structure ds = new Dsn_Structure();
        Dsn_Rules rule = new Dsn_Rules();
        Return r = new Return();
        try {
            if (!this.isSaveRule(userNo, node_no)) {
                throw new BusinessException(new Message("2016026", "\u5f53\u524d\u7528\u6237\u65e0\u5220\u9664\u89c4\u5219\u7684\u6743\u9650"));
            }
            rule.where().addEq((ModelField)Dsn_Rules.Field.rule_no, (Object)node_no);
            this.dao.delete((AbsModel)rule);
            ds.where().addEq((ModelField)Dsn_Structure.Field.serno, (Object)serno);
            this.dao.delete((AbsModel)ds);
        }
        catch (BusinessException e) {
            r.setFailMsg("\u5f53\u524d\u7528\u6237\u65e0\u5220\u9664\u89c4\u5219\u7684\u6743\u9650");
            return r.msg();
        }
        catch (Exception e) {
            r.setFailMsg("\u5220\u9664\u89c4\u5219\u5931\u8d25");
            return r.msg();
        }
        r.setSuccessMsg("\u5220\u9664\u89c4\u5219\u6210\u529f");
        return r.msg();
    }

    private boolean isSaveRule(String userNo, String nodeNo) {
        boolean flag = true;
        Dsn_Rules sipOrganRule = new Dsn_Rules();
        sipOrganRule.where().addEq((ModelField)Dsn_Rules.Field.node_no, (Object)nodeNo);
        if ("propose".equals(userNo)) {
            sipOrganRule.where().addIn((ModelField)Dsn_Rules.Field.use_scene, new String[]{"all", "insure"});
        }
        if ("admin".equals(userNo)) {
            sipOrganRule.where().addIn((ModelField)Dsn_Rules.Field.use_scene, "propose");
        }
        if (!CollectionUtils.isEmpty((Collection)this.dao.findAll((AbsModel)sipOrganRule))) {
            flag = false;
        }
        return flag;
    }

    @Override
    public ReturnMsg queryRegRule(Map<String, Object> map) {
        String rule_name = StrUtil.trimStr((Object)map.get("rule_name"));
        Reg_Rules rule = new Reg_Rules();
        rule.where().addLike((ModelField)Reg_Rules.Field.rule_name, (Object)rule_name);
        rule.where().addEq((ModelField)Reg_Rules.Field.data_flag, (Object)"1");
        rule.setOrderBy(new Sort.Order[]{Reg_Rules.Field.crt_date.desc()});
        Return msg = new Return();
        msg.setDataList(this.dao.findAll((AbsModel)rule, true), Reg_Rules.class);
        return msg.msg();
    }

    private List<Reg_Rules> checkRule(Reg_Rules rule) {
        Reg_Rules rule1 = new Reg_Rules();
        rule1.where().addEq((ModelField)Reg_Rules.Field.rule_name, (Object)rule.getRuleName());
        List result = null;
        result = this.dao.findAll((AbsModel)rule1);
        return result;
    }

    @Override
    public ReturnMsg addRegRule(Reg_Rules rule) {
        Return msg = new Return();
        if (StrUtil.isNull((Object)rule.getRuleName())) {
            msg.setFailMsg("\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        if (rule.getRuleMemo().length() > 200) {
            msg.setFailMsg("\u89c4\u5219 \u8bf4\u660e\u4e0d\u80fd\u8d85\u8fc7\u4e24\u767e\u4e2a\u5b57\u7b26\uff01");
            return msg.msg();
        }
        if (!this.checkRule(rule).isEmpty()) {
            msg.setFailMsg("\u8be5\u89c4\u5219\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
            return msg.msg();
        }
        String rule_no = UniqueSeq.shortUUID();
        rule.setRuleNo(rule_no);
        this.dao.save((AbsModel)rule);
        msg.setDataTable(JsonUtilOld.objToMap((Object)rule));
        return msg.msg();
    }

    @Override
    public ReturnMsg addRegRuleParam(Reg_Rules_Param param, Reg_Rules_Param_Group group) {
        Reg_Rules_Param param1;
        String rule_no;
        Return msg = new Return();
        String group_type = StrUtil.trimStr((Object)group.getGroupType());
        String stored_field = StrUtil.trimStr((Object)param.getStoredField());
        if ("field_1".equals(stored_field.toLowerCase())) {
            msg.setFailMsg("\u5b58\u50a8\u5b57\u6bb5\u4e0d\u80fd\u586b\u5199field_1");
        }
        if ("field_2".equals(stored_field.toLowerCase())) {
            msg.setFailMsg("\u5b58\u50a8\u5b57\u6bb5\u4e0d\u80fd\u586b\u5199field_2");
        }
        if ("field_3".equals(stored_field.toLowerCase())) {
            msg.setFailMsg("\u5b58\u50a8\u5b57\u6bb5\u4e0d\u80fd\u586b\u5199field_3");
        }
        if (StrUtil.isNull((Object)group_type)) {
            msg.setFailMsg("\u53c2\u6570\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isNull((Object)(rule_no = StrUtil.trimStr((Object)group.getRuleNo())))) {
            msg.setFailMsg("\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!"INSIDE".equals(group_type)) {
            Reg_Rules_Param_Group group1 = new Reg_Rules_Param_Group();
            group1.where().addEq((ModelField)Reg_Rules_Param_Group.Field.group_type, (Object)group_type);
            group1.where().addEq((ModelField)Reg_Rules_Param_Group.Field.rule_no, (Object)rule_no);
            String group_no = ((Reg_Rules_Param_Group)this.dao.findOne((AbsModel)group1)).getGroupNo();
            group.setGroupNo(group_no);
            param.setGroupNo(group_no);
        }
        if (!StrUtil.isNull((Object)param.getGroupNo())) {
            param1 = new Reg_Rules_Param();
            param1.where().addEq((ModelField)Reg_Rules_Param.Field.group_no, (Object)param.getGroupNo());
            param1.where().addEq((ModelField)Reg_Rules_Param.Field.param_no, (Object)param.getParamNo());
            if (!this.dao.findAll((AbsModel)param1).isEmpty()) {
                msg.setFailMsg("\u53c2\u6570\u7f16\u7801[" + param.getParamNo() + "]\u5df2\u5b58\u5728");
            }
        }
        if (!StrUtil.isNull((Object)param.getGroupNo())) {
            param1 = new Reg_Rules_Param();
            param1.where().addEq((ModelField)Reg_Rules_Param.Field.group_no, (Object)param.getGroupNo());
            param1.where().addLike((ModelField)Reg_Rules_Param.Field.param_name, (Object)param.getParamName());
            if (!this.dao.findAll((AbsModel)param1).isEmpty()) {
                msg.setFailMsg("\u53c2\u6570\u540d\u79f0[" + param.getParamName() + "]\u5df2\u5b58\u5728");
            }
        }
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        String group_no = StrUtil.trimStr((Object)param.getGroupNo());
        if (StrUtil.isNull((Object)group_no)) {
            group_no = UniqueSeq.shortUUID();
            String group_name = "\u5165\u53c2";
            if ("OUTPUT".equals(group.getGroupType())) {
                group_name = "\u51fa\u53c2";
            }
            if ("INSIDE".equals(group_type)) {
                Reg_Rules_Param_Group group1 = new Reg_Rules_Param_Group();
                group1.where().addEq((ModelField)Reg_Rules_Param_Group.Field.group_type, (Object)group_type);
                group1.where().addEq((ModelField)Reg_Rules_Param_Group.Field.rule_no, (Object)group.getRuleNo());
                group_name = "innerGroup" + (this.dao.findAll((AbsModel)group1).size() + 1);
            }
            group.setGroupName(group_name);
            param.setGroupNo(group_no);
            group.setGroupNo(group_no);
            group.setRuleNo(group.getRuleNo());
            this.dao.save((AbsModel)group);
        }
        this.dao.save((AbsModel)param);
        Reg_Rules_Param_Group group1 = new Reg_Rules_Param_Group();
        group1.where().addEq((ModelField)Reg_Rules_Param_Group.Field.rule_no, (Object)group.getRuleNo());
        group1.where().addEq((ModelField)Reg_Rules_Param_Group.Field.group_type, (Object)group.getGroupType());
        group1.setOrderBy(new Sort.Order[]{Reg_Rules_Param_Group.Field.crt_date.asc()});
        List paramGrpList = this.dao.findAll((AbsModel)group1);
        LinkedHashMap<String, List> paramTable = new LinkedHashMap<String, List>();
        for (Reg_Rules_Param_Group aGrp : paramGrpList) {
            Reg_Rules_Param param12 = new Reg_Rules_Param();
            param12.where().addEq((ModelField)Reg_Rules_Param.Field.group_no, (Object)aGrp.getGroupNo());
            param12.setOrderBy(new Sort.Order[]{Reg_Rules_Param.Field.param_order.asc()});
            String map_key = "param_" + aGrp.getGroupType() + "_list_" + (paramTable.size() + 1);
            paramTable.put(map_key, this.dao.findAll((AbsModel)param12));
        }
        msg.setDataTable(paramTable);
        return msg.msg();
    }

    @Override
    public ReturnMsg addRegSubRule(Map<String, Object> map) {
        String rule_no = StrUtil.trimStr((Object)map.get("rule_no"));
        String rule_type = StrUtil.trimStr((Object)map.get("rule_type"));
        String rule_detail = StrUtil.trimStr((Object)map.get("ueditor_textarea_editorValue"));
        map.put("rule_detail", rule_detail);
        Return msg = new Return();
        if (StrUtil.isNull((Object)map.get("rule_no"))) {
            msg.setFailMsg("\u89c4\u5219\u7f16\u7801[rule_no]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        map.put("rule_no", rule_no);
        String rule_sub_no = UniqueSeq.shortUUID();
        map.put("rule_sub_no", rule_sub_no);
        map.put("depend_sub_no", "depend");
        Reg_Rules_Sub sub = new Reg_Rules_Sub();
        sub.where().addEq((ModelField)Reg_Rules_Sub.Field.rule_no, (Object)rule_no);
        sub.where().addLike((ModelField)Reg_Rules_Sub.Field.rule_type, (Object)rule_type);
        List dataMap = this.dao.findAll((AbsModel)sub);
        if (!dataMap.isEmpty()) {
            msg.setFailMsg("\u8be5\u7c7b\u578b\u7684\u89c4\u5219\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
            return msg.msg();
        }
        Reg_Rules_Sub sub1 = new Reg_Rules_Sub();
        sub1.setRuleNo(rule_no);
        sub1.setRuleSubNo(rule_sub_no);
        sub1.setRuleType(rule_type);
        sub1.setRuleMethod(StrUtil.trimStr((Object)map.get("rule_method")));
        sub1.setRuleDetail(rule_detail);
        sub1.setDependSubNo("depend");
        this.dao.save((AbsModel)sub1);
        Reg_Rules_Sub sub2 = new Reg_Rules_Sub();
        sub2.where().addEq((ModelField)Reg_Rules_Sub.Field.rule_no, (Object)rule_no);
        List subList = this.dao.findAll((AbsModel)sub2);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Reg_Rules_Sub s : subList) {
            list.add(JsonUtilOld.objToMap((Object)s));
        }
        msg.setDataList(list);
        return msg.msg();
    }

    @Override
    public ReturnMsg initMdfRegRuleData(Map<String, Object> map) {
        Return msg = new Return();
        LinkedHashMap<String, Object> paramTable = new LinkedHashMap<String, Object>();
        String rule_no = StrUtil.trimStr((Object)map.get("rule_no"));
        if (StrUtil.isNull((Object)map.get("rule_no"))) {
            msg.setFailMsg("\u89c4\u5219\u7f16\u7801[rule_no]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        Reg_Rules rule = new Reg_Rules();
        rule.where().addEq((ModelField)Reg_Rules.Field.rule_no, (Object)rule_no);
        paramTable.putAll(JsonUtilOld.objToMap(this.dao.findOne((AbsModel)rule)));
        Reg_Rules_Sub sub = new Reg_Rules_Sub();
        sub.where().addEq((ModelField)Reg_Rules_Sub.Field.rule_no, (Object)rule_no);
        List subList = this.dao.findAll((AbsModel)sub, false);
        ArrayList<Map<String, Object>> subListMap = new ArrayList<Map<String, Object>>();
        for (Reg_Rules_Sub s : subList) {
            subListMap.add(JsonUtilOld.objToMap((Object)s));
        }
        paramTable.put("reg_rules_sub", subListMap);
        Reg_Rules_Param_Group group = new Reg_Rules_Param_Group();
        group.where().addEq((ModelField)Reg_Rules_Param_Group.Field.rule_no, map.get("rule_no"));
        group.setOrderBy(new Sort.Order[]{Reg_Rules_Param_Group.Field.crt_date.asc()});
        group.setOrderBy(new Sort.Order[]{Reg_Rules_Param_Group.Field.group_name.asc()});
        List paramGrpList = this.dao.findAll((AbsModel)group, false);
        int i = 1;
        int j = 1;
        HashMap<String, String> assy_mode = new HashMap<String, String>();
        for (Reg_Rules_Param_Group aGrp : paramGrpList) {
            ArrayList<Map<String, Object>> paramListMap;
            List paramList;
            i = 1;
            if ("INSIDE".equals(aGrp.getGroupType())) {
                i = j++;
            }
            Reg_Rules_Param param = new Reg_Rules_Param();
            param.where().addEq((ModelField)Reg_Rules_Param.Field.group_no, (Object)aGrp.getGroupNo());
            param.setOrderBy(new Sort.Order[]{Reg_Rules_Param.Field.param_order.asc()});
            String map_key = "param_" + aGrp.getGroupType() + "_list_" + i;
            assy_mode.put(map_key, aGrp.getAssyMode());
            if (paramTable.get(map_key) == null) {
                paramList = this.dao.findAll((AbsModel)param, false);
                paramListMap = new ArrayList();
                for (Reg_Rules_Param p : paramList) {
                    paramListMap.add(JsonUtilOld.objToMap((Object)p));
                }
                paramTable.put(map_key, paramListMap);
                continue;
            }
            paramList = this.dao.findAll((AbsModel)param);
            paramListMap = new ArrayList<Map<String, Object>>();
            for (Reg_Rules_Param p : paramList) {
                paramListMap.add(JsonUtilOld.objToMap((Object)p));
            }
            paramTable.put(map_key, paramListMap);
        }
        paramTable.put("assy_mode", assy_mode);
        paramTable.put("uuid", map.get("uuid"));
        msg.setDataTable(paramTable);
        return msg.msg();
    }

    @Override
    public ReturnMsg queryRegRuleParamGrp4Ajax(Map<String, Object> map) {
        String rule_no;
        Return msg = new Return();
        String group_type = StrUtil.trimStr((Object)map.get("group_type"));
        if (StrUtil.isNull((Object)group_type)) {
            msg.setFailMsg("\u53c2\u6570\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isNull((Object)(rule_no = StrUtil.trimStr((Object)map.get("rule_no"))))) {
            msg.setFailMsg("\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        Reg_Rules_Param_Group group = new Reg_Rules_Param_Group();
        group.where().addEq((ModelField)Reg_Rules_Param_Group.Field.rule_no, (Object)rule_no);
        group.where().addEq((ModelField)Reg_Rules_Param_Group.Field.group_type, (Object)group_type);
        group.setOrderBy(new Sort.Order[]{Reg_Rules_Param_Group.Field.crt_date.asc()});
        List paraGrpList = this.dao.findAll((AbsModel)group);
        ArrayList<Map<String, Object>> paraGrpList1 = new ArrayList<Map<String, Object>>();
        for (Reg_Rules_Param_Group g : paraGrpList) {
            Map<String, Object> gMap = JsonUtilOld.objToMap((Object)g);
            gMap.put("code", g.getGroupNo());
            gMap.put("name", "\u5185\u53c2" + g.getGroupName().substring(g.getGroupName().length() - 1));
            gMap.remove("group_no");
            gMap.remove("group_name");
            paraGrpList1.add(gMap);
        }
        if (!"INSIDE".equals(map.get("group_type")) && !paraGrpList1.isEmpty()) {
            ((Map)paraGrpList1.get(0)).put("selected", "selected");
        }
        HashMap<String, Object> select = new HashMap<String, Object>();
        select.put("ajaxtype", "select");
        select.put("group_no", paraGrpList1);
        msg.getDataList().add(select);
        return msg.msg();
    }

    @Override
    public ReturnMsg setAssyMode4Inside(Map<String, Object> map) {
        Return msg = new Return();
        String rule_no = StrUtil.trimStr((Object)map.get("rule_no"));
        if (StrUtil.isNull((Object)rule_no)) {
            msg.setFailMsg("\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        Reg_Rules_Param_Group group = new Reg_Rules_Param_Group();
        group.where().addEq((ModelField)Reg_Rules_Param_Group.Field.rule_no, (Object)rule_no);
        group.where().addEq((ModelField)Reg_Rules_Param_Group.Field.group_no, map.get("group_no"));
        Reg_Rules_Param_Group group_type = (Reg_Rules_Param_Group)this.dao.findOne((AbsModel)group);
        if (StrUtil.isNull((Object)((Object)group_type))) {
            HashMap<String, String> edit = new HashMap<String, String>();
            edit.put("ajaxtype", "edit");
            edit.put("assy_mode", "ROW");
            msg.getDataList().add(edit);
            return msg.msg();
        }
        HashMap<String, String> disabled = new HashMap<String, String>();
        disabled.put("ajaxtype", "disabled");
        disabled.put("assy_mode", group_type.getAssyMode());
        msg.getDataList().add(disabled);
        return msg.msg();
    }

    @Override
    public ReturnMsg delRegRule(Map<String, Object> map) {
        Return msg = new Return();
        List list = (List)map.get("checkbox");
        for (int i = 0; i < list.size(); ++i) {
            Map ruleList = (Map)list.get(i);
            String rule_no = ruleList.get("rule_no").toString();
            List result1 = null;
            List result2 = null;
            String rule_name = "";
            Sip_Risk_Rules s_rule = new Sip_Risk_Rules();
            s_rule.where().addEq((ModelField)Sip_Risk_Rules.Field.rule_no, (Object)rule_no);
            result1 = this.dao.findAll((AbsModel)s_rule);
            if (!result1.isEmpty() || result1.size() != 0) {
                Reg_Rules rule = new Reg_Rules();
                rule.where().addEq((ModelField)Reg_Rules.Field.rule_no, (Object)rule_no);
                rule_name = StrUtil.trimStr((Object)((Reg_Rules)this.dao.findOne((AbsModel)rule)).getRuleName());
                msg.setFailMsg(rule_name + "\u8be5\u89c4\u5219\u4e1a\u52a1\u4e2d\u6b63\u5728\u4f7f\u7528\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
                return msg.msg();
            }
            Dsn_Biz_Attribute_Rules attr_rule = new Dsn_Biz_Attribute_Rules();
            attr_rule.where().addEq((ModelField)Dsn_Biz_Attribute_Rules.Field.rule_no, (Object)rule_no);
            result2 = this.dao.findAll((AbsModel)attr_rule);
            if (!result2.isEmpty() || result2.size() != 0) {
                Reg_Rules rule = new Reg_Rules();
                rule.where().addEq((ModelField)Reg_Rules.Field.rule_no, (Object)rule_no);
                rule_name = StrUtil.trimStr((Object)((Reg_Rules)this.dao.findOne((AbsModel)rule)).getRuleName());
                msg.setFailMsg(rule_name + "\u8be5\u89c4\u5219\u4e1a\u52a1\u4e2d\u6b63\u5728\u4f7f\u7528\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
                return msg.msg();
            }
            List groupList = null;
            Reg_Rules_Param_Group group = new Reg_Rules_Param_Group();
            group.where().addEq((ModelField)Reg_Rules_Param_Group.Field.rule_no, (Object)rule_no);
            groupList = this.dao.findAll((AbsModel)group);
            if (groupList.size() > 0) {
                for (int j = 0; j < groupList.size(); ++j) {
                    Reg_Rules_Param_Group group1 = (Reg_Rules_Param_Group)((Object)groupList.get(j));
                    String group_no = group1.getGroupNo();
                    if (StrUtil.isNull((Object)((Object)group1))) continue;
                    Reg_Rules_Param param = new Reg_Rules_Param();
                    param.where().addEq((ModelField)Reg_Rules_Param.Field.group_no, (Object)group_no);
                    this.dao.delete((AbsModel)param);
                    Reg_Rules_Param_Group group2 = new Reg_Rules_Param_Group();
                    group2.where().addEq((ModelField)Reg_Rules_Param_Group.Field.group_no, (Object)group_no);
                    this.dao.delete((AbsModel)group2);
                }
            }
            Reg_Rules_Sub sub = new Reg_Rules_Sub();
            sub.where().addEq((ModelField)Reg_Rules_Sub.Field.rule_no, (Object)rule_no);
            this.dao.delete((AbsModel)sub);
            Reg_Rules rule = new Reg_Rules();
            rule.where().addEq((ModelField)Reg_Rules.Field.rule_no, (Object)rule_no);
            this.dao.delete((AbsModel)rule);
        }
        return msg.msg();
    }

    @Override
    public ReturnMsg delRegRuleSub(Map<String, Object> map) {
        Return msg = new Return();
        List releSubList = (List)map.get("checkbox");
        Map<String, Object> aSubRule = new HashMap();
        String rule_no = "";
        for (int i = 0; i < releSubList.size(); ++i) {
            aSubRule = (Map)releSubList.get(i);
            rule_no = StrUtil.trimStr(aSubRule.get("rule_no"));
            String serno = StrUtil.trimStr(aSubRule.get("serno"));
            Reg_Rules_Sub sub = new Reg_Rules_Sub();
            sub.where().addEq((ModelField)Reg_Rules_Sub.Field.serno, (Object)serno);
            this.dao.delete((AbsModel)sub);
        }
        if (StrUtil.isNull((Object)rule_no)) {
            return msg.msg();
        }
        aSubRule.clear();
        aSubRule.put("rule_no", rule_no);
        ReturnMsg newMsg = this.initMdfRegRuleData(aSubRule);
        return newMsg;
    }

    @Override
    public ReturnMsg delRegRuleParam(Map<String, Object> map) {
        Reg_Rules_Param_Group group1;
        List releSubList = (List)map.get("checkbox");
        Map<String, String> aParam = new HashMap();
        String rule_no = "";
        String serno = "";
        ArrayList<String> group_type = new ArrayList<String>();
        for (int i = 0; i < releSubList.size(); ++i) {
            aParam = (Map)releSubList.get(i);
            rule_no = StrUtil.trimStr(aParam.get("rule_no"));
            serno = StrUtil.trimStr(aParam.get("serno"));
            if (!StrUtil.isNull((Object)rule_no)) continue;
            Reg_Rules_Param_Group group = new Reg_Rules_Param_Group();
            group.where().addEq((ModelField)Reg_Rules_Param_Group.Field.group_no, aParam.get("group_no"));
            group = (Reg_Rules_Param_Group)this.dao.findOne((AbsModel)group);
            rule_no = StrUtil.trimStr((Object)group.getRuleNo());
            group_type.add(group.getGroupType());
            Reg_Rules_Param param = new Reg_Rules_Param();
            param.where().addEq((ModelField)Reg_Rules_Param.Field.serno, (Object)serno);
            this.dao.delete((AbsModel)param);
            Reg_Rules_Param param1 = new Reg_Rules_Param();
            param1.where().addEq((ModelField)Reg_Rules_Param.Field.group_no, aParam.get("group_no"));
            if (this.dao.findAll((AbsModel)param1).size() > 0) continue;
            group1 = new Reg_Rules_Param_Group();
            group1.where().addEq((ModelField)Reg_Rules_Param_Group.Field.group_no, aParam.get("group_no"));
            this.dao.delete((AbsModel)group1);
        }
        LinkedHashMap<String, Object> paramTable = new LinkedHashMap<String, Object>();
        int i = 0;
        for (String type : group_type) {
            group1 = new Reg_Rules_Param_Group();
            group1.where().addEq((ModelField)Reg_Rules_Param_Group.Field.rule_no, (Object)rule_no);
            group1.where().addEq((ModelField)Reg_Rules_Param_Group.Field.group_type, (Object)type);
            group1.setOrderBy(new Sort.Order[]{Reg_Rules_Param_Group.Field.crt_date.asc()});
            List paramGrpList = this.dao.findAll((AbsModel)group1);
            if (!paramGrpList.isEmpty()) {
                for (Reg_Rules_Param_Group aGrp : paramGrpList) {
                    Reg_Rules_Param param1 = new Reg_Rules_Param();
                    param1.where().addEq((ModelField)Reg_Rules_Param.Field.group_no, (Object)aGrp.getGroupNo());
                    param1.setOrderBy(new Sort.Order[]{Reg_Rules_Param.Field.param_order.asc()});
                    String map_key = "param_" + aGrp.getGroupType() + "_list_" + (paramTable.size() + 1);
                    paramTable.put(map_key, this.dao.findAll((AbsModel)param1));
                }
                continue;
            }
            if (i != 0) continue;
            ++i;
            String map_key = "param_" + type + "_list_" + (paramTable.size() + 1);
            paramTable.put(map_key, "");
        }
        aParam.clear();
        aParam.put("rule_no", rule_no);
        Return r = new Return();
        r.setDataTable(paramTable);
        return r.msg();
    }

    @Override
    public ReturnMsg MdfRegRuleParam(Map<String, Object> map) {
        Return msg = new Return();
        String rule_memo = map.get("rule_memo").toString();
        if (rule_memo.length() > 255) {
            msg.setFailMsg("\u89c4\u5219\u8bf4\u660e\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7255\uff01");
        }
        String sql = "update reg_rules set rule_memo = ? where rule_no = ?";
        UpdateSqlable updateSql = DBHandleCreator.getInstance().getUpdateSql();
        updateSql.add((Object)rule_memo);
        updateSql.add(map.get("rule_no"));
        updateSql.setSql(sql);
        this.dao.update(updateSql);
        return msg.msg();
    }

    @Override
    public ReturnMsg validateRuleName(Map<String, Object> map) {
        Return msg = new Return();
        Reg_Rules rule = new Reg_Rules();
        rule.where().addEq((ModelField)Reg_Rules.Field.rule_name, map.get("rule_name"));
        msg.setDataList(this.dao.findAll((AbsModel)rule), Reg_Rules.class);
        return msg.msg();
    }

    @Override
    public ReturnMsg queryRule(Map<String, Object> param) {
        Return msg = new Return();
        Reg_Rules rule = new Reg_Rules();
        rule.where().setCheckWhere(false);
        List ruleList = this.dao.findAll((AbsModel)rule);
        ArrayList<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>();
        for (Reg_Rules r : ruleList) {
            listMap.add(JsonUtilOld.objToMap((Object)r));
        }
        HashMap<String, ArrayList<Map<String, Object>>> map = new HashMap<String, ArrayList<Map<String, Object>>>();
        map.put("left", listMap);
        msg.setDataTable(map);
        return msg.msg();
    }

    @Override
    public ReturnMsg queryPropertyRule(Map<String, Object> param) {
        Return msg = new Return();
        HashMap<String, Object> map = new HashMap<String, Object>();
        String rule_name = StrUtil.trimStr((Object)param.get("rule_name"));
        Reg_Rules rule = new Reg_Rules();
        rule.where().setCheckWhere(false);
        if (!StrUtil.isNull((Object)rule_name)) {
            rule.where().addLike((ModelField)Reg_Rules.Field.rule_name, (Object)rule_name);
        }
        List ruleList = this.dao.findAll((AbsModel)rule);
        ArrayList<Map<String, Object>> ruleListMap = new ArrayList<Map<String, Object>>();
        for (Reg_Rules r : ruleList) {
            Map<String, Object> m = JsonUtilOld.objToMap((Object)r);
            m.put("code", r.getRuleNo());
            m.put("name", r.getRuleName());
            m.remove("rule_no");
            m.remove("rule_name");
            ruleListMap.add(m);
        }
        map.put("leftSelect", ruleListMap);
        map.put("ajaxtype", "select");
        msg.getDataList().add(map);
        return msg.msg();
    }

    @Override
    public ReturnMsg addPropertyRule(Map<String, Object> param) {
        Return msg;
        block6: {
            msg = new Return();
            msg.setAutoRollback(false);
            try {
                String up_node = StrUtil.trimStr((Object)param.get("up_node"));
                List rightSelect = (List)param.get("rigthSelect");
                if (rightSelect != null) {
                    for (int i = 0; i < rightSelect.size(); ++i) {
                        Map rules = (Map)rightSelect.get(i);
                        String rule_no = StrUtil.trimStr(rules.get("rigthSelect"));
                        String rule_name = StrUtil.trimStr(rules.get("rigthSelect_name"));
                        Reg_Rules rule1 = new Reg_Rules();
                        rule1.where().addEq((ModelField)Reg_Rules.Field.rule_no, (Object)rule_no);
                        Map<String, Object> rule = JsonUtilOld.objToMap(this.dao.findOne((AbsModel)rule1));
                        String serno = StrUtil.trimStr((Object)rule.get("serno"));
                        String sql = " SELECT node_no,node_name,relate_fk,node_type FROM dsn_structure WHERE node_no = (SELECT\tup_node\tFROM dsn_structure WHERE node_no = (SELECT\tup_node\tFROM dsn_structure WHERE node_no = ?))";
                        QuerySqlable query = DBHandleCreator.getInstance().getQuerySql();
                        query.add((Object)up_node);
                        query.setSql(sql);
                        List listMap = this.dao.findAll(query);
                        Map map = (Map)listMap.get(0);
                        String parent_node_type = StrUtil.trimStr(map.get("node_type"));
                        String node_no = UniqueSeq.shortUUID();
                        if ("attr".equals(parent_node_type)) {
                            param.put("relate_tab", "dsn_biz_attribute_rules");
                        } else {
                            param.put("relate_tab", "sip_risk_rules");
                        }
                        String node_type = "rule";
                        param.put("relate_fk", serno);
                        param.put("node_no", node_no);
                        param.put("node_name", rule_name);
                        param.put("up_node", up_node);
                        Dsn_Structure ds = new Dsn_Structure();
                        ds.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)up_node);
                        String upnode_seq = StrUtil.trimStr((Object)((Dsn_Structure)this.dao.findOne((AbsModel)ds)).getNodeSeq());
                        String node_seq = null;
                        node_seq = StrUtil.isNull((Object)upnode_seq) ? node_no + "." : upnode_seq + node_no + ".";
                        param.put("node_seq", node_seq);
                        Dsn_Structure ds1 = new Dsn_Structure();
                        ds1.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)up_node);
                        ds1.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)node_type);
                        ds1.groupBy().max((ModelField)Dsn_Structure.Field.display_order);
                        ds1 = (Dsn_Structure)this.dao.findOne((AbsModel)ds1);
                        int display_order = Integer.parseInt(StrUtil.isNull((Object)ds1.getOtherProperty("max_display_order", String.class)) ? "0" : (String)ds1.getOtherProperty("max_display_order", String.class));
                        ds1 = new Dsn_Structure();
                        ds1.setNodeNo(node_no);
                        ds1.setNodeName(rule_name);
                        ds1.setNodeType(node_type);
                        ds1.setUpNode(up_node);
                        ds1.setNodeSeq(node_seq);
                        ds1.setDisplayOrder(display_order + 1);
                        ds1.setRelateFk(serno);
                        ds1.setRelateTab(StrUtil.trimStr((Object)param.get("relate_tab")));
                        this.dao.save((AbsModel)ds1);
                    }
                    break block6;
                }
                msg.setFailMsg("\u8bf7\u6dfb\u52a0\u89c4\u5219\uff01");
                return msg.msg();
            }
            catch (Exception e) {
                e.printStackTrace();
                msg.setFailMsg("\u6dfb\u52a0\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5");
                return msg.msg();
            }
        }
        return msg.msg();
    }

    private List<String> getChannelInfo(Map<String, Object> param) {
        ArrayList<String> channelList = new ArrayList<String>(10);
        Sys_Enum sys_enum = new Sys_Enum();
        sys_enum.where().addEq((ModelField)Sys_Enum.Field.up_enum, (Object)"channel_type");
        List sysList = this.dao.findAll((AbsModel)sys_enum);
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            for (Sys_Enum sysEnum : sysList) {
                if (!entry.getKey().equals(sysEnum.getEnumNo())) continue;
                channelList.add(StrUtil.trimStr((Object)entry.getValue()));
            }
        }
        return channelList;
    }

    @Override
    public ReturnMsg doQuerySelectedChannel(Map<String, Object> param) {
        ArrayList resultList = new ArrayList(10);
        String nodeNo = StrUtil.trimStr((Object)param.get("node_no"));
        Dsn_Biz_Attribute_Rules dsnBizAttributeRules4Query = new Dsn_Biz_Attribute_Rules();
        dsnBizAttributeRules4Query.where().addEq((ModelField)Dsn_Biz_Attribute_Rules.Field.attr_rule_uuid, (Object)nodeNo);
        List dsnBizAttributeRulesList = this.dao.findAll((AbsModel)dsnBizAttributeRules4Query);
        Sys_Enum sysEnum4Query = new Sys_Enum();
        sysEnum4Query.where().addEq((ModelField)Sys_Enum.Field.up_enum, (Object)"channel_type");
        List sysList = this.dao.findAll((AbsModel)sysEnum4Query);
        HashMap<String, Object> channelMap = null;
        for (Sys_Enum sysEnum : sysList) {
            channelMap = new HashMap<String, Object>(16);
            channelMap.put("enum_name", sysEnum.getEnumName());
            channelMap.put("enum_no", sysEnum.getEnumNo());
            channelMap.put("enum_code", sysEnum.getEnumCode());
            for (Dsn_Biz_Attribute_Rules dsnBizAttributeRules : dsnBizAttributeRulesList) {
                if (!sysEnum.getEnumCode().equals(dsnBizAttributeRules.getRuleChannels())) continue;
                channelMap.put("selected", true);
            }
            resultList.add(channelMap);
        }
        Return msg = new Return();
        msg.setDataList(resultList);
        return msg.msg();
    }

    @Override
    public ReturnMsg doSaveSelectedChannel(Map<String, Object> param) {
        Return msg = new Return();
        ArrayList<String> channelCodeList = new ArrayList<String>(10);
        String nodeNo = StrUtil.trimStr((Object)param.get("node_no"));
        Dsn_Biz_Attribute_Rules dsnBizAttributeRules4Query = new Dsn_Biz_Attribute_Rules();
        dsnBizAttributeRules4Query.where().addEq((ModelField)Dsn_Biz_Attribute_Rules.Field.attr_rule_uuid, (Object)nodeNo);
        List dsnBizAttributeRulesList = this.dao.findAll((AbsModel)dsnBizAttributeRules4Query);
        if (null == dsnBizAttributeRulesList || dsnBizAttributeRulesList.isEmpty()) {
            msg.setFailMsg("\u6ca1\u67e5\u8be2\u5230\u5386\u53f2\u4fe1\u606f!");
            return msg.msg();
        }
        Dsn_Biz_Attribute_Rules dsnBizAttributeRules = (Dsn_Biz_Attribute_Rules)((Object)dsnBizAttributeRulesList.get(0));
        Dsn_Biz_Attribute_Rules dsnBizAttributeRules4Delete = new Dsn_Biz_Attribute_Rules();
        dsnBizAttributeRules4Delete.where().addEq((ModelField)Dsn_Biz_Attribute_Rules.Field.attr_rule_uuid, (Object)nodeNo);
        this.dao.delete((AbsModel)dsnBizAttributeRules4Delete);
        Sys_Enum sysEnum4Query = new Sys_Enum();
        sysEnum4Query.where().addEq((ModelField)Sys_Enum.Field.up_enum, (Object)"channel_type");
        List sysList = this.dao.findAll((AbsModel)sysEnum4Query);
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            for (Sys_Enum sysEnum : sysList) {
                if (!entry.getKey().equals(sysEnum.getEnumNo()) || StrUtil.isNull((Object)entry.getValue())) continue;
                channelCodeList.add(StrUtil.trimStr((Object)entry.getValue()));
            }
        }
        for (String channelStr : channelCodeList) {
            dsnBizAttributeRules.setBizUuid(UniqueSeq.shortUUID());
            dsnBizAttributeRules.setRuleChannels(channelStr);
            this.dao.save((AbsModel)dsnBizAttributeRules);
        }
        return msg.msg();
    }

    @Override
    public ReturnMsg doMdfRuleParam(Map<String, Object> param) {
        AbsModel rule;
        Return r = new Return();
        r = this.verifyParam(param);
        if (!r.isSuccessflag()) {
            return r.msg();
        }
        String serno = StrUtil.trimStr((Object)param.get("serno"));
        String relate_tab = StrUtil.trimStr((Object)param.get("relate_tab"));
        String district = StrUtil.trimStr((Object)param.get("district_type"));
        String rule_channels = StrUtil.trimStr((Object)param.get("channel_type"));
        String startDate = StrUtil.trimStr((Object)param.get("start_date"));
        String endDate = StrUtil.trimStr((Object)param.get("end_date"));
        String old_rule_channel = "";
        String old_district = "";
        if ("dsn_biz_attribute_rules".equals(relate_tab)) {
            Dsn_Biz_Attribute_Rules attr_rule = new Dsn_Biz_Attribute_Rules();
            attr_rule.where().addEq((ModelField)Dsn_Biz_Attribute_Rules.Field.serno, (Object)serno);
            attr_rule = (Dsn_Biz_Attribute_Rules)this.dao.findOne((AbsModel)attr_rule);
            old_rule_channel = attr_rule.getRuleChannels();
            old_district = attr_rule.getDistrict();
            rule = new Dsn_Biz_Attribute_Rules();
            rule.setDistrict(district);
            rule.setRuleChannels(rule_channels);
            rule.setStartDate(DateUtil.obj2Timestamp((Object)DateUtil.string2Date((Object)startDate)));
            rule.setEndDate(DateUtil.obj2Timestamp((Object)DateUtil.string2Date((Object)endDate)));
            this.dao.update(serno, rule);
        } else if ("sip_risk_rules".equals(relate_tab)) {
            Sip_Risk_Rules riskRule = new Sip_Risk_Rules();
            riskRule.where().addEq((ModelField)Sip_Risk_Rules.Field.serno, (Object)serno);
            riskRule = (Sip_Risk_Rules)this.dao.findOne((AbsModel)riskRule);
            old_rule_channel = riskRule.getRuleChannels();
            old_district = riskRule.getDistrict();
            rule = new Sip_Risk_Rules();
            rule.setDistrict(district);
            rule.setRuleChannels(rule_channels);
            rule.setStartDate(DateUtil.obj2Timestamp((Object)DateUtil.string2Date((Object)startDate)));
            rule.setEndDate(DateUtil.obj2Timestamp((Object)DateUtil.string2Date((Object)endDate)));
            this.dao.update(serno, rule);
        }
        Dsn_Dynamic_Data data = new Dsn_Dynamic_Data();
        data.where().addEq((ModelField)Dsn_Dynamic_Data.Field.relate_fk, (Object)serno);
        data.where().addEq((ModelField)Dsn_Dynamic_Data.Field.field_5, (Object)old_rule_channel);
        data.where().addEq((ModelField)Dsn_Dynamic_Data.Field.field_6, (Object)old_district);
        List allDynamic_Data = this.dao.findAll((AbsModel)data);
        if (allDynamic_Data != null || !allDynamic_Data.isEmpty()) {
            for (Dsn_Dynamic_Data d : allDynamic_Data) {
                d.setField5(rule_channels);
                d.setField6(district);
                this.dao.update(d.getSerno(), (AbsModel)d);
            }
        }
        allDynamic_Data = null;
        data = new Dsn_Dynamic_Data();
        data.where().addEq((ModelField)Dsn_Dynamic_Data.Field.relate_fk, (Object)serno);
        data.where().addEq((ModelField)Dsn_Dynamic_Data.Field.field_2, (Object)old_rule_channel);
        data.where().addEq((ModelField)Dsn_Dynamic_Data.Field.field_3, (Object)old_district);
        allDynamic_Data = this.dao.findAll((AbsModel)data);
        if (allDynamic_Data != null || !allDynamic_Data.isEmpty()) {
            for (Dsn_Dynamic_Data d : allDynamic_Data) {
                d.setField2(rule_channels);
                d.setField3(district);
                this.dao.update(d.getSerno(), (AbsModel)d);
            }
        }
        return r.msg();
    }

    private Return verifyParam(Map<String, Object> param) {
        Return r = new Return();
        if (!param.containsKey("channel_type") || StrUtil.isNull((Object)param.get("channel_type"))) {
            r.setFailMsg("\u8bf7\u9009\u62e9\u6e20\u9053!");
            return r;
        }
        if (StrUtil.isNull((Object)param.get("district_type"))) {
            r.setFailMsg("\u8bf7\u9009\u62e9\u5730\u533a!");
            return r;
        }
        String startDate = StrUtil.trimStr((Object)param.get("start_date"));
        String endDate = StrUtil.trimStr((Object)param.get("end_date"));
        if (StrUtil.isNull((Object)startDate) || StrUtil.isNull((Object)endDate)) {
            r.setFailMsg("\u5f00\u59cb\u65f6\u95f4\u6216\u8005\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!");
            return r;
        }
        if (DateUtil.compareDate((Date)DateUtil.string2Date((Object)startDate), (Date)DateUtil.string2Date((Object)endDate)) != -1) {
            r.setFailMsg("\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u7ed3\u675f\u65f6\u95f4!");
            return r;
        }
        String relate_tab = StrUtil.trimStr((Object)param.get("relate_tab"));
        if ("dsn_biz_attribute_rules".equals(relate_tab)) {
            Dsn_Biz_Attribute_Rules rule = new Dsn_Biz_Attribute_Rules();
            rule.where().addEq((ModelField)Dsn_Biz_Attribute_Rules.Field.attr_rule_uuid, param.get("node_no"));
            rule.where().addEq((ModelField)Dsn_Biz_Attribute_Rules.Field.district, param.get("district"));
            rule.where().addEq((ModelField)Dsn_Biz_Attribute_Rules.Field.rule_channels, param.get("rule_channels"));
            rule.where().addCallback((RowCallback)new RepEnum("channel_type", (ModelField)Sip_Risk_Rules.Field.rule_channels));
            rule.where().addCallback((RowCallback)new RepEnum("district", (ModelField)Sip_Risk_Rules.Field.district));
            List ruleList = this.dao.findAll((AbsModel)rule);
            if (ruleList.size() > 0) {
                r.setFailMsg("\u8be5\u89c4\u5219\u7684\u6e20\u9053\u4fe1\u606f:" + ((Dsn_Biz_Attribute_Rules)((Object)ruleList.get(0))).getOtherProperty("rule_channels_name") + ",\u5730\u533a\u4fe1\u606f:" + ((Dsn_Biz_Attribute_Rules)((Object)ruleList.get(0))).getOtherProperty("district_name") + ",\u5df2\u5b58\u5728,\u8bf7\u91cd\u65b0\u9009\u62e9");
            }
        } else if ("sip_risk_rules".equals(relate_tab)) {
            Sip_Risk_Rules rule = new Sip_Risk_Rules();
            rule.where().addEq((ModelField)Sip_Risk_Rules.Field.risk_rule_uuid, param.get("node_no"));
            rule.where().addEq((ModelField)Sip_Risk_Rules.Field.district, param.get("district"));
            rule.where().addEq((ModelField)Sip_Risk_Rules.Field.rule_channels, param.get("rule_channels"));
            rule.where().addCallback((RowCallback)new RepEnum("channel_type", (ModelField)Sip_Risk_Rules.Field.rule_channels));
            rule.where().addCallback((RowCallback)new RepEnum("district", (ModelField)Sip_Risk_Rules.Field.district));
            List ruleList = this.dao.findAll((AbsModel)rule);
            if (ruleList.size() > 0) {
                r.setFailMsg("\u8be5\u89c4\u5219\u7684\u6e20\u9053\u4fe1\u606f:" + ((Sip_Risk_Rules)((Object)ruleList.get(0))).getOtherProperty("rule_channels_name") + ",\u5730\u533a\u4fe1\u606f:" + ((Sip_Risk_Rules)((Object)ruleList.get(0))).getOtherProperty("district_name") + ",\u5df2\u5b58\u5728,\u8bf7\u91cd\u65b0\u9009\u62e9");
            }
        }
        return r;
    }

    @Override
    public ReturnMsg doAddRuleParam(Map<String, Object> param) {
        Return r = new Return();
        r = this.verifyParam(param);
        if (!r.isSuccessflag()) {
            return r.msg();
        }
        String startDate = StrUtil.trimStr((Object)param.get("start_date"));
        String endDate = StrUtil.trimStr((Object)param.get("end_date"));
        String relate_tab = StrUtil.trimStr((Object)param.get("relate_tab"));
        String exception_handle = "\u6709\u5f02\u5e38\u9000\u51fa";
        String rule_type = "\u754c\u9762\u521d\u59cb\u5316\u65f6\u6821\u9a8c";
        String trigger_mode = "\u83b7\u5f97\u7126\u70b9\u65f6";
        int schedule_order = 1;
        String node_no = StrUtil.trimStr((Object)param.get("node_no"));
        String rule_no = StrUtil.trimStr((Object)param.get("rule_no"));
        String district = StrUtil.trimStr((Object)param.get("district_type"));
        String rule_channels = StrUtil.trimStr((Object)param.get("channel_type"));
        String up_node = StrUtil.trimStr((Object)param.get("up_node"));
        if ("dsn_biz_attribute_rules".equals(relate_tab)) {
            Dsn_Biz_Attribute_Rules rule = new Dsn_Biz_Attribute_Rules();
            rule.setAttrRuleUuid(node_no);
            rule.setBizUuid(UniqueSeq.shortUUID());
            rule.setRuleNo(rule_no);
            rule.setTriggerMode(trigger_mode);
            rule.setRuleType(rule_type);
            rule.setScheduleOrder(schedule_order);
            rule.setExceptionHandle(exception_handle);
            rule.setPatchMemo(trigger_mode);
            rule.setStartDate(DateUtil.obj2Timestamp((Object)DateUtil.string2Date((Object)startDate)));
            rule.setEndDate(DateUtil.obj2Timestamp((Object)DateUtil.string2Date((Object)endDate)));
            rule.setDistrict(district);
            rule.setRuleChannels(rule_channels);
            this.dao.save((AbsModel)rule);
        } else if ("sip_risk_rules".equals(relate_tab)) {
            String sql = "select * from dsn_structure where node_no = (select up_node from dsn_structure where node_no = ?)";
            QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
            querySql.add((Object)up_node);
            querySql.setSql(sql);
            List dsnList = this.dao.findAll(querySql);
            String node_seq = StrUtil.trimStr(((Map)dsnList.get(0)).get("node_seq"));
            String node_type = StrUtil.trimStr(((Map)dsnList.get(0)).get("node_type"));
            String[] node_seqs = node_seq.split("\\.");
            String risk_uuid = "";
            risk_uuid = "n_tbr_rule".equals(node_type) || "n_bbr_rule".equals(node_type) || "n_syr_rule".equals(node_type) ? node_seqs[node_seqs.length - 4] : node_seqs[node_seqs.length - 2];
            Sip_Risk_Rules rule = new Sip_Risk_Rules();
            rule.setRiskRuleUuid(node_no);
            rule.setRiskUuid(risk_uuid);
            rule.setRuleNo(rule_no);
            rule.setRuleType(rule_type);
            rule.setScheduleOrder(schedule_order);
            rule.setExceptionHandle(exception_handle);
            rule.setPatchMemo(trigger_mode);
            rule.setStartDate(DateUtil.obj2Timestamp((Object)DateUtil.string2Date((Object)startDate)));
            rule.setEndDate(DateUtil.obj2Timestamp((Object)DateUtil.string2Date((Object)endDate)));
            rule.setDistrict(district);
            rule.setRuleChannels(rule_channels);
            this.dao.save((AbsModel)rule);
        }
        return r.msg();
    }

    @Override
    public ReturnMsg doCopyRuleParam(Map<String, Object> param) {
        Return r = new Return();
        r = this.verifyParam(param);
        if (!r.isSuccessflag()) {
            return r.msg();
        }
        String startDate = StrUtil.trimStr((Object)param.get("start_date"));
        String endDate = StrUtil.trimStr((Object)param.get("end_date"));
        String relate_tab = StrUtil.trimStr((Object)param.get("relate_tab"));
        String exception_handle = "\u6709\u5f02\u5e38\u9000\u51fa";
        String rule_type = "\u754c\u9762\u521d\u59cb\u5316\u65f6\u6821\u9a8c";
        String trigger_mode = "\u83b7\u5f97\u7126\u70b9\u65f6";
        int schedule_order = 1;
        String node_no = StrUtil.trimStr((Object)param.get("node_no"));
        String rule_no = StrUtil.trimStr((Object)param.get("rule_no"));
        String district = StrUtil.trimStr((Object)param.get("district_type"));
        String rule_channel = StrUtil.trimStr((Object)param.get("channel_type"));
        String old_district = StrUtil.trimStr((Object)param.get("old_district"));
        String old_rule_channel = StrUtil.trimStr((Object)param.get("old_rule_channels"));
        String up_node = StrUtil.trimStr((Object)param.get("up_node"));
        String sernoOld = "";
        String sernoNew = "";
        if ("dsn_biz_attribute_rules".equals(relate_tab)) {
            Dsn_Biz_Attribute_Rules ruleAttr = new Dsn_Biz_Attribute_Rules();
            ruleAttr.setAttrRuleUuid(node_no);
            ruleAttr.setBizUuid(UniqueSeq.shortUUID());
            ruleAttr.setRuleNo(rule_no);
            ruleAttr.setTriggerMode(trigger_mode);
            ruleAttr.setRuleType(rule_type);
            ruleAttr.setScheduleOrder(schedule_order);
            ruleAttr.setExceptionHandle(exception_handle);
            ruleAttr.setPatchMemo(trigger_mode);
            ruleAttr.setStartDate(DateUtil.obj2Timestamp((Object)DateUtil.string2Date((Object)startDate)));
            ruleAttr.setEndDate(DateUtil.obj2Timestamp((Object)DateUtil.string2Date((Object)endDate)));
            ruleAttr.setDistrict(district);
            ruleAttr.setRuleChannels(rule_channel);
            this.dao.save((AbsModel)ruleAttr);
            Dsn_Biz_Attribute_Rules attr_rule = new Dsn_Biz_Attribute_Rules();
            attr_rule.where().addEq((ModelField)Dsn_Biz_Attribute_Rules.Field.attr_rule_uuid, (Object)node_no);
            attr_rule.where().addEq((ModelField)Dsn_Biz_Attribute_Rules.Field.rule_channels, (Object)rule_channel);
            attr_rule.where().addEq((ModelField)Dsn_Biz_Attribute_Rules.Field.district, (Object)district);
            attr_rule = (Dsn_Biz_Attribute_Rules)this.dao.findOne((AbsModel)attr_rule);
            sernoNew = attr_rule.getSerno();
            attr_rule = new Dsn_Biz_Attribute_Rules();
            attr_rule.where().addEq((ModelField)Dsn_Biz_Attribute_Rules.Field.attr_rule_uuid, (Object)node_no);
            attr_rule.where().addEq((ModelField)Dsn_Biz_Attribute_Rules.Field.rule_channels, (Object)old_rule_channel);
            attr_rule.where().addEq((ModelField)Dsn_Biz_Attribute_Rules.Field.district, (Object)old_district);
            attr_rule = (Dsn_Biz_Attribute_Rules)this.dao.findOne((AbsModel)attr_rule);
            sernoOld = attr_rule.getSerno();
        } else if ("sip_risk_rules".equals(relate_tab)) {
            String sql = "select * from dsn_structure where node_no = (select up_node from dsn_structure where node_no = ?)";
            QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
            querySql.add((Object)up_node);
            querySql.setSql(sql);
            List dsnList = this.dao.findAll(querySql);
            String node_seq = StrUtil.trimStr(((Map)dsnList.get(0)).get("node_seq"));
            String node_type = StrUtil.trimStr(((Map)dsnList.get(0)).get("node_type"));
            String[] node_seqs = node_seq.split("\\.");
            String risk_uuid = "";
            risk_uuid = "n_tbr_rule".equals(node_type) || "n_bbr_rule".equals(node_type) || "n_syr_rule".equals(node_type) ? node_seqs[node_seqs.length - 4] : node_seqs[node_seqs.length - 2];
            Sip_Risk_Rules rule = new Sip_Risk_Rules();
            rule.setRiskRuleUuid(node_no);
            rule.setRiskUuid(risk_uuid);
            rule.setRuleNo(rule_no);
            rule.setRuleType(rule_type);
            rule.setScheduleOrder(schedule_order);
            rule.setExceptionHandle(exception_handle);
            rule.setPatchMemo(trigger_mode);
            rule.setStartDate(DateUtil.obj2Timestamp((Object)DateUtil.string2Date((Object)startDate)));
            rule.setEndDate(DateUtil.obj2Timestamp((Object)DateUtil.string2Date((Object)endDate)));
            rule.setDistrict(district);
            rule.setRuleChannels(rule_channel);
            this.dao.save((AbsModel)rule);
            Sip_Risk_Rules riskRule = new Sip_Risk_Rules();
            riskRule.where().addEq((ModelField)Sip_Risk_Rules.Field.risk_rule_uuid, (Object)node_no);
            riskRule.where().addEq((ModelField)Sip_Risk_Rules.Field.rule_channels, (Object)rule_channel);
            riskRule.where().addEq((ModelField)Sip_Risk_Rules.Field.district, (Object)district);
            riskRule = (Sip_Risk_Rules)this.dao.findOne((AbsModel)riskRule);
            sernoNew = riskRule.getSerno();
            riskRule = new Sip_Risk_Rules();
            riskRule.where().addEq((ModelField)Sip_Risk_Rules.Field.risk_rule_uuid, (Object)node_no);
            riskRule.where().addEq((ModelField)Sip_Risk_Rules.Field.rule_channels, (Object)old_rule_channel);
            riskRule.where().addEq((ModelField)Sip_Risk_Rules.Field.district, (Object)old_district);
            riskRule = (Sip_Risk_Rules)this.dao.findOne((AbsModel)riskRule);
            sernoOld = riskRule.getSerno();
        }
        Dsn_Dynamic_Data data = new Dsn_Dynamic_Data();
        data.where().addEq((ModelField)Dsn_Dynamic_Data.Field.relate_fk, (Object)sernoOld);
        data.where().addEq((ModelField)Dsn_Dynamic_Data.Field.field_5, (Object)old_rule_channel);
        data.where().addEq((ModelField)Dsn_Dynamic_Data.Field.field_6, (Object)old_district);
        List allDynamic_Data = this.dao.findAll((AbsModel)data);
        if (allDynamic_Data != null || !allDynamic_Data.isEmpty()) {
            for (Dsn_Dynamic_Data d : allDynamic_Data) {
                d.setSerno("");
                d.setRelateFk(sernoNew);
                d.setField5(rule_channel);
                d.setField6(district);
                this.dao.save((AbsModel)d);
            }
        }
        allDynamic_Data = null;
        data = new Dsn_Dynamic_Data();
        data.where().addEq((ModelField)Dsn_Dynamic_Data.Field.relate_fk, (Object)sernoOld);
        data.where().addEq((ModelField)Dsn_Dynamic_Data.Field.field_2, (Object)old_rule_channel);
        data.where().addEq((ModelField)Dsn_Dynamic_Data.Field.field_3, (Object)old_district);
        allDynamic_Data = this.dao.findAll((AbsModel)data);
        if (allDynamic_Data != null || !allDynamic_Data.isEmpty()) {
            for (Dsn_Dynamic_Data d : allDynamic_Data) {
                d.setSerno("");
                d.setRelateFk(sernoNew);
                d.setField2(rule_channel);
                d.setField3(district);
                this.dao.save((AbsModel)d);
            }
        }
        return r.msg();
    }

    @Override
    public ReturnMsg copyRule(String copyFromNodeNo, Map<String, Object> param) {
        Return result = new Return();
        if (StrUtil.isNull((Object)copyFromNodeNo)) {
            result.setFailMsg("\u8bf7\u5148\u590d\u5236\u89c4\u5219\u8282\u70b9\u3002");
            return result.msg();
        }
        Dsn_Structure dsnStructure = new Dsn_Structure();
        dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)copyFromNodeNo);
        dsnStructure = (Dsn_Structure)this.dao.findOne((AbsModel)dsnStructure);
        if (dsnStructure == null || StrUtil.isNull((Object)dsnStructure.getNodeNo())) {
            result.setFailMsg("\u590d\u5236\u7684\u89c4\u5219\u8282\u70b9\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002");
            return result.msg();
        }
        String copyToNodeNo = StrUtil.trimStr((Object)param.get("node_no"));
        if (StrUtil.isNull((Object)copyToNodeNo)) {
            result.setFailMsg("\u7c98\u8d34\u8282\u70b9\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            return result.msg();
        }
        Dsn_Structure upNode = new Dsn_Structure();
        upNode.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)copyToNodeNo);
        upNode = (Dsn_Structure)this.dao.findOne((AbsModel)upNode);
        if (upNode == null || StrUtil.isNull((Object)upNode.getNodeNo())) {
            result.setFailMsg("\u7c98\u8d34\u89c4\u5219\u7236\u8282\u70b9\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002");
            return result.msg();
        }
        dsnStructure.setUpNode(copyToNodeNo);
        dsnStructure.setNodeNo(UniqueSeq.shortUUID());
        this.dao.save((AbsModel)dsnStructure);
        return result.msg();
    }

    @Override
    public ReturnMsg doDelRuleParam(Map<String, Object> param) {
        List checkbox = (List)param.get("checkbox");
        for (Map param1 : checkbox) {
            AbsModel rule;
            String relate_tab = StrUtil.trimStr(param1.get("relate_tab"));
            if ("dsn_biz_attribute_rules".equals(relate_tab)) {
                rule = new Dsn_Biz_Attribute_Rules();
                rule.where().addEq((ModelField)Dsn_Biz_Attribute_Rules.Field.serno, param1.get("serno"));
                this.dao.delete(rule);
                continue;
            }
            if (!"sip_risk_rules".equals(relate_tab)) continue;
            rule = new Sip_Risk_Rules();
            rule.where().addEq((ModelField)Sip_Risk_Rules.Field.serno, param1.get("serno"));
            this.dao.delete(rule);
        }
        return new Return().msg();
    }

    @Override
    public ReturnMsg queryDistrict() {
        Sys_Enum enumSys = new Sys_Enum();
        enumSys.where().addEq((ModelField)Sys_Enum.Field.up_enum, (Object)"district");
        List enumList = this.dao.findAll((AbsModel)enumSys);
        Return r = new Return();
        r.setDataList(enumList, Sys_Enum.class);
        return r.msg();
    }
}

