/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.design.risk.tag;

import com.newtouch.dao.DBHandleCreator;
import com.newtouch.dao.QuerySqlable;
import com.newtouch.log.Ulog;
import com.newtouch.repository.AbsModelRepository;
import com.newtouch.util.string.StrUtil;
import freemarker.core.Environment;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.Version;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="riskAttrInfo")
public class RiskAttrInfoDirective
implements TemplateDirectiveModel {
    @Autowired
    private AbsModelRepository dao;

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        Ulog.info((String)"\u81ea\u5b9a\u4e49\u6807\u7b7e\uff1a\u9669\u79cd\u5c5e\u6027\n");
        String risk_uuid = StrUtil.trimStr(params.get("risk_uuid"));
        String node_seq = StrUtil.trimStr(params.get("node_seq"));
        DefaultObjectWrapperBuilder builder = new DefaultObjectWrapperBuilder(new Version(2, 3, 22));
        List<Map<String, Object>> dsn_StructureList = this.getAttrInfoByNodeSeq(node_seq);
        List handleResult = RiskAttrInfoDirective.groupListByQuantity(dsn_StructureList, 2);
        env.setVariable("attrList", builder.build().wrap((Object)handleResult));
        env.setVariable("attrListNoGroup", builder.build().wrap(dsn_StructureList));
        if (body != null) {
            body.render(env.getOut());
        }
    }

    private List<Map<String, Object>> getAttrInfoByUUID(String risk_uuid, String node_seq) {
        String sql = "select * from dsn_structure where up_node = ?";
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        querySql.add((Object)risk_uuid);
        querySql.setSql(sql);
        List dsn_StructureList = this.dao.findAll(querySql);
        if (null == dsn_StructureList || dsn_StructureList.isEmpty()) {
            Ulog.error((String)"\u67e5\u8be2\u9669\u79cd\u4fe1\u606f\u51fa\u9519\uff01\uff01\uff01");
            throw new RuntimeException("\u67e5\u8be2\u9669\u79cd\u4fe1\u606f\u51fa\u9519\uff01\uff01\uff01");
        }
        return dsn_StructureList;
    }

    private List<Map<String, Object>> getAttrInfoByNodeSeq(String node_seq) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT ").append(" \t* ").append(" FROM ").append(" \tdsn_structure ").append(" WHERE ").append(" \tup_node = ( ").append(" \t\tSELECT ").append(" \t\t\tnode_no ").append(" \t\tFROM ").append(" \t\t\tdsn_structure ").append(" \t\tWHERE ").append(" \t\t\tup_node = ( ").append(" \t\t\t\tSELECT ").append(" \t\t\t\t\tnode_no ").append(" \t\t\t\tFROM ").append(" \t\t\t\t\tdsn_structure ").append(" \t\t\t\tWHERE ").append(" \t\t\t\t\tnode_seq = ? ").append(" \t\t\t) ").append(" \t\tAND node_type = ? ").append(" \t) ").append(" order by display_order asc ");
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        querySql.add((Object)node_seq);
        querySql.add((Object)"n_risk_attr");
        querySql.setSql(sqlBuffer.toString());
        List dsn_StructureList = this.dao.findAll(querySql);
        if (null == dsn_StructureList || dsn_StructureList.isEmpty()) {
            Ulog.error((String)"\u67e5\u8be2\u9669\u79cd\u5c5e\u6027\u51fa\u9519\uff01\uff01\uff01");
            throw new RuntimeException("\u67e5\u8be2\u9669\u79cd\u5c5e\u6027\u51fa\u9519\uff01\uff01\uff01");
        }
        return dsn_StructureList;
    }

    public static List groupListByQuantity(List list, int quantity) {
        if (list == null || list.size() == 0) {
            Ulog.info((String)"\u88ab\u5206\u7ec4\u96c6\u5408\u4e3a\u7a7a");
            return list;
        }
        if (quantity <= 0) {
            new IllegalArgumentException("\u88ab\u5206\u7ec4\u540e\u7684\u5c0f\u7ec4\u4e2d\u5143\u7d20\u4e2a\u6570\u4e0d\u80fd\u5c0f\u4e8e0\uff01");
        }
        ArrayList wrapList = new ArrayList();
        for (int count = 0; count < list.size(); count += quantity) {
            wrapList.add(list.subList(count, count + quantity > list.size() ? list.size() : count + quantity));
        }
        return wrapList;
    }
}

