/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.design.risk.service.imp;

import cn.com.chinalife.model.Dsn_Biz_Attribute_Option;
import cn.com.chinalife.model.Dsn_Dynamic_Data;
import cn.com.chinalife.model.Dsn_Dynamic_Text_Data;
import cn.com.chinalife.model.Dsn_Structure;
import cn.com.chinalife.model.Sip_Product_Risks;
import cn.com.chinalife.model.Sip_Risk_Relation;
import cn.com.chinalife.model.Sip_Risks;
import cn.com.chinalife.model.Sys_Tree_Menu;
import com.newtouch.dao.DBHandleCreator;
import com.newtouch.dao.IDao;
import com.newtouch.dao.QuerySqlable;
import com.newtouch.design.data.service.StructureService;
import com.newtouch.design.file.service.FileManger;
import com.newtouch.design.file.service.IFileService;
import com.newtouch.design.product.service.IProductConfigService;
import com.newtouch.design.risk.service.IRiskService;
import com.newtouch.design.tree.service.IPublicTreeService;
import com.newtouch.log.Ulog;
import com.newtouch.msg.Return;
import com.newtouch.msg.ReturnMsg;
import com.newtouch.msg.exception.BusinessException;
import com.newtouch.repository.AbsModel;
import com.newtouch.repository.AbsModelRepository;
import com.newtouch.repository.ModelField;
import com.newtouch.util.date.DateUtil;
import com.newtouch.util.md5.Md5;
import com.newtouch.util.string.StrUtil;
import com.newtouch.util.uuid.UniqueSeq;
import com.newtouch.web.BaseService;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class RiskServiceImp
extends BaseService
implements IRiskService {
    @Autowired
    private AbsModelRepository dao;
    @Autowired
    private IPublicTreeService tree;
    @Autowired
    @Qualifier(value="localService")
    private IFileService fileService;
    @Autowired
    @Qualifier(value="Sys_File_RepostryDao")
    private IDao fileDao;
    @Autowired
    private StructureService structureService;
    @Autowired
    private IProductConfigService productConfigService;
    private String allowSuffix = "png,gif,jpg,jpeg,bmp,tiff,txt,xml,pdf,zip,rar,doc,ppt,xls,docx,pptx,xlsx,html,htm,webp";
    private long allowSize = 0x500000L;
    private final String FIELD_VALUE = "field_value";

    @Override
    public ReturnMsg queryRisk4Ajax(Map<String, Object> param) {
        Dsn_Structure dsn = new Dsn_Structure();
        dsn.where().addEq((ModelField)Dsn_Structure.Field.node_no, param.get("node_no"));
        Dsn_Structure queryResultDsn = (Dsn_Structure)this.dao.findOne((AbsModel)dsn);
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT ").append("     node_name, ").append("     min(serno) AS serno").append(" FROM ").append("     dsn_structure ").append(" WHERE ").append("     1 = 1 ");
        if (!StrUtil.isNull((Object)param.get("node_type"))) {
            sqlBuffer.append("    AND node_type = ? ");
            querySql.add(param.get("node_type"));
        }
        if (!StrUtil.isNull((Object)param.get("node_name"))) {
            sqlBuffer.append("     AND node_name like ? ");
            querySql.add((Object)("%" + param.get("node_name") + "%"));
        }
        sqlBuffer.append(" AND node_name NOT IN ( ").append("     SELECT ").append("         node_name ").append("     FROM ").append("         dsn_structure ").append("     WHERE ").append("         node_seq LIKE ? ");
        querySql.add((Object)(queryResultDsn.getNodeSeq() + "%"));
        sqlBuffer.append("     AND node_type = ? ");
        querySql.add(param.get("node_type"));
        sqlBuffer.append(" ) ").append(" GROUP BY ").append("     node_name ");
        querySql.setSql(sqlBuffer.toString());
        List resultList = this.dao.findAll(querySql, false);
        for (Map myMap : resultList) {
            myMap.put("code", myMap.get("serno"));
            myMap.put("name", myMap.get("node_name"));
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("leftSelect", resultList);
        map.put("ajaxtype", "select");
        map.put("blankline", false);
        Return msg = new Return();
        msg.getDataList().add(map);
        return msg.msg();
    }

    @Override
    public ReturnMsg queryRootMenu(Dsn_Structure node, Sys_Tree_Menu menuInfo) {
        if (menuInfo == null || StrUtil.isNull((Object)menuInfo.getNodeType())) {
            return new Return().msg();
        }
        Sys_Tree_Menu menu = new Sys_Tree_Menu(true);
        menu.setMenuNo(menuInfo.getNodeType());
        menu = (Sys_Tree_Menu)this.dao.findOne((AbsModel)menu);
        Return ret = new Return();
        ret.getDataTable().put("node_type", menuInfo.getNodeType());
        ret.getDataTable().put("up_node", node.getUpNode());
        ret.getDataTable().put("node_seq", node.getNodeSeq());
        ret.getDataTable().put("node_no", node.getNodeNo());
        return ret.msg();
    }

    @Override
    public ReturnMsg addRisk(Map<String, Object> paramMap) {
        Return msg = new Return();
        String node_no = StrUtil.trimStr((Object)paramMap.get("node_no"));
        Dsn_Structure addRiskTopNode = this.structureService.getOneDsnByNodeNo(node_no);
        String node_type = StrUtil.trimStr((Object)paramMap.get("node_type"));
        List rightSelectList = (List)paramMap.get("rigthSelect");
        if (null == rightSelectList || rightSelectList.isEmpty()) {
            msg.setWarnMsg("\u8bf7\u9009\u62e9\u8981\u6dfb\u52a0\u7684\u9669\u79cd\uff01");
            return msg.msg();
        }
        try {
            for (Map tmpMap : rightSelectList) {
                String riskNodeSerno = StrUtil.trimStr(tmpMap.get("rigthSelect"));
                Dsn_Structure oldAddRiskNode = this.structureService.getOneDsnBySerno(riskNodeSerno);
                if (this.checkSubNodeisExit(addRiskTopNode, oldAddRiskNode)) continue;
                Dsn_Structure newAddRiskNode = this.saveNewRiskNode(oldAddRiskNode, addRiskTopNode, node_type);
                this.handleRiskRelation(addRiskTopNode, newAddRiskNode, node_type);
            }
        }
        catch (BusinessException e) {
            e.printStackTrace();
            msg.setAutoRollback(false);
            msg.setFailMsg("\u6dfb\u52a0\u9669\u79cd\u5931\u8d25\uff01\n\u5f02\u5e38\u4fe1\u606f:" + e.getMessage());
            return msg.msg();
        }
        catch (Exception e) {
            e.printStackTrace();
            msg.setFailMsg("\u6dfb\u52a0\u9669\u79cd\u5931\u8d25\uff01\n\u5f02\u5e38\u4fe1\u606f:" + e.getMessage());
            return msg.msg();
        }
        msg.setSuccessMsg("\u6dfb\u52a0\u9669\u79cd\u6210\u529f\uff01");
        return msg.msg();
    }

    private boolean checkSubNodeisExit(Dsn_Structure addRiskTopNode, Dsn_Structure oldAddRiskNode) {
        addRiskTopNode.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)addRiskTopNode.getNodeNo());
        List subRiskNodes = this.dao.findAll((AbsModel)addRiskTopNode);
        if (subRiskNodes == null || subRiskNodes.isEmpty()) {
            return false;
        }
        for (Dsn_Structure subRiskNode : subRiskNodes) {
            if (!oldAddRiskNode.getNodeNo().equals(subRiskNode.getNodeNo())) continue;
            return true;
        }
        return false;
    }

    private void handleRiskRelation(Dsn_Structure riskTopNode, Dsn_Structure riskNode, String newNodeType) {
        if ("accy_risks".equals(newNodeType) || "n_main_exempt".equals(newNodeType)) {
            this.handRiskRelation(riskTopNode, riskNode, newNodeType);
        }
        if ("main_risks".equals(newNodeType)) {
            this.handProductRiskRelation(riskNode);
        }
    }

    private void handProductRiskRelation(Dsn_Structure riskNode) {
        String[] nodeSeqs = riskNode.getNodeSeq().split("\\.");
        Dsn_Structure mainNode = this.structureService.getOneDsnByNodeNo(nodeSeqs[2]);
        String mainUuid = this.structureService.getRiskuuidByNode(mainNode);
        Sip_Product_Risks product2RiskRelation = new Sip_Product_Risks();
        product2RiskRelation.where().addEq((ModelField)Sip_Product_Risks.Field.product_uuid, (Object)nodeSeqs[0]);
        product2RiskRelation.where().addEq((ModelField)Sip_Product_Risks.Field.risk_uuid, (Object)mainUuid);
        this.dao.delete((AbsModel)product2RiskRelation);
        Sip_Product_Risks product2RiskSave = new Sip_Product_Risks();
        product2RiskSave.setProductUuid(nodeSeqs[0]);
        product2RiskSave.setRiskUuid(mainUuid);
        this.dao.save((AbsModel)product2RiskSave);
    }

    private void handRiskRelation(Dsn_Structure riskTopNode, Dsn_Structure riskNode, String newNodeType) {
        Dsn_Structure mainRiskNode = this.structureService.getOneDsnByNodeNo(riskTopNode.getUpNode());
        String mainUuid = this.structureService.getRiskuuidByNode(mainRiskNode);
        String subUuid = this.structureService.getRiskuuidByNode(riskNode);
        String relationType = "accy_risks".equals(newNodeType) ? "ADDED" : ("n_main_exempt".equals(newNodeType) ? "EXEMPT" : "");
        Sip_Risk_Relation relationDel = new Sip_Risk_Relation();
        relationDel.where().addEq((ModelField)Sip_Risk_Relation.Field.main_risk, (Object)mainUuid);
        relationDel.where().addEq((ModelField)Sip_Risk_Relation.Field.risk_uuid, (Object)subUuid);
        this.dao.delete((AbsModel)relationDel);
        Sip_Risk_Relation relationSave = new Sip_Risk_Relation();
        relationSave.setMainRisk(mainUuid);
        relationSave.setRiskUuid(subUuid);
        relationSave.setRelationType(relationType.equals("") ? "null" : relationType);
        relationSave.setIsRequired("N");
        relationSave.setIsRecommend("");
        this.dao.save((AbsModel)relationSave);
    }

    private Dsn_Structure saveNewRiskNode(Dsn_Structure oldNode, Dsn_Structure newUpNode, String newNodeType) {
        String oldNodeNo = oldNode.getNodeNo();
        if (StringUtils.isBlank((CharSequence)oldNodeNo)) {
            oldNodeNo = UniqueSeq.shortUUID();
        }
        oldNode.setSerno(UniqueSeq.shortUUID());
        Sip_Risks risk = new Sip_Risks();
        Dsn_Structure riskNode = this.structureService.getOneDsnByNodeNo(oldNodeNo);
        try {
            risk.where().addEq((ModelField)Sip_Risks.Field.risk_uuid, (Object)this.structureService.getRiskuuidByNode(riskNode));
            risk = (Sip_Risks)this.dao.findOne((AbsModel)risk);
        }
        catch (BusinessException businessException) {
            // empty catch block
        }
        if (StrUtil.isNull((Object)risk.getSerno())) {
            Ulog.info((String)("\u9669\u79cd[" + riskNode.getNodeName() + "]\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002riskNode:" + oldNodeNo));
            throw new BusinessException("\u9669\u79cd[" + riskNode.getNodeName() + "]\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
        }
        oldNode.setNodeNo(oldNodeNo);
        oldNode.setUpNode(newUpNode.getNodeNo());
        oldNode.setNodeType(newNodeType);
        StringBuffer noSeq = new StringBuffer(newUpNode.getNodeSeq()).append(oldNodeNo).append(".");
        oldNode.setNodeSeq(noSeq.toString());
        oldNode.setDisplayOrder(this.getDisplayOrder(newUpNode.getNodeSeq(), newNodeType));
        this.dao.save((AbsModel)oldNode);
        return oldNode;
    }

    public int getDisplayOrder(String node_seq, String node_type) {
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT ").append("     MAX(display_order)  AS display_order ").append(" FROM ").append("     dsn_structure ").append(" WHERE ").append("     node_type = ? ").append(" AND node_seq LIKE ? ");
        querySql.add((Object)node_type);
        querySql.add((Object)(node_seq + "%"));
        querySql.setSql(sqlBuffer.toString());
        Map resultMap = this.dbHandle().query(querySql);
        int displayOrder = 1;
        if (!StrUtil.isNull(resultMap.get("display_order"))) {
            displayOrder = Integer.parseInt(StrUtil.trimStr(resultMap.get("display_order"))) + 1;
        }
        return displayOrder;
    }

    @Override
    public ReturnMsg queryMainRisk(String node_no) {
        ArrayList<Dsn_Structure> dsnList = new ArrayList<Dsn_Structure>();
        this.tree.iterationTree(node_no, dsnList);
        Return msg = new Return();
        msg.setDataList(dsnList, Dsn_Structure.class);
        return msg.msg();
    }

    public String findFileName(String file_no) {
        String sql = "SELECT s.file_name from sys_file_repostry s where file_no = ? ";
        QuerySqlable querySqlable = DBHandleCreator.getInstance().getQuerySql();
        querySqlable.add((Object)file_no);
        querySqlable.setSql(sql);
        List attrList = this.dao.findAll(querySqlable, false);
        if (attrList != null && attrList.size() > 0) {
            return (String)((Map)attrList.get(0)).get("file_name");
        }
        return "";
    }

    public String findFileDownKeyUUID(String file_no) {
        String sql = "SELECT s.new_file_name from sys_file_repostry s where file_no = ? ";
        QuerySqlable querySqlable = DBHandleCreator.getInstance().getQuerySql();
        querySqlable.add((Object)file_no);
        querySqlable.setSql(sql);
        List attrList = this.dao.findAll(querySqlable, false);
        if (attrList != null && attrList.size() > 0) {
            return (String)((Map)attrList.get(0)).get("new_file_name");
        }
        return "";
    }

    @Override
    public ReturnMsg queryRiskInfo(Dsn_Structure dsn_Structure) {
        Return msg = new Return();
        String up_node = dsn_Structure.getNodeNo();
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        String queryAttr = "select * from dsn_biz_attribute where biz_uuid in ( SELECT node_no from dsn_structure where up_node = ? ) order by display_order ";
        querySql.add((Object)up_node);
        querySql.setSql(queryAttr);
        List attrList = this.dao.findAll(querySql, false);
        attrList.stream().forEach(map -> this.structureService.bizAttributeFieldChange2((Map<String, Object>)map));
        querySql.clearParam();
        if (null != attrList && !attrList.isEmpty()) {
            StringBuffer queryAttrValueBuffer = new StringBuffer();
            queryAttrValueBuffer.append(" SELECT ").append(" * ").append(" FROM ").append(" sip_risks  ").append(" WHERE ").append("     risk_uuid = ? ");
            querySql.add((Object)up_node);
            querySql.setSql(queryAttrValueBuffer.toString());
            List reslutList = this.dao.findAll(querySql, false);
            Map attrValueMap = reslutList.isEmpty() ? null : (Map)reslutList.get(0);
            String queryAttrOptValue = " SELECT DBAO.* FROM DSN_BIZ_ATTRIBUTE DBA  LEFT JOIN DSN_BIZ_ATTRIBUTE_OPTION DBAO  ON DBA.BIZ_UUID=DBAO.BIZ_UUID  WHERE DBA.BIZ_UUID IN ( SELECT NODE_NO FROM DSN_STRUCTURE WHERE UP_NODE = ? ) ORDER BY OPTION_ORDER ";
            querySql.add((Object)up_node);
            querySql.setSql(queryAttrOptValue);
            List attrOptValueList = this.dao.findAll(querySql, false);
            if (null != attrValueMap && !attrValueMap.isEmpty()) {
                for (Map tmpMap : attrList) {
                    this.structureService.bizAttributeFieldChange2(tmpMap);
                    if (!"sip_risks".equalsIgnoreCase(StrUtil.trimStr(tmpMap.get("stored_tab")))) continue;
                    tmpMap.put("field_value", attrValueMap.get(StrUtil.trimStr(tmpMap.get("stored_field"))));
                    if (null == attrOptValueList || attrOptValueList.isEmpty()) continue;
                    tmpMap.put("attrOptValueList", this.getThisAttrOptValueList(StrUtil.trimStr(tmpMap.get("biz_uuid")), attrOptValueList));
                }
            }
            for (Map tmpMap : attrList) {
                if (tmpMap.containsKey("field_value")) continue;
                if (null != attrOptValueList && !attrOptValueList.isEmpty()) {
                    tmpMap.put("attrOptValueList", this.getThisAttrOptValueList(StrUtil.trimStr(tmpMap.get("biz_uuid")), attrOptValueList));
                }
                querySql.clearParam();
                String stored_tab = StrUtil.trimStr(tmpMap.get("stored_tab"));
                String stored_field = StrUtil.trimStr(tmpMap.get("stored_field"));
                queryAttrValueBuffer = new StringBuffer();
                if ("dsn_dynamic_data".equalsIgnoreCase(stored_tab)) {
                    querySql.clearParam();
                    queryAttrValueBuffer.append("SELECT " + stored_field + " from dsn_dynamic_data WHERE ").append(" data_flag = ? and relate_tab =?  and relate_field =?  and relate_fk =?  ");
                    querySql.add((Object)"1");
                    querySql.add((Object)"dsn_biz_attribute");
                    querySql.add((Object)"biz_uuid");
                    querySql.add((Object)StrUtil.trimStr(tmpMap.get("biz_uuid")));
                } else if ("sys_file_repostry".equalsIgnoreCase(stored_tab)) {
                    querySql.clearParam();
                    queryAttrValueBuffer.append("SELECT * from sys_file_repostry where file_no = ?");
                    querySql.add((Object)up_node);
                } else if ("sip_risk_relation".equalsIgnoreCase(stored_tab)) {
                    querySql.clearParam();
                    queryAttrValueBuffer.append("SELECT * from sip_risk_relation where risk_uuid = ?");
                    String parentNo = StrUtil.trimStr(dsn_Structure.getOtherProperty().get("tId"));
                    Dsn_Structure dsn = new Dsn_Structure();
                    dsn.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)parentNo);
                    dsn.where().addIn((ModelField)Dsn_Structure.Field.node_type, new String[]{"n_risk_detail", "n_accy_detail"});
                    dsn = (Dsn_Structure)this.dao.findOne((AbsModel)dsn);
                    queryAttrValueBuffer.append(" and main_risk = ?");
                    querySql.add((Object)up_node);
                    querySql.add((Object)dsn.getNodeNo());
                } else {
                    if ("dsn_dynamic_text_data".equalsIgnoreCase(stored_tab)) {
                        Dsn_Dynamic_Text_Data textData = new Dsn_Dynamic_Text_Data();
                        textData.where().addEq((ModelField)Dsn_Dynamic_Text_Data.Field.text_key, tmpMap.get("biz_uuid"));
                        textData = (Dsn_Dynamic_Text_Data)this.dao.findOne((AbsModel)textData);
                        String str = "";
                        if (!StrUtil.isNull((Object)textData.getTextValue())) {
                            str = textData.getTextValue().replaceAll("<br>", "\r");
                        }
                        tmpMap.put("field_value", str);
                        continue;
                    }
                    Ulog.error((String)("\u5728\u6570\u636e\u5e93\u4e2d\u914d\u7f6e\u7684\u5b58\u50a8\u8868\u662f[" + stored_tab + "]\u672a\u627e\u5230\u8be5\u5c5e\u6027\u6240\u914d\u7f6e\u7684\u5b58\u50a8\u8868\uff01\uff01\uff01"));
                    continue;
                }
                querySql.setSql(queryAttrValueBuffer.toString());
                reslutList = this.dao.findAll(querySql, false);
                attrValueMap = reslutList.isEmpty() ? null : (Map)reslutList.get(0);
                if (null == attrValueMap || attrValueMap.isEmpty()) continue;
                tmpMap.put("field_value", attrValueMap.get(stored_field));
            }
        }
        this.getFileInfo(attrList, up_node);
        msg.setDataList(attrList);
        return msg.msg();
    }

    private Object getThisAttrOptValueList(Object object, List<Map<String, Object>> attrOptValueList) {
        LinkedList<Map<String, Object>> thisAttrOptValueList = new LinkedList<Map<String, Object>>();
        for (Map<String, Object> attrOptValue : attrOptValueList) {
            if (!object.equals(attrOptValue.get("biz_uuid"))) continue;
            thisAttrOptValueList.add(attrOptValue);
        }
        return thisAttrOptValueList;
    }

    @Override
    public ReturnMsg saveRiskInfo(Map<String, Object> paramMap, Sip_Risks sipRisks4Save) {
        this.preDeal(sipRisks4Save);
        String flag = StrUtil.trimStr((Object)paramMap.get("flag"));
        Return checkMsg = sipRisks4Save.checkValue();
        if (!checkMsg.isSuccessflag()) {
            return checkMsg.msg();
        }
        String current_node_no = StrUtil.trimStr((Object)paramMap.get("current_node_no"));
        String product_node_no = StrUtil.trimStr((Object)paramMap.get("root_node_no"));
        this.exchangFileInfo(current_node_no, paramMap);
        this.renameRiskNode(sipRisks4Save.getRiskName(), current_node_no);
        String isMainRisk = StrUtil.trimStr((Object)paramMap.get("is_main_risk"));
        if (StrUtil.isNull((Object)isMainRisk)) {
            checkMsg.setFailMsg("\u3010\u662f\u5426\u4e3b\u9669\u3011|\u4e3b\u9644\u9669\u7c7b\u578b\u5fc5\u987b\u8bbe\u7f6e\uff01");
            return checkMsg.msg();
        }
        String bizUUUD4RiskType = StrUtil.trimStr((Object)paramMap.get("bizUUUD4RiskType"));
        boolean mainRiskFlag = this.checkMainRisk(isMainRisk, bizUUUD4RiskType);
        if (mainRiskFlag) {
            this.maintainProductAndRiskRelation(product_node_no, current_node_no);
        } else if ("A".equals(isMainRisk)) {
            this.maintainSipRiskRelation(paramMap);
        }
        if (StrUtil.isNull((Object)paramMap.get("no_channel"))) {
            String string = StrUtil.trimStr((Object)paramMap.get("parent_risk_uuid"));
        }
        this.dealdsn_dynamic_data(paramMap, current_node_no);
        this.saveMarkDown(paramMap);
        sipRisks4Save.where().addEq((ModelField)Sip_Risks.Field.risk_uuid, (Object)sipRisks4Save.getRiskUuid());
        if ((null == flag || "".equalsIgnoreCase(flag)) && !StrUtil.isNull((Object)sipRisks4Save.getRiskUuid())) {
            this.dao.update((AbsModel)sipRisks4Save);
        } else {
            sipRisks4Save.where().addEq((ModelField)Sip_Risks.Field.risk_uuid, (Object)sipRisks4Save.getRiskUuid());
            this.dao.delete((AbsModel)sipRisks4Save);
            this.dao.save((AbsModel)sipRisks4Save);
        }
        return new Return().msg();
    }

    private void renameRiskNode(String riskName, String riskDetailNodeno) {
        if (!StrUtil.isNull((Object)riskName)) {
            Dsn_Structure dsn = new Dsn_Structure();
            dsn.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)riskDetailNodeno);
            dsn = (Dsn_Structure)this.dao.findOne((AbsModel)dsn);
            dsn.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)dsn.getUpNode());
            List dsnList = this.dao.findAll((AbsModel)dsn);
            for (Dsn_Structure dsn1 : dsnList) {
                Dsn_Structure mdfDsn = new Dsn_Structure();
                mdfDsn.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)dsn1.getNodeNo());
                mdfDsn.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)dsn1.getUpNode());
                mdfDsn.where().addEq((ModelField)Dsn_Structure.Field.serno, (Object)dsn1.getSerno());
                mdfDsn.setNodeName(riskName);
                this.dao.update((AbsModel)mdfDsn);
            }
        }
    }

    private void preDeal(Sip_Risks sipRisks4Save) {
        String endDate;
        String startDate;
        String riskName;
        String isMainRisk;
        String riskNo;
        String policyId = StrUtil.trimStr((Object)sipRisks4Save.getPolicyId());
        if (StrUtil.isNull((Object)policyId)) {
            sipRisks4Save.setPolicyId("\u672a\u77e5");
        }
        if (StrUtil.isNull((Object)(riskNo = StrUtil.trimStr((Object)sipRisks4Save.getRiskNo())))) {
            // empty if block
        }
        if (StrUtil.isNull((Object)(isMainRisk = StrUtil.trimStr((Object)sipRisks4Save.getIsMainRisk())))) {
            sipRisks4Save.setIsMainRisk("M");
        }
        if (StrUtil.isNull((Object)(riskName = StrUtil.trimStr((Object)sipRisks4Save.getRiskName())))) {
            // empty if block
        }
        if (StrUtil.isNull((Object)(startDate = StrUtil.trimStr((Object)sipRisks4Save.getStartDate())))) {
            sipRisks4Save.setStartDate(new java.util.Date());
        }
        if (StrUtil.isNull((Object)(endDate = StrUtil.trimStr((Object)sipRisks4Save.getEndDate())))) {
            sipRisks4Save.setEndDate(new java.util.Date());
        }
    }

    private void dealdsn_dynamic_data(Map<String, Object> paramMap, String current_node_no) {
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        String queryAttr = "select * from dsn_biz_attribute where biz_uuid in ( SELECT node_no from dsn_structure where up_node = ? )  and stored_tab = ?  order by display_order ";
        querySql.add((Object)current_node_no);
        querySql.add((Object)"dsn_dynamic_data");
        querySql.setSql(queryAttr);
        List attrList = this.dao.findAll(querySql, false);
        if (attrList == null || attrList.isEmpty()) {
            return;
        }
        String biz_uuid = "";
        String storedField = "";
        for (Map dsn_biz_attribute : attrList) {
            if (StrUtil.isNull(dsn_biz_attribute.get("biz_uuid"))) continue;
            biz_uuid = StrUtil.trimStr(dsn_biz_attribute.get("biz_uuid"));
            Dsn_Dynamic_Data dynamicData = new Dsn_Dynamic_Data();
            dynamicData.where().addEq((ModelField)Dsn_Dynamic_Data.Field.relate_tab, (Object)"dsn_biz_attribute");
            dynamicData.where().addEq((ModelField)Dsn_Dynamic_Data.Field.relate_field, (Object)"biz_uuid");
            dynamicData.where().addEq((ModelField)Dsn_Dynamic_Data.Field.relate_fk, (Object)biz_uuid);
            dynamicData = (Dsn_Dynamic_Data)this.dao.findOne((AbsModel)dynamicData);
            if (!StrUtil.isNull((Object)dynamicData.getSerno())) {
                Dsn_Dynamic_Data dsn_Dynamic4Delete = new Dsn_Dynamic_Data();
                dsn_Dynamic4Delete.where().addEq((ModelField)Dsn_Dynamic_Data.Field.serno, (Object)dynamicData.getSerno());
                this.dao.delete((AbsModel)dsn_Dynamic4Delete);
            }
            Dsn_Dynamic_Data dynamicDataSave = new Dsn_Dynamic_Data();
            dynamicDataSave.setRelateTab("dsn_biz_attribute");
            dynamicDataSave.setRelateField("biz_uuid");
            dynamicDataSave.setRelateFk(biz_uuid);
            storedField = StrUtil.trimStr(dsn_biz_attribute.get("stored_field"));
            try {
                BeanUtils.setProperty((Object)((Object)dynamicDataSave), (String)storedField.replace("_", ""), (Object)StrUtil.trimStr((Object)paramMap.get(storedField)));
            }
            catch (Exception e) {
                Ulog.error((String)("\u52a8\u6001\u8868\u5b58\u50a8\u9669\u79cd\u4fe1\u606f\u5f02\u5e38\uff1a\uff1a\u52a8\u6001\u8868\u5b57\u6bb5[" + storedField + "]\u5185\u5bb9\u3010" + StrUtil.trimStr((Object)paramMap.get("attr_no")) + "\u3011"));
                e.printStackTrace();
            }
            this.dao.save((AbsModel)dynamicDataSave);
        }
    }

    public boolean checkMainRisk(String isMainRisk, String bizUUUD4RiskType) {
        boolean mainRiskFlag = false;
        List<Dsn_Biz_Attribute_Option> dsnBizAttributeOptionList = this.queryDic4RiskType(bizUUUD4RiskType);
        if (null != dsnBizAttributeOptionList && !dsnBizAttributeOptionList.isEmpty()) {
            for (Dsn_Biz_Attribute_Option dsnBizAttributeOption : dsnBizAttributeOptionList) {
                String optionValue = dsnBizAttributeOption.getOptionValue();
                String optionName = dsnBizAttributeOption.getOptionName();
                if (!isMainRisk.equals(optionValue) || !"\u4e3b\u9669".equals(optionName)) continue;
                mainRiskFlag = true;
            }
        } else if ("M".equals(StrUtil.trimStr((Object)isMainRisk)) || "1".equals(StrUtil.trimStr((Object)isMainRisk)) || "\u662f".equals(StrUtil.trimStr((Object)isMainRisk))) {
            mainRiskFlag = true;
        }
        return mainRiskFlag;
    }

    private List<Dsn_Biz_Attribute_Option> queryDic4RiskType(String bizUUID) {
        Dsn_Biz_Attribute_Option dsnBizAttributeOption4Query = new Dsn_Biz_Attribute_Option();
        dsnBizAttributeOption4Query.where().addEq((ModelField)Dsn_Biz_Attribute_Option.Field.biz_uuid, (Object)bizUUID);
        List dsnBizAttributeOptionList = this.dao.findAll((AbsModel)dsnBizAttributeOption4Query);
        if (null != dsnBizAttributeOptionList && !dsnBizAttributeOptionList.isEmpty()) {
            return dsnBizAttributeOptionList;
        }
        return null;
    }

    @Override
    public void saveMarkDown(Map<String, Object> paramMap) {
        String current_node_no = StrUtil.trimStr((Object)paramMap.get("current_node_no"));
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        StringBuilder queryAttr = new StringBuilder();
        queryAttr.append("select attr.stored_field,attr.ui_type,attr.biz_uuid from dsn_biz_attribute attr , dsn_structure str").append(" where attr.biz_uuid = str.node_no and up_node = ? and attr.ui_type = ? ").append("order by attr.display_order ");
        querySql.add((Object)current_node_no);
        querySql.add((Object)"markdown");
        querySql.setSql(queryAttr.toString());
        List attrList = this.dao.findAll(querySql, false);
        HashMap<String, Map> uiTypeAttrMap = new HashMap<String, Map>();
        for (Map map : attrList) {
            uiTypeAttrMap.put((String)map.get("biz_uuid"), map);
        }
        ArrayList<Dsn_Dynamic_Text_Data> textDataList = new ArrayList<Dsn_Dynamic_Text_Data>();
        for (String paramKey : paramMap.keySet()) {
            Map uiTypeNode = (Map)uiTypeAttrMap.get(paramKey);
            if (uiTypeNode == null) continue;
            Dsn_Dynamic_Text_Data textData = new Dsn_Dynamic_Text_Data();
            textData.setTextKey((String)uiTypeNode.get("biz_uuid"));
            textData.setTextValue(StrUtil.isNull((Object)paramMap.get(paramKey)) ? "<br>" : (String)paramMap.get(paramKey));
            textDataList.add(textData);
            textData.where().addEq((ModelField)Dsn_Dynamic_Text_Data.Field.text_key, (Object)((String)uiTypeNode.get("biz_uuid")));
            this.dao.delete((AbsModel)textData);
        }
        this.dao.save(textDataList);
    }

    private void maintainProductAndRiskRelation(String product_node_no, String current_node_no) {
        Sip_Product_Risks sip_product_risks4Query = new Sip_Product_Risks();
        sip_product_risks4Query.where().addEq((ModelField)Sip_Product_Risks.Field.product_uuid, (Object)product_node_no);
        sip_product_risks4Query.where().addEq((ModelField)Sip_Product_Risks.Field.risk_uuid, (Object)current_node_no);
        List sip_product_riskses = this.dao.findAll((AbsModel)sip_product_risks4Query);
        if (null == sip_product_riskses || sip_product_riskses.isEmpty()) {
            Sip_Product_Risks sip_product_risks4Insert = new Sip_Product_Risks();
            sip_product_risks4Insert.setProductUuid(product_node_no);
            sip_product_risks4Insert.setRiskUuid(current_node_no);
            this.dao.save((AbsModel)sip_product_risks4Insert);
        } else {
            Sip_Product_Risks sip_product_risks4Update = new Sip_Product_Risks();
            sip_product_risks4Update.where().addEq((ModelField)Sip_Product_Risks.Field.product_uuid, (Object)product_node_no);
            sip_product_risks4Update.where().addEq((ModelField)Sip_Product_Risks.Field.risk_uuid, (Object)current_node_no);
            this.dao.update((AbsModel)sip_product_risks4Update);
        }
    }

    private void maintainSipRiskRelation(Map<String, Object> paramMap) {
        String mainRisk = StrUtil.trimStr((Object)paramMap.get("parent_risk_uuid"));
        String riskUUID = StrUtil.trimStr((Object)paramMap.get("current_node_no"));
        String riskOrderRelation = StrUtil.trimStr((Object)paramMap.get("risk_order_relation"));
        String isMainRisk = StrUtil.trimStr((Object)paramMap.get("is_main_risk"));
        String bizUUUD4RiskType = StrUtil.trimStr((Object)paramMap.get("bizUUUD4RiskType"));
        String relationType = this.getRelationType(StrUtil.trimStr((Object)paramMap.get("bizUUUD4RiskType")), isMainRisk);
        String isRequired = StrUtil.trimStr((Object)paramMap.get("is_required"));
        String isRecommend = StrUtil.trimStr((Object)paramMap.get("is_recommend"));
        if ("S".equals(isRequired)) {
            isRequired = "N";
        } else if ("M".equals(isRequired)) {
            isRequired = "Y";
        }
        Date startDate = StrUtil.isNull((Object)paramMap.get("start_date")) ? DateUtil.sysDate() : DateUtil.object2Date((Object)paramMap.get("start_date"));
        Date endDate = StrUtil.isNull((Object)paramMap.get("end_date")) ? DateUtil.sysDate() : DateUtil.object2Date((Object)paramMap.get("end_date"));
        this.dealRiskRelation(mainRisk, riskUUID, riskOrderRelation, relationType, isRequired, isRecommend, startDate, endDate);
    }

    private void dealRiskRelation(String mainRiskUUid, String subRiskUUID, String riskOrderRelation, String relationType, String isRequired, String isRecommend, java.util.Date startDate, java.util.Date endDate) {
        Sip_Risk_Relation sipRiskRelation4Query = new Sip_Risk_Relation();
        sipRiskRelation4Query.where().addEq((ModelField)Sip_Risk_Relation.Field.main_risk, (Object)mainRiskUUid);
        sipRiskRelation4Query.where().addEq((ModelField)Sip_Risk_Relation.Field.risk_uuid, (Object)subRiskUUID);
        Sip_Risk_Relation sipRiskRelation4Result = (Sip_Risk_Relation)this.dao.findOne((AbsModel)sipRiskRelation4Query);
        if (!StrUtil.isNull((Object)isRequired)) {
            Sip_Risk_Relation sipRiskRelation4Delete = new Sip_Risk_Relation();
            sipRiskRelation4Delete.where().addEq((ModelField)Sip_Risk_Relation.Field.main_risk, (Object)mainRiskUUid);
            sipRiskRelation4Delete.where().addEq((ModelField)Sip_Risk_Relation.Field.risk_uuid, (Object)subRiskUUID);
            this.dao.delete((AbsModel)sipRiskRelation4Delete);
        }
        if (StrUtil.isNull((Object)sipRiskRelation4Result.getSerno()) || !StrUtil.isNull((Object)isRequired)) {
            Sip_Risk_Relation sipRiskRelation4Insert = new Sip_Risk_Relation();
            sipRiskRelation4Insert.setMainRisk(mainRiskUUid);
            sipRiskRelation4Insert.setRiskUuid(subRiskUUID);
            sipRiskRelation4Insert.setRelationType(relationType.equals("") ? "null" : relationType);
            sipRiskRelation4Insert.setIsRequired(isRequired);
            sipRiskRelation4Insert.setIsRecommend(isRecommend);
            this.dao.save((AbsModel)sipRiskRelation4Insert);
        }
    }

    private String getRelationType(String bizUUUD4RiskType, String isMainRisk) {
        List<Dsn_Biz_Attribute_Option> dsnBizAttributeOptionList = this.queryDic4RiskType(bizUUUD4RiskType);
        String relationType = "";
        if (null == dsnBizAttributeOptionList || dsnBizAttributeOptionList.isEmpty()) {
            relationType = "2".equals(isMainRisk) || "A".equals(isMainRisk) ? "ADDED" : ("3".equals(isMainRisk) || "W".equals(isMainRisk) ? "EXEMPT" : "");
        } else {
            for (Dsn_Biz_Attribute_Option dsnBizAttributeOption : dsnBizAttributeOptionList) {
                String optionName = dsnBizAttributeOption.getOptionName();
                String optionValue = dsnBizAttributeOption.getOptionValue();
                if (optionName.equals("\u9644\u52a0\u9669") && isMainRisk.equals(optionValue)) {
                    relationType = "ADDED";
                    break;
                }
                if (optionName.equals("\u8c41\u514d\u9669") && isMainRisk.equals(optionValue)) {
                    relationType = "EXEMPT";
                    break;
                }
                if (!optionName.equals("\u5b50\u9669") || !isMainRisk.equals(optionValue)) continue;
                relationType = "SUB";
                break;
            }
        }
        return relationType;
    }

    @Override
    public ReturnMsg saveFile(Map<String, Object> paramMap) {
        Return res = new Return();
        String fileNo = StrUtil.trimStr((Object)paramMap.get("file_node_no"));
        MultipartFile file = (MultipartFile)paramMap.get("file");
        String localFileSize = StrUtil.trimStr((Object)paramMap.get("size"));
        if (StringUtils.isBlank((CharSequence)FileManger.getRemoteSendFileUrl())) {
            return this.uploadFileAndSave(file, fileNo, null, localFileSize);
        }
        IFileService iFileService = FileManger.getUpLoadFileService();
        try {
            res = iFileService.remoteUpLoadFileToServer(fileNo, file.getOriginalFilename(), Long.parseLong(localFileSize), file.getInputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
            res.setFailMsg(e.toString());
        }
        return res.msg();
    }

    public ReturnMsg uploadFileAndSave(MultipartFile file, String fileNo, String md5, String localFileSize) {
        long fileSize;
        String fileName = file.getOriginalFilename();
        Return msg = this.check(fileName, fileSize = file.getSize(), localFileSize);
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        try {
            if (!StrUtil.isNull((Object)md5) && !md5.equals(Md5.getFileMD5((InputStream)file.getInputStream()))) {
                msg.setFailMsg("\u4e0a\u4f20\u6587\u4ef6\u4e0d\u5b8c\u6574\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
                return msg.msg();
            }
            msg = this.fileService.saveFile(fileNo, fileName, fileSize, file.getInputStream());
            return msg.msg();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Return check(String fileName, long fileSize, String localFileSize) {
        String suffix;
        Return msg = new Return();
        if (StrUtil.isNull((Object)fileName)) {
            msg.setFailMsg("\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StrUtil.isNull((Object)localFileSize) && fileSize != Long.parseLong(localFileSize)) {
            msg.setFailMsg("\u4e0a\u4f20\u6587\u4ef6\u4e3a[" + Long.parseLong(localFileSize) / 1024L + "]KB\uff0c\u5b9e\u9645\u63a5\u6536[" + fileSize / 1024L + "]KB\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
        }
        if (fileName.indexOf(".") < 0) {
            msg.setFailMsg("\u53ea\u80fd\u4e0a\u4f20\u6269\u5c55\u540d\u4e3a[" + this.allowSuffix + "]\u7684\u6587\u4ef6");
        }
        if (this.allowSuffix.indexOf(suffix = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase()) == -1) {
            msg.setFailMsg("\u53ea\u80fd\u4e0a\u4f20\u6269\u5c55\u540d\u4e3a[" + this.allowSuffix + "]\u7684\u6587\u4ef6");
        }
        if (fileSize <= 0L) {
            msg.setFailMsg("\u6587\u4ef6\u5fc5\u987b\u5927\u4e8e0KB");
        }
        if (fileSize > this.allowSize) {
            msg.setFailMsg("\u6587\u4ef6\u6700\u5927\u4e0d\u80fd\u8d85\u8fc7[2M]");
        }
        return msg;
    }

    @Override
    public List<Map<String, Object>> getFileInfo(List<Map<String, Object>> params, String curentNode_no) {
        params.stream().forEach(x -> {
            if (x.get("ui_type").equals("file")) {
                x.put("node_no", x.get("biz_uuid"));
                x.put("file_no_url", x.get("biz_uuid"));
                x.put("file_name", this.findFileName((String)x.get("biz_uuid")));
            }
        });
        return params;
    }

    @Override
    public void exchangFileInfo(String current_node_no, Map<String, Object> request) {
        Dsn_Structure dsn_structure = new Dsn_Structure();
        dsn_structure.setNodeNo(current_node_no);
        ReturnMsg returnMsg = this.queryRiskInfo(dsn_structure);
        if (returnMsg.isSuccessflag()) {
            List list_map = returnMsg.getDataList();
            list_map.parallelStream().forEach(param -> {
                if (param.get("ui_type").equals("file")) {
                    String tableParam = (String)param.get("attr_no");
                    String downLoadfileKey = (String)param.get("downLoadfileKey");
                    request.put(tableParam, downLoadfileKey);
                }
            });
        }
    }
}

