/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.design.risk.service.imp;

import cn.com.chinalife.model.Dsn_Structure;
import com.newtouch.dao.DBHandleCreator;
import com.newtouch.dao.QuerySqlable;
import com.newtouch.design.product.service.IProductConfigService;
import com.newtouch.design.product.service.imp.RiskCopyService;
import com.newtouch.design.risk.service.IRiskCopyService;
import com.newtouch.msg.Return;
import com.newtouch.msg.ReturnMsg;
import com.newtouch.repository.AbsModel;
import com.newtouch.repository.AbsModelRepository;
import com.newtouch.repository.ModelField;
import com.newtouch.util.string.StrUtil;
import com.newtouch.util.uuid.UniqueSeq;
import com.newtouch.web.BaseService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RiskCopyServiceImp
extends BaseService
implements IRiskCopyService {
    @Autowired
    private AbsModelRepository repository;
    @Autowired
    private IProductConfigService productConfigServiceImp;
    @Autowired
    private RiskCopyService riskCopyService;

    @Override
    public ReturnMsg doRiskCopy(Map<String, Object> request) {
        Return ress = new Return();
        String node_name = (String)request.get("node_name");
        String node_seq = (String)request.get("node_seq");
        String oldNodeNo = (String)request.get("node_no");
        String nodeType = (String)request.get("node_type");
        String parentSeq = this.getParentSeq(node_seq);
        String newNode = UniqueSeq.shortUUID();
        String currentNodeSeq = parentSeq + "." + newNode + ".";
        this.productConfigServiceImp.changeChildNodeNoAndSeriNoAndAttributes(node_name, oldNodeNo, currentNodeSeq, newNode);
        this.riskCopyService.handleRiskInfo(oldNodeNo, newNode, node_name);
        Dsn_Structure dsn_structure = new Dsn_Structure();
        dsn_structure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)oldNodeNo);
        dsn_structure = (Dsn_Structure)this.repository.findOne((AbsModel)dsn_structure);
        String serno = this.saveDsn(dsn_structure, newNode, parentSeq, node_name, nodeType);
        ress.setSuccessMsg("\u590d\u5236\u6210\u529f\uff0c\u8bf7\u4ece\u3010\u5df2\u6709\u9669\u79cd\u3011\u5217\u8868\u4e2d\u8fdb\u884c\u6dfb\u52a0\u3002");
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("serno", serno);
        ress.setDataTable(result);
        return ress.msg();
    }

    private String getParentSeq(String node_seq) {
        int endIndex = node_seq.lastIndexOf(".");
        String endString = node_seq.substring(0, endIndex);
        endIndex = endString.lastIndexOf(".");
        return endString.substring(0, endIndex);
    }

    String saveDsn(Dsn_Structure dsn_structure, String newNode, String parentSeq, String newRiskName, String node_type) {
        String serno = UniqueSeq.shortUUID();
        dsn_structure.setSerno(serno);
        dsn_structure.setNodeNo(newNode);
        dsn_structure.setNodeName(newRiskName);
        dsn_structure.setUpNode("root");
        dsn_structure.setNodeSeq(newNode + ".");
        dsn_structure.setDisplayOrder(this.getDisplayOrder(dsn_structure.getNodeSeq(), node_type));
        this.repository.save((AbsModel)dsn_structure);
        return serno;
    }

    public int getDisplayOrder(String node_seq, String node_type) {
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT  DISPLAY_ORDER   FROM    DSN_STRUCTURE ").append(" WHERE ").append(" node_type = ?  AND node_seq LIKE ? ").append(" ORDER BY display_order DESC ");
        querySql.add((Object)node_type);
        querySql.add((Object)(node_seq + "%"));
        querySql.setSql(sqlBuffer.toString());
        List resultList = this.repository.findAll(querySql, false);
        int displayOrder = 1;
        if (null != resultList && !resultList.isEmpty()) {
            displayOrder = Integer.parseInt(StrUtil.trimStr(((Map)resultList.get(0)).get("display_order"))) + 1;
        }
        return displayOrder;
    }

    public void exchangeRequestParam(Map<String, Object> paramMap) {
        Dsn_Structure dsn_structure = new Dsn_Structure();
        dsn_structure.setAppenWhere(true);
        dsn_structure.setNodeNo((String)paramMap.get("node_no"));
        Dsn_Structure dsn_structures = (Dsn_Structure)this.repository.findOne((AbsModel)dsn_structure);
        dsn_structure.clear();
        String node_no = dsn_structures.getUpNode();
        dsn_structure.setNodeNo(node_no);
        dsn_structures = (Dsn_Structure)this.repository.findOne((AbsModel)dsn_structure);
        paramMap.put("node_seq", dsn_structures.getNodeSeq());
        paramMap.put("up_node", dsn_structures.getNodeNo());
        paramMap.put("node_type", dsn_structures.getNodeType());
        paramMap.put("node_no", dsn_structures.getNodeNo());
    }
}

