/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.design.risk.service.imp;

import cn.com.chinalife.model.Dsn_Dynamic_Data;
import cn.com.chinalife.model.Dsn_Structure;
import cn.com.chinalife.model.Sip_Risks;
import com.newtouch.dao.DBHandleCreator;
import com.newtouch.dao.IDao;
import com.newtouch.dao.QuerySqlable;
import com.newtouch.design.risk.service.IPageService;
import com.newtouch.design.risk.tag.RiskAttrDirective;
import com.newtouch.freemarker.FreeMarkerConfig;
import com.newtouch.msg.Return;
import com.newtouch.msg.ReturnMsg;
import com.newtouch.repository.AbsModel;
import com.newtouch.repository.AbsModelRepository;
import com.newtouch.repository.ModelField;
import com.newtouch.util.date.DateUtil;
import com.newtouch.util.json.JsonUtilOld;
import com.newtouch.util.path.PathFactory;
import com.newtouch.util.properties.PropertiesUtil;
import com.newtouch.util.string.StrUtil;
import com.newtouch.util.uuid.UniqueSeq;
import com.newtouch.web.BaseService;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateDirectiveModel;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class PageServiceImp
extends BaseService
implements IPageService {
    @Autowired
    private AbsModelRepository dao;
    @Autowired
    private FreeMarkerConfig freemarkerConfig;
    @Autowired
    private RiskAttrDirective riskAttr;
    @Autowired
    @Qualifier(value="Sys_File_RepostryDao")
    private IDao file_RepostryDao;

    @Override
    public List<Sip_Risks> queryRiskInfo(Dsn_Structure dsn_Structure) {
        String node_no = dsn_Structure.getNodeNo();
        String sql = "select * from sip_risks where risk_uuid = (select node_no from dsn_structure where up_node = ? and node_type = ? )";
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        querySql.add((Object)node_no);
        querySql.add((Object)"n_risk_detail");
        querySql.setSql(sql);
        List sip_RisksList = this.dao.findAll(querySql, Sip_Risks.class, false);
        return sip_RisksList;
    }

    @Override
    public ReturnMsg buildRiskPage(Sip_Risks sip_Risks, Dsn_Structure dsn_Structure) throws Exception {
        Return msg = new Return();
        String policy_id = sip_Risks.getPolicyId();
        Map<String, Object> propertyMap = this.getBuildPageProperties();
        String[] file_namesArray = (String[])propertyMap.get("file_names");
        List<String> file_namesList = Arrays.asList(file_namesArray);
        String page_type = StrUtil.trimStr((Object)propertyMap.get("page_type"));
        String file_type = StrUtil.trimStr((Object)propertyMap.get("file_type"));
        String path_old = PathFactory.getProperty() + "buildPage/";
        String ftlPath_old = "newtouch/risk/mainRiskPage/" + page_type + "/";
        String ftlPath = "";
        String path = "";
        for (String file_name : file_namesList) {
            ftlPath = ftlPath_old + file_name + ".ftl";
            if (!"Risk".equalsIgnoreCase(file_name)) {
                path = path_old + policy_id + "/";
            } else {
                file_name = file_name + policy_id;
                path = path_old;
            }
            msg = this.buildPageByFtl(path, ftlPath, sip_Risks, dsn_Structure, file_type, file_name);
        }
        msg.isSuccessflag();
        return msg.msg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Return buildPageByFtl(String path, String ftlPath, Sip_Risks sip_Risks, Dsn_Structure dsn_Structure, String file_type, String file_name) throws Exception {
        Return msg = new Return();
        Template temp = null;
        String risk_uuid = sip_Risks.getRiskUuid();
        try (Writer out = null;){
            File file = new File(path);
            if (!file.exists() && !file.isDirectory()) {
                file.mkdir();
            }
            Configuration cfg = this.freemarkerConfig.getConfiguration();
            temp = cfg.getTemplate(ftlPath);
            Map<String, Object> paramMap = JsonUtilOld.objToMap((Object)sip_Risks);
            paramMap.put("node_seq", dsn_Structure.getNodeSeq());
            this.riskAttr.setParamMap(paramMap);
            Map<String, TemplateDirectiveModel> dataMap = this.freemarkerConfig.getFreemarkerTag();
            String fileName = file_name + file_type;
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path + fileName), "utf-8"));
            temp.process(dataMap, out);
            String file_no = UniqueSeq.shortUUID();
            this.saveFile(file_no, risk_uuid + file_type, path + risk_uuid + file_type);
            this.saveFileNo(file_no, risk_uuid);
        }
        return msg;
    }

    private void saveFile(String file_no, String file_name, String file_path) {
        this.file_RepostryDao.addEq("file_name", (Object)file_name);
        this.file_RepostryDao.delete();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("file_no", file_no);
        map.put("file_name", file_name);
        map.put("new_file_name", file_name);
        map.put("file_type", "html");
        map.put("file_suffix", "html");
        map.put("file_path", file_path);
        if (!StrUtil.isNull((Object)file_path)) {
            File file = new File(file_path);
            map.put("file_size", file.length());
        } else {
            map.put("file_size", 0);
        }
        map.put("upload_date", DateUtil.sysDate());
        this.file_RepostryDao.insert(map);
    }

    private void saveFileNo(String file_no, String risk_uuid) throws Exception {
        Dsn_Dynamic_Data dsn_Dynamic_Data4del = new Dsn_Dynamic_Data();
        dsn_Dynamic_Data4del.where().addEq((ModelField)Dsn_Dynamic_Data.Field.biz_type, (Object)3);
        dsn_Dynamic_Data4del.where().addEq((ModelField)Dsn_Dynamic_Data.Field.relate_tab, (Object)"sys_file_repostry");
        dsn_Dynamic_Data4del.where().addEq((ModelField)Dsn_Dynamic_Data.Field.relate_fk, (Object)risk_uuid);
        this.dao.delete((AbsModel)dsn_Dynamic_Data4del);
        Dsn_Dynamic_Data dsn_Dynamic_Data4Insert = new Dsn_Dynamic_Data();
        dsn_Dynamic_Data4Insert.setBizType("3");
        dsn_Dynamic_Data4Insert.setRelateTab("sys_file_repostry");
        dsn_Dynamic_Data4Insert.setRelateFk(risk_uuid);
        dsn_Dynamic_Data4Insert.setField1(file_no);
        this.dao.save((AbsModel)dsn_Dynamic_Data4Insert);
    }

    private Map<String, Object> getBuildPageProperties() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("page_type", PropertiesUtil.getPropertiesBySrc((String)"build_page", (String)"page_type"));
        resultMap.put("file_type", PropertiesUtil.getPropertiesBySrc((String)"build_page", (String)"file_type"));
        String file_names = PropertiesUtil.getPropertiesBySrc((String)"build_page", (String)"file_names");
        String[] file_namesArray = file_names.split(",");
        resultMap.put("file_names", file_namesArray);
        return resultMap;
    }
}

