/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.design.rate.service.imp;

import cn.com.chinalife.model.Dsn_Dynamic_Data;
import cn.com.chinalife.model.Dsn_Rules;
import cn.com.chinalife.model.Dsn_Structure;
import cn.com.chinalife.model.Sip_Risks;
import com.newtouch.config.RateConfig;
import com.newtouch.context.ThreadLocalContext;
import com.newtouch.dao.DBHandleCreator;
import com.newtouch.dao.QuerySqlable;
import com.newtouch.dao.UpdateSqlable;
import com.newtouch.dao.pojo.DBTypes;
import com.newtouch.design.rate.service.IRateService;
import com.newtouch.design.rate.service.imp.RateTask;
import com.newtouch.design.util.ExcelUtil;
import com.newtouch.design.util.ListUtil;
import com.newtouch.design.util.PinYin4J;
import com.newtouch.excel.pojo.Excel;
import com.newtouch.excel.pojo.Sheet;
import com.newtouch.log.Ulog;
import com.newtouch.msg.Return;
import com.newtouch.msg.ReturnMsg;
import com.newtouch.msg.pojo.Message;
import com.newtouch.repository.AbsModel;
import com.newtouch.repository.AbsModelRepository;
import com.newtouch.repository.ModelField;
import com.newtouch.util.date.DateUtil;
import com.newtouch.util.json.JsonUtil;
import com.newtouch.util.string.StrUtil;
import com.newtouch.util.uuid.UniqueSeq;
import com.newtouch.web.BaseService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class RateServiceImp
extends BaseService
implements IRateService {
    @Autowired
    private AbsModelRepository dao;
    @Autowired
    private RateConfig rateConfig;
    private static final String TABLE_PREFIX = "dsn_rate_";
    private Map<String, Object> newTableInfoMap = new HashMap<String, Object>();
    private String tabNameKey = "tabNameKey";
    private String columnInfoKey = "columnInfoKey";

    @Override
    public Map<String, Object> rateDetailQuery(String nodeSeq, String nodeNo) throws SQLException {
        Return msg = this.getNewTableInfo(nodeSeq, nodeNo);
        if (!msg.isSuccessflag()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
            resultMap.put("errorInfo", ((Message)msg.getMsgList().get(0)).getMsgRemark());
            return resultMap;
        }
        Map<String, Object> conditionMap = this.getConditionQueryInfo();
        return conditionMap;
    }

    @Override
    public List<Map<String, Object>> queryRateDetail(Map<String, Object> paramMap) throws SQLException {
        HashMap<String, Object> cloneMap = new HashMap<String, Object>();
        StringBuffer paramBuffer = new StringBuffer();
        String tableName = StrUtil.trimStr((Object)this.newTableInfoMap.get(this.tabNameKey));
        paramMap.remove("tableName");
        cloneMap.putAll(paramMap);
        Map sqlMap = (Map)cloneMap.get("queryTerms");
        sqlMap.remove("row4Page");
        sqlMap.remove("tableName");
        sqlMap.remove("order");
        sqlMap.remove("nowPage");
        sqlMap.remove("uploadService");
        sqlMap.remove("downloadService");
        sqlMap.remove("fileType");
        for (Map.Entry entry : sqlMap.entrySet()) {
            paramBuffer.append((String)entry.getKey() + ",");
        }
        if (StrUtil.isNull((Object)paramBuffer.toString())) {
            return null;
        }
        String paramStr = paramBuffer.toString().substring(0, paramBuffer.toString().length() - 1);
        StringBuffer sqlbuffer = new StringBuffer();
        QuerySqlable query = DBHandleCreator.getInstance().getQuerySql();
        sqlbuffer.append(" select serno, ").append(paramStr);
        sqlbuffer.append(" from " + tableName);
        sqlbuffer.append(" where 1=1 ");
        for (Map.Entry entry : sqlMap.entrySet()) {
            if (StrUtil.isNull(entry.getValue())) continue;
            sqlbuffer.append(" and  " + (String)entry.getKey() + " like ? ");
            query.add((Object)("%" + entry.getValue() + "%"));
        }
        query.setSql(sqlbuffer.toString());
        query.setPaginate(true);
        List resultList = this.dao.findAll(query);
        return resultList;
    }

    private Map<String, Object> getConditionQueryInfo() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList conditionList = new ArrayList();
        List columnInfoList = (List)this.newTableInfoMap.get(this.columnInfoKey);
        columnInfoList.stream().forEach(column -> {
            HashMap<String, String> conditonMap = new HashMap<String, String>();
            conditonMap.put("nodeKey", PinYin4J.converterToFirstSpell(StrUtil.trimStr((Object)column.getNodeName())).toLowerCase());
            conditonMap.put("nodeName", column.getNodeName());
            conditionList.add(conditonMap);
        });
        resultMap.put("tableName", this.newTableInfoMap.get(this.tabNameKey));
        resultMap.put("nodeList", conditionList);
        return resultMap;
    }

    private void createTable() {
        String schemaName = this.rateConfig.getSchemaName();
        StringBuffer sqlBuffer = new StringBuffer();
        DBTypes dbTypes = this.dao.getDbType();
        if (dbTypes.equals((Object)DBTypes.MYSQL)) {
            sqlBuffer.append(" CREATE TABLE `" + StrUtil.trimStr((Object)this.newTableInfoMap.get(this.tabNameKey)) + "` ( ");
            sqlBuffer.append("   `serno` VARCHAR (32) COLLATE utf8_bin NOT NULL COMMENT '01.serno', ");
            for (Dsn_Structure dsn : (List)this.newTableInfoMap.get(this.columnInfoKey)) {
                sqlBuffer.append("   `" + PinYin4J.converterToFirstSpell(StrUtil.trimStr((Object)dsn.getNodeName())).toLowerCase() + "` VARCHAR (256) COLLATE utf8_bin COMMENT '" + StrUtil.trimStr((Object)dsn.getNodeName()) + "', ");
            }
            sqlBuffer.append("   `crt_date` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '05.\u521b\u5efa\u65e5\u671f', ").append("   `mdf_date` timestamp NOT NULL DEFAULT '1970-01-02 00:00:01' COMMENT '06.\u4fee\u6539\u65e5\u671f',").append("   `crt_user` VARCHAR (64) COLLATE utf8_bin NOT NULL COMMENT '07.\u521b\u5efa\u64cd\u4f5c\u5458', ").append("   `mdf_user` VARCHAR (64) COLLATE utf8_bin NOT NULL COMMENT '08.\u4fee\u6539\u64cd\u4f5c\u5458', ").append("   `data_flag` VARCHAR (4) COLLATE utf8_bin NOT NULL COMMENT '09.\u6709\u6548\u6027\u6807\u5fd7', ").append("   `patch_memo` VARCHAR (1024) CHARACTER ").append(" SET utf8 DEFAULT NULL COMMENT '10.\u6570\u8865\u5907\u6ce8', ").append("  PRIMARY KEY (`serno`) ").append(" ) ENGINE = INNODB DEFAULT CHARSET = utf8 COLLATE = utf8_bin ");
            Ulog.info((String)("\u8d39\u7387\u8be6\u60c5\u5efa\u8868sql==> " + sqlBuffer.toString()));
            try {
                JdbcTemplate jdbcTemplate = this.dao.getJdbcTemplate();
                jdbcTemplate.execute(sqlBuffer.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (dbTypes.equals((Object)DBTypes.ORACLE)) {
            sqlBuffer.append(" CREATE TABLE " + schemaName + "." + StrUtil.trimStr((Object)this.newTableInfoMap.get(this.tabNameKey)).toLowerCase() + " ( ");
            sqlBuffer.append("   \"serno\" VARCHAR (32  ) NOT NULL, ");
            for (Dsn_Structure dsn : (List)this.newTableInfoMap.get(this.columnInfoKey)) {
                sqlBuffer.append("   \"" + PinYin4J.converterToFirstSpell(StrUtil.trimStr((Object)dsn.getNodeName())).toLowerCase() + "\" VARCHAR (256  ) , ");
            }
            sqlBuffer.append("   \"crt_date\" DATE NOT NULL , ").append("   \"mdf_date\" DATE NOT NULL ,").append("   \"crt_user\" VARCHAR2(32  ) NOT NULL , ").append("   \"mdf_user\" VARCHAR2(32  ) NOT NULL , ").append("   \"data_flag\" VARCHAR2(4  ) NOT NULL , ").append("   \"patch_memo\" VARCHAR2(1024  ) ").append(" ) ");
            Ulog.info((String)("\u8d39\u7387\u8be6\u60c5\u5efa\u8868sql==> " + sqlBuffer.toString()));
            try {
                JdbcTemplate jdbcTemplate = this.dao.getJdbcTemplate();
                jdbcTemplate.execute(sqlBuffer.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean queryTableInDB(String node_seq) throws SQLException {
        Connection conn = DBHandleCreator.getInstance().getDBHandle().getJdbcTemplate().getDataSource().getConnection();
        String[] types = new String[]{"TABLE"};
        ResultSet rs = conn.getMetaData().getTables(null, null, "%", types);
        while (rs.next()) {
            String tabName = StrUtil.trimStr((Object)rs.getObject("TABLE_NAME")).toUpperCase();
            String table_name = StrUtil.trimStr((Object)this.newTableInfoMap.get(this.tabNameKey));
            if (DBTypes.ORACLE.equals((Object)DBHandleCreator.getInstance().getDbType())) {
                table_name = table_name.toUpperCase();
            }
            if (!tabName.equals(table_name)) continue;
            rs.close();
            conn.close();
            return true;
        }
        rs.close();
        conn.close();
        return false;
    }

    private Return getNewTableInfo(String nodeSeq, String nodeNo) throws SQLException {
        boolean flag;
        int sum;
        Return msg4RiskUUID = this.getRiskNo(nodeNo);
        String riskUUID = StrUtil.trimStr(msg4RiskUUID.getDataTable().get("riskUUID"));
        if (StrUtil.isNull((Object)riskUUID)) {
            return msg4RiskUUID;
        }
        Return msg4RateCode = this.getRateNo(nodeNo);
        String rateCode = StrUtil.trimStr(msg4RateCode.getDataTable().get("rateCode"));
        if (StrUtil.isNull((Object)rateCode)) {
            return msg4RateCode;
        }
        String tableName = TABLE_PREFIX + riskUUID.toLowerCase() + "_" + rateCode.toLowerCase();
        this.newTableInfoMap.put(this.tabNameKey, tableName);
        Dsn_Structure model = new Dsn_Structure();
        model.where().addLikeR((ModelField)Dsn_Structure.Field.node_seq, (Object)nodeSeq);
        model.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"attr4Rate");
        List dsnList = this.dao.findAll((AbsModel)model);
        this.newTableInfoMap.put(this.columnInfoKey, dsnList);
        if (!this.queryTableInDB(nodeSeq)) {
            Ulog.info((String)"\u8868\u4e0d\u5b58\u5728\uff0c\u9700\u8981\u521b\u5efa=======>\n");
            this.createTable();
        }
        String sql1 = " select * from  " + tableName + " where  serno=(  SELECT min(serno)  FROM  " + tableName + " ) ";
        QuerySqlable query = DBHandleCreator.getInstance().getQuerySql();
        query.setSql(sql1);
        List list = this.dao.findAll(query);
        if (!list.isEmpty() && (sum = ((Map)list.get(0)).keySet().size()) - 8 != dsnList.size() && !(flag = CollectionUtils.isEqualCollection((Collection)dsnList, (Collection)((List)this.newTableInfoMap.get(this.columnInfoKey))))) {
            String sql = " delete table " + tableName;
            QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
            querySql.setSql(sql);
            this.dao.getJdbcTemplate().execute(sql);
        }
        return new Return();
    }

    private Return getRiskNo(String nodeNo) {
        Return msg = new Return();
        String nodeNo1 = this.getNodeNo(nodeNo);
        String nodeNo2 = this.getNodeNo(nodeNo1);
        Dsn_Structure dsnQuery = new Dsn_Structure();
        dsnQuery.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)nodeNo2);
        dsnQuery.where().addEq((ModelField)Dsn_Structure.Field.node_name, (Object)"\u9669\u79cd\u4fe1\u606f");
        Dsn_Structure one = (Dsn_Structure)this.dao.findOne((AbsModel)dsnQuery);
        String riskUUID = "";
        if (!StrUtil.isNull((Object)((Object)one))) {
            riskUUID = one.getNodeNo();
        }
        Sip_Risks sipRisks4Query = new Sip_Risks();
        sipRisks4Query.where().addEq((ModelField)Sip_Risks.Field.risk_uuid, (Object)riskUUID);
        Sip_Risks sipRisks4Result = (Sip_Risks)this.dao.findOne((AbsModel)sipRisks4Query);
        if (StrUtil.isNull((Object)sipRisks4Result.getSerno())) {
            msg.setFailMsg("\u8bf7\u5148\u914d\u7f6e\u5e76\u4fdd\u5b58\u9669\u79cd\u4fe1\u606f\uff01");
            return msg;
        }
        HashMap<String, String> dataTable = new HashMap<String, String>();
        dataTable.put("riskUUID", riskUUID);
        msg.setDataTable(dataTable);
        return msg;
    }

    private String getNodeNo(String nodeNo) {
        Dsn_Structure dsnQuery = new Dsn_Structure();
        dsnQuery.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)nodeNo);
        Dsn_Structure one = (Dsn_Structure)this.dao.findOne((AbsModel)dsnQuery);
        return one.getUpNode();
    }

    private Return getRateNo(String nodeNo) {
        Return msg = new Return();
        String rateCode = "";
        Dsn_Dynamic_Data dsnDynamicData4Query = new Dsn_Dynamic_Data();
        dsnDynamicData4Query.where().addEq((ModelField)Dsn_Dynamic_Data.Field.relate_fk, (Object)nodeNo);
        Dsn_Dynamic_Data dsnDynamicData4Result = (Dsn_Dynamic_Data)this.dao.findOne((AbsModel)dsnDynamicData4Query);
        if (StrUtil.isNull((Object)dsnDynamicData4Result.getSerno())) {
            msg.setFailMsg("\u8bf7\u5148\u914d\u7f6e\u8d39\u7387\u7f16\u7801\uff0c\u5e76\u6dfb\u52a0\u8f93\u5165\u8f93\u51fa\u9879\uff01");
            return msg;
        }
        rateCode = dsnDynamicData4Result.getField2();
        HashMap<String, String> dataTable = new HashMap<String, String>();
        dataTable.put("rateCode", rateCode);
        msg.setDataTable(dataTable);
        return msg;
    }

    @Override
    public ReturnMsg exportExcel(Map<String, Object> paramMap) {
        Return msg = new Return();
        List<Map<String, Object>> list = this.getExcelTitleMap(paramMap);
        Sheet sheet = Sheet.getInstance();
        sheet.setSheetName("sheet1");
        for (Map<String, Object> head : list) {
            sheet.addHead(StrUtil.trimStr((Object)head.get("nodeKey")), StrUtil.trimStr((Object)head.get("nodeName")));
        }
        Excel excel = Excel.getInstance();
        excel.addSheets(sheet);
        excel.setExcelName("importAttr.xlsx");
        msg.getDataTable().put("excel", excel);
        return msg.msg();
    }

    private List<Map<String, Object>> getExcelTitleMap(Map<String, Object> paramMap) {
        ArrayList<Map<String, Object>> titleList = new ArrayList<Map<String, Object>>();
        List columnInfoList = (List)this.newTableInfoMap.get(this.columnInfoKey);
        columnInfoList.stream().forEach(column -> {
            HashMap<String, String> conditonMap = new HashMap<String, String>();
            conditonMap.put("nodeKey", PinYin4J.converterToFirstSpell(StrUtil.trimStr((Object)column.getNodeName())).toLowerCase());
            conditonMap.put("nodeName", column.getNodeName());
            titleList.add(conditonMap);
        });
        return titleList;
    }

    @Override
    public ReturnMsg importAttribute(Map<String, Object> paramMap) throws Exception {
        ExcelUtil excel = new ExcelUtil();
        String[] titles = this.getExcelTitle(paramMap);
        String[] titlesName = this.getExcelTitleName(paramMap);
        MultipartFile mFile = (MultipartFile)paramMap.get("file");
        Map<String, List<Object>> excelMap = excel.initSheet4Stream(mFile.getInputStream(), titles, titlesName, mFile.getOriginalFilename());
        ReturnMsg rm = this.valid(excelMap, titles, paramMap);
        if (!rm.isSuccessflag()) {
            return rm;
        }
        rm = this.impAttr(excelMap, titles, paramMap);
        return rm;
    }

    private Map<String, Object> getNodeType(Map<String, Object> param) {
        String sql = "SELECT node_type, relate_fk,node_no,up_node FROM dsn_structure WHERE\tnode_no = ( SELECT up_node FROM dsn_structure WHERE node_no = ( SELECT up_node FROM dsn_structure WHERE node_no = ( SELECT up_node FROM dsn_structure WHERE node_no =? ) ) )";
        QuerySqlable query = DBHandleCreator.getInstance().getQuerySql();
        query.add(param.get("node_no"));
        query.setSql(sql);
        return this.dbHandle().query(query);
    }

    public String[] getExcelTitle(Map<String, Object> paramMap) {
        List<Map<String, Object>> list = this.getExcelTitleMap(paramMap);
        String[] arrayTitle = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            arrayTitle[i] = StrUtil.trimStr((Object)list.get(i).get("nodeKey"));
        }
        return arrayTitle;
    }

    public String[] getExcelTitleName(Map<String, Object> paramMap) {
        List<Map<String, Object>> list = this.getExcelTitleMap(paramMap);
        String[] arrayTitle = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            arrayTitle[i] = StrUtil.trimStr((Object)list.get(i).get("nodeName"));
        }
        return arrayTitle;
    }

    private ReturnMsg valid(Map<String, List<Object>> excelMap, String[] titles, Map<String, Object> paramMap) {
        Return rm = new Return();
        rm.setAutoRollback(false);
        Message m = new Message();
        if (excelMap.get("sheet1").size() == 0) {
            m.setMsgRemark("\u5bfc\u5165\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u5bfc\u5165\u6570\u636e\uff01");
            rm.setFailMsg(m);
            return rm.msg();
        }
        for (int i = 0; i < excelMap.get("sheet1").size(); ++i) {
            Map jkkvo = (Map)excelMap.get("sheet1").get(i);
            for (int o = i; o < titles.length; ++o) {
                String code = titles[o];
                String cmount = StrUtil.trimStr(jkkvo.get(code));
                if (!StrUtil.isNull((Object)cmount)) continue;
                m.setMsgRemark("\u7b2c" + (i + 1) + "\u884c\u5bfc\u5165\u6570\u636e\u5b58\u5728\u7a7a\u503c");
                rm.setFailMsg(m);
                return rm.msg();
            }
        }
        return rm.msg();
    }

    private ReturnMsg impAttr(Map<String, List<Object>> excelMap, String[] titles, Map<String, Object> paramMap) {
        Return returnMsg = new Return();
        Timestamp start1 = null;
        try {
            List<String> insertList = this.getInsertParam(excelMap);
            List<List<?>> taskList = ListUtil.splitList(insertList, 1000);
            Ulog.info((String)("\u6570\u636e\u603b\u91cf\u4e3a===>" + insertList.size() + "\n\u5206\u7ec4\u6570\u91cf\u4e3a===>" + taskList.size()));
            ExecutorService executor = Executors.newFixedThreadPool(5);
            start1 = DateUtil.sysTimestamp();
            for (int i = 0; i < taskList.size(); ++i) {
                RateTask rateTask = new RateTask(taskList.get(i), this.dao.getJdbcTemplate());
                executor.execute(rateTask);
            }
            executor.shutdown();
            while (!executor.isTerminated()) {
            }
            Ulog.info((String)("excel\u6570\u636e\u5bfc\u5165\u5b8c\u6210,\u7528\u65f6[" + DateUtil.dateBetween((Date)new Date(), (Date)start1, (DateUtil.DateType)DateUtil.DateType.SS) + "]\u79d2"));
        }
        catch (Exception e) {
            Ulog.info((String)("excel\u6570\u636e\u5bfc\u5165\u5931\u8d25,\u7528\u65f6[" + DateUtil.dateBetween((Date)new Date(), start1, (DateUtil.DateType)DateUtil.DateType.SS) + "]\u79d2"));
            e.printStackTrace();
            returnMsg.setFailMsg("\u5c06excel\u4e2d\u7684\u6570\u636e\u6279\u91cf\u63d2\u5165\u5bfc\u6570\u636e\u5e93\u5931\u8d25!");
            return returnMsg.msg();
        }
        return returnMsg.msg();
    }

    private Map<String, Object> getBatchParam(Map<String, List<Object>> excelMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList resultList = new ArrayList();
        ArrayList<String> tmpList = null;
        StringBuffer paramBuffer = new StringBuffer();
        StringBuffer paramValueBuffer = new StringBuffer();
        int count = 0;
        List<Object> sheetList = excelMap.get("sheet1");
        Map map = (Map)sheetList.get(0);
        paramBuffer.append(" insert into " + this.newTableInfoMap.get(this.tabNameKey) + " ( serno, crt_user, mdf_user, data_flag, ");
        paramValueBuffer.append(" values( ?, '" + ThreadLocalContext.get().getUser().getOptName() + "', '" + ThreadLocalContext.get().getUser().getOptName() + "','1', ");
        for (Map.Entry en : map.entrySet()) {
            paramBuffer.append((String)en.getKey() + " ,");
            paramValueBuffer.append("? ,");
            ++count;
        }
        String paramStr = paramBuffer.toString().substring(0, paramBuffer.toString().length() - 1) + " ) ";
        String paramValueStr = paramValueBuffer.toString().substring(0, paramValueBuffer.toString().length() - 1) + " ) ";
        resultMap.put("insertSql", paramStr + paramValueStr);
        resultMap.put("paramCount", count + 1);
        for (Map.Entry<String, List<Object>> entry : excelMap.entrySet()) {
            List<Object> dataList = entry.getValue();
            for (Object obj : dataList) {
                if (obj instanceof Map) {
                    Map tmpMap = (Map)obj;
                    tmpList = new ArrayList<String>();
                    tmpList.add(UniqueSeq.shortUUID());
                    for (Map.Entry en : tmpMap.entrySet()) {
                        tmpList.add(StrUtil.trimStr(en.getValue()));
                    }
                    resultList.add(tmpList);
                    continue;
                }
                Ulog.info((String)"\u89e3\u6790excel\u4e2d\u7684\u6570\u636e\u5f02\u5e38===>");
            }
        }
        resultMap.put("dataList", resultList);
        return resultMap;
    }

    private List<String> getInsertParam(Map<String, List<Object>> excelMap) {
        ArrayList<String> insertList = new ArrayList<String>();
        StringBuffer paramBuffer = null;
        StringBuffer paramValueBuffer = null;
        String opt_name = "system";
        if (!StrUtil.isNull((Object)ThreadLocalContext.get().getUser().getOptName())) {
            opt_name = ThreadLocalContext.get().getUser().getOptName();
        }
        for (Map.Entry<String, List<Object>> entry : excelMap.entrySet()) {
            List<Object> dataList = entry.getValue();
            for (Object obj : dataList) {
                paramBuffer = new StringBuffer();
                paramValueBuffer = new StringBuffer();
                if (obj instanceof Map) {
                    Map map = (Map)obj;
                    if (DBTypes.ORACLE.equals((Object)DBHandleCreator.getInstance().getDbType())) {
                        paramBuffer.append(" insert into " + this.newTableInfoMap.get(this.tabNameKey) + " ( serno, crt_user, mdf_user, data_flag, crt_date, mdf_date,");
                        paramValueBuffer.append(" values( '" + UniqueSeq.shortUUID() + "', '" + opt_name + "', '" + opt_name + "','1', to_timestamp('" + DateUtil.date2String((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + "','yyyy-MM-dd hh24:mi:ss.ff'),to_timestamp('" + DateUtil.date2String((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + "','yyyy-MM-dd hh24:mi:ss.ff'),");
                    } else {
                        paramBuffer.append(" insert into " + this.newTableInfoMap.get(this.tabNameKey) + " ( serno, crt_user, mdf_user, data_flag, ");
                        paramValueBuffer.append(" values( '" + UniqueSeq.shortUUID() + "', '" + opt_name + "', '" + opt_name + "','1', ");
                    }
                    for (Map.Entry en : map.entrySet()) {
                        paramBuffer.append((String)en.getKey() + " ,");
                        paramValueBuffer.append("'" + en.getValue() + "' ,");
                    }
                    String paramStr = paramBuffer.toString().substring(0, paramBuffer.toString().length() - 1) + " ) ";
                    String paramValueStr = paramValueBuffer.toString().substring(0, paramValueBuffer.toString().length() - 1) + " ) ";
                    insertList.add(paramStr + paramValueStr);
                    continue;
                }
                Ulog.info((String)"\u89e3\u6790excel\u4e2d\u7684\u6570\u636e\u5f02\u5e38===>");
            }
        }
        return insertList;
    }

    @Override
    public ReturnMsg delAttr(Map<String, Object> paramMap) {
        Return msg = new Return();
        List delList = (List)paramMap.get("checkbox");
        final ArrayList<String> sernoList = new ArrayList<String>();
        for (Map tmpMap : delList) {
            sernoList.add(StrUtil.trimStr(tmpMap.get("serno")));
        }
        String sql = "delete from " + this.newTableInfoMap.get(this.tabNameKey) + " where serno = ? ";
        try {
            this.dao.getJdbcTemplate().batchUpdate(sql, new BatchPreparedStatementSetter(){

                public void setValues(PreparedStatement ps, int i) throws SQLException {
                    Object[] args = sernoList.toArray();
                    ps.setString(1, (String)args[i]);
                }

                public int getBatchSize() {
                    return sernoList.size();
                }
            });
            msg.setSuccessMsg("\u5220\u9664\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            msg.setFailMsg("\u5220\u9664\u5931\u8d25\uff01");
        }
        return msg.msg();
    }

    @Override
    public Map<String, Object> mdfAttr(Map<String, Object> paramMap) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        List relationList = (List)this.getConditionQueryInfo().get("nodeList");
        String sernoStr = StrUtil.trimStr((Object)paramMap.get("serno"));
        StringBuffer paramBuffer = new StringBuffer();
        for (Map map : relationList) {
            paramBuffer.append(map.get("nodeKey")).append(" ,");
        }
        String paramStr = paramBuffer.toString().substring(0, paramBuffer.toString().length() - 1);
        String sql = "select serno, " + paramStr + " from " + this.newTableInfoMap.get(this.tabNameKey) + " where serno = ? ";
        QuerySqlable query = DBHandleCreator.getInstance().getQuerySql();
        query.setSql(sql);
        query.add((Object)sernoStr);
        Map resultMap = (Map)this.dao.findAll(query).get(0);
        HashMap showMap = new HashMap();
        for (Map map : relationList) {
            for (Map.Entry entry : resultMap.entrySet()) {
                if (!((String)entry.getKey()).equals(StrUtil.trimStr(map.get("nodeKey")))) continue;
                showMap.put(((String)entry.getKey()).toLowerCase(), map.get("nodeName"));
            }
        }
        returnMap.put("resultMap", resultMap);
        returnMap.put("showMap", showMap);
        Ulog.info((String)("returnMap:" + JsonUtil.toJson(returnMap)));
        return returnMap;
    }

    @Override
    public ReturnMsg addAttr(Map<String, Object> paramMap) {
        Return msg = new Return();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.putAll(paramMap);
        map.remove("rqstType");
        String serno = StrUtil.trimStr(map.get("serno"));
        map.remove("serno");
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" update " + this.newTableInfoMap.get(this.tabNameKey) + " set ");
        for (Map.Entry entry : map.entrySet()) {
            sqlBuffer.append((String)entry.getKey() + "='" + entry.getValue() + "',");
        }
        String sqlStr = sqlBuffer.toString().substring(0, sqlBuffer.toString().length() - 1);
        sqlStr = sqlStr + " where serno =  '" + serno + "'";
        Ulog.info((String)("\u4fdd\u5b58\u4fee\u6539\u7684\u5c5e\u6027\u7684sql===>" + sqlStr));
        try {
            this.dao.getJdbcTemplate().execute(sqlStr);
            msg.setSuccessMsg("\u4fdd\u5b58\u4fee\u6539\u540e\u7684\u5c5e\u6027\u6210\u529f!");
        }
        catch (Exception e) {
            e.printStackTrace();
            msg.setFailMsg("\u4fdd\u5b58\u4fee\u6539\u540e\u7684\u5c5e\u6027\u5931\u8d25!");
        }
        return msg.msg();
    }

    @Override
    public Map<String, Object> goRateModify(Map<String, Object> paramMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String dsn_structure_serno = StrUtil.trimStr((Object)paramMap.get("node_no"));
        Dsn_Dynamic_Data dsn_dynamic_data4Query = new Dsn_Dynamic_Data();
        dsn_dynamic_data4Query.where().addEq((ModelField)Dsn_Dynamic_Data.Field.relate_fk, (Object)dsn_structure_serno);
        Dsn_Dynamic_Data dsn_dynamic_data4Result = (Dsn_Dynamic_Data)this.dao.findOne((AbsModel)dsn_dynamic_data4Query);
        if (StrUtil.isNull((Object)dsn_dynamic_data4Result.getSerno())) {
            Ulog.warn((String)("dsn_dynamic_data\u8868\u4e2d\u672a\u67e5\u5230relate_fk\u4e3a" + dsn_structure_serno + "\u7684\u8bb0\u5f55"));
        }
        resultMap.put("dsn_structure_serno", dsn_structure_serno);
        resultMap.put("rate_name", dsn_dynamic_data4Result.getField1());
        resultMap.put("rate_code", dsn_dynamic_data4Result.getField2());
        resultMap.put("rate_order", dsn_dynamic_data4Result.getField3());
        return resultMap;
    }

    @Override
    public ReturnMsg doRateSelfAdd(Map<String, Object> paramMap) {
        Return msg = new Return();
        Dsn_Dynamic_Data dsn_dynamic_data4Insert = new Dsn_Dynamic_Data();
        String dsn_structure_serno = StrUtil.trimStr((Object)paramMap.get("dsn_structure_serno"));
        dsn_dynamic_data4Insert.setRelateFk(dsn_structure_serno);
        String rate_name = StrUtil.trimStr((Object)paramMap.get("rate_name"));
        String rate_order = StrUtil.trimStr((Object)paramMap.get("rate_order"));
        if (StrUtil.isNull((Object)rate_name)) {
            msg.setFailMsg("\u8d39\u7387\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        dsn_dynamic_data4Insert.setField1(rate_name);
        String rate_code = StrUtil.trimStr((Object)paramMap.get("rate_code"));
        if (StrUtil.isNull((Object)rate_code)) {
            msg.setFailMsg("\u8d39\u7387\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        dsn_dynamic_data4Insert.setField2(rate_code);
        dsn_dynamic_data4Insert.setField3(rate_order);
        try {
            Dsn_Dynamic_Data dsn_dynamic_data4Query = new Dsn_Dynamic_Data();
            dsn_dynamic_data4Query.where().addEq((ModelField)Dsn_Dynamic_Data.Field.relate_fk, (Object)dsn_structure_serno);
            Dsn_Dynamic_Data dsn_dynamic_data4Result = (Dsn_Dynamic_Data)this.dao.findOne((AbsModel)dsn_dynamic_data4Query);
            if (StrUtil.isNull((Object)dsn_dynamic_data4Result.getSerno())) {
                this.dao.save((AbsModel)dsn_dynamic_data4Insert);
            } else {
                Dsn_Dynamic_Data dsn_dynamic_data4Update = new Dsn_Dynamic_Data();
                dsn_dynamic_data4Update.where().addEq((ModelField)Dsn_Dynamic_Data.Field.relate_fk, (Object)dsn_structure_serno);
                dsn_dynamic_data4Update.setField1(rate_name);
                dsn_dynamic_data4Update.setField2(rate_code);
                dsn_dynamic_data4Update.setField3(rate_order);
                this.dao.update((AbsModel)dsn_dynamic_data4Update);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            msg.setFailMsg(e.getMessage());
        }
        return msg.msg();
    }

    @Override
    public Return goDropTargTable(Map<String, Object> param) {
        Return r = new Return();
        if ("1".equals(param.get("flag"))) {
            r.setSuccessMsg("\u8be5\u64cd\u4f5c\u5c06\u4f1a\u5220\u9664\u8be5\u8282\u70b9\u6240\u5728\u7684\u6307\u6807\u4fe1\u606f<br />\u786e\u8ba4\u5220\u9664\u5417?");
            r.setDataTable(param);
            return r;
        }
        String nodeNo = StrUtil.trimStr((Object)param.get("node_no"));
        Dsn_Dynamic_Data data = new Dsn_Dynamic_Data();
        data.where().addEq((ModelField)Dsn_Dynamic_Data.Field.relate_field, (Object)nodeNo);
        this.dao.delete((AbsModel)data);
        Dsn_Structure dsnStructure = new Dsn_Structure();
        dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)nodeNo);
        Dsn_Structure structure = (Dsn_Structure)this.dao.findOne((AbsModel)dsnStructure);
        Dsn_Rules rule = new Dsn_Rules();
        rule.where().addEq((ModelField)Dsn_Rules.Field.node_no, (Object)structure.getNodeNo());
        dsnStructure.clear();
        dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)nodeNo);
        this.dao.delete((AbsModel)dsnStructure);
        dsnStructure.clear();
        dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)nodeNo);
        this.dao.delete((AbsModel)dsnStructure);
        dsnStructure.clear();
        r.setSuccessMsg("\u5229\u76ca\u6f14\u793a\u6307\u6807\u5220\u9664\u6210\u529f");
        return r;
    }

    @Override
    public Return goDropRateTable(Map<String, Object> param, boolean flag) {
        Return r = new Return();
        r.setAutoRollback(false);
        if (flag) {
            r.setSuccessMsg("\u8be5\u64cd\u4f5c\u5c06\u4f1a\u5220\u9664\u8be5\u8282\u70b9\u6240\u5728\u7684\u8d39\u7387\u4fe1\u606f<br />\u786e\u8ba4\u5220\u9664\u5417?");
            r.setDataTable(param);
            return r;
        }
        String nodeNo = StrUtil.trimStr((Object)param.get("node_no"));
        Return rate_no = this.getRateNo(nodeNo);
        if (rate_no.isSuccessflag()) {
            Return msg4RiskUUID = this.getRiskNo((String)param.get("node_seq"));
            String riskUUID = StrUtil.trimStr(msg4RiskUUID.getDataTable().get("riskUUID"));
            if (StrUtil.isNull((Object)riskUUID)) {
                return msg4RiskUUID;
            }
            Return msg4RateCode = this.getRateNo(nodeNo);
            String rateCode = StrUtil.trimStr(msg4RateCode.getDataTable().get("rateCode"));
            if (StrUtil.isNull((Object)rateCode)) {
                return msg4RateCode;
            }
            String tableName = TABLE_PREFIX + riskUUID.toLowerCase() + "_" + rateCode.toLowerCase();
            UpdateSqlable updateSqlable = DBHandleCreator.getInstance().getUpdateSql();
            String sql = "drop  table " + tableName;
            updateSqlable.setSql(sql);
            try {
                this.dbHandle().update(updateSqlable);
            }
            catch (Exception e) {
                Dsn_Structure structure = new Dsn_Structure();
                structure.where().addLike((ModelField)Dsn_Structure.Field.node_seq, (Object)nodeNo);
                this.dao.delete((AbsModel)structure);
                r.setFailMsg("\u8282\u70b9\u5df2\u5220\u9664\u3002");
                return r;
            }
        } else {
            r.setFailMsg("\u60a8\u672a\u914d\u7f6e\u8d39\u7387\u7f16\u7801\uff0c\u65e0\u9700\u6267\u884c\u5220\u9664\u64cd\u4f5c");
            return r;
        }
        return r;
    }
}

